/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INote;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class ChainAnchorNote
extends AbstractNote
implements INote,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 1;
    byte[] m_scratchBuffer = new byte[8];
    byte m_anchorNumber;
    boolean m_first;
    long m_oldPageNumber;
    long m_newPageNumber;

    @Override
    public long getPageNum() {
        return 0L;
    }

    ChainAnchorNote() {
    }

    public String toString() {
        return this.getClass().getName() + " anchor " + this.m_anchorNumber + " first? " + this.m_first + " old page " + this.m_oldPageNumber + " new page " + this.m_newPageNumber;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)1);
        writer.write(this.m_anchorNumber);
        writer.write((byte)(this.m_first ? 1 : 0));
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_oldPageNumber);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_newPageNumber);
        writer.write(this.m_scratchBuffer, 0, 8);
        return 19;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_anchorNumber = buffer[currentOffset++];
        this.m_first = buffer[currentOffset++] == 1;
        this.m_oldPageNumber = BitUtil.getLong(buffer, currentOffset);
        this.m_newPageNumber = BitUtil.getLong(buffer, currentOffset += 8);
    }

    void initNote(byte anchorNumber, boolean first, long oldPageNumber, long newPageNumber) {
        this.m_anchorNumber = anchorNumber;
        this.m_first = first;
        this.m_oldPageNumber = oldPageNumber;
        this.m_newPageNumber = newPageNumber;
    }
}

