/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication;

import com.sonicsw.mtstorage.replication.AbstractCommunicationManager;
import com.sonicsw.mtstorage.replication.BackupConnection;
import com.sonicsw.mtstorage.replication.ICommunicationStatusHandler;
import com.sonicsw.mtstorage.replication.IMessageHandler;
import com.sonicsw.mtstorage.replication.IStateListener;
import com.sonicsw.mtstorage.replication.PeerConnection;
import com.sonicsw.mtstorage.replication.PrimaryConnection;
import com.sonicsw.mtstorage.replication.StateManager;
import com.sonicsw.mtstorage.replication.ftchannel.IChannelListener;
import com.sonicsw.mtstorage.replication.ftchannel.PermanentException;
import com.sonicsw.mtstorage.replication.util.BitUtil;
import com.sonicsw.mtstorage.replication.util.Serializer;
import com.sonicsw.mtstorage.replication.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;

final class BlackbirdCommunicationManager
extends AbstractCommunicationManager {
    private static final String COMM_TEST_PROPERTY = "_TEST_PSEReplication_TotalCommFailure";
    private static final int ARBITRARY_INITIAL_SEND_BUFFER_LENGTH = 10000;
    private static final byte REPLICATION_MESSAGE_TYPE = 1;
    private static final byte STATE_MESSAGE_TYPE = 2;
    private static final long ACTIVE_CONN_TIMEOUT_DEFAULT = 40L;
    private static final long STANDBY_CONN_TIMEOUT_DEFAULT = 90L;
    private boolean m_primary;
    private boolean m_closing = false;
    private ChannelListener m_channelListener;
    private HashMap[] m_connsConfigs;
    private HashMap m_commParams;
    private PeerConnection m_peer;
    private byte[] m_sendBuffer;
    private IMessageHandler m_peerStateHandler;
    private IMessageHandler m_replicationHandler;
    private ArrayList m_listeners = new ArrayList();
    private StateReporter m_stateReporter;
    private long m_connTimeout;
    private String m_peerRole;
    private boolean m_temporaryConnection = false;

    BlackbirdCommunicationManager(IMessageHandler peerStateHandler, IMessageHandler replicationHandler, boolean primary, boolean wasActiveOrStartActive) {
        this.m_sendBuffer = new byte[10000];
        this.m_channelListener = new ChannelListener();
        this.m_primary = primary;
        this.m_peerStateHandler = peerStateHandler;
        this.m_replicationHandler = replicationHandler;
        String tmp = System.getProperty("sonicsw.pse.replication.connection.timeout");
        if (tmp == null) {
            tmp = System.getProperty("sonicsw.ds.replication.connection.timeout");
        }
        this.m_connTimeout = wasActiveOrStartActive ? 40L : 90L;
        long propTimeout = tmp != null ? new Long(tmp) : -1L;
        this.m_connTimeout = (propTimeout >= 0L ? propTimeout : this.m_connTimeout) * 1000L;
        this.m_peerRole = this.m_primary ? "BACKUP" : "PRIMARY";
        String testFile = System.getProperty(COMM_TEST_PROPERTY);
        if (!this.m_primary && testFile != null) {
            this.testCommunication(testFile);
        }
    }

    @Override
    IStateListener getStateReporter() {
        this.m_stateReporter = new StateReporter();
        return this.m_stateReporter;
    }

    @Override
    void addListener(ICommunicationStatusHandler listener) {
        this.m_listeners.add(listener);
    }

    @Override
    void open(HashMap[] connsConfigs, HashMap commParams) throws IOException {
        Boolean tmp = (Boolean)commParams.get("_TEMPORARY_CONNECTION");
        this.m_temporaryConnection = tmp != null && tmp != false;
        this.m_connsConfigs = connsConfigs;
        this.m_commParams = commParams;
        try {
            this.doConnect(true, false);
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    void sendReplicationMessage(HashMap msgProperties) throws IOException {
        this.send((byte)1, msgProperties, new byte[0], 0, 0);
    }

    @Override
    void sendReplicationMessage(HashMap msgProperties, byte[] data, int dataOffset, int dataLength) throws IOException {
        this.send((byte)1, msgProperties, data, dataOffset, dataLength);
    }

    @Override
    void sendStateMessage(HashMap msgProperties) throws IOException {
        this.send((byte)2, msgProperties, new byte[0], 0, 0);
    }

    private synchronized void send(byte type, HashMap msgProperties, byte[] data, int dataOffset, int dataLength) throws IOException {
        byte[] serializedProps = Serializer.serialize(msgProperties);
        int totalLength = 9 + serializedProps.length + dataLength;
        if (this.m_sendBuffer.length < totalLength) {
            this.m_sendBuffer = new byte[totalLength];
        }
        int currentOffset = 0;
        BitUtil.putInt(this.m_sendBuffer, currentOffset, totalLength - 4);
        this.m_sendBuffer[currentOffset += 4] = type;
        BitUtil.putInt(this.m_sendBuffer, ++currentOffset, serializedProps.length);
        System.arraycopy(serializedProps, 0, this.m_sendBuffer, currentOffset += 4, serializedProps.length);
        System.arraycopy(data, dataOffset, this.m_sendBuffer, currentOffset += serializedProps.length, dataLength);
        this.m_peer.send(this.m_sendBuffer, 0, totalLength);
    }

    private void submitMessage(byte[] message, IMessageHandler handler) {
        int dataOffset;
        int dataLength;
        int currentOffset = 1;
        int propLength = BitUtil.getInt(message, currentOffset);
        HashMap msgProperties = (HashMap)Serializer.unserialize(message, currentOffset += 4);
        Boolean tmp = (Boolean)msgProperties.get("TEMPORARY_CONNECTION");
        if (tmp != null && tmp.booleanValue() && this.m_peer != null) {
            try {
                this.m_peer.doNotReportFailure();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((dataLength = message.length - (dataOffset = (currentOffset += propLength))) > 0) {
            handler.handleMessage(msgProperties, message, dataOffset, dataLength);
        } else {
            handler.handleMessage(msgProperties);
        }
    }

    private void doConnect(boolean firstConnect, boolean alwaysRetry) throws IOException, InterruptedException {
        if (!this.m_primary) {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.m_peer != null) {
            this.m_peer.close(true);
        }
        this.m_peer = this.m_primary ? new PrimaryConnection() : new BackupConnection();
        ConnectionHandler connHandler = new ConnectionHandler(!firstConnect);
        this.m_peer.open(this.m_connsConfigs, this.m_commParams, this.m_channelListener, connHandler, alwaysRetry);
        if (firstConnect) {
            connHandler.waitUntilConnected();
        }
    }

    private void reportConnected(boolean connStatus) {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ICommunicationStatusHandler handler = (ICommunicationStatusHandler)this.m_listeners.get(i);
            handler.connected(connStatus);
        }
    }

    private void permanentCommFailure(Exception e) {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ICommunicationStatusHandler handler = (ICommunicationStatusHandler)this.m_listeners.get(i);
            handler.permanentCommFailure(e);
        }
    }

    private void doReportEvent(String event, boolean warning) {
        if (event == null) {
            return;
        }
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ICommunicationStatusHandler handler = (ICommunicationStatusHandler)this.m_listeners.get(i);
            handler.reportEvent(event, warning);
        }
    }

    @Override
    void close() {
        this.m_closing = true;
        if (this.m_stateReporter != null) {
            this.m_stateReporter.close();
            this.m_stateReporter = null;
        }
        this.m_peer.close(true);
    }

    private void testCommunication(final String testFile) {
        System.out.println("_TEST_PSEReplication_TotalCommFailure is set: Communication Test Thread is ON; test file " + testFile);
        Thread testThread = new Thread("Test Communication"){

            @Override
            public void run() {
                while (!BlackbirdCommunicationManager.this.m_closing) {
                    File f;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!(f = new File(testFile)).exists()) continue;
                    BlackbirdCommunicationManager.this.testCommFailure(f);
                    return;
                }
            }
        };
        testThread.setDaemon(true);
        testThread.start();
    }

    private void testCommFailure(File f) {
        f.delete();
        this.m_peer.close(false);
        this.doReportEvent("Test: Communication 60 seconds failure!", true);
        this.reportConnected(false);
        try {
            Thread.sleep(60000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.doConnect(false, false);
        }
        catch (Exception e) {
            this.doReportEvent(e.toString(), true);
        }
        this.doReportEvent("Test: doConnect() called ", true);
    }

    private class ChannelListener
    implements IChannelListener {
        private ChannelListener() {
        }

        @Override
        public void connectionDropped(String errorMessage) {
            if (BlackbirdCommunicationManager.this.m_closing) {
                return;
            }
            BlackbirdCommunicationManager.this.doReportEvent(errorMessage, true);
            BlackbirdCommunicationManager.this.reportConnected(false);
            try {
                BlackbirdCommunicationManager.this.doConnect(false, true);
            }
            catch (Exception e) {
                BlackbirdCommunicationManager.this.permanentCommFailure(e);
            }
        }

        @Override
        public void reportEvent(String eventMessage, boolean warning) {
            BlackbirdCommunicationManager.this.doReportEvent(eventMessage, warning);
        }

        @Override
        public void messageReceived(byte[] data) {
            IMessageHandler handler = null;
            byte messageType = data[0];
            switch (messageType) {
                case 1: {
                    handler = BlackbirdCommunicationManager.this.m_replicationHandler;
                    break;
                }
                case 2: {
                    handler = BlackbirdCommunicationManager.this.m_peerStateHandler;
                    break;
                }
                default: {
                    throw new Error("CommunicationManager: Unknown message type " + messageType);
                }
            }
            BlackbirdCommunicationManager.this.submitMessage(data, handler);
        }
    }

    class ConnectionHandler {
        private boolean m_connected = false;
        private Exception m_exception = null;
        private boolean m_connectFailedCalled = false;
        private boolean m_gracePeriodOver = false;

        ConnectionHandler(boolean firstAttemptDone) {
            this.m_gracePeriodOver = firstAttemptDone;
        }

        synchronized void waitUntilConnected() throws IOException, InterruptedException {
            BlackbirdCommunicationManager.this.doReportEvent("Connecting to " + BlackbirdCommunicationManager.this.m_peerRole + " with a " + BlackbirdCommunicationManager.this.m_connTimeout / 1000L + " seconds timeout", false);
            this.wait(BlackbirdCommunicationManager.this.m_connTimeout);
            if (this.m_connected) {
                BlackbirdCommunicationManager.this.doReportEvent("Connected successfully to " + BlackbirdCommunicationManager.this.m_peerRole, false);
                return;
            }
            this.m_gracePeriodOver = true;
            if (this.m_exception == null) {
                BlackbirdCommunicationManager.this.doReportEvent("Failed to connect to " + BlackbirdCommunicationManager.this.m_peerRole + " (retrying)", true);
                BlackbirdCommunicationManager.this.reportConnected(false);
            } else {
                if (this.m_exception instanceof PermanentException) {
                    Throwable cause;
                    Throwable nextCause = cause = this.m_exception.getCause();
                    while ((nextCause = nextCause.getCause()) != null) {
                        if (!(nextCause instanceof SocketException)) continue;
                        cause = nextCause;
                        break;
                    }
                    cause.printStackTrace();
                    IOException ioe = cause instanceof IOException ? (IOException)cause : new IOException(cause.toString());
                    throw ioe;
                }
                BlackbirdCommunicationManager.this.doReportEvent("Failed to connect to " + BlackbirdCommunicationManager.this.m_peerRole + " (retrying): " + this.m_exception.toString(), true);
                BlackbirdCommunicationManager.this.reportConnected(false);
            }
        }

        synchronized void connected() {
            this.notifyAll();
            this.m_connected = true;
            if (this.m_gracePeriodOver) {
                BlackbirdCommunicationManager.this.reportConnected(true);
                return;
            }
            this.m_gracePeriodOver = true;
        }

        synchronized void connectFailed(Exception e) {
            if (e instanceof PermanentException) {
                this.m_gracePeriodOver = true;
                this.m_exception = e;
                this.m_connectFailedCalled = true;
                this.notifyAll();
                return;
            }
            if (!this.m_connectFailedCalled) {
                this.m_connectFailedCalled = true;
                return;
            }
            this.notifyAll();
            this.m_gracePeriodOver = true;
            this.m_exception = e;
        }
    }

    private class StateReporter
    extends Thread
    implements IStateListener {
        StateManager.State m_stateToSend;

        StateReporter() {
            super("CommunicationManager.StateReporter Thread");
            this.m_stateToSend = null;
            this.setDaemon(true);
            this.start();
        }

        @Override
        public synchronized void preShutdown() {
        }

        @Override
        public synchronized void stateComment(String comment) {
        }

        @Override
        public synchronized void newState(StateManager.State state, boolean toPeerOnly) {
            if (BlackbirdCommunicationManager.this.m_peer == null || !BlackbirdCommunicationManager.this.m_peer.isConnected()) {
                return;
            }
            this.m_stateToSend = state;
            this.notifyAll();
        }

        private synchronized void waitForNewState() {
            while (this.m_stateToSend == null && !BlackbirdCommunicationManager.this.m_closing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Tracer.TRACE(e);
                }
            }
        }

        private synchronized void close() {
            this.notifyAll();
        }

        @Override
        public void run() {
            while (true) {
                this.waitForNewState();
                if (BlackbirdCommunicationManager.this.m_closing) {
                    return;
                }
                StateManager.State state = this.m_stateToSend;
                this.newState(null, false);
                try {
                    BlackbirdCommunicationManager.this.sendStateMessage(state.toHashmap(BlackbirdCommunicationManager.this.m_temporaryConnection));
                    continue;
                }
                catch (IOException e) {
                    Tracer.TRACE(e);
                    continue;
                }
                break;
            }
        }
    }
}

