/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.Field;
import com.odi.IPersistent;
import com.odi.SchemaException;
import com.odi.imp.SchemaManager;
import java.lang.reflect.Modifier;

public class ClassField
extends com.odi.imp.Field {
    private String className;
    boolean isInterface;
    boolean isEmbeddedField = false;

    public ClassField(String fieldName, String className, boolean isInterface) {
        super(fieldName, (byte)15);
        this.className = className;
        this.isInterface = isInterface;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    void encodeType(StringBuffer buffer, boolean computeEncodingOnly) {
        if (this.isEmbeddedField) {
            Class<?> eClass = null;
            buffer.append('E');
            try {
                eClass = Class.forName(this.className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            if (eClass != null && !IPersistent.class.isAssignableFrom(eClass)) {
                throw new SchemaException("The class \"" + this.className + "\" associated with the embedded field \"" + this.getName() + "\" must implement the com.odi.IPersistent interface.");
            }
            if (Modifier.isAbstract(eClass.getModifiers())) {
                throw new SchemaException("The class \"" + this.className + "\" associated with the embedded field \"" + this.getName() + "\" must not be abstract.");
            }
        }
        if (this.isInterface) {
            SchemaManager.encodeInterfaceType(this.className, buffer);
        } else {
            SchemaManager.encodeClassType(this.className, buffer, computeEncodingOnly);
        }
    }

    @Override
    public String getTypeName() {
        return this.className;
    }

    @Override
    public Field makeEmbedded() {
        if (this.isInterface) {
            throw new IllegalArgumentException("\"" + this.name + "\" cannot be embedded, since it is an interface type");
        }
        this.isEmbeddedField = true;
        return this;
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbeddedField;
    }
}

