/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.ClassInfo;
import com.odi.FatalInternalException;
import com.odi.NoTransactionInProgressException;
import com.odi.Placement;
import com.odi.imp.Cluster;
import com.odi.imp.GenericObject;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.util.MapKeys;

public class Ref4ByteLocal
extends ReferenceType {
    private static Ref4ByteLocal _instance = null;
    static final int NULL_ENCODING = -1;
    final Ref4ByteLocalReference NULL_REF = new Ref4ByteLocalReference(-1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref4ByteLocal(int enumVal) {
        super(enumVal);
        Class<Ref4ByteLocal> clazz = Ref4ByteLocal.class;
        synchronized (Ref4ByteLocal.class) {
            if (_instance != null) {
                throw new FatalInternalException("Can not have more than one instances of a ReferenceType.");
            }
            _instance = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Reference makeReference(byte[] rep, int offset) {
        if (rep.length - offset < 4) {
            throw new FatalInternalException("Can not make reference with size less than 4");
        }
        int val = Ref4ByteLocal.makeInt(rep, offset);
        return new Ref4ByteLocalReference(val);
    }

    @Override
    public byte[] getBytes(Reference ref) {
        return Ref4ByteLocal.getBytes(((Ref4ByteLocalReference)ref).value);
    }

    static byte[] getBytes(int num) {
        byte[] out = new byte[4];
        int l = num;
        for (int i = 0; i < 4; ++i) {
            l = num >> 8 * i & 0xFF;
            out[3 - i] = (byte)l;
        }
        return out;
    }

    private static int makeInt(byte[] bytes, int offset) {
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            int t = bytes[offset + i] & 0xFF;
            ret |= t << 8 * (3 - i);
        }
        return ret;
    }

    @Override
    public Reference getFieldValue(GenericObject go, int fieldNum, ClassInfo cinfo) {
        int val = go.getIntField(fieldNum, cinfo);
        if (val == -1) {
            return this.NULL_REF;
        }
        return new Ref4ByteLocalReference(val);
    }

    @Override
    public void setFieldValue(Reference reference, GenericObject go, int fieldNum, ClassInfo cinfo) {
        go.setIntField(fieldNum, ((Ref4ByteLocalReference)reference).value, cinfo);
    }

    @Override
    public Reference[] getArrayFieldValue(int sz, GenericObject go, int fieldNum, ClassInfo cInfo) {
        int[] rep = (int[])go.getEmbeddedArrayField(fieldNum, cInfo, new int[sz]);
        return this.createRefArray(rep);
    }

    @Override
    public void setArrayFieldValue(Reference[] values, GenericObject go, int fieldNum, ClassInfo cInfo) {
        go.setEmbeddedArrayField(fieldNum, this.createIntArray(values), cInfo);
    }

    private Reference[] createRefArray(int[] rep) {
        Reference[] refs = new Ref4ByteLocalReference[rep.length];
        for (int i = 0; i < refs.length; ++i) {
            refs[i] = rep[i] == -1 ? this.NULL_REF : new Ref4ByteLocalReference(rep[i]);
        }
        return refs;
    }

    private int[] createIntArray(Reference[] rep) {
        int[] values = new int[rep.length];
        for (int i = 0; i < rep.length; ++i) {
            values[i] = ((Ref4ByteLocalReference)rep[i]).value;
        }
        return values;
    }

    @Override
    public Class getReferenceClass() {
        return Ref4ByteLocalReference.class;
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public Reference NULL() {
        return this.NULL_REF;
    }

    @Override
    public Reference getReference(Object object) {
        ObjectReference value = ObjectManager.getObjectReference(object);
        return this.getReference(value);
    }

    @Override
    public Reference getReference(ObjectReference value) {
        return new Ref4ByteLocalReference((int)value.getLocation());
    }

    @Override
    public Object resolve(Reference reference, com.odi.Cluster cluster, int AFTypecode) {
        return this.resolve(reference, cluster);
    }

    @Override
    public Object resolve(Reference reference, com.odi.Cluster cluster) {
        long location = ((Ref4ByteLocalReference)reference).value;
        ObjectManager om = (ObjectManager)cluster.getSession();
        if (!om.inTransaction()) {
            throw new NoTransactionInProgressException();
        }
        return om.resolveLazyReference(reference, cluster);
    }

    @Override
    public void resolveObjectReference(ObjectReference ref, Placement place, Reference reference, int AFTypeCode, int arrayElementCount) {
        MutatingObjRef objRef = (MutatingObjRef)ref;
        objRef.place = place;
        objRef.location = ((Ref4ByteLocalReference)reference).value;
        objRef.AFTypeCode = AFTypeCode;
        objRef.arrayElementCount = arrayElementCount;
    }

    @Override
    public void copy(Reference from, Reference to) {
        if (to == null) {
            throw new IllegalArgumentException("reference \"to\" must not be null");
        }
        ((Ref4ByteLocalReference)from).copyTo((Ref4ByteLocalReference)to);
    }

    @Override
    public boolean areEqualReferences(Reference reference, ObjectReference objRef) {
        return objRef.getLocation() == (long)((Ref4ByteLocalReference)reference).value;
    }

    @Override
    public ReferenceType childLeafType() {
        return this;
    }

    @Override
    public boolean isNullEncoding(byte[] rep, int offset, ObjectAccess objectAccess) {
        return ObjectAccess.decodeInt(rep, offset) == -1;
    }

    @Override
    public void encodeNull(byte[] rep, int offset, ObjectAccess objectAccess) {
        ObjectAccess.encodeInt(rep, offset, -1);
    }

    @Override
    public void encode(byte[] rep, int offset, Reference value, ObjectAccess objectAccess) {
        ObjectAccess.encodeInt(rep, offset, ((Ref4ByteLocalReference)value).value);
    }

    @Override
    public void encode(byte[] rep, int offset, Reference value) {
        ObjectAccess.encodeInt(rep, offset, ((Ref4ByteLocalReference)value).value);
    }

    @Override
    public byte[] encodeToByteArray(Reference ref, byte[] buffer) {
        return MapKeys.intToByteArray(((Ref4ByteLocalReference)ref).value, buffer);
    }

    @Override
    public Reference decode(byte[] rep, int offset, ObjectAccess objectAccess) {
        int value = ObjectAccess.decodeInt(rep, offset);
        return value == -1 ? this.NULL_REF : new Ref4ByteLocalReference(value);
    }

    @Override
    public Reference decode(byte[] rep, int offset) {
        int value = ObjectAccess.decodeInt(rep, offset);
        return value == -1 ? this.NULL_REF : new Ref4ByteLocalReference(value);
    }

    @Override
    public Reference decode(byte[] rep) {
        int value = MapKeys.byteArrayToInt(rep);
        return value == -1 ? this.NULL_REF : new Ref4ByteLocalReference(value);
    }

    @Override
    public ObjectReference createObjectReference(Reference lazyReference, Cluster cluster, int AFTypeCode) {
        return new MutatingObjRef(cluster, ((Ref4ByteLocalReference)lazyReference).value, AFTypeCode);
    }

    final class Ref4ByteLocalReference
    extends Reference {
        int value;

        Ref4ByteLocalReference() {
        }

        Ref4ByteLocalReference(int value) {
            this.value = value;
        }

        @Override
        public ReferenceType REFTYPE() {
            return ReferenceType.REF_4BYTE_LOCAL;
        }

        @Override
        public long getOID() {
            return this.value;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Ref4ByteLocalReference)) {
                return false;
            }
            return this.value == ((Ref4ByteLocalReference)other).value;
        }

        public int hashCode() {
            return this.value;
        }

        public void copyTo(Ref4ByteLocalReference to) {
            to.value = this.value;
        }

        public String toString() {
            return "" + this.value;
        }
    }
}

