/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.FatalInternalException;
import com.odi.Field;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.ObjectStore;
import com.odi.imp.ByteIterator;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.util.BTreeCheckValidInfo;
import com.odi.util.BTreeImpl;
import com.odi.util.BTreeNodeFactory;
import com.odi.util.KeyType;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public abstract class BTreeNode
implements IPersistent {
    static int MIN_MAX_ENTRIES = 100;
    static final int FIND_LESS_THAN_EQUAL = 1;
    static final int FIND_EQUAL = 2;
    static final int FIND_GREATER_THAN_EQUAL = 3;
    static final int FIND_GREATER_THAN = 4;
    protected short numEntries = 0;
    protected BTreeImpl btree;
    protected byte[] keys;
    protected Reference[] values;
    protected boolean childrenAreLeaves;
    private transient ReferenceType referenceTypeTransient;
    private transient KeyType keyTypeTransient;
    private static final int HEADER_SIZE = 15;
    transient short maxEntries = Short.MIN_VALUE;
    private transient ObjectReference ref;
    public transient byte objectState;
    private static Field[] fields = new Field[]{Field.createShort("numEntries"), Field.createClass("btree", "com.odi.util.BTreeImpl"), Field.createBoolean("childrenAreLeaves")};
    private static ClassInfo myOdiClassInfoInstance = BTreeNode.createClassInfo("com.odi.util.BTreeNode", fields);
    private static final Map classInfos = new HashMap(10);
    private transient int valuesOffset = -1;
    private static byte[] nullKey = new byte[0];

    abstract ReferenceType REFTYPE();

    abstract KeyType KEYTYPE();

    public BTreeNode(BTreeImpl btree) {
        this.btree = btree;
    }

    public BTreeNode(ClassInfo ignored) {
    }

    public BTreeNode() {
    }

    protected BTreeNode init() {
        this.keys = new byte[this.maxEntries() * this.KEYTYPE().size()];
        this.values = this.REFTYPE().getEmptyArray(this.maxEntries());
        return this;
    }

    ReferenceType nonLeafChildRefType() {
        return this.REFTYPE();
    }

    ReferenceType leafChildRefType() {
        return this.REFTYPE().childLeafType();
    }

    int headerSize() {
        return 15;
    }

    static short maxEntries(KeyType keyType, ReferenceType refType) {
        return BTreeNode.computeMaxEntries(keyType.size(), refType.size(), 15, BTreeImpl.PAGE_SIZE);
    }

    short maxEntries() {
        if (this.maxEntries < 0) {
            this.maxEntries = BTreeNode.maxEntries(this.KEYTYPE(), this.REFTYPE());
        }
        return this.maxEntries;
    }

    private static short computeMaxEntries(int keySize, int valueSize, int headerSize, int pageSize) {
        int sizePerEntry = keySize + valueSize;
        int result = (pageSize - headerSize) / sizePerEntry;
        if (result < MIN_MAX_ENTRIES) {
            result = (2 * pageSize - headerSize) / sizePerEntry;
            BTreeNode.odiAssert(result > MIN_MAX_ENTRIES, "Too few entries");
        }
        BTreeNode.odiAssert(result <= Short.MAX_VALUE, "Too many entries");
        return (short)(result / 2 * 2);
    }

    static Field[] getDynamicFields(ReferenceType refType, KeyType keyType) {
        return new Field[]{Field.createByteArray("keys", 1).makeEmbedded(BTreeNode.maxEntries(keyType, refType) * keyType.size()), Field.createReferenceArray("values", 1, refType).makeEmbedded(BTreeNode.maxEntries(keyType, refType))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ClassInfo getClassInfo(String className, Field[] fields) {
        ClassInfo cf = (ClassInfo)classInfos.get(className);
        if (cf != null) return cf;
        Class<BTreeNode> clazz = BTreeNode.class;
        synchronized (BTreeNode.class) {
            if (classInfos.get(className) != null) return cf;
            cf = BTreeNode.createClassInfo(className, fields);
            classInfos.put(className, cf);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cf;
        }
    }

    static ClassInfo getClassInfo(String className, ReferenceType refType, KeyType keyType) {
        return BTreeNode.getClassInfo(className, BTreeNode.getDynamicFields(refType, keyType));
    }

    static ClassInfo getClassInfo(Class clazz, ReferenceType refType, KeyType keyType) {
        return BTreeNode.getClassInfo(clazz.getName(), refType, keyType);
    }

    abstract ClassInfo getClassInfo();

    private static synchronized ClassInfo createClassInfo(String className, Field[] fields) {
        ClassInfo _classInfo = ClassInfo.register(ClassInfo.getDynamic(className, fields));
        if (BTreeImpl.debug) {
            System.out.println("[BTREE.DEBUG] createClassInfo: ClassInfo for " + className + " = " + _classInfo + "; Fields: " + BTreeNode.printFields(fields));
        }
        return _classInfo;
    }

    private static StringBuffer printFields(Field[] fields) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            buff.append(";" + fields[i].getName() + "(type=" + fields[i].getType() + ")");
        }
        return buff;
    }

    @Override
    public void initializeContents(GenericObject genericObject) {
        this.numEntries = genericObject.getShortField(1, myOdiClassInfoInstance);
        this.btree = (BTreeImpl)genericObject.getClassField(2, myOdiClassInfoInstance);
        this.childrenAreLeaves = genericObject.getBooleanField(3, myOdiClassInfoInstance);
        this.keys = (byte[])genericObject.getEmbeddedArrayField(1, this.getClassInfo(), new byte[this.maxEntries() * this.KEYTYPE().size()]);
        this.values = genericObject.getEmbeddedLazyReferenceArrayField(2, this.getClassInfo(), this.maxEntries(), this.REFTYPE());
    }

    @Override
    public void flushContents(GenericObject genericObject) {
        genericObject.setShortField(1, this.numEntries, myOdiClassInfoInstance);
        genericObject.setClassField(2, this.btree, myOdiClassInfoInstance);
        genericObject.setBooleanField(3, this.childrenAreLeaves, myOdiClassInfoInstance);
        genericObject.setEmbeddedArrayField(1, this.keys, this.getClassInfo());
        genericObject.setEmbeddedLazyReferenceArrayField(2, this.values, this.getClassInfo(), this.REFTYPE());
    }

    @Override
    public void clearContents() {
        this.numEntries = 0;
        this.btree = null;
        this.keys = null;
        this.values = null;
    }

    @Override
    public final ObjectReference ODIgetRef() {
        return this.ref;
    }

    @Override
    public final void ODIsetRef(ObjectReference ref) {
        this.ref = ref;
    }

    @Override
    public final byte ODIgetState() {
        return this.objectState;
    }

    @Override
    public final void ODIsetState(byte value) {
        this.objectState = value;
    }

    protected final void fetch() {
        if (this.objectState < 0) {
            ObjectManager.fetch(this);
        }
    }

    protected final void dirty() {
        if ((this.objectState & 2) != 0) {
            ObjectManager.dirty(this);
        }
    }

    protected void copyEntries(int fromIndex, BTreeNode toNode, int toIndex, int numToCopy) {
        this.fetch();
        ObjectStore.dirty(toNode);
        BTreeNode.odiAssert(fromIndex + numToCopy <= this.numEntries, "Bad index");
        int keySize = this.KEYTYPE().size();
        System.arraycopy(this.keys, fromIndex * keySize, toNode.keys, toIndex * keySize, numToCopy * keySize);
        this.copyValues(fromIndex, toNode, toIndex, numToCopy);
    }

    protected void copyValues(int fromIndex, BTreeNode toNode, int toIndex, int numToCopy) {
        System.arraycopy(this.values, fromIndex, toNode.values, toIndex, numToCopy);
    }

    protected void nullValues(int index, int count) {
        int max = index + count;
        for (int i = index; i < max; ++i) {
            this.values[i] = this.REFTYPE().NULL();
        }
    }

    protected int compareKey(byte[] key, int index) {
        this.fetch();
        if (index < this.numEntries) {
            int keySize = this.KEYTYPE().size();
            return this.KEYTYPE().compare(key, this.keys, index * keySize, this.btree);
        }
        if (index == this.numEntries) {
            return 1;
        }
        throw new FatalInternalException("Bad index");
    }

    protected int compareKey(int thisIndex, BTreeNode node, int nodeIndex) {
        this.fetch();
        if (thisIndex < this.numEntries && nodeIndex < node.getNumEntries()) {
            int keySize = this.KEYTYPE().size();
            ObjectStore.fetch(node);
            return this.KEYTYPE().compare(this.keys, thisIndex * keySize, node.keys, nodeIndex * keySize, this.btree);
        }
        throw new FatalInternalException("Bad index");
    }

    int findSubstringMatch(int index, byte[] substring, boolean caseInsensitive) {
        this.fetch();
        while (index < this.numEntries && !this.KEYTYPE().substringMatch(this.keys, index * this.KEYTYPE().size(), substring, caseInsensitive, this.btree)) {
            ++index;
        }
        return index;
    }

    protected boolean compareValue(int index, ObjectReference value, byte[] key) {
        BTreeNode child = this.getChildNode(index);
        if (key == null) {
            key = this.getKey(index, null);
        }
        return child.find(key, value, 2) >= 0;
    }

    protected byte[] getKey(int index, byte[] keyBuffer) {
        this.fetch();
        BTreeNode.odiAssert(index < this.numEntries, "Bad index");
        int keySize = this.KEYTYPE().size();
        return this.KEYTYPE().getKey(this.keys, index * keySize, keyBuffer, this.btree);
    }

    protected void setKey(int index, byte[] key) {
        this.dirty();
        int keySize = this.KEYTYPE().size();
        this.KEYTYPE().setKey(key, this.keys, index * keySize, this.btree);
        if (BTreeImpl.debug) {
            System.out.println("Set key " + BTreeNode.keyToString(key) + " at index " + index + "(offset=" + index * keySize + ")");
        }
    }

    protected void deallocate() {
        this.btree.deallocateNode(this);
    }

    protected void remove(int index) {
        this.dirty();
        BTreeNode child = this.getChildNode(index);
        if (BTreeImpl.debug) {
            System.out.println("Destroying key at index " + index + " for non-leaf node");
        }
        this.KEYTYPE().destroy(this.keys, index * this.KEYTYPE().size(), this.getIsLeaf(), this.btree);
        child.deallocate();
        if (this.numEntries > index + 1) {
            this.copyEntries(index + 1, this, index, this.numEntries - index - 1);
        }
        this.clearEntries(this.numEntries - 1, 1);
        this.numEntries = (short)(this.numEntries - 1);
    }

    protected KeyByteIterator keyByteIterator(int index) {
        return new KeyByteIterator(this, index);
    }

    final int findMatchingKey(byte[] key, int low, int high, int[] lastLow) {
        if (BTreeImpl.debug) {
            System.out.println("Looking for key " + BTreeNode.keyToString(key) + " in range [ " + low + "," + high + "]");
        }
        if (low > high) {
            lastLow[0] = low;
            return -9999;
        }
        int mid = (low + high) / 2;
        int compare = this.compareKey(key, mid);
        if (compare < 0) {
            return this.findMatchingKey(key, low, mid - 1, lastLow);
        }
        if (compare > 0) {
            return this.findMatchingKey(key, mid + 1, high, lastLow);
        }
        if (BTreeImpl.debug) {
            System.out.println("Found match at " + mid);
        }
        return mid;
    }

    final int find(byte[] key, int operation) {
        this.fetch();
        int[] lastLow = new int[]{0};
        int pos = this.findMatchingKey(key, 0, this.numEntries - 1, lastLow);
        if (BTreeImpl.debug) {
            System.out.println("Key " + BTreeNode.keyToString(key) + " found at index " + pos);
        }
        if (operation == 4) {
            return -9999;
        }
        if (pos >= 0) {
            return pos;
        }
        return operation == 2 ? pos : this.findRange(lastLow[0], key, operation);
    }

    int find(byte[] key, ObjectReference value, int operation) {
        this.fetch();
        int[] lastLow = new int[]{0};
        short pos = this.findMatchingKey(key, 0, this.numEntries - 1, lastLow);
        if (BTreeImpl.debug) {
            System.out.println("Key " + BTreeNode.keyToString(key) + " found at index " + pos + " Now searching for Reference " + value);
        }
        if (BTreeImpl.debug && value != null) {
            System.out.println("REference is " + ((ObjectManager)value.getPlacement().getSession()).findObject(value));
        }
        if (operation == 4) {
            pos = -9999;
        }
        if (pos >= 0) {
            short h;
            short exact = -1;
            short l = 0;
            for (h = pos; h < this.numEntries && this.compareKey(key, h) == 0; ++h) {
                if (!this.compareValue(h, value, key)) continue;
                exact = h;
                break;
            }
            if (exact < 0) {
                for (l = pos - 1; l >= 0 && this.compareKey(key, l) == 0; --l) {
                    if (!this.compareValue(l, value, key)) continue;
                    exact = l;
                    break;
                }
            }
            if (exact >= 0) {
                return operation == 4 ? (short)-9999 : exact;
            }
            switch (operation) {
                case 1: {
                    return l;
                }
                case 2: {
                    return -9999;
                }
                case 3: 
                case 4: {
                    return h;
                }
            }
        }
        return operation == 2 ? -9999 : this.findRange(lastLow[0], key, operation);
    }

    private int findRange(int l, byte[] key, int operation) {
        boolean isAbove;
        boolean bl = isAbove = l >= this.numEntries || this.compareKey(key, l) < 0;
        if (operation == 1) {
            return isAbove ? l - 1 : l;
        }
        return isAbove ? l : l + 1;
    }

    void insertValue(ObjectReference value, int index) {
        BTreeNode.odiAssert(index <= this.numEntries, "Bad index");
        if (index < this.numEntries) {
            this.copyEntries(index, this, index + 1, this.numEntries - index);
        }
        this.setValue(index, value);
    }

    void insertKey(byte[] key, int index) {
        BTreeNode child = this.getChildNode(index);
        this.updateKey(index, child);
    }

    protected void updateKey(int childIndex, BTreeNode child) {
        this.dirty();
        int keySize = this.KEYTYPE().size();
        System.arraycopy(child.keys, 0, this.keys, childIndex * keySize, keySize);
    }

    protected void updateValue(int index, Reference value) {
    }

    final boolean insert(byte[] key, ObjectReference value, int index) {
        this.fetch();
        if (this.numEntries == this.btree.getMaxNodeEntries()) {
            return false;
        }
        BTreeNode.odiAssert(index <= this.numEntries, "Bad index");
        this.dirty();
        this.shiftEntries(index);
        this.setValue(index, value);
        this.numEntries = (short)(this.numEntries + 1);
        this.insertKey(key, index);
        this.updateInsertedValue(index);
        if (BTreeImpl.debug) {
            System.out.println("Inserted value " + value + " at index " + index + "; values[i]=" + this.values[index]);
        }
        return true;
    }

    protected void updateInsertedValue(int index) {
        BTreeNode valueNode = this.getChildNode(index);
        valueNode.updateAfterInsert(this, index);
    }

    void updateAfterInsert(BTreeNode parent, int parentIndex) {
    }

    final void shiftEntries(int index) {
        if (index < this.numEntries) {
            this.copyEntries(index, this, index + 1, this.numEntries - index);
        }
    }

    final void moveEntries(int fromIndex, BTreeNode toNode, int toIndex, int numToMove) {
        this.fetch();
        ObjectStore.dirty(toNode);
        BTreeNode.odiAssert(this != toNode, "Move to this");
        if (toNode.numEntries > toIndex) {
            toNode.copyEntries(toIndex, toNode, toIndex + numToMove, toNode.numEntries - toIndex);
        }
        this.copyEntries(fromIndex, toNode, toIndex, numToMove);
        if (fromIndex + numToMove < this.numEntries) {
            this.copyEntries(fromIndex + numToMove, this, fromIndex, this.numEntries - fromIndex - numToMove);
        }
        this.clearEntries(this.numEntries - numToMove, numToMove);
        this.numEntries = (short)(this.numEntries - numToMove);
        toNode.numEntries = (short)(toNode.numEntries + numToMove);
    }

    boolean compareLeafEntry(byte[] key, boolean compareValue, ObjectReference value, int index) {
        throw new FatalInternalException("can not compareLeafEntry for non-leaf nodes");
    }

    protected Reference getChildReference(int index) {
        return this.values[index];
    }

    protected Object getValue(int index) {
        BTreeNode node = this.getChildNode(index);
        return node;
    }

    protected void setValue(int index, ObjectReference value) {
        this.dirty();
        Reference reference = this.values[index] = ObjRefUtils.isNull(value) ? this.REFTYPE().NULL() : this.REFTYPE().getReference(value);
        if (BTreeImpl.debug) {
            System.out.println("Set value " + ((ObjectManager)value.getPlacement().getSession()).findObject(value) + " as lazy ref=" + this.values[index] + " at index " + index + " in node with lazyref=" + this.REFTYPE().getReference(this));
        }
    }

    public BTreeNode getChildNode(int childIndex) {
        this.fetch();
        return (BTreeNode)this.getChildReference(childIndex).resolve(this.btree.cluster, this.childrenAreLeaves ? this.btree.leafNodeAFTypecode : this.btree.nonLeafNodeAFTypecode);
    }

    protected void printContents(PrintStream stream, int level) {
        this.fetch();
        byte[] keyBuffer = new byte[this.KEYTYPE().size()];
        for (int i = 0; i < this.numEntries; ++i) {
            for (int j = 0; j < level; ++j) {
                stream.print("  ");
            }
            stream.print(i + ": " + BTreeNode.keyToString(this.getKey(i, keyBuffer)));
            Reference value = this.getChildReference(i);
            stream.println(" => (" + value + ")");
            this.getChildNode(i).printContents(stream, level + 1);
        }
    }

    boolean checkValid(PrintStream stream, BTreeCheckValidInfo info) {
        int i;
        this.fetch();
        if (info == null) {
            info = new BTreeCheckValidInfo(stream);
            info.prevLeaf = this.btree.getTop();
        }
        this.validateNumEntries(info);
        this.validateClassName(info);
        this.validateLinks(info);
        for (i = 0; i < this.numEntries; ++i) {
            this.validateKey(info, i);
            this.validateChildren(stream, info, i);
        }
        for (i = this.numEntries; i < this.maxEntries; ++i) {
            this.validateValue(info, i);
        }
        if (this == this.btree.getTop() && this.btree.size() != info.nItems) {
            info.assertFailure("Found " + info.nItems + " items but size is " + this.btree.size());
        }
        return info.ok;
    }

    void validateNumEntries(BTreeCheckValidInfo info) {
        int minEntries;
        BTreeNode.odiAssert(info != null, "BTreeCheckValidInfo argument must not be null");
        int maxEntries = this.btree.getMaxNodeEntries();
        int n = minEntries = this == this.btree.getTop() ? 0 : maxEntries / 2;
        if (this.numEntries < minEntries || this.numEntries > maxEntries) {
            info.assertFailure("Node has " + this.numEntries + " entries");
        }
        if (this == this.btree.getTop() && this.btree.size() < this.btree.getMaxNodeEntries()) {
            info.odiAssert(this.getIsLeaf(), "Single node is not leaf");
        }
    }

    void validateClassName(BTreeCheckValidInfo info) {
        BTreeNode.odiAssert(info != null, "BTreeCheckValidInfo argument must not be null");
        BTreeNodeFactory cfr_ignored_0 = this.btree.nodeFactory;
        if (!this.getClass().getName().equals(BTreeNodeFactory.newNodeClassName(this.btree, this, false))) {
            BTreeNodeFactory cfr_ignored_1 = this.btree.nodeFactory;
            info.assertFailure("Node class is " + this.getClass().getName() + " but should be " + BTreeNodeFactory.newNodeClassName(this.btree, this, false));
        }
    }

    void validateLinks(BTreeCheckValidInfo info) {
    }

    void validateKey(BTreeCheckValidInfo info, int i) {
        BTreeNode.odiAssert(info != null, "BTreeCheckValidInfo argument must not be null");
        int compare = this.compareKey(info.lastKey, i);
        if (compare > 0) {
            info.assertFailure("Key " + BTreeNode.keyToString(info.lastKey) + " appears before key " + BTreeNode.keyToString(this.getKey(i, null)));
        } else if (compare < 0) {
            if (info.checkValue && i == 0) {
                info.assertFailure("Parent key " + BTreeNode.keyToString(info.lastKey) + " does not match first child key " + BTreeNode.keyToString(this.getKey(i, null)));
            }
        } else if (!this.btree.getDuplicateKeys()) {
            if (i != 0) {
                info.assertFailure("Key " + BTreeNode.keyToString(info.lastKey) + " is duplicated");
            }
        } else if (this.getIsLeaf() && info.checkValue && info.lastKeyValues.contains(this.getValue(i))) {
            info.assertFailure("Duplicate entry for key " + BTreeNode.keyToString(this.getKey(i, null)) + ", value" + this.getValue(i));
        }
        info.lastKey = this.getKey(i, null);
        if (compare != 0) {
            info.lastKeyValues.clear();
        }
    }

    void validateChildren(PrintStream stream, BTreeCheckValidInfo info, int i) {
        BTreeNode.odiAssert(info != null, "BTreeCheckValidInfo argument must not be null");
        BTreeNode child = this.getChildNode(i);
        child.checkValid(stream, info);
    }

    void validateValue(BTreeCheckValidInfo info, int i) {
        info.odiAssert(this.getValue(i) == null, "Value beyond node length was not null.");
    }

    final void clear() {
        this.dirty();
        this.clearEntries(0, this.numEntries);
        this.numEntries = 0;
    }

    public final boolean getChildrenAreLeaves() {
        return this.childrenAreLeaves;
    }

    public final void setChildrenAreLeaves(boolean value) {
        this.childrenAreLeaves = value;
    }

    public boolean getIsLeaf() {
        return false;
    }

    public final int getNumEntries() {
        this.fetch();
        return this.numEntries;
    }

    final void setNumEntries(short value) {
        this.dirty();
        this.numEntries = value;
    }

    void clearEntries(int index, int numToClear) {
        this.dirty();
        int max = index + numToClear;
        for (int i = index; i < max; ++i) {
            this.setKey(i, nullKey);
        }
        this.nullValues(index, numToClear);
    }

    static String keyToString(byte[] key) {
        StringBuffer buffer = new StringBuffer(2 + key.length * 2);
        buffer.append("0x");
        for (int j = 0; j < key.length; ++j) {
            int b = key[j] & 0xFF;
            buffer.append(Character.forDigit(b >>> 4, 16));
            buffer.append(Character.forDigit(b & 0xF, 16));
        }
        return buffer.toString();
    }

    static void odiAssert(boolean test, String failureMessage) {
        if (!test) {
            throw new FatalInternalException(failureMessage);
        }
    }

    public static int compareKeys(byte[] key1, int offset1, int length1, byte[] key2, int offset2, int length2) {
        int max = length1 > length2 ? length1 : length2;
        for (int i = 0; i < max; ++i) {
            byte b2;
            byte b1 = i < length1 ? key1[offset1 + i] : (byte)0;
            byte by = b2 = i < length2 ? key2[offset2 + i] : (byte)0;
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return 0;
    }

    static byte[] dupKey(byte[] source, int sourceIndex, int sourceLength, byte[] buffer) {
        if (buffer == null || sourceLength > buffer.length) {
            buffer = new byte[sourceLength];
        }
        BTreeNode.copyKey(source, sourceIndex, sourceLength, buffer, 0, buffer.length);
        return buffer;
    }

    static void copyKey(byte[] source, int sourceIndex, int sourceLength, byte[] dest, int destIndex, int destLength) {
        BTreeNode.odiAssert(sourceLength <= destLength, "Source too long");
        System.arraycopy(source, sourceIndex, dest, destIndex, sourceLength);
        if (sourceLength < destLength) {
            for (int i = sourceLength; i < destLength; ++i) {
                dest[destIndex + i] = 0;
            }
        }
    }

    static int keyLength(byte[] key) {
        for (int i = key.length - 1; i >= 0; --i) {
            if (key[i] == 0) continue;
            return i + 1;
        }
        return 0;
    }

    static int keyLength(byte[] keys, int offset, int maxLength) {
        for (int i = offset + maxLength - 1; i >= offset; --i) {
            if (keys[i] == 0) continue;
            return i - offset + 1;
        }
        return 0;
    }

    static class KeyByteIterator
    extends ByteIterator {
        protected KeyType.ByteIterator keyItr;
        protected BTreeNode node;

        protected KeyByteIterator(BTreeNode node, int index) {
            this.reset(node, index);
        }

        @Override
        public boolean hasNext() {
            return this.keyItr.hasNext();
        }

        @Override
        public byte next() {
            return this.keyItr.next();
        }

        protected void reset(BTreeNode node, int index) {
            this.node = node;
            ObjectStore.fetch(node);
            this.keyItr = node.KEYTYPE().getByteIterator(node.keys, node.KEYTYPE().size() * index, node.btree);
            this.keyItr.reset();
        }
    }
}

