/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.NoSessionException;
import com.odi.util.EmptyIterator;
import com.odi.util.OSAbstractCollection;
import com.odi.util.OSHashtable;
import com.odi.util.OSHashtableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

class OSHashtableCollectionView
extends OSAbstractCollection {
    int viewWhat;
    OSHashtable hashtable;

    OSHashtableCollectionView(OSHashtable t, int what) {
        this.hashtable = t;
        this.viewWhat = what;
    }

    @Override
    public int size() {
        return this.hashtable.size();
    }

    @Override
    public synchronized boolean contains(Object o) {
        switch (this.viewWhat) {
            case 0: {
                return this.hashtable.containsKey(o);
            }
            case 1: {
                return this.hashtable.contains(o);
            }
            case 2: {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                return this.hashtable.containsKey(entry.getKey()) && entry.getValue().equals(this.hashtable.get(entry.getKey()));
            }
        }
        return false;
    }

    @Override
    public synchronized Iterator iterator() {
        this.hashtable.fetch();
        if (this.hashtable.table == null) {
            return EmptyIterator.theEmptyIterator;
        }
        return new OSHashtableIterator(this.hashtable, this.viewWhat);
    }

    @Override
    public synchronized boolean remove(Object o) {
        switch (this.viewWhat) {
            case 0: {
                return this.hashtable.remove(o) != null;
            }
            case 1: {
                return this.hashtable.removeValue(o);
            }
            case 2: {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                if (this.hashtable.containsKey(entry.getKey()) && entry.getValue().equals(this.hashtable.get(entry.getKey()))) {
                    this.hashtable.remove(entry.getKey());
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.hashtable.clear();
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection coll = (Collection)o;
        return coll.size() == this.hashtable.size() && this.containsAll(coll);
    }

    @Override
    public synchronized int hashCode() {
        int h;
        block3: {
            h = 0;
            try {
                Iterator e = this.iterator();
                while (e.hasNext()) {
                    h += e.next().hashCode();
                }
            }
            catch (NoSessionException e) {
                if (Boolean.getBoolean("com.odi.debugHashCodes")) break block3;
                throw e;
            }
        }
        return h;
    }
}

