/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AsyncDeleteNote;
import com.sonicsw.mtstorage.impl.Storage;
import com.sonicsw.mtstorage.impl.TransactionEndNote;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

final class AsyncDeleteManager
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int DELETIONS_PER_TRANSACTION = 10;
    private static final long MILLIS_TO_SLEEP_WHEN_NO_OBJECTS = 30000L;
    private Storage m_st;
    private transient DeletionThread m_deletionThread = null;
    private DeletionList m_deletionList = new DeletionList();
    private TransContexts m_transContexts = new TransContexts();
    private boolean m_closingStorage = false;

    AsyncDeleteManager() {
        this.m_transContexts.setDelManager(this);
    }

    void startAlreadyDeletedCollection() {
        this.m_deletionList.startAlreadyDeletedCollection();
    }

    void alreadyDeleted(Long id) {
        this.m_deletionList.alreadyDeleted(id);
    }

    void undoAlreadyDeleted(Long id) {
        this.m_deletionList.undoAlreadyDeleted(id);
    }

    void endAlreadyDeletedCollection() {
        this.m_deletionList.endAlreadyDeletedCollection();
    }

    synchronized void startAsyncDeletion() {
        if (this.m_closingStorage) {
            return;
        }
        this.m_deletionThread = new DeletionThread();
    }

    void setStorage(Storage st) {
        this.m_st = st;
    }

    void markDeleted(Long transID, long dbkey) throws IOException {
        try {
            this.m_deletionThread.validateOK();
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        this.m_transContexts.addObjectID(transID, dbkey);
    }

    void redo(AsyncDeleteNote asyncDeleteNote) throws IOException {
        this.markDeleted(new Long(asyncDeleteNote.getTransID()), asyncDeleteNote.getDbk());
    }

    void transEnd(TransactionEndNote endNote) throws IOException {
        Long transID = new Long(endNote.getTransactionNum());
        this.transEnd(transID, endNote.m_committed);
    }

    void transEnd(Long transID, boolean commit) throws IOException {
        if (commit) {
            this.m_transContexts.transCommit(transID);
            try {
                this.m_deletionThread.wakeUp();
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            this.m_transContexts.transRollback(transID);
        }
    }

    synchronized boolean stopAsyncDeletion(boolean closingStorage) {
        this.m_closingStorage = closingStorage;
        if (this.m_deletionThread == null) {
            return false;
        }
        this.m_deletionThread.terminate();
        this.m_deletionThread = null;
        return true;
    }

    private void doSleep(long periodMillis) {
        try {
            Thread.sleep(periodMillis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addIDs(ArrayList ids) {
        this.m_deletionList.addIDs(ids);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.m_deletionList);
        s.writeObject(this.m_transContexts);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.m_deletionList = (DeletionList)s.readObject();
        if (this.m_deletionList == null) {
            this.m_deletionList = new DeletionList();
        }
        this.m_transContexts = (TransContexts)s.readObject();
        if (this.m_transContexts == null) {
            this.m_transContexts = new TransContexts();
        }
        this.m_transContexts.setDelManager(this);
    }

    byte[] serialize() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(this);
            byte[] bytes = out.toByteArray();
            objectOut.close();
            return bytes;
        }
        catch (Throwable t) {
            throw new Error("AsyncDeletionManager serialize failure: " + t.toString());
        }
    }

    static AsyncDeleteManager deSerialize(byte[] bytes, int offset) {
        try {
            ObjectInputStream objectIn = new ObjectInputStream(new ByteArrayInputStream(bytes, offset, bytes.length - offset));
            return (AsyncDeleteManager)objectIn.readObject();
        }
        catch (Exception t) {
            throw new Error("TransactionManager deSerialize failure: " + t.toString());
        }
    }

    private final class DeletionThread
    extends Thread {
        volatile Throwable m_failure;
        volatile boolean m_done;

        DeletionThread() {
            super("Sonic DB object async deletion thread");
            this.m_failure = null;
            this.m_done = false;
            this.setDaemon(true);
            this.start();
        }

        synchronized void wakeUp() {
            this.notifyAll();
        }

        @Override
        public void run() {
            try {
                while (!this.m_done) {
                    if (this.deleteObjects()) {
                        AsyncDeleteManager.this.doSleep(1L);
                        continue;
                    }
                    this.waitForObjectsToDelete(30000L);
                }
            }
            catch (Throwable t) {
                if (!AsyncDeleteManager.this.m_closingStorage) {
                    t.printStackTrace();
                }
                this.m_failure = t;
            }
        }

        private boolean deleteObjects() throws IOException {
            Long transID = null;
            for (int i = 0; i < 10; ++i) {
                Long objID = AsyncDeleteManager.this.m_deletionList.getNext();
                if (objID == null) {
                    if (transID != null) {
                        AsyncDeleteManager.this.m_st.commit(transID);
                    }
                    return i != 0;
                }
                if (i == 0) {
                    transID = AsyncDeleteManager.this.m_st.begin();
                }
                AsyncDeleteManager.this.m_st.delete(transID, objID, false, true);
                if (this.m_done) break;
            }
            AsyncDeleteManager.this.m_st.commit(transID);
            return true;
        }

        void terminate() {
            this.m_done = true;
            this.wakeUp();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void validateOK() throws IOException {
            if (this.m_failure == null) {
                return;
            }
            if (this.m_failure instanceof IOException) {
                throw (IOException)this.m_failure;
            }
            throw new IOException(this.m_failure.toString());
        }

        private synchronized void waitForObjectsToDelete(long maxWaitMillis) {
            try {
                this.wait(maxWaitMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private final class TransContexts
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private HashMap m_transactions = new HashMap();
        private AsyncDeleteManager m_delManager;

        TransContexts() {
        }

        void setDelManager(AsyncDeleteManager delManager) {
            this.m_delManager = delManager;
        }

        synchronized void addObjectID(Long transactionNum, long objectID) {
            ArrayList<Long> ids = (ArrayList<Long>)this.m_transactions.get(transactionNum);
            if (ids == null) {
                ids = new ArrayList<Long>();
                this.m_transactions.put(transactionNum, ids);
            }
            ids.add(new Long(objectID));
        }

        synchronized void transRollback(Long transactionNum) {
            this.m_transactions.remove(transactionNum);
        }

        synchronized void transCommit(Long transactionNum) {
            ArrayList ids = (ArrayList)this.m_transactions.remove(transactionNum);
            if (ids != null) {
                this.m_delManager.addIDs(ids);
            }
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.writeObject(this.m_transactions);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            this.m_transactions = (HashMap)s.readObject();
            if (this.m_transactions == null) {
                this.m_transactions = new HashMap();
            }
        }
    }

    private final class DeletionList
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private ArrayList m_list = new ArrayList();
        private transient HashSet m_alreadyDeleted;

        DeletionList() {
        }

        void startAlreadyDeletedCollection() {
            this.m_alreadyDeleted = new HashSet();
        }

        void alreadyDeleted(Long id) {
            this.m_alreadyDeleted.add(id);
        }

        void undoAlreadyDeleted(Long id) {
            this.m_alreadyDeleted.remove(id);
        }

        void endAlreadyDeletedCollection() {
            this.m_list.removeAll(this.m_alreadyDeleted);
        }

        synchronized int size() {
            return this.m_list.size();
        }

        synchronized void addIDs(ArrayList ids) {
            this.m_list.addAll(ids);
        }

        synchronized Long getNext() {
            if (this.m_list.isEmpty()) {
                return null;
            }
            return (Long)this.m_list.remove(0);
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.writeObject(this.m_list);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            this.m_list = (ArrayList)s.readObject();
            if (this.m_list == null) {
                this.m_list = new ArrayList();
            }
        }
    }
}

