/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BTreeAbstractBufferSupply;
import com.sonicsw.mtstorage.impl.Page;
import java.util.HashMap;

final class BTreeMemoryBufferSupply
extends BTreeAbstractBufferSupply {
    private static final int BUFFER_SIZE = Page.PAGE_LENGTH;
    private HashMap m_bufferTable = new HashMap();
    private HashMap m_cachedStates = new HashMap();
    private long m_nextDbk = 0L;

    BTreeMemoryBufferSupply() {
    }

    @Override
    BTreeAbstractBufferSupply.AllocatedBuffer allocateBuffer(long transNum, long unused) {
        byte[] buffer = new byte[BUFFER_SIZE];
        long newDbk = this.m_nextDbk++;
        this.m_bufferTable.put(new Long(newDbk), buffer);
        return new BTreeAbstractBufferSupply.AllocatedBuffer(buffer, 0, BUFFER_SIZE, newDbk, null);
    }

    @Override
    long getBufferNoteID(long dbk) {
        return 0L;
    }

    @Override
    BTreeAbstractBufferSupply.AllocatedBuffer getBuffer(long dbk, boolean forUpdate) {
        Long dbkO = new Long(dbk);
        BTreeAbstractBufferSupply.AllocatedBuffer buffer = new BTreeAbstractBufferSupply.AllocatedBuffer((byte[])this.m_bufferTable.get(dbkO), 0, BUFFER_SIZE, dbk, null);
        buffer.m_cachedState = this.m_cachedStates.get(dbkO);
        return buffer;
    }

    @Override
    void doneUpdateBuffer(BTreeAbstractBufferSupply.AllocatedBuffer allocatedBuffer, long transaction) {
        this.m_cachedStates.put(new Long(allocatedBuffer.m_dbk), allocatedBuffer.m_cachedState);
    }

    @Override
    void releaseBuffer(BTreeAbstractBufferSupply.AllocatedBuffer allocatedBuffer, long transaction) {
        Long dbkO = new Long(allocatedBuffer.m_dbk);
        this.m_bufferTable.remove(dbkO);
        this.m_cachedStates.remove(dbkO);
    }

    @Override
    void setCachedState(BTreeAbstractBufferSupply.AllocatedBuffer buffer) {
        this.m_cachedStates.put(new Long(buffer.m_dbk), buffer.m_cachedState);
    }
}

