/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.Page;
import java.util.ArrayList;
import java.util.HashMap;

final class PageWriterQueue {
    private HashMap m_pageIndex = new HashMap();
    ArrayList m_queue;
    long m_nextQueueID;
    long m_lastOueueIDWritten;
    private boolean m_stop = false;
    private int m_sizeLimit;

    PageWriterQueue(int sizeLimit) {
        this.m_sizeLimit = sizeLimit;
        this.m_queue = new ArrayList();
        this.m_lastOueueIDWritten = -1L;
        this.m_nextQueueID = 0L;
    }

    synchronized void queue(Page page) {
        boolean interrupted = false;
        do {
            interrupted = false;
            try {
                while (this.m_queue.size() == this.m_sizeLimit) {
                    if (this.m_stop) {
                        return;
                    }
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (interrupted);
        this.m_queue.add(new QueuePage(page, this.m_nextQueueID++));
        this.m_pageIndex.put(page.getPageKey(), page);
        this.notifyAll();
    }

    synchronized Page getFirstPageForWriting() {
        if (this.m_stop) {
            return null;
        }
        boolean interrupted = false;
        do {
            interrupted = false;
            try {
                while (this.m_queue.isEmpty()) {
                    if (this.m_stop) {
                        return null;
                    }
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (interrupted);
        QueuePage queuePage = (QueuePage)this.m_queue.get(0);
        return queuePage.m_page;
    }

    synchronized void acknowledgePageWritten() {
        QueuePage queuePage = (QueuePage)this.m_queue.remove(0);
        Page page = queuePage.m_page;
        this.m_lastOueueIDWritten = queuePage.m_queueID;
        Page indexedPage = (Page)this.m_pageIndex.get(page.getPageKey());
        if (indexedPage == page) {
            this.m_pageIndex.remove(page.getPageKey());
        }
        this.notifyAll();
    }

    synchronized boolean waitForAllPagesToBeWritten() {
        long tailID = this.m_nextQueueID - 1L;
        boolean interrupted = false;
        do {
            interrupted = false;
            try {
                while (tailID > this.m_lastOueueIDWritten) {
                    if (this.m_stop) {
                        return false;
                    }
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (interrupted);
        return true;
    }

    synchronized void terminate() {
        this.m_stop = true;
        this.notifyAll();
    }

    synchronized Page lookup(Long pageNum) {
        return (Page)this.m_pageIndex.get(pageNum);
    }

    final class QueuePage {
        Page m_page;
        long m_queueID;

        QueuePage(Page page, long queueID) {
            this.m_page = page;
            this.m_queueID = queueID;
        }
    }
}

