/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.ObjectStoreException;
import com.odi.ReplicationController;
import com.odi.ReplicationStateHandler;
import com.odi.imp.mtsonic.PhysicalStorage;
import java.util.HashMap;

public abstract class Storage {
    public static final String REPLICATION_RETRY_INTERVAL_ATTR = "REPLICATION_RETRY_INTERVAL";
    public static final String REPLICATION_PING_INTERVAL_ATTR = "REPLICATION_PING_INTERVAL";
    public static final String REPLICATION_FAILURE_DETECTION_TIMEOUT_ATTR = "REPLICATION_FAILURE_DETECTION_TIMEOUT";
    public static final String MAX_REPLICATION_LOG_SIZE_ATTR = "MAX_REPLICATION_LOG_SIZE";
    public static final String REPLICATION_TIMEOUT_ATTR = "REPLICATION_TIMEOUT";
    public static final String REPLICATION_SSL_ATTR = "REPLICATION_SSL";
    public static final String CIPHER_SUITE_ATTR = "CIPHER_SUITE";
    public static final String PRIMARY_KEY_STORE_FILE_ATT = "PRIMARY_KEY_STORE_FILE";
    public static final String PRIMARY_TRUST_STORE_FILE_ATT = "PRIMARY_TRUST_STORE_FILE";
    public static final String BACKUP_KEY_STORE_FILE_ATT = "BACKUP_KEY_STORE_FILE";
    public static final String BACKUP_TRUST_STORE_FILE_ATT = "BACKUP_TRUST_STORE_FILE";
    public static final String PRIMARY_KEY_STORE_PASSWORD_ATT = "PRIMARY_KEY_STORE_PASSWORD";
    public static final String PRIMARY_TRUST_STORE_PASSWORD_ATT = "PRIMARY_TRUST_STORE_PASSWORD";
    public static final String BACKUP_KEY_STORE_PASSWORD_ATT = "BACKUP_KEY_STORE_PASSWORD";
    public static final String BACKUP_TRUST_STORE_PASSWORD_ATT = "BACKUP_TRUST_STORE_PASSWORD";
    public static final String HANDSHAKE_TIMEOUT_ATT = "HANDSHAKE_TIMEOUT";
    public static final String CLOSE_TIMEOUT_ATT = "CLOSE_TIMEOUT";

    public static Storage openStorage(String path, HashMap parameters) throws ObjectStoreException {
        return PhysicalStorage.openPhysicalStorage(path, parameters);
    }

    public static Storage createStorage(String name, HashMap parameters) throws ObjectStoreException {
        return PhysicalStorage.createPhysicalStorage(name, parameters);
    }

    public static Storage openStorage(ReplicationController controller, ReplicationStateHandler callerStateListener, String path, HashMap storageParameters, boolean thisPrimary, boolean startActive, boolean autoDualActiveResolve, HashMap[] channelConfigs) throws ObjectStoreException {
        return PhysicalStorage.openPhysicalStorage(controller, callerStateListener, path, storageParameters, thisPrimary, startActive, autoDualActiveResolve, channelConfigs);
    }

    public static Storage createStorage(ReplicationController controller, ReplicationStateHandler callerStateListener, String path, HashMap storageParameters, boolean thisPrimary, boolean startActive, boolean autoDualActiveResolve, HashMap[] channelConfigs) throws ObjectStoreException {
        return PhysicalStorage.createPhysicalStorage(controller, callerStateListener, path, storageParameters, thisPrimary, startActive, autoDualActiveResolve, channelConfigs);
    }

    public static void setReplicationTracing(boolean trace, boolean trace_verbose) {
        PhysicalStorage.setReplicationTracing(trace, trace_verbose);
    }

    public abstract void close() throws ObjectStoreException;
}

