/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.ClassControl;
import com.odi.filter.ClassInfoBuilder;
import com.odi.filter.FieldAction;
import com.odi.filter.FilterEnv;
import com.odi.filter.FilterError;
import com.odi.filter.InvokeAnnotation;
import com.odi.filter.MethodAction;
import com.odi.filter.MethodBuilder;
import com.odi.filter.classfile.AttributeVector;
import com.odi.filter.classfile.ClassAttribute;
import com.odi.filter.classfile.ClassField;
import com.odi.filter.classfile.ClassFile;
import com.odi.filter.classfile.ClassMethod;
import com.odi.filter.classfile.CodeAttribute;
import com.odi.filter.classfile.ConstBasic;
import com.odi.filter.classfile.ConstClass;
import com.odi.filter.classfile.ConstFieldRef;
import com.odi.filter.classfile.ConstNameAndType;
import com.odi.filter.classfile.ConstantPool;
import com.odi.filter.classfile.Descriptor;
import com.odi.filter.classfile.GenericAttribute;
import com.odi.filter.classfile.Insn;
import com.odi.filter.classfile.InsnConstOp;
import com.odi.filter.classfile.VMConstants;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class ClassAction
implements VMConstants {
    private static final int GENClassInfo = 1;
    private static final int GENInitContents = 2;
    private static final int GENFlushContents = 4;
    private static final int GENClearContents = 8;
    private static final int GENClassInfoCtor = 16;
    private static final int GENRegisterInfo = 32;
    private static final int GENAllContents = 14;
    private static final String AnnotatedAttribute = "com.odi.annotated";
    private static final short AnnotatedVersion = 1;
    private ClassControl control;
    private Hashtable methodActionTable = new Hashtable(11);
    private Vector fieldActionTable = new Vector();
    private int generate;
    private String classInfoClass;
    private String classInfoMember = "myOdiClassInfoInstance";
    private String refMember = null;
    private boolean refMemberValid = false;
    private static final String defaultHashCodeMember = "ODITheHashCode";
    private String objectStateMember = null;
    private boolean objectStateMemberValid = false;
    private ClassControl objectStateMemberClassControl = null;
    private Vector registerInfo = new Vector(1);
    private boolean implementsPersistence = false;
    private boolean implementsPersistenceHooks = false;
    private boolean implementsPersistenceHooksKnown = false;
    private static final String iPersistentName = "com/odi/IPersistent";
    private static final String iPersistentHooksName = "com/odi/IPersistentHooks";
    private int totalFields = -1;
    private boolean needsHashCode = false;
    private boolean needsODIRefMethods = false;
    private boolean needsODIStateMethods = false;
    private boolean sawGetRef = false;
    private boolean sawGetState = false;
    private boolean needsPreDestroyPersistent = true;
    private boolean needsPostInitializeContents = true;
    private boolean needsPreFlushContents = true;
    private boolean needsPreClearContents = true;
    private boolean needsClone = true;
    private boolean previouslyAnnotated = false;

    public ClassAction(ClassControl theControl) {
        this.control = theControl;
    }

    public void scan1(FilterEnv filterEnv, boolean filterRequired) {
        if (!this.classFile().isInterface()) {
            this.checkHashCode(filterEnv);
        }
        if (filterRequired) {
            this.scanAttributes(filterEnv);
            this.scanFields(filterEnv);
            if (!this.previouslyAnnotated && !this.classFile().isInterface()) {
                this.scanMethods(filterEnv);
            }
        }
    }

    public void scan2(FilterEnv filterEnv, boolean filterRequired) {
        if (this.previouslyAnnotated && !filterEnv.updateInPlace()) {
            return;
        }
        this.checkClassInfo(filterEnv, filterRequired);
        if (filterRequired && !this.classFile().isInterface()) {
            this.checkPersistence(filterEnv);
            if ((this.generate & 1) != 0 && (this.generate & 0xE) != 14 && !this.previouslyAnnotated) {
                filterEnv.error("The ClassInfo for " + this.userClassName() + " needs to be generated but one or more of the" + " contents methods has been manually implemented.");
            }
            if (!filterEnv.optimizeClassInfo() && (this.generate & 1) == 0 && (this.generate & 0xE) != 0) {
                filterEnv.error("The ClassInfo for " + this.userClassName() + " has been manually implemented but one or more" + " of the contents methods needs to be generated.");
            }
            if (this.sawGetRef && !this.implementsPersistence) {
                filterEnv.error("The class " + this.userClassName() + " implements ODIgetRef() which overrides one of " + "its super-class's ODIgetRef() method.");
            }
            if (this.sawGetState && !this.implementsPersistence) {
                filterEnv.error("The class " + this.userClassName() + " implements ODIgetState() which overrides one of " + "its super-class's ODIgetState() method.");
            }
        }
    }

    public void augmentInterfaces(FilterEnv env, boolean filterRequired) {
        if (this.previouslyAnnotated) {
            return;
        }
        if (filterRequired) {
            if (this.implementsPersistence) {
                env.message("Modifying class " + this.control.userClassName() + " to implement " + ClassControl.userClassFromVMClass(iPersistentName));
                if (!this.control.implementsIPersistent(env)) {
                    this.augmentClassInterface(iPersistentName, env);
                }
                if (this.needsODIRefMethods) {
                    this.insertIPersistentFields(env, this.refMember, "Lcom/odi/imp/ObjectReference;", "com.odi.imp.ObjectReference", 130);
                }
                if (this.needsODIStateMethods) {
                    this.insertIPersistentFields(env, this.objectStateMember, "B", "byte", 129);
                }
                this.insertIPersistentMethods(env);
            }
            if (this.getImplementsPersistenceHooks() && !this.control.hasIPersistentHooksProvided(env)) {
                env.message("Modifying class " + this.control.userClassName() + " to implement " + ClassControl.userClassFromVMClass(iPersistentHooksName));
                this.augmentClassInterface(iPersistentHooksName, env);
                this.insertIPersistentHooksMethods(env);
            }
            if (this.needsHashCode) {
                this.insertIPersistentHashCodeImplementation(env);
            }
        }
    }

    public void retarget(FilterEnv filterEnv, Hashtable classTranslations, boolean filterRequired) {
        String newSig;
        String sig;
        String mapTo;
        if (this.classInfoClass != null && (mapTo = (String)classTranslations.get(this.classInfoClass)) != null) {
            this.classInfoClass = mapTo;
            this.control.noteUpdate(filterEnv);
        }
        ConstantPool pool = this.classFile().pool();
        int nEntries = pool.nEntries();
        for (int i = 0; i < nEntries; ++i) {
            ConstNameAndType ntRef;
            String sig2;
            String modSig;
            ConstBasic basic = pool.constantAt(i);
            if (basic == null) continue;
            if (basic instanceof ConstClass) {
                ConstClass classRef = (ConstClass)basic;
                String classRefName = classRef.asString();
                String translation = Descriptor.translateClass(classRefName, classTranslations);
                if (translation == classRefName) continue;
                classRef.changeClass(pool.addUtf8(translation));
                continue;
            }
            if (!(basic instanceof ConstNameAndType) || (modSig = Descriptor.remapTypes(sig2 = (ntRef = (ConstNameAndType)basic).signature().asString(), classTranslations)).equals(sig2)) continue;
            ntRef.changeSignature(pool.addUtf8(modSig));
        }
        Enumeration cme = this.classFile().methods().elements();
        while (cme.hasMoreElements()) {
            ClassMethod method = (ClassMethod)cme.nextElement();
            sig = method.signature().asString();
            newSig = Descriptor.remapTypes(sig, classTranslations);
            if (newSig.equals(sig)) continue;
            method.changeSignature(pool.addUtf8(newSig));
        }
        Enumeration cfe = this.classFile().fields().elements();
        while (cfe.hasMoreElements()) {
            ClassField field = (ClassField)cfe.nextElement();
            sig = field.signature().asString();
            newSig = Descriptor.remapTypes(sig, classTranslations);
            if (newSig.equals(sig)) continue;
            field.changeSignature(pool.addUtf8(newSig));
        }
        InvokeAnnotation.retarget(filterEnv, classTranslations);
        Enumeration me = this.methodActionTable.elements();
        while (me.hasMoreElements()) {
            MethodAction ma = (MethodAction)me.nextElement();
            ma.retarget(filterEnv, classTranslations);
        }
        Enumeration fe = this.fieldActionTable.elements();
        while (fe.hasMoreElements()) {
            FieldAction fa = (FieldAction)fe.nextElement();
            fa.retarget(filterEnv, classTranslations);
        }
        if (!filterRequired) {
            return;
        }
        this.control.noteUpdate(filterEnv);
    }

    public void annotate(FilterEnv env) {
        if (this.previouslyAnnotated && !env.updateInPlace()) {
            return;
        }
        this.bindFields(env);
        if ((this.generate & 1) != 0) {
            ClassFile cinfo = ClassInfoBuilder.makeClassInfo(this, this.classInfoClass, env);
            ClassControl infoControl = env.addClass(cinfo, this.control.source());
            infoControl.noteUpdate(env);
            infoControl.requireUpdate();
            try {
                infoControl.source().setModificationDate(this.control.source().modificationDate());
            }
            catch (FileNotFoundException fnfe) {
                throw new FilterError("Unexpected FileNotFoundException:" + fnfe.getMessage());
            }
        }
        if (this.previouslyAnnotated) {
            return;
        }
        boolean updates = false;
        Enumeration e = this.methodActions();
        while (e.hasMoreElements()) {
            MethodAction methodAction = (MethodAction)e.nextElement();
            if (!methodAction.needsAnnotation()) continue;
            methodAction.annotate(env);
            updates = true;
        }
        if ((this.generate & 2) != 0) {
            this.classFile().addMethod(MethodBuilder.makeInitializeContents(this, env));
            updates = true;
        }
        if ((this.generate & 4) != 0) {
            this.classFile().addMethod(MethodBuilder.makeFlushContents(this, env));
            updates = true;
        }
        if ((this.generate & 8) != 0) {
            this.classFile().addMethod(MethodBuilder.makeClearContents(this, env));
            updates = true;
        }
        if ((this.generate & 0x10) != 0) {
            this.classFile().addMethod(MethodBuilder.makeClassInfoCtor(this, env));
            updates = true;
        }
        if ((this.generate & 0x20) != 0) {
            ClassMethod clInit;
            if (!this.classFile().isInterface()) {
                MethodBuilder.buildClassInfoMember(this, env);
            }
            if ((clInit = this.classFile().findMethod("<clinit>", "()V")) == null) {
                clInit = MethodBuilder.makeClassInit(this, env);
                this.classFile().addMethod(clInit);
            }
            MethodBuilder.registerClassInfo(this, clInit, this.registerInfo, env);
            this.classFile().addMethod(MethodBuilder.makeGetClassInfoInstance(this, env));
            updates = true;
        }
        if (updates || env.updateInPlace()) {
            this.control.noteUpdate(env);
            byte[] data = new byte[]{0, 1};
            GenericAttribute annotatedAttr = new GenericAttribute(this.classFile().pool().addUtf8(AnnotatedAttribute), data);
            this.classFile().attributes().addElement(annotatedAttr);
        }
    }

    boolean canFindClassInfo(FilterEnv filterEnv) {
        this.checkForClassInfo(filterEnv);
        return filterEnv.canFindClass(this.classInfoClass);
    }

    ClassControl classControl() {
        return this.control;
    }

    ClassFile classFile() {
        return this.control.classFile();
    }

    Enumeration fieldActions() {
        return this.fieldActionTable.elements();
    }

    Enumeration methodActions() {
        return this.methodActionTable.elements();
    }

    boolean isInstantiable() {
        ClassFile cfile = this.classFile();
        return !cfile.isAbstract() && !cfile.isInterface();
    }

    public String className() {
        return this.control.className();
    }

    public String userClassName() {
        return this.control.userClassName();
    }

    public boolean getImplementsPersistence() {
        return this.implementsPersistence;
    }

    public boolean getImplementsPersistenceHooks() {
        if (!this.implementsPersistenceHooksKnown) {
            if (!(this.needsPreDestroyPersistent && this.needsPreClearContents && this.needsPreFlushContents && this.needsPostInitializeContents)) {
                this.implementsPersistenceHooks = true;
            }
            this.implementsPersistenceHooksKnown = true;
        }
        return this.implementsPersistenceHooks;
    }

    public String classInfoClassName() {
        return this.classInfoClass;
    }

    public String getClassInfoMember() {
        return this.classInfoMember;
    }

    public String getHashCodeMember() {
        return defaultHashCodeMember;
    }

    public boolean getNeedsHashCode() {
        return this.needsHashCode;
    }

    public String getRefMember() {
        return this.refMember;
    }

    public boolean getRefMemberValid() {
        return this.refMemberValid;
    }

    public void setRefMember(String orm) {
        this.refMember = orm;
        this.refMemberValid = true;
    }

    public boolean getNeedsODIRefMethods() {
        return this.needsODIRefMethods;
    }

    public String getObjectStateMember() {
        return this.objectStateMember;
    }

    public boolean getObjectStateMemberValid() {
        return this.objectStateMemberValid;
    }

    public ClassControl getObjectStateMemberClassControl(FilterEnv env) {
        return this.objectStateMemberClassControl;
    }

    public void setObjectStateMember(String osm) {
        this.objectStateMember = osm;
        this.objectStateMemberValid = true;
        this.objectStateMemberClassControl = this.control;
    }

    public void setObjectStateMember(String osm, ClassControl cc) {
        this.objectStateMember = osm;
        this.objectStateMemberValid = true;
        this.objectStateMemberClassControl = cc;
    }

    public boolean getNeedsODIStateMethods() {
        return this.needsODIStateMethods;
    }

    public boolean getNeedsClone() {
        return this.needsClone;
    }

    public boolean hasAnnotatedAttribute(FilterEnv env) {
        if (this.previouslyAnnotated) {
            return true;
        }
        Enumeration e = this.classFile().attributes().elements();
        while (e.hasMoreElements()) {
            ClassAttribute attr = (ClassAttribute)e.nextElement();
            if (!attr.attrName().asString().equals(AnnotatedAttribute)) continue;
            return true;
        }
        return false;
    }

    public boolean hasClassInfoStatic() {
        ClassField aField = this.classFile().findField(this.classInfoMember);
        return aField != null && aField.isStatic() && aField.signature().asString().equals("Lcom/odi/ClassInfo;");
    }

    boolean fieldIsPersistent(String fieldName, FilterEnv env) {
        ClassField field = this.classFile().findField(fieldName);
        if (field != null) {
            return FieldAction.fieldIsPersistent(this.classFile(), field, env);
        }
        return false;
    }

    private void scanAttributes(FilterEnv env) {
        Enumeration e = this.classFile().attributes().elements();
        while (e.hasMoreElements()) {
            ClassAttribute attr = (ClassAttribute)e.nextElement();
            if (!attr.attrName().asString().equals(AnnotatedAttribute)) continue;
            this.previouslyAnnotated = true;
            if (this.control.isImplicitlyPersistent() || env.updateInPlace()) break;
            env.error("class " + this.control.userClassName() + " was previously annotated.");
            break;
        }
    }

    private void scanFields(FilterEnv env) {
        if (this.control.persistType() == 1) {
            Enumeration e = this.classFile().fields().elements();
            while (e.hasMoreElements()) {
                ClassField f = (ClassField)e.nextElement();
                FieldAction action = new FieldAction(this, f);
                action.check(env);
                this.fieldActionTable.addElement(action);
            }
        }
    }

    private void scanMethods(FilterEnv env) {
        boolean sawInitializeContents = false;
        boolean sawFlushContents = false;
        boolean sawClearContents = false;
        boolean sawClassInfoCtor = false;
        boolean sawSetRef = false;
        boolean sawSetState = false;
        boolean isPersistent = this.control.persistType() == 1;
        Enumeration e = this.classFile().methods().elements();
        while (e.hasMoreElements()) {
            ClassMethod m = (ClassMethod)e.nextElement();
            String methodName = m.name().asString();
            String methodSig = m.signature().asString();
            if (isPersistent) {
                if (methodName.equals("initializeContents") && methodSig.equals("(Lcom/odi/GenericObject;)V")) {
                    sawInitializeContents = true;
                } else if (methodName.equals("flushContents") && methodSig.equals("(Lcom/odi/GenericObject;)V")) {
                    sawFlushContents = true;
                } else if (methodName.equals("clearContents") && methodSig.equals("()V")) {
                    sawClearContents = true;
                } else if (methodName.equals("ODIgetRef") && methodSig.equals("()Lcom/odi/imp/ObjectReference;")) {
                    this.sawGetRef = true;
                    this.setRefMember(this.disassembleGetter(env, m, "Lcom/odi/imp/ObjectReference;"));
                } else if (methodName.equals("ODIsetRef") && methodSig.equals("(Lcom/odi/imp/ObjectReference;)V")) {
                    sawSetRef = true;
                } else if (methodName.equals("ODIgetState") && methodSig.equals("()B")) {
                    this.sawGetState = true;
                    this.setObjectStateMember(this.disassembleGetter(env, m, "B"));
                } else if (methodName.equals("ODIsetState") && methodSig.equals("(B)V")) {
                    sawSetState = true;
                } else if (methodName.equals("<init>") && methodSig.equals("(Lcom/odi/ClassInfo;)V")) {
                    sawClassInfoCtor = true;
                } else if (methodName.equals("preDestroyPersistent") && methodSig.equals("()V")) {
                    this.needsPreDestroyPersistent = false;
                } else if (methodName.equals("postInitializeContents") && methodSig.equals("()V")) {
                    this.needsPostInitializeContents = false;
                } else if (methodName.equals("preFlushContents") && methodSig.equals("()V")) {
                    this.needsPreFlushContents = false;
                } else if (methodName.equals("preClearContents") && methodSig.equals("()V")) {
                    this.needsPreClearContents = false;
                } else if (methodName.equals("clone") && methodSig.equals("()Ljava/lang/Object;")) {
                    this.needsClone = false;
                }
            }
            MethodAction action = new MethodAction(this, m);
            action.check(env);
            this.methodActionTable.put(m, action);
        }
        if (isPersistent) {
            if (!sawInitializeContents) {
                this.generate |= 2;
            }
            if (!sawFlushContents) {
                this.generate |= 4;
            }
            if (!sawClearContents) {
                this.generate |= 8;
            }
            if (!sawClassInfoCtor) {
                this.generate |= 0x10;
            }
            if (this.sawGetRef != sawSetRef) {
                env.error("class " + this.control.userClassName() + " defines a method called " + (this.sawGetRef ? "ODIgetRef()" : "ODIsetRef()") + " but the corresponding method " + (sawSetRef ? "ODIgetRef()" : "ODIsetRef()") + " was not defined." + "\nPlease define either both or neither of these methods.");
            }
            if (this.sawGetState != sawSetState) {
                env.error("class " + this.control.userClassName() + " defines a method called " + (this.sawGetRef ? "ODIgetState()" : "ODIsetState()") + " but the corresponding method " + (sawSetRef ? "ODIgetState()" : "ODIsetState()") + " was not defined." + "\nPlease define either both or neither of these methods.");
            }
            if (!this.sawGetRef) {
                ClassMethod getRefMethod;
                ClassControl refCC = this.control.findMethodClass(env, "ODIgetRef", "(Lcom/odi/imp/ObjectReference;)V");
                ClassMethod classMethod = getRefMethod = refCC == null ? null : refCC.classFile().findMethod("ODIgetRef", "(Lcom/odi/imp/ObjectReference;)V");
                if (getRefMethod == null) {
                    this.needsODIRefMethods = true;
                    this.setRefMember("ODIref");
                } else {
                    this.setRefMember(this.disassembleGetter(env, getRefMethod, "Lcom/odi/imp/ObjectReference;"));
                }
            }
            if (!this.sawGetState) {
                ClassMethod getStateMethod;
                ClassControl stateCC = this.control.findMethodClass(env, "ODIgetState", "()B");
                ClassMethod classMethod = getStateMethod = stateCC == null ? null : stateCC.classFile().findMethod("ODIgetState", "()B");
                if (getStateMethod == null) {
                    this.needsODIStateMethods = true;
                    this.setObjectStateMember("ODIObjectState", this.control.findBasestPersistCapable(env));
                } else {
                    this.setObjectStateMember(this.disassembleGetter(env, getStateMethod, "B"), stateCC);
                }
            }
        }
    }

    void ensureObjectStateMemberValid(FilterEnv env) {
        if (!this.getObjectStateMemberValid()) {
            ClassMethod getStateMethod;
            ClassControl stateCC = this.control.findMethodClass(env, "ODIgetState", "()B");
            ClassMethod classMethod = getStateMethod = stateCC == null ? null : stateCC.classFile().findMethod("ODIgetState", "()B");
            if (getStateMethod == null) {
                this.setObjectStateMember(null);
                return;
            }
            this.setObjectStateMember(this.disassembleGetter(env, getStateMethod, "B"), stateCC);
        }
    }

    private String disassembleGetter(FilterEnv env, ClassMethod m, String fieldSignature) {
        Insn returnInsn;
        CodeAttribute codeAttr = m.codeAttribute();
        if (codeAttr == null) {
            return null;
        }
        Insn firstInsn = codeAttr.theCode();
        Insn aloadInsn = firstInsn == null ? null : firstInsn.next();
        Insn getFieldInsn = aloadInsn == null ? null : aloadInsn.next();
        Insn insn = returnInsn = getFieldInsn == null ? null : getFieldInsn.next();
        if (aloadInsn == null || aloadInsn.opcode() != 42 || getFieldInsn == null || getFieldInsn.opcode() != 180 || returnInsn == null || returnInsn.opcode() != 172 && returnInsn.opcode() != 176) {
            return null;
        }
        ConstFieldRef fieldRef = (ConstFieldRef)((InsnConstOp)getFieldInsn).value();
        String fieldOf = fieldRef.className().asString();
        ClassControl cc = env.findClass(fieldOf);
        ConstNameAndType nameAndType = fieldRef.nameAndType();
        String fieldName = nameAndType.name().asString();
        ClassField field = cc.classFile().findField(fieldName);
        if (cc != null && cc.persistCapable(env) && nameAndType.signature().asString().equals(fieldSignature) && field != null && (field.access() & 1) != 0) {
            String ret = nameAndType.name().asString();
            env.message("Found ODIgetState() method in class " + cc.userClassName() + " which refers to public field " + ret);
            return ret;
        }
        return null;
    }

    private void initClassInfoClassName(String suffix) {
        String className = this.className();
        StringBuffer buf = new StringBuffer(this.className());
        buf.append(suffix);
        this.classInfoClass = buf.toString();
    }

    private void checkForClassInfo(FilterEnv filterEnv) {
        if (this.classInfoClass == null) {
            this.initClassInfoClassName("Info");
            if (this.isClassInfoClass(this.classInfoClass, filterEnv)) {
                return;
            }
            this.initClassInfoClassName("ClassInfo");
            if (this.isClassInfoClass(this.classInfoClass, filterEnv)) {
                return;
            }
            this.initClassInfoClassName("CI");
            if (this.isClassInfoClass(this.classInfoClass, filterEnv)) {
                return;
            }
            this.initClassInfoClassName(filterEnv.classInfoSuffix());
        }
    }

    private boolean isClassInfoClass(String className, FilterEnv env) {
        ClassControl cc = env.findClass(className);
        return cc != null && cc.inherits("com/odi/ClassInfo", env);
    }

    private void checkClassInfo(FilterEnv filterEnv, boolean filterRequired) {
        if (this.control.persistType() == 1) {
            this.checkForClassInfo(filterEnv);
            if (filterRequired && (!filterEnv.canFindClass(this.classInfoClass) || (this.generate & 0xE) != 0)) {
                if (!filterEnv.optimizeClassInfo() || !this.classFile().isInterface() && !this.classFile().isPublic() && !this.classFile().isAbstract() || filterEnv.needsClassInfo(this.className())) {
                    this.generate |= 1;
                }
                if (!this.previouslyAnnotated && !this.classFile().isInterface()) {
                    this.generate |= 0x20;
                    if ((this.generate & 1) == 0) {
                        Enumeration fe = this.fieldActions();
                        while (fe.hasMoreElements()) {
                            FieldAction fa = (FieldAction)fe.nextElement();
                            if (fa.getFieldNote() == null) continue;
                            this.registerInfo.addElement(fa.getFieldNote());
                        }
                    }
                    this.registerInfo.addElement(this);
                }
            }
        }
    }

    private void checkHashCode(FilterEnv filterEnv) {
        if (filterEnv.hashCodeRequested(this.userClassName())) {
            ClassFile cfile = this.classFile();
            ClassMethod method = cfile.findMethod("hashCode", "()I");
            if (method != null) {
                filterEnv.error("A hashCode() method was requested for class " + this.userClassName() + " but the class already has " + "a hashCode() method defined.");
            } else {
                this.needsHashCode = true;
            }
        }
        if (this.control.persistType() == 1 && this.isInstantiable() && filterEnv.addDefaultHashCode()) {
            ClassFile cfile;
            ClassMethod method;
            ClassAction ca = this;
            while ((method = (cfile = ca.classFile()).findMethod("hashCode", "()I")) == null && !filterEnv.hashCodeRequested(ca.className())) {
                String superName = cfile.superNameString();
                if (superName.equals("java/lang/Object")) {
                    ca.needsHashCode = true;
                    break;
                }
                ClassControl cc = filterEnv.findClass(superName);
                if (cc == null) {
                    throw new FilterError("Unable to find class " + superName);
                }
                ca = cc.action();
            }
        }
    }

    private void checkPersistence(FilterEnv filterEnv) {
        if (this.control.persistType() == 1) {
            ClassFile cfile = this.classFile();
            if (cfile.superNameString().equals("java/lang/Object")) {
                this.implementsPersistence = true;
            } else {
                this.needsODIRefMethods = false;
                this.needsODIStateMethods = false;
            }
        }
    }

    private void insertIPersistentFields(FilterEnv env, String fieldName, String signature, String printableSignature, int accessFlags) {
        this.control.noteUpdate(env);
        ClassFile cfile = this.classFile();
        ConstantPool pool = cfile.pool();
        ConstClass thisClass = cfile.className();
        ClassField theField = cfile.findField(fieldName);
        if (theField != null) {
            if (theField.isStatic() || theField.isFinal() || !theField.signature().asString().equals(signature)) {
                env.error("Member " + fieldName + " of class " + this.classControl().userClassName() + " must be non-static, non-final, transient and of type " + printableSignature);
            }
        } else {
            env.message("Modifying class " + this.control.userClassName() + " to contain " + fieldName + " field.");
            theField = new ClassField(accessFlags, pool.addUtf8(fieldName), pool.addUtf8(signature), new AttributeVector());
            cfile.addField(theField);
        }
    }

    private void insertIPersistentHashCodeImplementation(FilterEnv env) {
        env.message("Modifying class " + this.control.userClassName() + " to contain hashCode() method and " + defaultHashCodeMember + " field.");
        this.control.noteUpdate(env);
        ClassFile cfile = this.classFile();
        ConstantPool pool = cfile.pool();
        ClassField f = new ClassField(2, pool.addUtf8(defaultHashCodeMember), pool.addUtf8("I"), new AttributeVector());
        cfile.addField(f, 0);
        FieldAction action = new FieldAction(this, f);
        action.notePersistentAddition(env);
        this.fieldActionTable.insertElementAt(action, 0);
        cfile.addMethod(MethodBuilder.makeHashCode(this, env));
        cfile.addMethod(MethodBuilder.makeODIComputeHashCode(this, env));
    }

    private void insertIPersistentMethods(FilterEnv env) {
        if (this.needsODIRefMethods) {
            env.message("Modifying class " + this.control.userClassName() + " to contain ODIgetRef and ODIsetRef methods.");
            this.classFile().addMethod(MethodBuilder.makeODIGetRef(this, env));
            this.classFile().addMethod(MethodBuilder.makeODISetRef(this, env));
        }
        if (this.needsODIStateMethods) {
            env.message("Modifying class " + this.control.userClassName() + " to contain ODIgetState and ODIsetState methods.");
            this.classFile().addMethod(MethodBuilder.makeODIGetState(this, env));
            this.classFile().addMethod(MethodBuilder.makeODISetState(this, env));
        }
        if (this.needsClone) {
            env.message("Modifying class " + this.control.userClassName() + " to contain Clone method.");
            this.classFile().addMethod(MethodBuilder.makeClone(this, env));
        }
        if (this.needsODIRefMethods || this.needsODIStateMethods || this.needsClone) {
            this.control.noteUpdate(env);
        }
    }

    private void insertIPersistentHooksMethods(FilterEnv env) {
        if (this.needsPreDestroyPersistent) {
            this.classFile().addMethod(MethodBuilder.makeNullMethod(this, env, "preDestroyPersistent"));
        }
        if (this.needsPostInitializeContents) {
            this.classFile().addMethod(MethodBuilder.makeNullMethod(this, env, "postInitializeContents"));
        }
        if (this.needsPreFlushContents) {
            this.classFile().addMethod(MethodBuilder.makeNullMethod(this, env, "preFlushContents"));
        }
        if (this.needsPreClearContents) {
            this.classFile().addMethod(MethodBuilder.makeNullMethod(this, env, "preClearContents"));
        }
        if (this.needsPreDestroyPersistent || this.needsPostInitializeContents || this.needsPreFlushContents || this.needsPreClearContents) {
            this.control.noteUpdate(env);
        }
    }

    private void augmentClassInterface(String interfaceName, FilterEnv env) {
        this.control.noteUpdate(env);
        ClassFile cfile = this.classFile();
        ConstClass iface = cfile.pool().addClass(interfaceName);
        cfile.addInterface(iface);
    }

    private int bindFields(FilterEnv env) {
        if (this.totalFields < 0) {
            this.totalFields = 0;
            Enumeration e = this.fieldActions();
            while (e.hasMoreElements()) {
                FieldAction act = (FieldAction)e.nextElement();
                if (!act.isPersistent()) continue;
                act.setIndex(++this.totalFields);
            }
        }
        return this.totalFields;
    }
}

