/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.AnnotationConstants;
import com.odi.filter.ClassControl;
import com.odi.filter.FilterEnv;
import com.odi.filter.FilterError;
import com.odi.filter.MethodEntry;
import com.odi.filter.classfile.ConstBasicMemberRef;
import com.odi.filter.classfile.Descriptor;
import java.util.Enumeration;
import java.util.Hashtable;

final class InvokeAnnotation
implements AnnotationConstants {
    private InvokeAnnotation nextOne;
    private int whichArgNum;
    private int annotateType;
    private static Hashtable methods = new Hashtable();

    InvokeAnnotation next() {
        return this.nextOne;
    }

    int whichArg() {
        return this.whichArgNum;
    }

    int annotateHow() {
        return this.annotateType;
    }

    InvokeAnnotation(int arg, int type) {
        this.whichArgNum = arg;
        this.annotateType = type;
    }

    static InvokeAnnotation checkInvoke(ConstBasicMemberRef method, FilterEnv env) {
        MethodEntry e = (MethodEntry)methods.get(method.className().asString());
        if (e != null) {
            String methodName = method.nameAndType().name().asString();
            String methodSig = method.nameAndType().signature().asString();
            while (e != null) {
                if (e.methodSig.equals(methodSig) && e.methodName.equals(methodName)) {
                    return e.annotationList;
                }
                e = e.next;
            }
        }
        return InvokeAnnotation.buildMethodEntry((ConstBasicMemberRef)method, (FilterEnv)env).annotationList;
    }

    static void retarget(FilterEnv env, Hashtable classTranslations) {
        Enumeration hte = methods.elements();
        while (hte.hasMoreElements()) {
            MethodEntry entry = (MethodEntry)hte.nextElement();
            while (entry != null) {
                block6: {
                    block5: {
                        block4: {
                            String mapTo = (String)classTranslations.get(entry.className);
                            if (mapTo == null) break block4;
                            entry.className = mapTo;
                            break block5;
                        }
                        ClassControl cc = env.findClass(entry.className);
                        if (cc == null || !cc.annotateable(env)) break block6;
                    }
                    entry.methodSig = Descriptor.remapTypes(entry.methodSig, classTranslations);
                }
                entry = entry.next;
            }
        }
    }

    private static MethodEntry buildMethodEntry(ConstBasicMemberRef methRef, FilterEnv env) {
        String className = methRef.className().asString();
        String methodName = methRef.nameAndType().name().asString();
        String methodSig = methRef.nameAndType().signature().asString();
        ClassControl cc = env.findClass(className);
        InvokeAnnotation annotationList = null;
        if (cc == null || !cc.persistAware(env)) {
            String stackSig = Descriptor.extractReversedArgSig(methodSig);
            int depth = 0;
            int nextIdx = 0;
            int idx = 0;
            while (idx < stackSig.length()) {
                nextIdx = Descriptor.nextSigElement(stackSig, idx);
                char c = stackSig.charAt(idx);
                if (c == '[') {
                    int arrayElementType = InvokeAnnotation.computeArrayElementType(stackSig, idx);
                    InvokeAnnotation ia = new InvokeAnnotation(depth, 0x440 | arrayElementType);
                    ia.nextOne = annotationList;
                    annotationList = ia;
                }
                depth = c == 'D' || c == 'J' ? (depth += 2) : ++depth;
                idx = nextIdx;
            }
        }
        MethodEntry e = new MethodEntry(className, methodName, methodSig, annotationList);
        InvokeAnnotation.addMethod(e.className, e);
        return e;
    }

    private static int computeArrayElementType(String sig, int index) {
        switch (sig.charAt(index + 1)) {
            case 'Z': {
                return 0x8000000;
            }
            case 'B': {
                return 0x10000000;
            }
            case 'C': {
                return 0x18000000;
            }
            case 'S': {
                return 0x20000000;
            }
            case 'I': {
                return 0x28000000;
            }
            case 'J': {
                return 0x30000000;
            }
            case 'F': {
                return 0x38000000;
            }
            case 'D': {
                return 0x40000000;
            }
            case 'L': 
            case '[': {
                return 0x48000000;
            }
        }
        throw new FilterError("unexpected signature character at index " + (index + 1) + " in (" + sig + ")");
    }

    private static void addMethod(String className, MethodEntry e) {
        e.next = (MethodEntry)methods.get(className);
        methods.put(className, e);
    }

    private static void addMethod(String className, String methodName, String methodSig, InvokeAnnotation a) {
        InvokeAnnotation.addMethod(className, new MethodEntry(className, methodName, methodSig, a));
    }

    private static void addMethod(String className, String methodName, String methodSig, InvokeAnnotation a1, InvokeAnnotation a2) {
        a1.nextOne = a2;
        InvokeAnnotation.addMethod(className, methodName, methodSig, a1);
    }

    static {
        InvokeAnnotation.addMethod("java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V", new InvokeAnnotation(4, 64), new InvokeAnnotation(2, 128));
        InvokeAnnotation.addMethod("java/lang/String", "getChars", "(II[CI)V", new InvokeAnnotation(1, 128));
        InvokeAnnotation.addMethod("java/lang/String", "getBytes", "(II[BI)V", new InvokeAnnotation(1, 128));
    }
}

