/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter.classfile;

import com.odi.filter.classfile.CodeEnv;
import com.odi.filter.classfile.ConstantPool;
import com.odi.filter.classfile.InsnError;
import com.odi.filter.classfile.InsnTarget;

class InsnReadEnv {
    private CodeEnv codeEnv;
    private byte[] byteCodes;
    private int currPc;

    InsnReadEnv(byte[] bytes, CodeEnv codeEnv) {
        this.byteCodes = bytes;
        this.currPc = 0;
        this.codeEnv = codeEnv;
    }

    int currentPC() {
        return this.currPc;
    }

    boolean more() {
        return this.currPc < this.byteCodes.length;
    }

    byte getByte() {
        if (!this.more()) {
            throw new InsnError("out of byte codes");
        }
        return this.byteCodes[this.currPc++];
    }

    int getUByte() {
        return this.getByte() & 0xFF;
    }

    int getShort() {
        byte byte1 = this.byteCodes[this.currPc++];
        byte byte2 = this.byteCodes[this.currPc++];
        return byte1 << 8 | byte2 & 0xFF;
    }

    int getUShort() {
        return this.getShort() & 0xFFFF;
    }

    int getInt() {
        byte byte1 = this.byteCodes[this.currPc++];
        byte byte2 = this.byteCodes[this.currPc++];
        byte byte3 = this.byteCodes[this.currPc++];
        byte byte4 = this.byteCodes[this.currPc++];
        return byte1 << 24 | (byte2 & 0xFF) << 16 | (byte3 & 0xFF) << 8 | byte4 & 0xFF;
    }

    ConstantPool pool() {
        return this.codeEnv.pool();
    }

    InsnTarget getTarget(int targ) {
        return this.codeEnv.getTarget(targ);
    }
}

