/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter.util;

import com.odi.filter.util.ClassFileSource;
import com.odi.filter.util.DirectoryClassPathElement;
import com.odi.filter.util.ZipFileClassPathElement;
import java.io.File;
import java.util.Enumeration;

abstract class ClassPathElement {
    private ClassPathElement next;

    public abstract ClassFileSource sourceOf(String var1);

    public abstract Enumeration classesInPackage(String var1);

    abstract boolean matches(File var1);

    ClassPathElement next() {
        return this.next;
    }

    void setNext(ClassPathElement next) {
        this.next = next;
    }

    ClassPathElement() {
    }

    static ClassPathElement create(String elementSpec) {
        File element = new File(elementSpec);
        if (!element.isDirectory() && ClassPathElement.looksLikeZipName(elementSpec)) {
            return new ZipFileClassPathElement(element);
        }
        return new DirectoryClassPathElement(element);
    }

    void append(ClassPathElement another) {
        ClassPathElement e = this;
        while (e.next() != null) {
            e = e.next();
        }
        e.next = another;
    }

    protected static boolean looksLikeZipName(String fname) {
        return fname.length() > 4 && (fname.regionMatches(true, fname.length() - 4, ".zip", 0, 4) || fname.regionMatches(true, fname.length() - 4, ".jar", 0, 4));
    }
}

