/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.DatabaseException;
import com.odi.DeadlockException;
import com.odi.LockTimeoutException;
import com.odi.LockWaitInterruptedException;
import com.odi.Placement;
import com.odi.Session;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.mtsonic.DatabasesTable;
import com.odi.imp.mtsonic.ObjectAccess8ByteObjRefFormat;
import com.odi.imp.mtsonic.SchemaManager;
import com.odi.imp.mtsonic.StorageObject;
import com.odi.imp.mtsonic.Transaction;
import com.sonicsw.mtstorage.AbstractBTreeIterator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class ObjectTable {
    private StorageObject m_storageObject;
    private String m_dataFilePathname;
    private SchemaManager m_schemaManager;
    private ObjectAccess8ByteObjRefFormat m_objectAccess;
    private long m_databaseHeaderOID;
    private boolean m_mvccMode;
    private Long m_snapShot;
    private Long m_transactionID;
    private long m_lockTimeout = -1L;
    private volatile boolean m_isUseByThisSession;

    public void init(SchemaManager schemaManager, ObjectAccess8ByteObjRefFormat objectAccess, Properties plist_unused) {
        this.m_schemaManager = schemaManager;
        this.m_objectAccess = objectAccess;
        this.m_mvccMode = false;
        this.m_snapShot = null;
        this.m_transactionID = null;
        this.m_isUseByThisSession = false;
    }

    public static void getMetrics(Properties props) {
        DatabasesTable.m_databases.getMetrics(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long createBTree(boolean noDuplicates, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            if (this.m_mvccMode) {
                throw new IOException("Cannot modify the database in an MVCC session.");
            }
            long l = this.m_storageObject.createBTree(this.m_transactionID, noDuplicates, this.m_lockTimeout, pathInfo);
            return l;
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
            long l = 0L;
            return l;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] put(long treeDbk, byte[] key, byte[] value, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            if (this.m_mvccMode) {
                throw new IOException("Cannot modify the database in an MVCC session.");
            }
            byte[] byArray = this.m_storageObject.put(this.m_transactionID, treeDbk, key, value, this.m_lockTimeout, pathInfo);
            return byArray;
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(long treeDbk, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            if (this.m_mvccMode) {
                throw new IOException("Cannot modify the database in an MVCC session.");
            }
            this.m_storageObject.clear(this.m_transactionID, treeDbk, this.m_lockTimeout, pathInfo);
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(long treeDbk, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            if (this.m_mvccMode) {
                throw new IOException("Cannot modify the database in an MVCC session.");
            }
            this.m_storageObject.delete(this.m_transactionID, treeDbk, this.m_lockTimeout, pathInfo);
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(long treeDbk, byte[] key, byte[] value, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            if (this.m_mvccMode) {
                throw new IOException("Cannot modify the database in an MVCC session.");
            }
            this.m_storageObject.remove(this.m_transactionID, treeDbk, key, value, this.m_lockTimeout, pathInfo);
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] remove(long treeDbk, byte[] key, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            if (this.m_mvccMode) {
                throw new IOException("Cannot modify the database in an MVCC session.");
            }
            byte[] byArray = this.m_storageObject.remove(this.m_transactionID, treeDbk, key, this.m_lockTimeout, pathInfo);
            return byArray;
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void advance(AbstractBTreeIterator iterator, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            this.m_storageObject.advance(this.getTransactionalContext(), iterator, this.m_lockTimeout, pathInfo);
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] get(long treeDbk, byte[] key, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            byte[] byArray = this.m_storageObject.get(this.getTransactionalContext(), treeDbk, key, this.m_lockTimeout, pathInfo);
            return byArray;
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getFirstKey(long treeDbk, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            byte[] byArray = this.m_storageObject.getFirstKey(this.getTransactionalContext(), treeDbk, this.m_lockTimeout, pathInfo);
            return byArray;
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getLastKey(long treeDbk, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            byte[] byArray = this.m_storageObject.getLastKey(this.getTransactionalContext(), treeDbk, this.m_lockTimeout, pathInfo);
            return byArray;
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(long treeDbk, byte[] key, byte[] value, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            boolean bl = this.m_storageObject.contains(this.getTransactionalContext(), treeDbk, key, value, this.m_lockTimeout, pathInfo);
            return bl;
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsKey(long treeDbk, byte[] key, String pathInfo) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            boolean bl = this.m_storageObject.containsKey(this.getTransactionalContext(), treeDbk, key, this.m_lockTimeout, pathInfo);
            return bl;
        }
        catch (Exception e) {
            this.m_isUseByThisSession = false;
            this.convertLockException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    private void convertLockException(Exception e) throws IOException {
        if (e instanceof com.sonicsw.mtstorage.DeadlockException) {
            throw new DeadlockException(e.toString());
        }
        if (e instanceof com.sonicsw.mtstorage.LockTimeoutException) {
            throw new LockTimeoutException(e.toString(), null, 0);
        }
        if (e instanceof com.sonicsw.mtstorage.LockWaitInterruptedException) {
            throw new LockWaitInterruptedException(e.toString());
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new IOException(e.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long allocateObject(int size, int AFT, int alignment_unused) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            if (this.m_mvccMode) {
                throw new IOException("Cannot modify the database in an MVCC session.");
            }
            long l = this.m_storageObject.allocateObject(this.m_transactionID, size, AFT, alignment_unused);
            return l;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    void deleteObject(long oid, boolean checkLive) throws IOException {
        if (this.m_mvccMode) {
            throw new IOException("Cannot modify the database in an MVCC session.");
        }
        this.m_storageObject.acquireLock(this.getLockOwnerContext(), oid, 7, this.m_lockTimeout);
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            this.m_storageObject.deleteObject(this.m_transactionID, oid, checkLive);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    int getObjectSize(long oid) throws IOException {
        int size = 0;
        if (!this.m_mvccMode) {
            this.m_storageObject.acquireLock(this.getLockOwnerContext(), oid, 6, this.m_lockTimeout);
        }
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            size = this.m_storageObject.getObjectSize(this.getTransactionalContext(), oid);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
        return size;
    }

    void readObject(long oid, byte[] rep, int size) throws IOException {
        if (!this.m_mvccMode) {
            this.m_storageObject.acquireLock(this.getLockOwnerContext(), oid, 6, this.m_lockTimeout);
        }
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            this.m_storageObject.readObject(this.getTransactionalContext(), oid, rep, size);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    void writeObject(long oid, int header_unused, byte[] rep, int size, int alignment_unused) throws IOException {
        if (this.m_mvccMode) {
            throw new IOException("Cannot modify the database in an MVCC session.");
        }
        this.checkWrite();
        this.m_storageObject.acquireLock(this.getLockOwnerContext(), oid, 7, this.m_lockTimeout);
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            this.m_storageObject.writeObject(this.m_transactionID, oid, header_unused, rep, size, alignment_unused);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    protected void checkWrite() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void begin(int type) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            if (this.m_storageObject == null) {
                return;
            }
            if (this.m_mvccMode) {
                this.m_snapShot = this.m_storageObject.createSnapshot();
            } else {
                this.m_transactionID = this.m_storageObject.begin(type);
            }
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            if (this.m_storageObject == null) {
                return;
            }
            if (this.m_mvccMode) {
                this.m_storageObject.deleteSnapshot(this.m_snapShot);
                this.m_snapShot = null;
            } else {
                this.m_storageObject.commit(this.m_transactionID);
                this.m_storageObject.releaseAllLocks(this.getLockOwnerContext(), false);
            }
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            if (this.m_storageObject == null) {
                return;
            }
            if (this.m_mvccMode) {
                this.m_storageObject.deleteSnapshot(this.m_snapShot);
                this.m_snapShot = null;
            } else {
                this.m_storageObject.abort(this.m_transactionID);
                this.m_storageObject.releaseAllLocks(this.getLockOwnerContext(), false);
            }
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    void openDatabase(String dataFilePathname, boolean openForWrite, boolean mvccMode, HashMap parameters, int upgradeType_not_used, boolean exclusive_always_false) throws IOException {
        if (this.m_storageObject != null) {
            throw new DatabaseException("Opening multiple databases in one session is not supported.");
        }
        this.m_dataFilePathname = new File(dataFilePathname).getCanonicalPath();
        this.m_storageObject = DatabasesTable.m_databases.openStorage(this.m_dataFilePathname, this.m_objectAccess, this.m_schemaManager, openForWrite, parameters, upgradeType_not_used, exclusive_always_false);
        this.m_mvccMode = mvccMode;
        if (Transaction.inTransaction()) {
            if (this.m_mvccMode) {
                this.m_snapShot = this.m_storageObject.createSnapshot();
            } else {
                this.m_transactionID = this.m_storageObject.begin(((Transaction)Transaction.current()).type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void backup(String backupDB) throws IOException {
        try {
            if (this.m_storageObject == null) {
                throw new IOException("The \"" + (this.m_dataFilePathname == null ? "" : this.m_dataFilePathname) + "\" database is closed.");
            }
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            this.m_storageObject.backup(backupDB);
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    void closeDatabase() throws IOException {
        this.closeDatabase(ObjectManager.getCurrent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeDatabase(Session sess) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            if (this.m_storageObject == null) {
                return;
            }
            DatabasesTable.m_databases.closeStorage(this.m_dataFilePathname, sess, this.m_storageObject, this.m_snapShot);
            this.m_snapShot = null;
            this.m_mvccMode = false;
            this.m_storageObject = null;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    void resync() {
    }

    void createDatabase(String dataFilePathname, HashMap parameters) throws IOException {
        if (this.m_storageObject != null) {
            throw new DatabaseException("Creating a database while a database is open is not supported.");
        }
        this.m_dataFilePathname = new File(dataFilePathname).getCanonicalPath();
        this.m_storageObject = DatabasesTable.m_databases.createStorage(this.m_dataFilePathname, this.m_objectAccess, this.m_schemaManager, parameters);
        if (Transaction.inTransaction()) {
            this.m_transactionID = this.m_storageObject.begin(((Transaction)Transaction.current()).type);
        }
    }

    String getPathname() {
        return this.m_storageObject.getPathname();
    }

    void destroyDatabase() throws IOException {
        DatabasesTable.m_databases.destroyStorage(this.m_dataFilePathname, this.m_storageObject);
        this.m_storageObject = null;
    }

    long databaseGetSizeInBytes() {
        return this.m_storageObject.databaseGetSizeInBytes();
    }

    long databaseGetHeader() {
        return this.m_databaseHeaderOID;
    }

    void checkLive(long oid) {
        if (!this.m_mvccMode) {
            this.m_storageObject.acquireLock(this.getLockOwnerContext(), oid, 6, this.m_lockTimeout);
        }
        this.m_storageObject.checkLive(this.getTransactionalContext(), oid);
    }

    void databaseSetHeader(long oid) {
        this.m_databaseHeaderOID = oid;
    }

    ObjectReference getObjRef(long oid, Placement place, MutatingObjRef objRef) throws IOException {
        ObjectReference ref = null;
        if (!this.m_mvccMode) {
            this.m_storageObject.acquireLock(this.getLockOwnerContext(), oid, 6, this.m_lockTimeout);
        }
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            ref = this.m_storageObject.getObjRef(this.getTransactionalContext(), oid, place, objRef);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long nextValidOid(long oid) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            long l = this.m_storageObject.nextValidOid(oid);
            return l;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long nextValidOid(long oid, int[] sizes) throws IOException {
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            long l = this.m_storageObject.nextValidOid(this.getTransactionalContext(), oid, sizes);
            return l;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
    }

    public boolean hasLock(Session sess) {
        if (this.m_mvccMode) {
            return false;
        }
        return this.m_storageObject.hasLock(sess);
    }

    int getArrayElementCount(long oid, int AFTypeCode) {
        int count;
        if (!this.m_mvccMode) {
            this.m_storageObject.acquireLock(this.getLockOwnerContext(), oid, 6, this.m_lockTimeout);
        }
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            count = this.m_storageObject.getArrayElementCount(this.getTransactionalContext(), oid, AFTypeCode);
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
        return count;
    }

    Properties GC(Properties GCProperties) {
        throw new Error("Not supported");
    }

    public long getStorageOffset(long oid) {
        long offset = 0L;
        if (!this.m_mvccMode) {
            this.m_storageObject.acquireLock(this.getLockOwnerContext(), oid, 6, this.m_lockTimeout);
        }
        try {
            this.validateNoConcurrentUse();
            this.m_isUseByThisSession = true;
            offset = this.m_storageObject.getStorageOffset(this.getTransactionalContext(), oid);
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            this.m_isUseByThisSession = false;
        }
        return offset;
    }

    void doInstanceBecome(long otherOID, long thisOID) {
        throw new Error("Used only for object schema upgrades.");
    }

    void upgradeComplete() throws IOException {
        throw new Error("Used only upgrades.");
    }

    int getUpgradeType() {
        return 0;
    }

    void getCounters(Properties props, boolean reset) {
    }

    int getNDeadOTEs() {
        return 0;
    }

    void validate(long oid, int refAFT) throws IOException {
        if (!this.m_mvccMode) {
            this.m_storageObject.acquireLock(this.getLockOwnerContext(), oid, 6, this.m_lockTimeout);
        }
        this.m_storageObject.validate(this.getTransactionalContext(), oid, refAFT);
    }

    private void validateNoConcurrentUse() {
    }

    private Long getTransactionalContext() {
        if (this.m_mvccMode) {
            return this.m_snapShot;
        }
        return this.m_transactionID;
    }

    private Object getLockOwnerContext() {
        return this.getTransactionalContext();
    }

    public void acquireLock(long oid, int lockmode, long timeoutMillis, boolean checkLive) {
        if (!this.m_mvccMode) {
            this.m_storageObject.acquireLock(this.getLockOwnerContext(), oid, lockmode, timeoutMillis);
        }
        if (checkLive) {
            this.m_storageObject.checkLive(this.getTransactionalContext(), oid);
        }
    }

    public void setLockTimeout(int milliseconds) {
        this.m_lockTimeout = milliseconds;
    }

    public int getLockTimeout() {
        return (int)this.m_lockTimeout;
    }
}

