/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.NoSessionException;
import com.odi.ObjectStore;
import com.odi.util.OSVector;
import com.odi.util.OSVectorListIterator;
import java.util.List;
import java.util.ListIterator;

public class OSVectorList
extends OSVector
implements List {
    static final long serialVersionUID = 4544854216707710375L;
    private static final ClassInfo classinfo = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSVectorList"));
    int modificationTick;

    public OSVectorList(ClassInfo ignored) {
    }

    @Override
    public void initializeContents(GenericObject genObject) {
        super.initializeContents(genObject);
        this.modificationTick = genObject.getIntField(1, classinfo);
    }

    @Override
    public void flushContents(GenericObject genObject) {
        super.flushContents(genObject);
        genObject.setIntField(1, this.modificationTick, classinfo);
    }

    @Override
    public void clearContents() {
        super.clearContents();
        this.modificationTick = 0;
    }

    public OSVectorList(int initialBufferSize, int capacityIncrement) {
        super(initialBufferSize, capacityIncrement);
        this.modificationTick = 0;
    }

    public OSVectorList(int initialBufferSize) {
        super(initialBufferSize);
        this.modificationTick = 0;
    }

    public OSVectorList() {
        this.modificationTick = 0;
    }

    @Override
    public synchronized void addElement(Object obj) {
        super.addElement(obj);
        ++this.modificationTick;
    }

    @Override
    public synchronized void setSize(int newSize) {
        super.setSize(newSize);
        ++this.modificationTick;
    }

    @Override
    public synchronized void setElementAt(Object obj, int index) {
        super.setElementAt(obj, index);
        ObjectStore.dirty(this);
        ++this.modificationTick;
    }

    @Override
    public synchronized void removeElementAt(int index) {
        super.removeElementAt(index);
        ++this.modificationTick;
    }

    @Override
    public synchronized void insertElementAt(Object obj, int index) {
        super.insertElementAt(obj, index);
        ++this.modificationTick;
    }

    @Override
    public synchronized void removeAllElements() {
        super.removeAllElements();
        ++this.modificationTick;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List otherList = (List)obj;
        if (this.size() != otherList.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Object a = this.get(i);
            Object b = otherList.get(i);
            if (!(a == null ? b != null : !a.equals(b))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode;
        block3: {
            hashCode = 1;
            try {
                for (Object obj : this) {
                    hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
                }
            }
            catch (NoSessionException e) {
                if (Boolean.getBoolean("com.odi.debugHashCodes")) break block3;
                throw e;
            }
        }
        return hashCode;
    }

    @Override
    public synchronized ListIterator listIterator() {
        return new OSVectorListIterator(this);
    }

    @Override
    public synchronized ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("listIterator(" + index + ")");
        }
        return new OSVectorListIterator(this, index);
    }

    int getTick() {
        ObjectStore.fetch(this);
        return this.modificationTick;
    }
}

