/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.util.OSVectorIterator;
import com.odi.util.OSVectorList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.ListIterator;

class OSVectorListIterator
extends OSVectorIterator
implements Enumeration,
ListIterator {
    private int modificationTick;
    private OSVectorList vl;

    OSVectorListIterator(OSVectorList v) {
        super(v);
        this.vl = v;
        this.modificationTick = this.vl.getTick();
    }

    OSVectorListIterator(OSVectorList v, int index) {
        super(v, index);
        this.vl = v;
        this.modificationTick = this.vl.getTick();
    }

    @Override
    public boolean hasMoreElements() {
        this.checkStale();
        return super.hasMoreElements();
    }

    @Override
    public Object nextElement() {
        this.checkStale();
        return super.nextElement();
    }

    @Override
    public void add(Object obj) {
        this.checkStale();
        super.add(obj);
        this.modificationTick = this.vl.getTick();
    }

    @Override
    public boolean hasNext() {
        this.checkStale();
        return super.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        this.checkStale();
        return super.hasPrevious();
    }

    @Override
    public Object next() {
        this.checkStale();
        return super.next();
    }

    @Override
    public Object previous() {
        this.checkStale();
        return super.previous();
    }

    @Override
    public int nextIndex() {
        this.checkStale();
        return super.nextIndex();
    }

    @Override
    public int previousIndex() {
        this.checkStale();
        return super.previousIndex();
    }

    @Override
    public void remove() {
        this.checkStale();
        super.remove();
        this.modificationTick = this.vl.getTick();
    }

    @Override
    public void set(Object obj) {
        this.checkStale();
        super.set(obj);
        this.modificationTick = this.vl.getTick();
    }

    private void checkStale() {
        if (this.modificationTick != this.vl.getTick()) {
            throw new ConcurrentModificationException("OSVectorList modified while iterating");
        }
    }
}

