/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.jmx.client.ExpressionBasedNotificationFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

final class NotificationListenerDelegate
implements NotificationListener,
Serializable {
    private static final long serialVersionUID = 8484344976480223320L;
    private static final short m_serialVersion = 0;
    private ObjectName m_objectName;
    private com.sonicsw.mf.jmx.client.NotificationListenerDelegate m_remoteListener;
    private long m_expirationTime;
    private HashMap m_handbacks = new HashMap();
    private static volatile ContainerImpl m_container;
    private transient boolean m_isDirty = true;
    private long m_closeTimestamp;

    NotificationListenerDelegate(ObjectName objectName, com.sonicsw.mf.jmx.client.NotificationListenerDelegate remoteListener) {
        this.m_objectName = objectName;
        this.m_remoteListener = remoteListener;
    }

    void close() {
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_closeTimestamp = System.currentTimeMillis();
    }

    static void setContainerImpl(ContainerImpl container) {
        m_container = container;
    }

    String getDestination() {
        return this.m_remoteListener.m_destination;
    }

    com.sonicsw.mf.jmx.client.NotificationListenerDelegate getRemoteListener() {
        return this.m_remoteListener;
    }

    ObjectName getObjectName() {
        return this.m_objectName;
    }

    String getRemoteListenerKey() {
        return this.m_remoteListener.m_destination + ':' + this.m_remoteListener.m_listenerHash + ':' + this.m_objectName.getCanonicalName();
    }

    boolean hasExpired() {
        return System.currentTimeMillis() > this.m_expirationTime;
    }

    boolean isDirty() {
        return this.m_isDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHandbackFilterPair(Object handback, NotificationFilter newFilter) {
        boolean dirty = false;
        HashMap hashMap = this.m_handbacks;
        synchronized (hashMap) {
            if (!this.m_handbacks.containsKey(handback)) {
                dirty = true;
            } else {
                NotificationFilter oldFilter = (NotificationFilter)this.m_handbacks.get(handback);
                if (newFilter != null || oldFilter != null) {
                    if (newFilter == null && oldFilter != null) {
                        dirty = true;
                    } else if (newFilter != null && oldFilter == null) {
                        dirty = true;
                    } else if (!newFilter.getClass().equals(oldFilter.getClass())) {
                        dirty = true;
                    } else if (newFilter instanceof NotificationFilterSupport) {
                        Vector<String> oldEnabledTypes = ((NotificationFilterSupport)oldFilter).getEnabledTypes();
                        Vector<String> newEnabledTypes = ((NotificationFilterSupport)newFilter).getEnabledTypes();
                        if (oldEnabledTypes.size() != newEnabledTypes.size()) {
                            dirty = true;
                        } else {
                            Iterator<String> iterator = oldEnabledTypes.iterator();
                            while (iterator.hasNext()) {
                                if (newEnabledTypes.contains(iterator.next())) continue;
                                dirty = true;
                                break;
                            }
                        }
                    } else if (newFilter instanceof ExpressionBasedNotificationFilter && !newFilter.equals(oldFilter)) {
                        dirty = true;
                    }
                }
            }
            if (dirty) {
                this.m_handbacks.put(handback, newFilter);
                this.m_isDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHandbackFilterPair(Object handback, NotificationFilter filter) {
        HashMap hashMap = this.m_handbacks;
        synchronized (hashMap) {
            if (this.m_handbacks.remove(handback) != null) {
                this.m_isDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllHandbackFilterPairs() {
        HashMap hashMap = this.m_handbacks;
        synchronized (hashMap) {
            this.m_handbacks.clear();
        }
    }

    HashMap getHandbackFilterPairs() {
        return this.m_handbacks;
    }

    void setNotificationSubscriptionTimeout(long timeout) {
        if (this.m_remoteListener != null && this.m_remoteListener.getNotificationSubscriptionTimeout() != timeout) {
            this.m_remoteListener.setNotificationSubscriptionTimeout(timeout);
            this.m_isDirty = true;
        }
        this.m_expirationTime = System.currentTimeMillis() + (this.m_remoteListener != null ? this.m_remoteListener.getNotificationSubscriptionTimeout() : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object suppliedHandback) {
        block8: {
            if (this.m_closeTimestamp == 0L || notification.getTimeStamp() < this.m_closeTimestamp) {
                try {
                    if (System.currentTimeMillis() <= this.m_expirationTime) {
                        HashMap hashMap = this.m_handbacks;
                        synchronized (hashMap) {
                            ArrayList<Object> notifiedHandbacks = new ArrayList<Object>();
                            for (Map.Entry entry : this.m_handbacks.entrySet()) {
                                NotificationFilter filter;
                                Object handback = this.extractHandbackID(entry.getKey());
                                if (notifiedHandbacks.contains(handback) || (filter = (NotificationFilter)entry.getValue()) != null && !filter.isNotificationEnabled(notification)) continue;
                                notifiedHandbacks.add(handback);
                                m_container.sendDirectedNotification("jmx", this.m_remoteListener.m_destination, this.m_remoteListener.m_listenerHash, notification, handback);
                            }
                            break block8;
                        }
                    }
                    m_container.expireSubscription(this);
                }
                catch (Throwable e) {
                    m_container.logMessage("AGENT", e, 2);
                }
            }
        }
    }

    private Object extractHandbackID(Object compoundHandbackID) {
        String bell = "\b";
        if (compoundHandbackID == null || !(compoundHandbackID instanceof String) || !((String)compoundHandbackID).startsWith(bell + bell)) {
            return compoundHandbackID;
        }
        StringTokenizer st = new StringTokenizer(((String)compoundHandbackID).substring(2), bell);
        if (st.countTokens() != 2) {
            return compoundHandbackID;
        }
        st.nextToken();
        String handbackID = st.nextToken();
        return handbackID.length() == 0 ? compoundHandbackID : handbackID;
    }

    byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this);
        oos.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NotificationListenerDelegate fromByteArray(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais;
        ByteArrayInputStream byteArrayInputStream = bais = new ByteArrayInputStream(bytes);
        synchronized (byteArrayInputStream) {
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (NotificationListenerDelegate)ois.readObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        HashMap hashMap = this.m_handbacks;
        synchronized (hashMap) {
            stream.writeInt(4);
            stream.writeUTF("serialVersion");
            stream.writeObject(new Short(0));
            stream.writeUTF("objectName");
            stream.writeObject(this.m_objectName);
            stream.writeUTF("remoteListener");
            stream.writeObject(this.m_remoteListener);
            stream.writeUTF("handbacks");
            stream.writeObject(this.m_handbacks);
        }
        this.m_isDirty = false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(count);
        for (int i = 0; i < count; ++i) {
            String key = stream.readUTF();
            Object value = stream.readObject();
            map.put(key, value);
        }
        switch ((Short)map.remove("serialVersion")) {
            default: 
        }
        try {
            this.m_objectName = (ObjectName)map.get("objectName");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_remoteListener = (com.sonicsw.mf.jmx.client.NotificationListenerDelegate)map.get("remoteListener");
            this.setNotificationSubscriptionTimeout(this.m_remoteListener.getNotificationSubscriptionTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_handbacks = (HashMap)map.get("handbacks");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_isDirty = false;
    }
}

