/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.agent.PBE;
import com.sonicsw.mf.framework.directory.storage.DSEncryptionException;
import com.sonicsw.mf.framework.directory.storage.IStorage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;

public final class PrepareDSBackupToOnline {
    private IStorage m_storage;
    private String m_password = null;

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("?")) {
            PrepareDSBackupToOnline.printUsage();
        }
        try {
            new PrepareDSBackupToOnline(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrepareDSBackupToOnline(String[] args) throws Exception {
        File systemDir;
        File dsDir;
        System.err.println("Validating the directory store...");
        if (args.length == 2) {
            this.m_password = args[1];
        }
        if (!(dsDir = new File(args[0])).exists()) {
            System.err.println(args[0] + " directory does not exist.");
            System.exit(1);
        }
        if (!dsDir.isDirectory()) {
            System.err.println(args[0] + " is not a directory.");
            System.exit(1);
        }
        File dataDir = new File(dsDir, "data");
        File dataTrDir = new File(dsDir, "data.tr");
        File trDir = new File(dsDir, "tr");
        if (!(dataDir.exists() && dataDir.isDirectory() && dataTrDir.exists() && dataTrDir.isDirectory() && trDir.exists())) {
            System.err.println(args[0] + " is not a valid Directory Service store.");
            System.exit(1);
        }
        if (!(systemDir = new File(dataDir, "_MFSystem")).exists() || !systemDir.isDirectory()) {
            System.err.println(args[0] + " is not a valid Directory Service store.");
            System.exit(1);
        }
        ObjectInputStream objectSin = null;
        IElementIdentity versionElementID = null;
        IDirElement versionElement = null;
        File versionFile = new File(systemDir, "version");
        try {
            objectSin = new ObjectInputStream(new BufferedInputStream(new FileInputStream(versionFile)));
            Object inS = objectSin.readObject();
            if (this.m_password == null && inS instanceof byte[]) {
                throw new DSEncryptionException("Storage data is encrypted. Password must be specified.");
            }
            if (this.m_password != null && inS instanceof HashMap) {
                throw new DSEncryptionException("Storage data is not encrypted. Invalid password.");
            }
            if (this.m_password == null) {
                HashMap map = (HashMap)inS;
                versionElementID = (IElementIdentity)this.getObject(map);
                versionElement = (IDirElement)this.getObject((HashMap)objectSin.readObject());
            } else {
                versionElementID = (IElementIdentity)this.getObject(this.readEncryptedData(inS));
                versionElement = (IDirElement)this.getObject(this.readEncryptedData(objectSin.readObject()));
            }
            IAttributeSet attributes = versionElement.getAttributes();
            Integer dsVersion = (Integer)attributes.getAttribute("VERSION");
            if (dsVersion != 8) {
                System.err.println("The directory service storage version mismatches the version of the software.\nStorage version is: " + dsVersion + ". Software version is: " + 8 + ".");
                System.exit(1);
            }
            PrepareDSBackupToOnline.closeObjectSin(objectSin);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        finally {
            PrepareDSBackupToOnline.closeObjectSin(objectSin);
        }
        File lockFile = new File(systemDir, "lock");
        File openFile = new File(systemDir, "dsisopen");
        File backupFile = new File(systemDir, "backup_state");
        if ((lockFile.exists() || openFile.exists()) && !backupFile.exists()) {
            System.err.println(args[0] + " is not a valid backup copy instance. The directory Service must be put in a 'backup state' when the copy is created.");
            System.exit(1);
        }
        lockFile.delete();
        openFile.delete();
        backupFile.delete();
        System.err.println("...validation complete.");
        System.err.println("Modifying the backup version...");
        File backupVersionFile = new File(systemDir, "backup_version");
        backupVersionFile.delete();
        IDirElement backupVersionElement = ElementFactory.createElement((String)"/_MFSystem/backup_version", (String)"backup_version", (String)"2.0");
        IAttributeSet attributes = backupVersionElement.getAttributes();
        attributes.setLongAttribute("BACKUP_VERSION", new Long(System.currentTimeMillis()));
        String name = null;
        try {
            name = new EntityName(backupVersionElement.getIdentity().getName()).getBaseName();
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
        ObjectOutputStream objectSout = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(backupVersionFile)));
        if (this.m_password != null) {
            objectSout.writeObject(this.convertObjectToBytes(name, backupVersionElement.getIdentity()));
            objectSout.writeObject(this.convertObjectToBytes(name, backupVersionElement));
        } else {
            HashMap<String, IElementIdentity> ids = new HashMap<String, IElementIdentity>(1, 1.0f);
            HashMap<String, IDirElement> elements = new HashMap<String, IDirElement>(1, 1.0f);
            ids.put(name, backupVersionElement.getIdentity());
            elements.put(name, backupVersionElement);
            objectSout.writeObject(ids);
            objectSout.writeObject(elements);
        }
        objectSout.close();
        objectSin = null;
        File subscribersFile = new File(systemDir, "subscribers");
        try {
            IElementIdentity subscribersElementID = null;
            IDirElement subscribersElement = null;
            objectSin = new ObjectInputStream(new BufferedInputStream(new FileInputStream(subscribersFile)));
            if (this.m_password != null) {
                subscribersElementID = (IElementIdentity)this.getObject((HashMap)objectSin.readObject());
                subscribersElement = (IDirElement)this.getObject((HashMap)objectSin.readObject());
            } else {
                subscribersElementID = (IElementIdentity)this.getObject(this.readEncryptedData(objectSin.readObject()));
                subscribersElement = (IDirElement)this.getObject(this.readEncryptedData(objectSin.readObject()));
            }
        }
        catch (Exception e) {
            subscribersFile.delete();
        }
        finally {
            PrepareDSBackupToOnline.closeObjectSin(objectSin);
        }
        System.err.println("...modification complete - " + args[0] + " is ready for use.");
    }

    private static void closeObjectSin(ObjectInputStream objectSin) throws IOException {
        if (objectSin != null) {
            objectSin.close();
        }
    }

    private byte[] convertObjectToBytes(String name, Object elmntData) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(out);
        HashMap<String, Object> data = new HashMap<String, Object>(1, 1.0f);
        data.put(name, elmntData);
        objectOut.writeObject(data);
        byte[] encBytes = PBE.encrypt(out.toByteArray(), this.m_password);
        out.close();
        return encBytes;
    }

    private HashMap readEncryptedData(Object input) throws Exception {
        if (input instanceof HashMap) {
            throw new DSEncryptionException("Could not backup the Directory Storage because of a wrong or missing encryption password.");
        }
        byte[] bytes = PBE.decrypt((byte[])input, this.m_password);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream object = new ObjectInputStream(in);
        return (HashMap)object.readObject();
    }

    private Object getObject(HashMap map) {
        Iterator i = map.keySet().iterator();
        return map.get(i.next());
    }

    private static void printUsage() {
        System.err.println();
        System.err.println("Usage: com.sonicsw.mf.framework.directory.storage.PrepareDSBackupToOnline <ds-directory> [<password>]");
        System.err.println();
        System.err.println("Where: <ds-directory>       the name of the directory that contains the backup copy. Required.");
        System.err.println("Where: <password>           the password used to encrypt the Directory Service storage.");
        System.exit(1);
    }
}

