/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.impl.NameMapper;
import com.sonicsw.mf.framework.directory.IPersistSubscribers;
import com.sonicsw.mx.util.IEmptyArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SubscriptionRegistry {
    private static final boolean DEBUG = false;
    private HashMap m_subscribers;
    private HashMap m_topics;
    private long m_subscriptionDuration;
    private Thread m_exiprator;
    private volatile boolean m_closed = false;
    private IPersistSubscribers m_storage;
    private LogicalSubscribersMap m_logicalMap;
    private static final String MF_RUNTIME_PREFIX = "/_MFRuntime/";

    public static void main(String[] args) throws Exception {
        SubscriptionRegistry registry = new SubscriptionRegistry(40L, null);
        registry.subscribe("S1", "x");
        registry.subscribe("S2", "x");
        registry.subscribe("S3", "x");
        String E1 = "/a1/b1/l1";
        String E2 = "/a1/b1/l2";
        String E3 = "/a1/b2/l3";
        registry.addLogicalSubscriber(E1, "S1");
        registry.addLogicalSubscriber(E1, "S2");
        registry.addLogicalSubscriber(E2, "S2");
        registry.addLogicalSubscriber(E3, "S3");
        String oldEr = "/a1";
        String newEr = "/x1";
        System.out.println();
        System.out.println("Interested in " + oldEr + " to " + newEr + " renaming:");
        HashSet interestedSubs = registry.renameLogicalPath(oldEr, newEr);
        Iterator iterator = interestedSubs.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    SubscriptionRegistry(long subscriptionDuration, IPersistSubscribers storage) {
        this.m_subscriptionDuration = subscriptionDuration;
        this.m_subscribers = new HashMap();
        this.m_topics = new HashMap();
        this.m_storage = storage;
        this.m_logicalMap = new LogicalSubscribersMap();
        this.m_exiprator = new Thread("DIRECTORY SERVICE - Subscription Expirer"){

            @Override
            public void run() {
                while (!SubscriptionRegistry.this.m_closed) {
                    try {
                        Thread.sleep(SubscriptionRegistry.this.m_subscriptionDuration);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (SubscriptionRegistry.this.m_closed) continue;
                    SubscriptionRegistry.this.expire();
                }
            }
        };
        this.m_exiprator.start();
    }

    synchronized void addLogicalSubscriber(String path, String subscriber) {
        this.m_logicalMap.addSubscriber(path, subscriber);
    }

    synchronized void deleteLogicalPath(String path) {
        this.m_logicalMap.removePath(path);
    }

    synchronized HashSet renameLogicalPath(String oldPath, String newPath) {
        HashSet interestedSubscribes = this.m_logicalMap.rename(oldPath, newPath);
        if (interestedSubscribes == null) {
            return new HashSet();
        }
        interestedSubscribes.retainAll(this.m_subscribers.keySet());
        return interestedSubscribes;
    }

    synchronized void close() {
        this.m_closed = true;
        this.m_exiprator.interrupt();
    }

    synchronized void subscribe(String subscriber, String topic) {
        if (this.subscribeInternal(subscriber, topic)) {
            this.m_storage.addSubscriber(subscriber);
        }
    }

    synchronized void subscribe(String subscriber, String[] topics) {
        boolean subscribersListChanged = false;
        for (int i = 0; i < topics.length; ++i) {
            if (!this.subscribeInternal(subscriber, topics[i])) continue;
            subscribersListChanged = true;
        }
        if (subscribersListChanged) {
            this.m_storage.addSubscriber(subscriber);
        }
    }

    private boolean subscribeInternal(String subscriber, String topic) {
        if (topic.startsWith(MF_RUNTIME_PREFIX)) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        Subscription subscription = new Subscription(subscriber, currentTime);
        Subscription oldSubscription = this.m_subscribers.put(subscriber, subscription);
        HashMap<String, Subscription> topicSubscribers = (HashMap<String, Subscription>)this.m_topics.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = new HashMap<String, Subscription>();
            this.m_topics.put(topic, topicSubscribers);
        }
        topicSubscribers.remove(subscriber);
        topicSubscribers.put(subscriber, subscription);
        return oldSubscription == null;
    }

    synchronized String[] getSubscribers(String topic) {
        HashMap topicSubscribers = (HashMap)this.m_topics.get(topic);
        if (topicSubscribers == null) {
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }
        return topicSubscribers.keySet().toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    synchronized String[] getSubscribers() {
        return this.m_subscribers.keySet().toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    synchronized void expire() {
        long expiredSubscriptionTime = System.currentTimeMillis() - this.m_subscriptionDuration;
        Iterator topicEntryIterator = this.m_topics.entrySet().iterator();
        while (topicEntryIterator.hasNext()) {
            Map.Entry topicEntry = topicEntryIterator.next();
            HashMap subscriptions = (HashMap)topicEntry.getValue();
            Iterator subscriptionsEntryIterator = subscriptions.entrySet().iterator();
            while (subscriptionsEntryIterator.hasNext()) {
                Map.Entry subscriptionEntry = subscriptionsEntryIterator.next();
                Subscription subscription = (Subscription)subscriptionEntry.getValue();
                if (subscription.m_subscriptionTime >= expiredSubscriptionTime) continue;
                subscriptionsEntryIterator.remove();
            }
            if (!subscriptions.isEmpty()) continue;
            topicEntryIterator.remove();
        }
        ArrayList expiredSubscribers = new ArrayList();
        Iterator subscriptionEntryIterator = this.m_subscribers.entrySet().iterator();
        while (subscriptionEntryIterator.hasNext()) {
            Map.Entry subscriptionEntry = subscriptionEntryIterator.next();
            Subscription subscription = (Subscription)subscriptionEntry.getValue();
            if (subscription.m_subscriptionTime >= expiredSubscriptionTime) continue;
            subscriptionEntryIterator.remove();
            expiredSubscribers.add(subscriptionEntry.getKey());
        }
        if (!expiredSubscribers.isEmpty()) {
            this.m_storage.removeSubscribers(expiredSubscribers.toArray(IEmptyArray.EMPTY_STRING_ARRAY));
        }
    }

    private class LogicalSubscribersMap {
        private NameMapper m_map = new NameMapper();

        LogicalSubscribersMap() {
        }

        void addSubscriber(String path, String subscriber) {
            EntityName pathE = this.getEntityName(path);
            HashSet<String> subscribers = (HashSet<String>)this.m_map.get(pathE);
            if (subscribers == null) {
                subscribers = new HashSet<String>();
            }
            subscribers.add(subscriber);
            this.m_map.set(pathE, subscribers);
        }

        void removePath(String path) {
            this.m_map.remove(this.getEntityName(path));
        }

        HashSet rename(String oldPath, String newPath) {
            NameMapper.NamedPayLoad[] list = this.m_map.rename(this.getEntityName(oldPath), this.getEntityName(newPath));
            if (list == null) {
                return null;
            }
            HashSet allSubscribersSet = new HashSet();
            for (int i = 0; i < list.length; ++i) {
                allSubscribersSet.addAll((HashSet)list[i].getPayload());
            }
            return allSubscribersSet;
        }

        private EntityName getEntityName(String path) {
            try {
                return new EntityName(path);
            }
            catch (ConfigException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    private class Subscription {
        private String m_subscriber;
        private long m_subscriptionTime;

        Subscription(String subscriber, long time) {
            this.m_subscriber = subscriber;
            this.m_subscriptionTime = time;
        }
    }
}

