/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IDSHandler;
import com.sonicsw.mf.common.config.IDSHandlerContext;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IHandlerConstants;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.impl.NameMapper;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceHandlerException;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.view.INamingListener;
import com.sonicsw.mf.framework.directory.IDebuggingMasks;
import com.sonicsw.mf.framework.directory.impl.DSHandlerContext;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;
import com.sonicsw.mf.framework.directory.impl.DiskFileDSHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

final class DSHandlers
implements IDebuggingMasks,
IHandlerConstants {
    private NameMapper m_handlersTable;
    private DirectoryService m_ds;
    private DSHandlerContext m_dsContext;

    DSHandlers(DirectoryService ds) {
        this.m_ds = ds;
        this.m_handlersTable = new NameMapper();
        this.m_dsContext = new DSHandlerContext(ds);
        HandlerInfo[] handlerList = this.getAllHandlers();
        for (int i = 0; i < handlerList.length; ++i) {
            IDSHandler handler = null;
            try {
                handler = this.createDSHandler(handlerList[i].m_className, handlerList[i].m_classpath);
            }
            catch (Exception e) {
                this.m_ds.logMessage("Could not create a handler for class  " + handlerList[i].m_className + " for handler " + handlerList[i].m_handlerName + ", trace follows...", e, 2);
                continue;
            }
            if (handler == null) continue;
            EntityName eName = this.getEntityName(handlerList[i].m_handlerName);
            if (eName.isRoot()) {
                this.m_ds.logMessage("Could not create a handler for class  " + handlerList[i].m_className + " for handler " + handlerList[i].m_handlerName + ": Cannot register a root handler", 2);
                continue;
            }
            if (this.m_handlersTable.getPrefix(eName) != null || this.m_handlersTable.get(eName) != null) {
                this.m_ds.logMessage("Could not create a handler for class  " + handlerList[i].m_className + " for handler " + handlerList[i].m_handlerName + ": A handler with the same name prefix already exists", 2);
                continue;
            }
            handler.setHandlerName(eName.getName());
            this.m_handlersTable.set(eName, (Object)handler);
        }
        try {
            IDSHandler diskHandler = this.createDiskHandler();
            this.m_handlersTable.set(this.getEntityName(DiskFileDSHandler.getHandlerName()), (Object)diskHandler);
        }
        catch (Exception e) {
            this.m_ds.logMessage("Could not create a handler for class  com.sonicsw.mf.framework.directory.impl.DiskDSHandler, for handler " + DiskFileDSHandler.getHandlerName() + ", trace follows...", e, 2);
        }
    }

    IDSHandler getHandler(EntityName name) {
        return (IDSHandler)this.m_handlersTable.getPrefix(name);
    }

    IDSHandler getHandler(String name) throws DirectoryServiceException {
        return this.getHandler(DirectoryService.validateName(name));
    }

    IDirElement getElement(IDSHandler handler, String elementName) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IDirElement iDirElement = handler.getElement(elementName);
            return iDirElement;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IDirElement[] getAllElements(IDSHandler handler, String dirName) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IDirElement[] iDirElementArray = handler.getAllElements(dirName);
            return iDirElementArray;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IDirIdentity[] listDirectories(IDSHandler handler, String dirName) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IDirIdentity[] iDirIdentityArray = handler.listDirectories(dirName);
            return iDirIdentityArray;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IIdentity[] listAll(IDSHandler handler, String dirName) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IIdentity[] iIdentityArray = handler.listAll(dirName);
            return iIdentityArray;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IElementIdentity[] listElements(IDSHandler handler, String dirName) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IElementIdentity[] iElementIdentityArray = handler.listElements(dirName);
            return iElementIdentityArray;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    void rename(IDSHandler handler, String oldName, String newName) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            handler.rename(oldName, newName);
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    void createFolder(IDSHandler handler, String folderPath, boolean existingOk) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            handler.createFolder(folderPath, existingOk);
            handler.doNotify();
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    void createFolder(IDSHandler handler, String folderPath) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            handler.createFolder(folderPath);
            handler.doNotify();
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    void deleteFolder(IDSHandler handler, String folderPath) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            handler.deleteFolder(folderPath);
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    HashMap[] listFolders(IDSHandler handler, String folderPath) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            HashMap[] hashMapArray = handler.listFolders(folderPath);
            return hashMapArray;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    HashMap[] listFSAll(IDSHandler handler, String path) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            HashMap[] hashMapArray = handler.listFSAll(path);
            return hashMapArray;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    ArrayList listFSAll(IDSHandler handler, String path, boolean getFolders, boolean getElements, String extension) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            ArrayList arrayList = handler.listFSAll(path, getFolders, getElements, extension);
            return arrayList;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    HashMap[] listFSElements(IDSHandler handler, String folderPath) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            HashMap[] hashMapArray = handler.listFSElements(folderPath);
            return hashMapArray;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    void setMetaAttributes(IDSHandler handler, String path, HashMap attributes) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            handler.setMetaAttributes(path, attributes);
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    HashMap getMetaAttributes(IDSHandler handler, String path) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            HashMap hashMap = handler.getMetaAttributes(path);
            return hashMap;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IBlob getBlobByLogicalName(IDSHandler handler, String logicalName) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IBlob iBlob = handler.getBlobByLogicalName(logicalName);
            return iBlob;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IDirElement getFSElement(IDSHandler handler, String elementPath, boolean forUpdate) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IDirElement iDirElement = handler.getFSElement(elementPath, forUpdate);
            return iDirElement;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IDirElement[] getFSElements(IDSHandler handler, String folderPath, boolean forUpdate) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IDirElement[] iDirElementArray = handler.getFSElements(folderPath, forUpdate);
            return iDirElementArray;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IDirElement getFSElement(IDSHandler handler, String elementPath, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IDirElement iDirElement = handler.getFSElement(elementPath, forUpdate, getSubclassingDelta);
            return iDirElement;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IElementIdentity getFSIdentity(IDSHandler handler, String elementPath) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IElementIdentity iElementIdentity = handler.getFSIdentity(elementPath);
            return iElementIdentity;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IElementIdentity deleteFSElement(IDSHandler handler, String elementPath) throws DirectoryServiceException, VersionOutofSyncException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IElementIdentity iElementIdentity = handler.deleteFSElement(elementPath);
            return iElementIdentity;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    INextVersionToken createFSElement(IDSHandler handler, IDirElement element) throws DirectoryServiceException, VersionOutofSyncException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            INextVersionToken iNextVersionToken = handler.createFSElement(element);
            return iNextVersionToken;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    INextVersionToken updateFSElement(IDSHandler handler, IDeltaDirElement element) throws DirectoryServiceException, VersionOutofSyncException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            INextVersionToken iNextVersionToken = handler.updateFSElement(element);
            return iNextVersionToken;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    void attachFSBlob(IDSHandler handler, IBasicElement element, InputStream blobStream) throws DirectoryServiceException, VersionOutofSyncException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            handler.attachFSBlob(element, blobStream);
            handler.doNotify();
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    void attachFSBlob(IDSHandler handler, IBasicElement element, byte[] blob) throws DirectoryServiceException, VersionOutofSyncException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            handler.attachFSBlob(element, blob);
            handler.doNotify();
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    void appendFSBlob(IDSHandler handler, IBasicElement element, byte[] blob, int offset, boolean last) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            handler.appendFSBlob(element, blob, offset, last);
            if (last) {
                handler.doNotify();
            }
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IBlob getFSBlob(IDSHandler handler, String elementPath, boolean forUpdate) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IBlob iBlob = handler.getFSBlob(elementPath, forUpdate);
            return iBlob;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    IBlob getFSBlob(IDSHandler handler, String elementPath, boolean forUpdate, int offset) throws DirectoryServiceException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            IBlob iBlob = handler.getFSBlob(elementPath, forUpdate, offset);
            return iBlob;
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    void detachFSBlob(IDSHandler handler, IDeltaDirElement delta) throws DirectoryServiceException, VersionOutofSyncException {
        ClassLoader existingContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            handler.detachFSBlob(delta);
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingContextClassLoader);
        }
    }

    private DirectoryServiceException convertException(Throwable t) {
        if (t instanceof DirectoryServiceException) {
            return (DirectoryServiceException)t;
        }
        return new DirectoryServiceHandlerException(t.toString());
    }

    private HandlerInfo handlerInfoFromElement(IElement hadlerElement) {
        IAttributeSet handlerAttributes = hadlerElement.getAttributes();
        String handlerClass = (String)handlerAttributes.getAttribute("DS_HANDLER_CLASS");
        if (handlerClass == null) {
            return null;
        }
        String handlerName = (String)handlerAttributes.getAttribute("DS_HANDLER_NAME");
        if (handlerName == null) {
            return null;
        }
        String classpath = DirectoryService.listToClasspath((IAttributeList)handlerAttributes.getAttribute("DS_HANDLER_ARCHIVES"));
        return new HandlerInfo(handlerClass, classpath.length() > 0 ? classpath : null, handlerName);
    }

    private HandlerInfo[] getAllHandlers() {
        IElementIdentity[] libraryElements = null;
        try {
            libraryElements = this.m_ds.listElements("/_MFLibrary/ds_handlers");
        }
        catch (DirectoryServiceException e) {
            return new HandlerInfo[0];
        }
        ArrayList<HandlerInfo> list = new ArrayList<HandlerInfo>();
        for (int i = 0; i < libraryElements.length; ++i) {
            HandlerInfo handlerInfo;
            IDirElement handlerElement = null;
            try {
                handlerElement = this.m_ds.getElement(libraryElements[i].getName(), false);
            }
            catch (DirectoryServiceException e) {
                throw new IllegalStateException(e.toString());
            }
            if (!libraryElements[i].getType().equals("MF_DS_HANDLER") || (handlerInfo = this.handlerInfoFromElement((IElement)handlerElement)) == null) continue;
            list.add(handlerInfo);
        }
        HandlerInfo[] handlerList = new HandlerInfo[list.size()];
        list.toArray(handlerList);
        return handlerList;
    }

    private IDSHandler createDSHandler(String className, String classpath) throws Exception {
        Object handler = this.m_ds.loadClass(className, classpath).newInstance();
        if (!(handler instanceof IDSHandler)) {
            throw new Exception(className + " must implement the 'IDSHandler' interface.");
        }
        ((IDSHandler)handler).setDSContext((IDSHandlerContext)this.m_dsContext);
        return (IDSHandler)handler;
    }

    private IDSHandler createDiskHandler() throws DirectoryServiceException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        DiskFileDSHandler handler = new DiskFileDSHandler(this.m_ds.getBlobCopiesDir());
        handler.setDSContext(this.m_dsContext);
        return handler;
    }

    private EntityName getEntityName(String path) {
        try {
            return new EntityName(path);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void subscribe(INamingListener listener) {
        try {
            NameMapper.NamedPayLoad[] allHandlers = this.m_handlersTable.scan(new EntityName("/"));
            for (int i = 0; i < allHandlers.length; ++i) {
                IDSHandler handler = (IDSHandler)allHandlers[i].getPayload();
                handler.subscribe(listener);
            }
        }
        catch (ConfigException configE) {
            throw new RuntimeException(configE.toString());
        }
    }

    private class HandlerInfo {
        String m_className;
        String m_classpath;
        String m_handlerName;

        HandlerInfo(String className, String classpath, String handlerName) {
            this.m_className = className;
            this.m_classpath = classpath;
            this.m_handlerName = handlerName;
        }
    }
}

