/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.dirconfig.BackupStateException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.InvalidRoleException;
import com.sonicsw.mf.common.dirconfig.UpdateDisallowedOnFailoverException;
import com.sonicsw.mf.framework.agent.TaskScheduler;
import java.util.LinkedList;

final class ReadWriteLock {
    private LinkedList m_waitersQueue = new LinkedList();
    private boolean m_isRestrictedBackupDS;

    public ReadWriteLock(boolean isRestrictedBackupDS) {
        this.m_isRestrictedBackupDS = isRestrictedBackupDS;
        if (this.m_isRestrictedBackupDS) {
            this.noWriteLock();
        }
    }

    private int getFirstLockTypeIndx(int lockType) {
        if (this.m_waitersQueue.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        for (int index = 0; index < this.m_waitersQueue.size(); ++index) {
            Caller caller = (Caller)this.m_waitersQueue.get(index);
            if (caller.state != lockType) continue;
            return index;
        }
        return Integer.MAX_VALUE;
    }

    private int getIndex(Thread t) {
        if (this.m_waitersQueue.isEmpty()) {
            return -1;
        }
        for (int index = 0; index < this.m_waitersQueue.size(); ++index) {
            Caller caller = (Caller)this.m_waitersQueue.get(index);
            if (caller.t != t) continue;
            return index;
        }
        return -1;
    }

    public synchronized void readLock() {
        Caller caller;
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            caller = new Caller(me, 0);
            this.m_waitersQueue.addLast(caller);
        } else {
            caller = (Caller)this.m_waitersQueue.get(index);
        }
        while (this.getIndex(me) > this.getFirstLockTypeIndx(1)) {
            try {
                this.wait();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ++caller.nAcquires;
    }

    public synchronized boolean noWriteLock() {
        Caller caller;
        if (this.getFirstLockTypeIndx(2) != Integer.MAX_VALUE) {
            return false;
        }
        Thread me = Thread.currentThread();
        int noWriteIndex = 0;
        if (this.getIndex(me) == -1) {
            caller = new Caller(null, 2);
            this.m_waitersQueue.addLast(caller);
            noWriteIndex = this.m_waitersQueue.size() - 1;
        } else {
            throw new Error("Cannot call noWriteLock while holding a lock");
        }
        while (noWriteIndex > this.getFirstLockTypeIndx(1)) {
            try {
                this.wait();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ++caller.nAcquires;
        return true;
    }

    public synchronized void removeNoWriteLock() {
        int noWriteCallerIndex = this.getFirstLockTypeIndx(2);
        if (noWriteCallerIndex == Integer.MAX_VALUE) {
            throw new Error("No NO_WRITE lock");
        }
        this.m_waitersQueue.remove(noWriteCallerIndex);
        this.notifyAll();
    }

    public synchronized boolean hasNoWriteLock() {
        return this.getFirstLockTypeIndx(2) != Integer.MAX_VALUE;
    }

    public synchronized void writeLock() throws DirectoryServiceException {
        Caller caller;
        this.validateAdministratorRole();
        if (this.getFirstLockTypeIndx(2) < Integer.MAX_VALUE) {
            if (this.m_isRestrictedBackupDS) {
                throw new UpdateDisallowedOnFailoverException();
            }
            throw new BackupStateException("The BACKUP Directory Service is set to Failover Read-only - cannot be modified.");
        }
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            caller = new Caller(me, 1);
            this.m_waitersQueue.addLast(caller);
        } else {
            caller = (Caller)this.m_waitersQueue.get(index);
            if (caller.state == 0) {
                throw new Error("Lock upgrade is invalid");
            }
            caller.state = 1;
        }
        while (this.getIndex(me) != 0) {
            try {
                this.wait();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ++caller.nAcquires;
    }

    public synchronized void releaseLock() {
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            return;
        }
        if (index > this.getFirstLockTypeIndx(1)) {
            throw new Error("Conflicting WRITE lock");
        }
        Caller caller = (Caller)this.m_waitersQueue.get(index);
        --caller.nAcquires;
        if (caller.nAcquires == 0) {
            this.m_waitersQueue.remove(index);
            this.notifyAll();
        }
    }

    private void validateAdministratorRole() throws InvalidRoleException {
        String role = TaskScheduler.getCurrentRole();
        if (role != null && role.equals("READER")) {
            throw new InvalidRoleException("Request rejected: unauthorized request.");
        }
    }

    public static class Test {
        DSResource resource = new DSResource();

        public Test() {
            new Reader("r/0").start();
            new Writer("w/0").start();
            new Reader("r/1").start();
            new Writer("w/1").start();
            new Writer("w/2").start();
            new Reader("r/2").start();
            new Reader("r/3").start();
            new Reader("r/4").start();
            new Reader("r/5").start();
            new Reader("r/6").start();
            new Writer("w/3").start();
        }

        public static void main(String[] args) {
            Test t = new Test();
        }

        class Writer
        extends Thread {
            private String name;

            Writer(String name) {
                this.name = name;
            }

            @Override
            public void run() {
                System.out.println("Starting " + this.name);
                try {
                    Test.this.resource.write(this.name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Error(e.toString());
                }
                System.out.println("Stopping " + this.name);
            }
        }

        class Reader
        extends Thread {
            private String name;

            Reader(String name) {
                this.name = name;
            }

            @Override
            public void run() {
                System.out.println("Starting " + this.name);
                Test.this.resource.read(this.name);
                System.out.println("Stopping " + this.name);
            }
        }

        static class DSResource {
            ReadWriteLock lock = new ReadWriteLock(false);

            DSResource() {
            }

            public void read(String reader) {
                try {
                    this.lock.readLock();
                    System.out.println("\t\t" + reader + "reading");
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("\t\t" + reader + "done");
                }
                finally {
                    this.lock.releaseLock();
                }
            }

            public void write(String writer) throws Exception {
                try {
                    this.lock.writeLock();
                    System.out.println("\t\t" + writer + "writing");
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("\t\t" + writer + "done");
                }
                finally {
                    this.lock.releaseLock();
                }
            }
        }
    }

    class Caller {
        static final int READ = 0;
        static final int WRITE = 1;
        static final int NO_WRITE = 2;
        Thread t;
        int state;
        int nAcquires;

        Caller(Thread t, int state) {
            this.t = t;
            this.state = state;
            this.nAcquires = 0;
        }
    }
}

