/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.storage.fs;

import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.agent.EncryptionException;
import com.sonicsw.mf.framework.agent.PBE;
import com.sonicsw.mf.framework.directory.ILogger;
import com.sonicsw.mf.framework.directory.storage.DSEncryptionException;
import com.sonicsw.mf.framework.directory.storage.StorageException;
import com.sonicsw.mf.framework.directory.storage.fs.FSTransactionManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;

final class FileManager {
    private String m_password = null;
    private FSTransactionManager m_trManager = null;
    private ILogger m_logger;

    FileManager(String password, FSTransactionManager manager) throws Exception {
        this.m_password = password;
        this.m_trManager = manager;
        this.m_logger = null;
    }

    void setLogger(ILogger logger) {
        this.m_logger = logger;
    }

    IDirElement getElement(File file, EntityName elementName) throws StorageException {
        IdsAndElements idsAndElements = this.readFile(file, false);
        return (IDirElement)idsAndElements.elements.get(elementName.getBaseName());
    }

    IDirElement[] getElements(File file) throws StorageException {
        IdsAndElements idsAndElements = this.readFile(file, false);
        return idsAndElements.elements.values().toArray(new IDirElement[idsAndElements.elements.size()]);
    }

    IElementIdentity[] getIds(File file) throws StorageException {
        IdsAndElements idsAndElements = this.readFile(file, true);
        return idsAndElements.ids.values().toArray(new IElementIdentity[idsAndElements.ids.size()]);
    }

    IElementIdentity deleteElement(File file, EntityName elementName) throws StorageException {
        String name = elementName.getBaseName();
        IdsAndElements idsAndElements = this.readFile(file, false);
        IElementIdentity id = (IElementIdentity)idsAndElements.ids.get(name);
        if (id == null) {
            return null;
        }
        idsAndElements.ids.remove(name);
        idsAndElements.elements.remove(name);
        this.updateFile(file, idsAndElements.ids, idsAndElements.elements, elementName.getParentEntity());
        return id;
    }

    IElementIdentity[] deleteElements(File file, EntityName[] elementNames) throws StorageException {
        IdsAndElements idsAndElements = this.readFile(file, false);
        EntityName elementName = null;
        ArrayList deletedIds = new ArrayList();
        for (int i = 0; i < elementNames.length; ++i) {
            String name = elementNames[i].getBaseName();
            if (idsAndElements.ids.get(name) == null) continue;
            elementName = elementNames[i];
            Object removedID = idsAndElements.ids.remove(name);
            if (removedID != null) {
                deletedIds.add(removedID);
            }
            idsAndElements.elements.remove(name);
        }
        if (elementName != null) {
            this.updateFile(file, idsAndElements.ids, idsAndElements.elements, elementName.getParentEntity());
        }
        IElementIdentity[] result = new IElementIdentity[deletedIds.size()];
        deletedIds.toArray(result);
        return result;
    }

    void setElement(File file, IDirElement element) throws StorageException {
        this.setElementsInternal(file, new IDirElement[]{element}, this.getParentDir(element));
    }

    void setElements(File file, IDirElement[] elements) throws StorageException {
        if (elements.length == 0) {
            throw new IllegalArgumentException();
        }
        this.setElementsInternal(file, elements, this.getParentDir(elements[0]));
    }

    private void setElementsInternal(File file, IDirElement[] newElements, EntityName dirName) throws StorageException {
        IdsAndElements idsAndElements = this.readFile(file, false);
        for (int i = 0; i < newElements.length; ++i) {
            IElementIdentity id = newElements[i].getIdentity();
            String name = null;
            try {
                name = new EntityName(id.getName()).getBaseName();
            }
            catch (Exception e) {
                throw new Error(e.toString());
            }
            idsAndElements.ids.put(name, id);
            idsAndElements.elements.put(name, newElements[i]);
        }
        this.updateFile(file, idsAndElements.ids, idsAndElements.elements, dirName);
    }

    private void updateFile(File file, HashMap ids, HashMap elements, EntityName dirName) throws StorageException {
        try {
            EntityName fileName = dirName.createChild(file.getName());
            if (ids.isEmpty()) {
                this.m_trManager.deleteElement(fileName);
                file.delete();
                return;
            }
            if (file.exists()) {
                this.m_trManager.deleteElement(fileName);
            } else {
                this.m_trManager.newElement(fileName.getName());
            }
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream fileOut = new BufferedOutputStream(fos);
            ObjectOutputStream objectOS = new ObjectOutputStream(fileOut);
            if (this.m_password == null) {
                objectOS.writeObject(ids);
                objectOS.writeObject(elements);
            } else {
                objectOS.writeObject(this.convertObjectToBytes(ids));
                objectOS.writeObject(this.convertObjectToBytes(elements));
            }
            objectOS.close();
        }
        catch (Exception e) {
            throw new StorageException("Could not write file'':" + file.getPath() + " " + e.toString());
        }
    }

    private IdsAndElements readFile(File file, boolean idsOnly) throws StorageException {
        ObjectInputStream objectS = null;
        if (!file.exists() || file.isDirectory()) {
            return new IdsAndElements(true);
        }
        try {
            IdsAndElements idsAndElements = new IdsAndElements();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            objectS = new ObjectInputStream(is);
            if (this.m_password == null) {
                Object idsObject = objectS.readObject();
                if (idsObject instanceof byte[]) {
                    throw new DSEncryptionException("Could not access the Directory Service because of a wrong or a lacking encryption password.");
                }
                idsAndElements.ids = (HashMap)idsObject;
            } else {
                idsAndElements.ids = this.readEncryptedData(objectS);
            }
            if (idsOnly) {
                objectS.close();
                return idsAndElements;
            }
            idsAndElements.elements = this.m_password == null ? (HashMap)objectS.readObject() : this.readEncryptedData(objectS);
            objectS.close();
            return idsAndElements;
        }
        catch (Exception ex) {
            try {
                if (objectS != null) {
                    objectS.close();
                }
            }
            catch (Exception is) {
                // empty catch block
            }
            if (ex instanceof EncryptionException) {
                throw new DSEncryptionException("Failed to read encrypted data", (EncryptionException)((Object)ex));
            }
            String msg = "Could not read file '" + file.getName();
            if (!idsOnly) {
                StorageException storageException = new StorageException(msg);
                storageException.initCause(ex);
                throw storageException;
            }
            msg = msg + ", trace follows...";
            if (this.m_logger != null) {
                this.m_logger.logMessage(msg, ex, 1);
            } else {
                System.err.println(msg);
                ex.printStackTrace();
            }
            return new IdsAndElements(true);
        }
    }

    EntityName getParentDir(IDirElement element) {
        EntityName name = null;
        String elmntName = element.getIdentity().getName();
        try {
            name = new EntityName(elmntName);
        }
        catch (Exception ex) {
            throw new Error();
        }
        return name.getParentEntity();
    }

    private HashMap readEncryptedData(ObjectInputStream input) throws Exception {
        Object inS = input.readObject();
        if (inS instanceof HashMap) {
            throw new DSEncryptionException("Could not access the Directory Service because of a wrong or a lacking encryption password.");
        }
        byte[] bytes = PBE.decrypt((byte[])inS, this.m_password);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream object = new ObjectInputStream(in);
        return (HashMap)object.readObject();
    }

    private byte[] convertObjectToBytes(Object data) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(out);
        objectOut.writeObject(data);
        byte[] encBytes = PBE.encrypt(out.toByteArray(), this.m_password);
        out.close();
        return encBytes;
    }

    private class IdsAndElements {
        HashMap ids = null;
        HashMap elements = null;

        IdsAndElements() {
            this(false);
        }

        IdsAndElements(boolean emptyTables) {
            if (emptyTables) {
                this.ids = new HashMap();
                this.elements = new HashMap();
            }
        }
    }
}

