/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.AbstractBTreeIterator;
import com.sonicsw.mtstorage.BTreeKeyNotFoundException;
import com.sonicsw.mtstorage.BTreeLockNeededException;
import com.sonicsw.mtstorage.IBTreeManager;
import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.AccessSemaphore;
import com.sonicsw.mtstorage.impl.BTree;
import com.sonicsw.mtstorage.impl.BTreeAbstractBufferSupply;
import com.sonicsw.mtstorage.impl.BTreeCreateTreeLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeDeleteLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeIteratorState;
import com.sonicsw.mtstorage.impl.BTreeKeyBuffer;
import com.sonicsw.mtstorage.impl.BTreeLockID;
import com.sonicsw.mtstorage.impl.BTreePageBufferSupply;
import com.sonicsw.mtstorage.impl.BTreePhysicalRecovery;
import com.sonicsw.mtstorage.impl.BTreePutLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveAnyLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeSecondary;
import com.sonicsw.mtstorage.impl.BTreeSnapshotManager;
import com.sonicsw.mtstorage.impl.INote;
import com.sonicsw.mtstorage.impl.Logger;
import com.sonicsw.mtstorage.impl.PageManager;
import com.sonicsw.mtstorage.impl.SnapshotStorage;
import com.sonicsw.mtstorage.impl.Storage;
import com.sonicsw.mtstorage.impl.TransactionManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

final class BTreeManager
implements IBTreeManager {
    static final int NO_LOCKING = 0;
    static final int ENTRY_LOCKING = 1;
    static final int RANGE_LOCKING = 2;
    private PageManager m_pageManager;
    private BTreePhysicalRecovery m_btreePhysicalRecovery;
    private Storage m_storage;
    private BTreeAbstractBufferSupply m_bufferSupply;
    private AccessSemaphore m_accessSemaphore;
    private TransactionManager m_transactionManager;
    private Logger m_logger;
    private HashMap m_btrees;
    private String m_dbPath;
    private short m_inCritical = 0;
    private boolean m_threadDeath = false;
    private BTreeSecondary m_secondary;
    private BTreePutLogicalNote m_putLogicalNote;
    private BTreeDeleteLogicalNote m_deleteLogicalNote;
    private BTreeRemoveLogicalNote m_removeLogicalNote;
    private BTreeRemoveAnyLogicalNote m_removeAnyLogicalNote;
    private BTreeCreateTreeLogicalNote m_createlogicalNote;
    private BTreeSnapshotManager m_snapshotManager;
    private int m_lockLevel;

    BTreeManager(Storage storage, PageManager pageManager, Logger logger, SnapshotStorage snpashotStorage, AccessSemaphore accessSemaphore, String dbPath, int lockLevel) throws IOException {
        this.m_storage = storage;
        this.m_pageManager = pageManager;
        this.m_logger = logger;
        this.m_accessSemaphore = accessSemaphore;
        this.m_dbPath = dbPath;
        this.m_lockLevel = lockLevel;
        this.m_snapshotManager = snpashotStorage != null ? new BTreeSnapshotManager(snpashotStorage, this.m_lockLevel < 2) : null;
        this.m_bufferSupply = new BTreePageBufferSupply(pageManager);
        this.m_secondary = new BTreeSecondary(this.m_bufferSupply, logger);
        this.m_btreePhysicalRecovery = new BTreePhysicalRecovery(logger, this.m_bufferSupply, this.m_secondary);
        this.m_btrees = new HashMap();
        this.m_putLogicalNote = new BTreePutLogicalNote();
        this.m_deleteLogicalNote = new BTreeDeleteLogicalNote();
        this.m_removeLogicalNote = new BTreeRemoveLogicalNote();
        this.m_removeAnyLogicalNote = new BTreeRemoveAnyLogicalNote();
        this.m_createlogicalNote = new BTreeCreateTreeLogicalNote();
    }

    void createSnapshot(Long snashotID) throws IOException {
        this.m_snapshotManager.createSnapshot(snashotID);
    }

    void deleteSnapshot(Long snashotID) throws IOException {
        this.m_snapshotManager.deleteSnapshot(snashotID);
    }

    void undo(INote note) throws IOException {
        this.m_btreePhysicalRecovery.undo((AbstractNote)note);
    }

    void redo(INote note) throws IOException {
        this.m_btreePhysicalRecovery.redo((AbstractNote)note);
    }

    void setTransactionManager(TransactionManager transactionManager) {
        this.m_transactionManager = transactionManager;
    }

    void close() {
        this.m_storage = null;
        this.m_bufferSupply = null;
        this.m_accessSemaphore = null;
        this.m_pageManager = null;
        this.m_transactionManager = null;
        this.m_logger = null;
        this.m_btrees = null;
    }

    @Override
    public long createBTree(Long transactionNum, boolean uniqueIndex, String pathInfo) throws IOException {
        return this.createBTree(uniqueIndex, transactionNum, 0L);
    }

    void transactionRolledback(Long transactionID) throws IOException {
        if (this.m_snapshotManager != null) {
            this.m_snapshotManager.transactionRolledback(transactionID);
        }
    }

    void transactionCommitted(Long transactionID) throws IOException {
        if (this.m_snapshotManager != null) {
            this.m_snapshotManager.transactionCommitted(transactionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long createBTree(boolean uniqueIndex, long transactionNum, long useThisDbk) throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            if (useThisDbk != 0L) {
                this.m_transactionManager.pageUnreserveDBK(useThisDbk);
            }
            this.m_createlogicalNote.initNote(true, uniqueIndex, transactionNum, useThisDbk);
            this.m_logger.writeNote(this.m_createlogicalNote);
            BTree tree = new BTree(this.m_logger, this.m_secondary, uniqueIndex, this.m_bufferSupply, transactionNum, useThisDbk);
            long dbk = tree.getTreeDbk();
            this.m_btrees.put(new Long(dbk), tree);
            if (this.m_snapshotManager != null) {
                this.m_snapshotManager.treeCreatedOrDeleted(new Long(transactionNum), dbk, useThisDbk != 0L);
            }
            this.m_createlogicalNote.initNote(false, uniqueIndex, transactionNum, dbk);
            long noteID = this.m_logger.writeNote(this.m_createlogicalNote);
            this.m_storage.conditionalCheckpoint(noteID);
            long l = dbk;
            return l;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            long l = 0L;
            return l;
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countTree(Long transactionNum, long treeDbk) throws IOException {
        try {
            this.m_accessSemaphore.sharedLock();
            long l = this.getTree(treeDbk).countTree();
            return l;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            long l = 0L;
            return l;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Long transactionNum, long treeDbk, byte[] key, String pathInfo) throws IOException {
        try {
            this.m_accessSemaphore.sharedLock();
            if (this.m_storage.isSnapshot(transactionNum)) {
                Long dbk = new Long(treeDbk);
                BTree tree = this.m_snapshotManager.treeWasDeleted(transactionNum, dbk) ? null : this.getTree(treeDbk);
                boolean bl = this.m_snapshotManager.containsKey(tree, transactionNum, dbk, key);
                return bl;
            }
            BTree tree = this.getTree(treeDbk);
            boolean hasKey = tree.containsKey(key);
            this.lockKeyRead(transactionNum, treeDbk, tree, key, hasKey, pathInfo);
            boolean bl = hasKey;
            return bl;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            boolean bl = false;
            return bl;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countKeyEntries(long treeDbk, byte[] key) throws IOException {
        try {
            this.m_accessSemaphore.sharedLock();
            int n = this.getTree(treeDbk).countKeyEntries(key);
            return n;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            int n = 0;
            return n;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Long transactionNum, long treeDbk, byte[] key, byte[] value, String pathInfo) throws IOException {
        try {
            this.m_accessSemaphore.sharedLock();
            if (this.m_storage.isSnapshot(transactionNum)) {
                Long dbk = new Long(treeDbk);
                BTree tree = this.m_snapshotManager.treeWasDeleted(transactionNum, dbk) ? null : this.getTree(treeDbk);
                boolean bl = this.m_snapshotManager.contains(tree, transactionNum, dbk, key, value);
                return bl;
            }
            BTree tree = this.getTree(treeDbk);
            if (this.needEntryLocking(transactionNum)) {
                this.m_storage.tryLock(transactionNum, new BTreeLockID(tree.isUnique(), treeDbk, key, value), 1, false, pathInfo);
            }
            boolean bl = tree.contains(key, value);
            return bl;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            boolean bl = false;
            return bl;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advance(Long transactionNum, AbstractBTreeIterator iterator0, String pathInfo) throws IOException {
        BTreeIteratorState iterator = (BTreeIteratorState)iterator0;
        boolean noLockScan = iterator.getNolock();
        try {
            this.m_accessSemaphore.sharedLock();
            if (!noLockScan && this.needEntryLocking(transactionNum)) {
                iterator.save();
            }
            if (this.m_storage.isSnapshot(transactionNum)) {
                long treeDbk = iterator.getTreeDbk();
                Long dbk = new Long(treeDbk);
                BTree tree = this.m_snapshotManager.treeWasDeleted(transactionNum, dbk) ? null : this.getTree(treeDbk);
                this.m_snapshotManager.advance(tree, transactionNum, iterator);
                return;
            }
            BTreeIteratorState savedIterator = null;
            if (!noLockScan && this.needRangeLocking(transactionNum)) {
                savedIterator = iterator.replicate();
            }
            BTree tree = this.getTree(iterator.getTreeDbk());
            tree.advance(iterator);
            if (!noLockScan && this.needEntryLocking(transactionNum) && iterator.currentChanged()) {
                if (!noLockScan && this.needRangeLocking(transactionNum)) {
                    BTreeIteratorState savedToUse = !savedIterator.isInitialized() ? savedIterator.replicate() : savedIterator;
                    this.checkDeletedRangeLocks(transactionNum, iterator.getTreeDbk(), tree, savedToUse, iterator, pathInfo);
                    if (!savedIterator.isInitialized()) {
                        this.ensureRangeLocked(transactionNum, iterator.getTreeDbk(), tree, iterator.getCurrentKey(), savedIterator, pathInfo);
                    }
                }
                this.m_storage.tryLock(transactionNum, new BTreeLockID(tree.isUnique(), iterator.getTreeDbk(), iterator.getCurrentKey(), iterator.getCurrentValue()), 1, false, pathInfo);
            } else if (!noLockScan && this.needRangeLocking(transactionNum)) {
                this.checkDeletedRangeLocksToEnd(transactionNum, iterator.getTreeDbk(), tree, savedIterator, pathInfo);
            }
        }
        catch (BTreeLockNeededException e) {
            iterator.restore();
            throw e;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getFirstKey(Long transactionNum, long treeDbk, String pathInfo) throws IOException {
        try {
            this.m_accessSemaphore.sharedLock();
            if (this.m_storage.isSnapshot(transactionNum)) {
                Long dbk = new Long(treeDbk);
                BTree tree = this.m_snapshotManager.treeWasDeleted(transactionNum, dbk) ? null : this.getTree(treeDbk);
                byte[] byArray = this.m_snapshotManager.getFirstKey(tree, transactionNum, dbk);
                return byArray;
            }
            BTree tree = this.getTree(treeDbk);
            byte[] key = tree.getFirstKey();
            if (this.needRangeLocking(transactionNum)) {
                BTreeIteratorState iterator = new BTreeIteratorState(treeDbk, key, null, true);
                this.internalCheckDeletedLocks(transactionNum, treeDbk, tree, iterator, null, pathInfo);
            }
            this.lockKeyRead(transactionNum, treeDbk, tree, key, true, pathInfo);
            byte[] byArray = key;
            return byArray;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getLastKey(Long transactionNum, long treeDbk, String pathInfo) throws IOException {
        try {
            BTreeIteratorState iterator;
            boolean gotToEnd;
            this.m_accessSemaphore.sharedLock();
            if (this.m_storage.isSnapshot(transactionNum)) {
                Long dbk = new Long(treeDbk);
                BTree tree = this.m_snapshotManager.treeWasDeleted(transactionNum, dbk) ? null : this.getTree(treeDbk);
                byte[] byArray = this.m_snapshotManager.getLastKey(tree, transactionNum, dbk);
                return byArray;
            }
            BTree tree = this.getTree(treeDbk);
            byte[] key = tree.getLastKey();
            if (this.needRangeLocking(transactionNum) && !(gotToEnd = this.skipToNextDeletedKey(transactionNum, treeDbk, tree, iterator = new BTreeIteratorState(treeDbk, key, null, false), key, pathInfo))) {
                this.internalCheckDeletedLocks(transactionNum, treeDbk, tree, iterator, null, pathInfo);
            }
            this.lockKeyRead(transactionNum, treeDbk, tree, key, true, pathInfo);
            byte[] byArray = key;
            return byArray;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(Long transactionNum, long treeDbk, byte[] key, byte[] valueBuffer, String pathInfo) throws IOException {
        try {
            this.m_accessSemaphore.sharedLock();
            if (this.m_storage.isSnapshot(transactionNum)) {
                Long dbk = new Long(treeDbk);
                BTree tree = this.m_snapshotManager.treeWasDeleted(transactionNum, dbk) ? null : this.getTree(treeDbk);
                byte[] byArray = this.m_snapshotManager.get(tree, transactionNum, dbk, key);
                return byArray;
            }
            BTree tree = this.getTree(treeDbk);
            byte[] value = tree.get(key, valueBuffer);
            if (this.needEntryLocking(transactionNum)) {
                this.m_storage.tryLock(transactionNum, new BTreeLockID(tree.isUnique(), treeDbk, key, value), 1, false, pathInfo);
            }
            byte[] byArray = value;
            return byArray;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] remove(Long transactionNum, long treeDbk, byte[] key, String pathInfo) throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            BTree tree = this.getTree(treeDbk);
            if (tree.isUnique()) {
                if (this.needEntryLocking(transactionNum)) {
                    this.m_storage.tryLock(transactionNum, new BTreeLockID(true, treeDbk, key, null), 2, false, pathInfo);
                }
                if (this.needRangeLocking(transactionNum)) {
                    byte[] value = null;
                    try {
                        value = tree.get(key, new byte[8]);
                    }
                    catch (BTreeKeyNotFoundException e) {
                        byte[] byArray = null;
                        this.m_inCritical = (short)(this.m_inCritical - 1);
                        this.m_accessSemaphore.releaseLock();
                        return byArray;
                    }
                    this.checkNeighboringLocks(transactionNum, treeDbk, tree, key, value, pathInfo);
                }
            }
            this.m_removeAnyLogicalNote.initNote();
            this.m_logger.writeNote(this.m_removeAnyLogicalNote);
            ArrayList alreadyRemoved = new ArrayList();
            byte[] oldValue = tree.remove(key, transactionNum, alreadyRemoved);
            if (this.m_snapshotManager != null && alreadyRemoved.isEmpty()) {
                this.m_snapshotManager.btreeEntryDeleted(transactionNum, new Long(treeDbk), key, oldValue);
            }
            this.m_removeAnyLogicalNote.initNote(transactionNum, treeDbk, key, oldValue, alreadyRemoved.size() > 0);
            long noteID = this.m_logger.writeNote(this.m_removeAnyLogicalNote);
            this.m_storage.conditionalCheckpoint(noteID);
            byte[] byArray = oldValue;
            return byArray;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Long transactionNum, long treeDbk, byte[] key, byte[] value, String pathInfo, boolean lock) throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            BTree tree = this.getTree(treeDbk);
            if (lock && this.needEntryLocking(transactionNum)) {
                this.m_storage.tryLock(transactionNum, new BTreeLockID(tree.isUnique(), treeDbk, key, value), 2, false, pathInfo);
            }
            if (lock && this.needRangeLocking(transactionNum)) {
                this.checkNeighboringLocks(transactionNum, treeDbk, tree, key, value, pathInfo);
            }
            this.m_removeLogicalNote.initNote();
            this.m_logger.writeNote(this.m_removeLogicalNote);
            ArrayList alreadyRemoved = new ArrayList();
            tree.remove(key, value, transactionNum, alreadyRemoved);
            if (this.m_snapshotManager != null && alreadyRemoved.isEmpty()) {
                this.m_snapshotManager.btreeEntryDeleted(transactionNum, new Long(treeDbk), key, value);
            }
            this.m_removeLogicalNote.initNote(transactionNum, treeDbk, key, value, alreadyRemoved.size() > 0);
            long noteID = this.m_logger.writeNote(this.m_removeLogicalNote);
            this.m_storage.conditionalCheckpoint(noteID);
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    @Override
    public void delete(Long transactionNum, long treeDbk, String pathInfo, boolean lock) throws IOException {
        this.delete(transactionNum, treeDbk, pathInfo, lock, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(Long transactionNum, long treeDbk, String pathInfo, boolean lock, boolean rollingBack) throws IOException {
        this.clear(transactionNum, treeDbk, pathInfo, lock);
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            BTree tree = this.getTree(treeDbk);
            boolean unique = tree.isUnique();
            this.m_transactionManager.reserveDBK(transactionNum, treeDbk);
            this.m_deleteLogicalNote.initNote(true, unique, transactionNum, treeDbk);
            this.m_logger.writeNote(this.m_deleteLogicalNote);
            tree.delete(transactionNum);
            if (this.m_snapshotManager != null) {
                this.m_snapshotManager.treeCreatedOrDeleted(transactionNum, treeDbk, rollingBack);
            }
            this.m_deleteLogicalNote.initNote(false, unique, transactionNum, treeDbk);
            long noteID = this.m_logger.writeNote(this.m_deleteLogicalNote);
            this.m_btrees.remove(new Long(treeDbk));
            this.m_storage.conditionalCheckpoint(noteID);
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    @Override
    public void clear(Long transactionNum, long treeDbk, String pathInfo, boolean lock) throws IOException {
        BTreeIteratorState iteratorState = new BTreeIteratorState(treeDbk, false);
        while (true) {
            this.advance(transactionNum, iteratorState, pathInfo);
            if (iteratorState.getAfterLast()) break;
            this.remove(transactionNum, treeDbk, iteratorState.getCurrentKey(), iteratorState.getCurrentValue(), pathInfo, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] put(Long transactionNum, long treeDbk, byte[] key, byte[] value, String pathInfo, boolean lock) throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            BTree tree = this.getTree(treeDbk);
            if (lock && this.needEntryLocking(transactionNum)) {
                this.m_storage.tryLock(transactionNum, new BTreeLockID(tree.isUnique(), treeDbk, key, value), 2, false, pathInfo);
            }
            if (lock && this.needRangeLocking(transactionNum)) {
                this.checkNeighboringLocks(transactionNum, treeDbk, tree, key, value, pathInfo);
            }
            this.m_putLogicalNote.initNote();
            this.m_logger.writeNote(this.m_putLogicalNote);
            ArrayList aleradyExists = new ArrayList();
            byte[] oldValue = tree.put(key, value, transactionNum, aleradyExists);
            if (this.m_snapshotManager != null && aleradyExists.isEmpty()) {
                this.m_snapshotManager.btreeEntryInserted(transactionNum, new Long(treeDbk), key, value);
            }
            if (this.m_snapshotManager != null && oldValue != null && aleradyExists.isEmpty()) {
                this.m_snapshotManager.btreeEntryDeleted(transactionNum, new Long(treeDbk), key, oldValue);
            }
            this.m_putLogicalNote.initNote(transactionNum, treeDbk, key, value, oldValue != null, oldValue, aleradyExists.size() > 0);
            long noteID = this.m_logger.writeNote(this.m_putLogicalNote);
            this.m_storage.conditionalCheckpoint(noteID);
            byte[] byArray = oldValue;
            return byArray;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    private BTree getTree(long treeDbk) throws IOException {
        Long treeDbkObj = new Long(treeDbk);
        BTree tree = (BTree)this.m_btrees.get(treeDbkObj);
        if (tree == null) {
            tree = new BTree(this.m_logger, this.m_secondary, treeDbk, this.m_bufferSupply);
            this.m_btrees.put(treeDbkObj, tree);
        }
        return tree;
    }

    private void checkInCritical() {
        if (this.m_threadDeath || this.m_inCritical > 0) {
            throw new Error("Tried to access database " + this.m_dbPath + " during the shutdown sequence.");
        }
    }

    private void handleThreadDeath(ThreadDeath td) {
        this.m_threadDeath = true;
        throw td;
    }

    private void lockKeyRead(Long transactionNum, long treeDbk, BTree tree, byte[] key, boolean hasKey, String pathInfo) throws IOException {
        if (this.needEntryLocking(transactionNum)) {
            byte[] value = null;
            if (!tree.isUnique() && hasKey) {
                value = tree.get(key, new byte[8]);
            }
            if (tree.isUnique() || hasKey) {
                // empty if block
            }
            this.m_storage.tryLock(transactionNum, new BTreeLockID(tree.isUnique(), treeDbk, key, value), 1, false, pathInfo);
        }
    }

    private void checkDeletedRangeLocks(Long transactionNum, long treeDbk, BTree tree, BTreeIteratorState iteratorBefore, BTreeIteratorState iteratorAfter, String pathInfo) throws BTreeLockNeededException, IOException {
        this.internalCheckDeletedLocks(transactionNum, treeDbk, tree, iteratorBefore, iteratorAfter.getPosition(), pathInfo);
    }

    private void checkDeletedRangeLocksToEnd(Long transactionNum, long treeDbk, BTree tree, BTreeIteratorState iteratorBefore, String pathInfo) throws BTreeLockNeededException, IOException {
        this.internalCheckDeletedLocks(transactionNum, treeDbk, tree, iteratorBefore, null, pathInfo);
    }

    private void ensureRangeLocked(Long transactionNum, long treeDbk, BTree tree, byte[] firstKey, BTreeIteratorState iteratorBefore, String pathInfo) throws BTreeLockNeededException, IOException {
        if (BTreeKeyBuffer.keysEqual(firstKey, iteratorBefore.getInitialKey())) {
            return;
        }
        iteratorBefore.setReverse(!iteratorBefore.isReverse());
        BTreeIteratorState iteratorBeforeReplica = iteratorBefore.replicate();
        BTreeIteratorState.KeyValuePair prevEntry = null;
        iteratorBeforeReplica.setNotChanged();
        tree.advance(iteratorBeforeReplica);
        if (iteratorBeforeReplica.currentChanged()) {
            prevEntry = iteratorBeforeReplica.getPosition();
        }
        this.internalCheckDeletedLocks(transactionNum, treeDbk, tree, iteratorBefore, prevEntry, pathInfo);
        if (prevEntry == null) {
            return;
        }
        this.m_storage.tryLock(transactionNum, new BTreeLockID(tree.isUnique(), treeDbk, prevEntry.m_key, prevEntry.m_value), 1, false, pathInfo);
    }

    private boolean skipToNextDeletedKey(Long transactionNum, long treeDbk, BTree tree, BTreeIteratorState iterator, byte[] key, String pathInfo) throws BTreeLockNeededException, IOException {
        BTreeIteratorState.KeyValuePair currentEntry;
        do {
            if ((currentEntry = this.m_snapshotManager.advanceInDeleted(iterator)) != null) continue;
            return true;
        } while (BTreeKeyBuffer.compareKeys(currentEntry.m_key, key) == 0);
        this.m_storage.tryLock(transactionNum, new BTreeLockID(tree.isUnique(), treeDbk, currentEntry.m_key, currentEntry.m_value), 1, false, pathInfo);
        return false;
    }

    private void internalCheckDeletedLocks(Long transactionNum, long treeDbk, BTree tree, BTreeIteratorState iteratorBefore, BTreeIteratorState.KeyValuePair lastEntry, String pathInfo) throws BTreeLockNeededException, IOException {
        BTreeIteratorState.KeyValuePair currentEntry;
        while ((currentEntry = this.m_snapshotManager.advanceInDeleted(iteratorBefore)) != null) {
            if (lastEntry != null) {
                int smallerOrLarger;
                int n = smallerOrLarger = iteratorBefore.isReverse() ? 2 : -2;
                if (BTreeIteratorState.compareEntries(currentEntry, lastEntry) != smallerOrLarger) break;
            }
            this.m_storage.tryLock(transactionNum, new BTreeLockID(tree.isUnique(), treeDbk, currentEntry.m_key, currentEntry.m_value), 1, false, pathInfo);
        }
    }

    private void checkNeighboringLocks(Long transactionNum, long treeDbk, BTree tree, byte[] key, byte[] value, String pathInfo) throws BTreeLockNeededException, IOException {
        BTreeIteratorState iterator = new BTreeIteratorState(treeDbk, key, value, false);
        BTreeIteratorState.KeyValuePair nextNeighborToCheck = this.getNextNeighbor(tree, iterator, false);
        BTreeIteratorState.KeyValuePair prevNeighborToCheck = this.getNextNeighbor(tree, iterator, true);
        boolean nextOk = true;
        BTreeLockNeededException nextLockDetails = null;
        if (nextNeighborToCheck != null) {
            try {
                this.m_storage.tryLock(transactionNum, new BTreeLockID(tree.isUnique(), treeDbk, nextNeighborToCheck.m_key, nextNeighborToCheck.m_value), 2, true, pathInfo);
            }
            catch (BTreeLockNeededException e) {
                if (prevNeighborToCheck == null) {
                    throw e;
                }
                nextOk = false;
                nextLockDetails = e;
            }
            if (nextOk) {
                return;
            }
        } else {
            nextOk = false;
        }
        if (prevNeighborToCheck == null) {
            if (nextNeighborToCheck != null) {
                throw nextLockDetails;
            }
            return;
        }
        this.m_storage.tryLock(transactionNum, new BTreeLockID(tree.isUnique(), treeDbk, prevNeighborToCheck.m_key, prevNeighborToCheck.m_value), 2, true, pathInfo);
    }

    private BTreeIteratorState.KeyValuePair getNextNeighbor(BTree tree, BTreeIteratorState iterator, boolean reverse) throws IOException {
        BTreeIteratorState.KeyValuePair nextNeighbor = this.getNeighbor(iterator, tree, reverse);
        BTreeIteratorState.KeyValuePair nextDeletedNeighbor = this.m_snapshotManager.adjacentInDeleted(iterator, reverse);
        return BTreeIteratorState.selectEntries(nextNeighbor, nextDeletedNeighbor, reverse);
    }

    private BTreeIteratorState.KeyValuePair getNeighbor(BTreeIteratorState iterator, BTree tree, boolean reverse) throws IOException {
        BTreeIteratorState.KeyValuePair neighbor = null;
        iterator.save();
        iterator.setReverse(reverse);
        tree.advance(iterator);
        if (iterator.currentChanged()) {
            neighbor = iterator.getPosition();
        }
        iterator.restore();
        return neighbor;
    }

    private boolean needRangeLocking(Long transactionNum) {
        return !this.m_storage.isSnapshot(transactionNum) && this.m_lockLevel >= 2;
    }

    private boolean needEntryLocking(Long transactionNum) {
        return !this.m_storage.isSnapshot(transactionNum) && this.m_lockLevel >= 1;
    }
}

