/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BTreeAbstractBufferSupply;
import com.sonicsw.mtstorage.impl.DataPage;
import com.sonicsw.mtstorage.impl.ObjectFragment;
import com.sonicsw.mtstorage.impl.ObjectsBuffer;
import com.sonicsw.mtstorage.impl.PageManager;
import java.io.IOException;

final class BTreePageBufferSupply
extends BTreeAbstractBufferSupply {
    PageManager m_pageManager;

    BTreePageBufferSupply(PageManager pageManager) {
        this.m_pageManager = pageManager;
    }

    @Override
    BTreeAbstractBufferSupply.AllocatedBuffer allocateBuffer(long transactionNum, long useThisPage) throws IOException {
        short nodeLength;
        DataPage page = null;
        page = useThisPage == 0L ? this.m_pageManager.getFreePage((long)transactionNum).m_page : (DataPage)this.m_pageManager.getForWrite(useThisPage);
        ObjectsBuffer objectsBuffer = (ObjectsBuffer)page.getContentBuffer();
        byte slot = objectsBuffer.allocate(nodeLength = objectsBuffer.getFreeSpace(), 0, true, true, false, (byte)0, nodeLength);
        if (slot != 0) {
            throw new Error("slot must be 0");
        }
        ObjectFragment fragment = objectsBuffer.getObjectFragment((byte)0);
        return new BTreeAbstractBufferSupply.AllocatedBuffer(page.getBuffer(), fragment.getPayloadOffset(), nodeLength, page.getPageNum(), page);
    }

    @Override
    long getBufferNoteID(long dbk) throws IOException {
        DataPage page = (DataPage)this.m_pageManager.getForRead(dbk);
        return page.getNoteID();
    }

    @Override
    BTreeAbstractBufferSupply.AllocatedBuffer getBuffer(long dbk, boolean forUpdate) throws IOException {
        DataPage page = (DataPage)(forUpdate ? this.m_pageManager.getForWrite(dbk) : this.m_pageManager.getForRead(dbk));
        ObjectsBuffer objectsBuffer = (ObjectsBuffer)page.getContentBuffer();
        ObjectFragment fragment = objectsBuffer.getObjectFragment((byte)0);
        BTreeAbstractBufferSupply.AllocatedBuffer buffer = new BTreeAbstractBufferSupply.AllocatedBuffer(page.getBuffer(), fragment.getPayloadOffset(), (int)fragment.getObjectLength(), page.getPageNum(), page);
        buffer.m_cachedState = objectsBuffer.getCachedState();
        return buffer;
    }

    @Override
    void doneUpdateBuffer(BTreeAbstractBufferSupply.AllocatedBuffer allocatedBuffer, long transaction) throws IOException {
        this.m_pageManager.getForWrite(allocatedBuffer.m_dbk);
        ObjectsBuffer objectsBuffer = (ObjectsBuffer)allocatedBuffer.m_page.getContentBuffer();
        objectsBuffer.setCachedState(allocatedBuffer.m_cachedState);
        this.m_pageManager.doneUpdate(allocatedBuffer.m_page, (byte)3, transaction);
    }

    @Override
    void releaseBuffer(BTreeAbstractBufferSupply.AllocatedBuffer allocatedBuffer, long transaction) throws IOException {
        ObjectsBuffer objectsBuffer = (ObjectsBuffer)allocatedBuffer.m_page.getContentBuffer();
        objectsBuffer.delete((byte)0);
        this.doneUpdateBuffer(allocatedBuffer, transaction);
    }

    @Override
    void setCachedState(BTreeAbstractBufferSupply.AllocatedBuffer allocatedBuffer) {
        ObjectsBuffer objectsBuffer = (ObjectsBuffer)allocatedBuffer.m_page.getContentBuffer();
        objectsBuffer.setCachedState(allocatedBuffer.m_cachedState);
    }
}

