/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IPageNote;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class PageChainPrevNote
extends AbstractNote
implements IPageNote,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 6;
    byte[] m_scratchBuffer = new byte[8];
    long m_pageNumber;
    long m_oldPrevPage;
    long m_newPrevPage;
    byte m_oldChainNumber;
    byte m_newChainNumber;

    PageChainPrevNote() {
    }

    public String toString() {
        return this.getClass().getName() + " page " + this.m_pageNumber + " oldPrevPage " + this.m_oldPrevPage + " newPrevPage " + this.m_newPrevPage + " oldChainNumber " + this.m_oldChainNumber + " newChainNumber " + this.m_newChainNumber;
    }

    @Override
    public long getPageNum() {
        return this.m_pageNumber;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)6);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_pageNumber);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_oldPrevPage);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_newPrevPage);
        writer.write(this.m_scratchBuffer, 0, 8);
        writer.write(this.m_oldChainNumber);
        writer.write(this.m_newChainNumber);
        return 27;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_pageNumber = BitUtil.getLong(buffer, currentOffset);
        this.m_oldPrevPage = BitUtil.getLong(buffer, currentOffset += 8);
        this.m_newPrevPage = BitUtil.getLong(buffer, currentOffset += 8);
        currentOffset += 8;
        this.m_oldChainNumber = buffer[currentOffset++];
        this.m_newChainNumber = buffer[currentOffset];
    }

    void initNote(long pageNumber, long oldPrevPage, long newPrevPage, byte oldChainNumber, byte newChainNumber) {
        this.m_pageNumber = pageNumber;
        this.m_oldPrevPage = oldPrevPage;
        this.m_newPrevPage = newPrevPage;
        this.m_oldChainNumber = oldChainNumber;
        this.m_newChainNumber = newChainNumber;
    }
}

