/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.Cache;
import com.sonicsw.mtstorage.impl.Constants;
import com.sonicsw.mtstorage.impl.LogEndIndicator;
import com.sonicsw.mtstorage.impl.LogFile;
import com.sonicsw.mtstorage.impl.LogPage;
import com.sonicsw.mtstorage.impl.LogPageHeader;
import com.sonicsw.mtstorage.replication.ReplicationManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

final class VirtualLogFile {
    static final String NO_LOGGING_PARAMETER = "NO_LOGGING";
    static final String LOG_NAME_PREFIX = "LOG";
    static final int MAX_CACHED_OPEN_LOG_FILES_DEFAULT = 200;
    static final String MAX_CACHED_OPEN_LOG_FILES_PARAMETER = "MAX_CACHED_OPEN_LOG_FILES";
    static final String LOG_PREALLOCATION_SIZE_PARAMETER = "LOG_PREALLOCATION_SIZE";
    static final String READ_ONLY = "r";
    static final String READ_WRITE_RW = "rw";
    static final String READ_WRITE_RWD = "rwd";
    static final boolean OPSYS_RW_MODE = System.getProperty("os.name").equalsIgnoreCase("SunOS");
    static final String READ_WRITE_OPEN_MODE = System.getProperty("_PSELogRWMode", OPSYS_RW_MODE ? "rw" : "rwd");
    static final int MAX_FULL_REPLICATION_PAGES_TO_SEND = 20;
    static final int MAX_FULL_REPLICATION_BYTES_TO_SEND = 20 * LogPage.PAGE_LENGTH;
    private static final int LOG_NAME_PREFIX_LENGTH = "LOG".length();
    private static final int FILES_TO_KEEP_FOR_DIAGNOSTICS = 5;
    private static final int LOG_FILE_MAX_PAGES = 500;
    private static final int LOG_FILE_SIZE = 500 * LogPage.PAGE_LENGTH;
    private static final long LOG_PREALLOCATION_SIZE_DEFAULT = 2 * LOG_FILE_SIZE;
    private LogFile m_currentLogFile;
    private LogEndIndicator m_logEndInidicator;
    private LogTail m_tail;
    private long m_nextLogToAllocate;
    private long m_highest;
    private long m_lowest;
    private File m_dbDir;
    private LogFilesCache m_logFilesCache;
    private Cache m_cache;
    private boolean m_newLog;
    private boolean m_noLogging = false;
    private boolean m_replicationActive = false;
    private LogPage m_currentLogPage;
    private long m_logPagesWrite_statistics;
    private long m_logPagesRead_statistics;
    private long m_logFileSync_statistics;

    VirtualLogFile(File dbDir) throws IOException {
        this.m_dbDir = dbDir;
        this.m_currentLogFile = null;
        this.m_currentLogPage = null;
    }

    VirtualLogFile(File dbDir, HashMap parameters) throws IOException {
        this.m_cache = null;
        this.m_dbDir = dbDir;
        this.m_nextLogToAllocate = 0L;
        Boolean noLogging = (Boolean)parameters.get(NO_LOGGING_PARAMETER);
        boolean bl = this.m_noLogging = noLogging != null ? noLogging : false;
        if (this.m_noLogging) {
            return;
        }
        long[] firstLastLog = new long[2];
        long[] lastAndNextNoteIDs = this.recoverNextNoteID(firstLastLog);
        this.m_logEndInidicator = new LogEndIndicator(lastAndNextNoteIDs[0], lastAndNextNoteIDs[1]);
        this.m_logEndInidicator.calcLogCommittedLength();
        this.m_currentLogFile = new LogFile(dbDir);
        int maxCachedOpenLogFiles = 200;
        Integer maxCachedOpenLogFilesParam = (Integer)parameters.get(MAX_CACHED_OPEN_LOG_FILES_PARAMETER);
        if (maxCachedOpenLogFilesParam != null) {
            maxCachedOpenLogFiles = maxCachedOpenLogFilesParam;
        }
        if (maxCachedOpenLogFiles < 1) {
            throw new IOException("MAX_CACHED_OPEN_LOG_FILES must be > 0, was set to " + maxCachedOpenLogFiles);
        }
        this.m_logFilesCache = new LogFilesCache(maxCachedOpenLogFiles);
        long logPreallocationSize = LOG_PREALLOCATION_SIZE_DEFAULT;
        Long logPreallocationSizeParam = (Long)parameters.get(LOG_PREALLOCATION_SIZE_PARAMETER);
        if (logPreallocationSizeParam != null) {
            logPreallocationSize = logPreallocationSizeParam;
        }
        if (firstLastLog[0] == Long.MAX_VALUE) {
            this.preAllocateFiles(logPreallocationSize / (long)LOG_FILE_SIZE);
        }
        this.openCurrentLogFile(firstLastLog);
        this.setInitialPosition(this.m_logEndInidicator.getNextNoteID());
        this.m_logPagesRead_statistics = 0L;
        this.m_logPagesWrite_statistics = 0L;
        this.m_logFileSync_statistics = 0L;
    }

    void replicateLog(long startID, byte[] srcBuffer, int offset, int length, int firstPageEndPointer) throws IOException {
        boolean firstCall = true;
        while (length > 0) {
            int replicatedCount = this.replicateLogPage(firstCall, startID, srcBuffer, offset, length, firstPageEndPointer);
            firstCall = false;
            length -= replicatedCount;
            startID += (long)replicatedCount;
            offset += replicatedCount;
        }
    }

    private int replicateLogPage(boolean firstCall, long startID, byte[] srcBuffer, int offset, int length, int firstPageEndPointer) throws IOException {
        boolean thisPageWillFillUp;
        long pageNum = VirtualLogFile.noteIDPageNum(startID);
        long localPageNum = VirtualLogFile.pageNumToLocalPageNum(pageNum);
        long logNum = VirtualLogFile.pageNumToLogNum(pageNum);
        int offsetInPage = VirtualLogFile.noteIDOffestInPage(startID);
        boolean bl = thisPageWillFillUp = offsetInPage + length >= LogPage.PAGE_LENGTH;
        if (this.m_currentLogPage == null) {
            this.m_currentLogPage = new LogPage();
        }
        this.m_currentLogPage.setPageNum(pageNum);
        if (firstCall) {
            this.m_currentLogPage.storeNoteEndPointer(firstPageEndPointer);
        }
        byte[] buffer = this.m_currentLogPage.getBuffer();
        int copyCount = Constants.MIN(LogPage.PAGE_LENGTH - offsetInPage, length);
        System.arraycopy(srcBuffer, offset, buffer, offsetInPage, copyCount);
        if (this.m_currentLogFile == null || this.m_currentLogFile.getLogNum() != logNum) {
            if (this.m_currentLogFile != null) {
                this.m_currentLogFile.close();
                this.m_currentLogFile = null;
            }
            this.m_currentLogFile = new LogFile(this.m_dbDir);
            this.m_currentLogFile.create(logNum, LOG_FILE_SIZE, this.m_currentLogPage.pageIsRed());
            if (firstCall && localPageNum != 0L) {
                this.m_currentLogFile.setInitialPosition(0L);
                this.m_currentLogFile.writeNext(this.m_currentLogPage, true, false);
            }
            this.m_currentLogFile.setInitialPosition(localPageNum);
        }
        this.m_currentLogFile.writeNext(this.m_currentLogPage, thisPageWillFillUp, false);
        if (thisPageWillFillUp) {
            this.m_currentLogPage = null;
        }
        return copyCount;
    }

    void endLogReplication() throws IOException {
        if (this.m_currentLogFile != null) {
            this.m_currentLogFile.close();
            this.m_currentLogFile = null;
        }
    }

    void getMetrics(Properties props, String dbName) {
        if (this.m_noLogging) {
            return;
        }
        props.setProperty(dbName + ".logPagesWrite_statistics", new Long(this.m_logPagesWrite_statistics).toString());
        props.setProperty(dbName + ".logPagesRead_statistics", new Long(this.m_logPagesRead_statistics).toString());
        props.setProperty(dbName + ".logFileSync_statistics", new Long(this.m_logFileSync_statistics).toString());
    }

    void activateCache(int maxSize) {
        if (this.m_noLogging) {
            return;
        }
        this.m_cache = new Cache(maxSize);
    }

    private long[] recoverNextNoteID(long[] firstLastLogFiles) throws IOException {
        long[] lastNextIDs = new long[]{-1L, 8L};
        if (this.m_noLogging) {
            return lastNextIDs;
        }
        this.getFirstLastLogFiles(this.m_dbDir, firstLastLogFiles);
        if (firstLastLogFiles[0] == Long.MAX_VALUE) {
            return lastNextIDs;
        }
        LogFile currentFile = new LogFile(this.m_dbDir);
        LogPage currentPage = new LogPage();
        for (long crntLogNum = firstLastLogFiles[1]; crntLogNum >= firstLastLogFiles[0]; --crntLogNum) {
            currentFile.open(crntLogNum, READ_ONLY, LOG_FILE_SIZE);
            long lastFilePage = currentFile.getCurrentPageNum() - 1L;
            currentFile.read(currentPage, 0L);
            if (lastFilePage == -1L || currentPage.fileIsEmpty()) {
                currentFile.close();
                continue;
            }
            boolean redFirstPage = currentPage.pageIsRed();
            for (long relativePageNum = lastFilePage; relativePageNum >= 0L; --relativePageNum) {
                int endOfNoteInPage;
                currentFile.read(currentPage, relativePageNum);
                if (redFirstPage != currentPage.pageIsRed() || (endOfNoteInPage = currentPage.getNoteEndPointer()) == 0) continue;
                currentFile.close();
                long absolutePageNum = VirtualLogFile.calcAbsolutePageNum(crntLogNum, relativePageNum);
                currentPage.setPageNum(absolutePageNum);
                int noteLen = this.lastWrittenNoteLen(currentPage, endOfNoteInPage);
                lastNextIDs[1] = VirtualLogFile.pageNumAndOffsetToNextNoteID(absolutePageNum, endOfNoteInPage);
                lastNextIDs[0] = VirtualLogFile.calcNoteIDOffsetBackwards(lastNextIDs[1], noteLen);
                this.recycleIncompleteLogFiles(lastNextIDs[1], firstLastLogFiles);
                return lastNextIDs;
            }
            currentFile.close();
        }
        this.recycleIncompleteLogFiles(lastNextIDs[1], firstLastLogFiles);
        return lastNextIDs;
    }

    private int lastWrittenNoteLen(LogPage currentPage, int endOfNoteInPage) throws IOException {
        byte[] noteLenBuf = new byte[4];
        byte[] pageBuffer = currentPage.getBuffer();
        int bufCount = 3;
        for (int i = endOfNoteInPage; i >= 8 && bufCount >= 0; --i) {
            noteLenBuf[bufCount--] = pageBuffer[i];
        }
        if (bufCount >= 0) {
            long prevPage = currentPage.getPageNum() - 1L;
            long logNum = VirtualLogFile.pageNumToLogNum(prevPage);
            long relativePageNum = VirtualLogFile.pageNumToLocalPageNum(prevPage);
            LogFile currentFile = new LogFile(this.m_dbDir);
            currentFile.open(logNum, READ_ONLY, LOG_FILE_SIZE);
            currentFile.read(currentPage, relativePageNum);
            pageBuffer = currentPage.getBuffer();
            int i = LogPage.PAGE_LENGTH - 1;
            while (bufCount >= 0) {
                noteLenBuf[bufCount--] = pageBuffer[i];
                --i;
            }
            currentFile.close();
        }
        return BitUtil.getInt(noteLenBuf, 0);
    }

    void replicateLog(File replicatedDBDir, long firstNoteID, long lastNoteID) throws IOException {
        long firstPageNum = VirtualLogFile.noteIDPageNum(firstNoteID);
        long lastPageNum = VirtualLogFile.noteIDPageNum(lastNoteID);
        long[] firstLastBackupLogs = new long[2];
        this.getFirstLastLogFiles(replicatedDBDir, firstLastBackupLogs);
        LogFile currentFile = new LogFile(replicatedDBDir);
        LogPage pageCopy = new LogPage();
        for (long pNum = firstPageNum; pNum <= lastPageNum; ++pNum) {
            LogPage srcPage = this.getPageContent(pNum);
            srcPage.copyTo(pageCopy);
            long localPageNum = VirtualLogFile.pageNumToLocalPageNum(pNum);
            long logNum = VirtualLogFile.pageNumToLogNum(pNum);
            if (currentFile.getLogNum() != logNum) {
                boolean logExists;
                currentFile.close();
                boolean bl = logExists = firstLastBackupLogs[0] != Long.MAX_VALUE && logNum >= firstLastBackupLogs[0] && logNum <= firstLastBackupLogs[1];
                if (logExists) {
                    currentFile.open(logNum, READ_WRITE_OPEN_MODE, LOG_FILE_SIZE);
                } else {
                    currentFile.create(logNum, LOG_FILE_SIZE, srcPage.pageIsRed());
                    if (localPageNum != 0L) {
                        currentFile.setInitialPosition(0L);
                        currentFile.writeNext(pageCopy, true, false);
                    }
                }
                currentFile.setInitialPosition(localPageNum);
            }
            currentFile.writeNext(pageCopy, true, false);
        }
        currentFile.close();
    }

    private void preAllocateLogFile(long logNum) throws IOException {
        LogFile logFile = new LogFile(this.m_dbDir);
        logFile.create(logNum, LOG_FILE_SIZE, false);
        logFile.reallocateAll(500, false);
        logFile.close();
    }

    private void preAllocateFiles(long numFiles) throws IOException {
        for (long i = 0L; i < numFiles; ++i) {
            this.preAllocateLogFile(i);
        }
        this.m_nextLogToAllocate = numFiles;
    }

    private void openCurrentLogFile(long[] logList) throws IOException {
        if (logList[0] == Long.MAX_VALUE) {
            this.m_newLog = true;
            this.m_currentLogFile.create(0L, LOG_FILE_SIZE, false);
            this.m_highest = 0L;
            this.m_lowest = 0L;
        } else {
            this.m_newLog = false;
            this.m_lowest = logList[0];
            this.m_highest = logList[1];
            this.m_currentLogFile.open(this.m_highest, READ_WRITE_OPEN_MODE, LOG_FILE_SIZE);
        }
    }

    boolean newLogFile() {
        if (this.m_noLogging) {
            return true;
        }
        return this.m_newLog;
    }

    private void recycleIncompleteLogFiles(long nextNoteID, long[] firstLast) throws IOException {
        long highestLog = firstLast[1];
        long pageNum = VirtualLogFile.noteIDPageNum(nextNoteID);
        long logNum = VirtualLogFile.pageNumToLogNum(pageNum);
        for (long i = logNum + 1L; i <= highestLog; ++i) {
            LogFile logFile = new LogFile(this.m_dbDir);
            logFile.open(i, READ_WRITE_RW, LOG_FILE_SIZE);
            logFile.recycle(i, 500);
        }
        this.m_nextLogToAllocate = highestLog + 1L;
        firstLast[1] = logNum;
    }

    private void setInitialPosition(long noteID) throws IOException {
        if (this.m_noLogging) {
            return;
        }
        long pageNum = VirtualLogFile.noteIDPageNum(noteID);
        long logNum = VirtualLogFile.pageNumToLogNum(pageNum);
        if (logNum > this.m_currentLogFile.getLogNum()) {
            this.createLogFile();
        }
        this.m_currentLogFile.setInitialPosition(VirtualLogFile.pageNumToLocalPageNum(pageNum));
        this.m_tail = new LogTail(VirtualLogFile.calcAbsolutePageNum(this.m_highest, this.m_currentLogFile.getCurrentPageNum()));
    }

    synchronized LogPage getNextPageForWrite(boolean getData) throws IOException {
        if (this.m_noLogging) {
            return new LogPage();
        }
        LogPage page = this.m_tail.getNextPage(getData);
        if (this.m_cache != null) {
            this.m_cache.remove(new Long(page.getPageNum()));
        }
        return page;
    }

    synchronized void writeTail(long lastToRemove) throws IOException {
        if (this.m_noLogging) {
            return;
        }
        LogPage[] tail = this.m_tail.removeTail(lastToRemove);
        for (int i = 0; i < tail.length; ++i) {
            this.createLogFileIfNeeded();
            LogPage page = tail[i];
            this.m_currentLogFile.writeNext(page, true, false);
            ++this.m_logPagesWrite_statistics;
        }
    }

    synchronized void forceToDisk(LogPage lastTailPage) throws IOException {
        if (this.m_noLogging) {
            return;
        }
        this.m_logEndInidicator.calcLogCommittedLength();
        if (lastTailPage != null) {
            if (this.m_tail.tailSize() != 1 || this.m_tail.lastServed() != lastTailPage.getPageNum()) {
                throw new Error("forceToDisk sequence error.");
            }
            this.createLogFileIfNeeded();
            this.m_currentLogFile.writeNext(lastTailPage, false, false);
            ++this.m_logPagesWrite_statistics;
        }
        if (this.m_currentLogFile.sync()) {
            // empty if block
        }
        ++this.m_logFileSync_statistics;
    }

    synchronized long getLogPhysicalLengthEstimate() {
        if (this.m_noLogging) {
            return 0L;
        }
        long logicalEstimate = (this.m_tail.lastServed() + 1L) * (long)LogPage.PAGE_LENGTH;
        return logicalEstimate - this.m_lowest * (long)LOG_FILE_SIZE;
    }

    private void createLogFileIfNeeded() throws IOException {
        if (this.m_currentLogFile.getCurrentPageNum() >= 500L) {
            this.createLogFile();
        }
    }

    private void createLogFile() throws IOException {
        this.m_currentLogFile.close();
        this.m_currentLogFile = new LogFile(this.m_dbDir);
        this.m_currentLogFile.create(++this.m_highest, LOG_FILE_SIZE, false);
        if (this.m_highest >= this.m_nextLogToAllocate) {
            this.m_nextLogToAllocate = this.m_highest + 1L;
        }
    }

    boolean muchLogToReplicate() {
        return this.m_replicationActive && this.m_logEndInidicator.getNextNoteID() - this.m_logEndInidicator.getCommittedLength() > (long)MAX_FULL_REPLICATION_BYTES_TO_SEND;
    }

    synchronized ReplicationManager.ReplicationDataIndicator getReplicationData(long startingID0, boolean firstLogRequest) throws IOException, InterruptedException {
        long startingID = firstLogRequest ? VirtualLogFile.noteIDPageNum(startingID0) * (long)LogPage.PAGE_LENGTH : startingID0;
        this.m_replicationActive = true;
        long logCommittedLength = this.m_logEndInidicator.getCommittedLength();
        if (logCommittedLength < startingID) {
            throw new IOException("Standby tries to skip log data");
        }
        if (logCommittedLength == startingID) {
            return null;
        }
        ReplicationManager.ReplicationDataIndicator dataIndicator = new ReplicationManager.ReplicationDataIndicator();
        try {
            AccumDescriptor descriptor = new AccumDescriptor();
            this.accumulateReplicationData(startingID, logCommittedLength, dataIndicator, 20, descriptor);
            if (descriptor.m_maxPageHit && descriptor.m_largestPageWithNoteEnd == -1L) {
                long pageNum = this.findPageWithNoteEnd(descriptor.m_lastPageVisited + 1L);
                int maxPagesToSend = (int)(pageNum - descriptor.m_firstPage + 1L);
                this.accumulateReplicationData(startingID, logCommittedLength, dataIndicator, maxPagesToSend, descriptor);
            }
            if (descriptor.m_maxPageHit) {
                dataIndicator.m_dataLength = descriptor.m_lengthOfFullNotes;
            }
        }
        catch (FileNotFoundException e) {
            dataIndicator.m_okStatus = false;
            return dataIndicator;
        }
        dataIndicator.m_okStatus = true;
        dataIndicator.m_dataID = startingID;
        dataIndicator.m_logData = true;
        return dataIndicator;
    }

    private long findPageWithNoteEnd(long startingPage) throws IOException {
        LogPage page;
        int endOfNoteInPage;
        long pNum = startingPage;
        do {
            if ((page = this.getPageContent(pNum++)) != null) continue;
            throw new IOException("VirtualLogFile.findPageWithNoteEnd: Could not locate an end note. Note end at page " + (pNum - 1L));
        } while ((endOfNoteInPage = page.getNoteEndPointer()) == 0);
        return pNum - 1L;
    }

    private void accumulateReplicationData(long startingID, long logCommittedLength, ReplicationManager.ReplicationDataIndicator indicator, int maxPagesToSend, AccumDescriptor descriptor) throws IOException {
        int amountToCopy;
        descriptor.m_largestPageWithNoteEnd = -1L;
        long firstPage = VirtualLogFile.noteIDPageNum(startingID);
        long lastPage = VirtualLogFile.noteIDPageNum(logCommittedLength - 1L);
        int offsetInFirstPage = VirtualLogFile.noteIDOffestInPage(startingID);
        int dataInLastPage = 0;
        int numOfPagesBetween = 0;
        int dataInFirstPage = 0;
        if (lastPage > firstPage) {
            dataInLastPage = VirtualLogFile.noteIDOffestInPage(logCommittedLength - 1L) + 1;
            numOfPagesBetween = (int)(lastPage - firstPage - 1L);
            dataInFirstPage = LogPage.PAGE_LENGTH - offsetInFirstPage;
        } else {
            dataInFirstPage = VirtualLogFile.noteIDOffestInPage(logCommittedLength - 1L) + 1 - offsetInFirstPage;
        }
        int numBetweenPagesToSend = Constants.MIN(maxPagesToSend, numOfPagesBetween);
        descriptor.m_maxPageHit = numBetweenPagesToSend < numOfPagesBetween;
        int totalData = dataInFirstPage + dataInLastPage + numBetweenPagesToSend * LogPage.PAGE_LENGTH;
        byte[] data = new byte[totalData];
        int currentPointer = 0;
        descriptor.m_firstPage = firstPage;
        for (long pNum = firstPage; pNum <= lastPage && currentPointer != totalData; currentPointer += amountToCopy, ++pNum) {
            int srcLength;
            int srcOffset;
            LogPage page = this.getPageContent(pNum);
            descriptor.m_lastPageVisited = pNum;
            if (pNum == firstPage) {
                srcOffset = offsetInFirstPage;
                srcLength = dataInFirstPage;
                indicator.m_firstPageEndNotePointer = new Integer(page.getNoteEndPointer());
            } else if (pNum == lastPage) {
                srcOffset = 0;
                srcLength = dataInLastPage;
            } else {
                srcOffset = 0;
                srcLength = LogPage.PAGE_LENGTH;
            }
            byte[] pageBuffer = page.getBuffer();
            amountToCopy = VirtualLogFile.MIN(srcLength, totalData - currentPointer);
            System.arraycopy(pageBuffer, srcOffset, data, currentPointer, amountToCopy);
            int endOfNoteInPage = page.getNoteEndPointer();
            if (endOfNoteInPage == 0 || pNum == firstPage || pNum == lastPage || amountToCopy < endOfNoteInPage + 1) continue;
            descriptor.m_largestPageWithNoteEnd = pNum;
            descriptor.m_lengthOfFullNotes = currentPointer + endOfNoteInPage + 1;
        }
        indicator.m_buffer = data;
        indicator.m_dataOffset = 0;
        indicator.m_dataLength = currentPointer;
    }

    synchronized LogPage getPageContent(long pageNum) throws IOException {
        if (this.m_noLogging) {
            throw new Error("m_noLogging is on");
        }
        Long pageNumObject = new Long(pageNum);
        LogPage page = this.m_tail.getPage(pageNum);
        if (page != null) {
            return page;
        }
        if (this.m_cache != null) {
            page = (LogPage)this.m_cache.get(pageNumObject);
        }
        if (page != null) {
            return page;
        }
        page = new LogPage();
        this.getPageContentFromLogFile(page, pageNum);
        if (this.m_cache != null) {
            this.m_cache.put(pageNumObject, page);
        }
        return page;
    }

    private void getPageContentFromLogFile(LogPage targetPage, long pageNum) throws IOException {
        targetPage.setPageNum(pageNum);
        long logNum = VirtualLogFile.pageNumToLogNum(pageNum);
        long localPageNum = VirtualLogFile.pageNumToLocalPageNum(pageNum);
        if (logNum == this.m_currentLogFile.getLogNum()) {
            this.m_currentLogFile.read(targetPage, localPageNum);
        } else {
            this.m_logFilesCache.get(logNum).read(targetPage, localPageNum);
        }
        ++this.m_logPagesRead_statistics;
    }

    LogEndIndicator getIndicator() {
        if (this.m_noLogging) {
            LogEndIndicator indicator = new LogEndIndicator(-1L, 8L);
            indicator.calcLogCommittedLength();
            return indicator;
        }
        return this.m_logEndInidicator;
    }

    synchronized void releasePages() throws IOException {
        if (this.m_noLogging) {
            return;
        }
        this.recycleLogs(this.m_currentLogFile.getLogNum() - 1L);
    }

    synchronized void releasePages(long pageNum) throws IOException {
        if (this.m_noLogging || this.m_currentLogFile == null) {
            return;
        }
        long logToRelase = VirtualLogFile.pageNumToLogNum(pageNum) - 1L;
        long currentLog = this.m_currentLogFile.getLogNum();
        if (currentLog - logToRelase < 5L && (logToRelase = currentLog - 5L) < 0L) {
            return;
        }
        this.recycleLogs(logToRelase);
    }

    private void recycleLogs(long highestToRecycle) throws IOException {
        if (highestToRecycle < 0L) {
            return;
        }
        this.m_logFilesCache.removeFiles(highestToRecycle);
        for (long i = this.m_lowest; i <= highestToRecycle; ++i) {
            LogFile logFile = new LogFile(this.m_dbDir);
            logFile.open(i, READ_WRITE_RW, LOG_FILE_SIZE);
            logFile.recycle(this.m_nextLogToAllocate++, 500);
        }
        this.m_lowest = highestToRecycle + 1L;
    }

    void close() throws IOException {
        if (this.m_noLogging) {
            return;
        }
        this.m_logFilesCache.close();
        this.m_currentLogFile.close();
    }

    private static long calcAbsolutePageNum(long logNum, long relativePageNum) {
        return 500L * logNum + relativePageNum;
    }

    private static long pageNumToLogNum(long pageNum) {
        return pageNum / 500L;
    }

    private static long pageNumToLocalPageNum(long pageNum) {
        return pageNum % 500L;
    }

    static long noteIDPageNum(long noteID) {
        return noteID / (long)LogPage.PAGE_LENGTH;
    }

    static long pageNumAndOffsetToNoteID(long pageNum, int offsetInPage) {
        return pageNum * (long)LogPage.PAGE_LENGTH + (long)offsetInPage;
    }

    static long pageNumAndOffsetToNextNoteID(long pageNum, int offsetInPage) {
        long nextID = pageNum * (long)LogPage.PAGE_LENGTH + (long)offsetInPage + 1L;
        if (offsetInPage + 1 == LogPage.PAGE_LENGTH) {
            nextID += 8L;
        }
        return nextID;
    }

    static int noteIDOffestInPage(long noteID) {
        return (int)(noteID % (long)LogPage.PAGE_LENGTH);
    }

    static long prevNoteID(long noteID) {
        long prevID = noteID - 1L;
        if (VirtualLogFile.noteIDOffestInPage(noteID) == 8) {
            prevID -= 8L;
        }
        return prevID;
    }

    static long calcNoteIDOffset(long noteID, long offset) {
        if (offset < 0L) {
            return VirtualLogFile.calcNoteIDOffsetBackwards(noteID, offset * -1L);
        }
        long bytesToEnd = (long)LogPage.PAGE_LENGTH - noteID % (long)LogPage.PAGE_LENGTH;
        if (bytesToEnd > offset) {
            return noteID + offset;
        }
        long needed = offset - bytesToEnd;
        long numPagesNeeded = needed / (long)LogPageHeader.PAYLOAD_BYTES_IN_PAGE + 1L;
        return noteID + offset + numPagesNeeded * 8L;
    }

    private static long calcNoteIDOffsetBackwards(long noteID, long offset) {
        long offsetInPage = noteID % (long)LogPage.PAGE_LENGTH;
        long availableInPage = offsetInPage - 8L;
        long needed = offset;
        if (availableInPage >= needed) {
            return noteID - offset;
        }
        long numPagesNeeded = ((needed -= availableInPage) - 1L) / (long)LogPageHeader.PAYLOAD_BYTES_IN_PAGE + 1L;
        return noteID - offset - numPagesNeeded * 8L;
    }

    private static int MIN(int a, int b) {
        return a < b ? a : b;
    }

    private long[] getFirstLastLogFiles(File dbDir, long[] result) throws IOException {
        long logFilesCount;
        String[] nameList = dbDir.list();
        long lowest = Long.MAX_VALUE;
        long highest = -1L;
        long logFilesFound = 0L;
        for (int i = 0; i < nameList.length; ++i) {
            Integer logNum = null;
            if (!nameList[i].startsWith(LOG_NAME_PREFIX)) continue;
            logNum = new Integer(nameList[i].substring(LOG_NAME_PREFIX_LENGTH));
            ++logFilesFound;
            if (logNum.longValue() < lowest) {
                lowest = logNum.longValue();
            }
            if (logNum.longValue() <= highest) continue;
            highest = logNum.longValue();
        }
        result[0] = lowest;
        result[1] = highest;
        if (lowest != Long.MAX_VALUE && (logFilesCount = highest - lowest + 1L) != logFilesFound) {
            throw new IOException("Only " + logFilesFound + " log files were found. " + logFilesCount + " are expected.");
        }
        return result;
    }

    private final class AccumDescriptor {
        boolean m_maxPageHit;
        int m_lengthOfFullNotes;
        long m_largestPageWithNoteEnd;
        long m_lastPageVisited;
        long m_firstPage;

        private AccumDescriptor() {
        }
    }

    private final class LRULogFileCache
    extends HashMap {
        private Item m_leastUsed = null;
        private Item m_mostUsed = null;
        private int m_maxSize;
        private int m_usedSize;

        LRULogFileCache(int maxSize) {
            this.m_maxSize = maxSize;
            this.m_usedSize = 0;
        }

        @Override
        public void clear() {
            super.clear();
            this.m_leastUsed = null;
            this.m_mostUsed = null;
            this.m_usedSize = 0;
        }

        @Override
        LogFile put(Long key, LogFile logFile) {
            LogFile objectRemovedFromCache = null;
            if (this.containsKey(key)) {
                throw new Error(logFile.getClass().getName() + " " + key + " already in cache");
            }
            if (this.m_maxSize == this.m_usedSize) {
                objectRemovedFromCache = this.remove(this.m_leastUsed.key);
            }
            Item newItem = new Item(key, logFile);
            super.put(key, newItem);
            ++this.m_usedSize;
            this.putAtEnd(newItem);
            return objectRemovedFromCache;
        }

        LogFile get(Long key) {
            Item item = (Item)super.get(key);
            if (item == null) {
                return null;
            }
            if (item != this.m_mostUsed) {
                this.removeFromChain(item);
                this.putAtEnd(item);
            }
            return item.logFile;
        }

        LogFile remove(Long key) {
            Item item = (Item)super.remove(key);
            if (item == null) {
                return null;
            }
            this.removeFromChain(item);
            --this.m_usedSize;
            return item.logFile;
        }

        private void removeFromChain(Item item) {
            Item prev = item.prevItem;
            Item next = item.nextItem;
            if (prev != null) {
                prev.nextItem = next;
            }
            if (next != null) {
                next.prevItem = prev;
            }
            if (this.m_leastUsed == item) {
                this.m_leastUsed = next;
            }
            if (this.m_mostUsed == item) {
                this.m_mostUsed = prev;
            }
            item.prevItem = null;
            item.nextItem = null;
        }

        void adjustSize(int newSize) {
            this.m_maxSize = newSize < this.m_usedSize ? this.m_usedSize : newSize;
        }

        private void putAtEnd(Item item) {
            if (this.m_leastUsed == null) {
                this.m_leastUsed = this.m_mostUsed = item;
                return;
            }
            this.m_mostUsed.nextItem = item;
            item.prevItem = this.m_mostUsed;
            this.m_mostUsed = item;
        }

        private class Item {
            private Long key;
            private LogFile logFile;
            private Item nextItem;
            private Item prevItem;

            Item(Long key, LogFile logFile) {
                this.key = key;
                this.logFile = logFile;
                this.prevItem = null;
                this.nextItem = null;
            }
        }
    }

    private final class LogTail {
        long m_nextPageNum;
        long m_firstPageNum;
        HashMap m_pages;
        HashSet m_pageSet;

        LogTail(long nextPageNum) {
            this.m_firstPageNum = this.m_nextPageNum = nextPageNum;
            this.m_pages = new HashMap();
            this.m_pageSet = new HashSet();
        }

        boolean pageInTail(LogPage page) {
            return this.m_pageSet.contains(page);
        }

        LogPage getNextPage(boolean getData) throws IOException {
            LogPage page = new LogPage(this.m_nextPageNum);
            if (getData) {
                VirtualLogFile.this.getPageContentFromLogFile(page, this.m_nextPageNum);
            }
            this.m_pages.put(new Long(this.m_nextPageNum++), page);
            this.m_pageSet.add(page);
            return page;
        }

        LogPage getPage(long pageNum) {
            return (LogPage)this.m_pages.get(new Long(pageNum));
        }

        int tailSize() {
            return this.m_pages.size();
        }

        long lastServed() {
            return this.m_nextPageNum - 1L;
        }

        LogPage[] removeTail(long lastToRemove) {
            if (lastToRemove >= this.m_nextPageNum) {
                throw new Error("Page " + lastToRemove + " was not created yet.");
            }
            LogPage[] result = new LogPage[(int)(lastToRemove - this.m_firstPageNum + 1L)];
            int j = 0;
            long i = this.m_firstPageNum;
            while (i <= lastToRemove) {
                result[j] = (LogPage)this.m_pages.remove(new Long(i));
                this.m_pageSet.remove(result[j]);
                ++i;
                ++j;
            }
            this.m_firstPageNum = lastToRemove + 1L;
            return result;
        }
    }

    private final class LogFilesCache {
        LRULogFileCache m_table;
        long m_lowestInCache = Long.MAX_VALUE;

        LogFilesCache(int maxCachedOpenLogFiles) {
            this.m_table = new LRULogFileCache(maxCachedOpenLogFiles);
        }

        LogFile get(long logNum) throws IOException {
            if (logNum < VirtualLogFile.this.m_lowest) {
                throw new FileNotFoundException("Log file " + logNum + " does not exist.");
            }
            LogFile logFile = this.m_table.get(new Long(logNum));
            if (logFile == null) {
                LogFile removedLog;
                logFile = new LogFile(VirtualLogFile.this.m_dbDir);
                logFile.open(logNum, VirtualLogFile.READ_ONLY, LOG_FILE_SIZE);
                if (logNum < this.m_lowestInCache) {
                    this.m_lowestInCache = logNum;
                }
                if ((removedLog = this.m_table.put(new Long(logNum), logFile)) != null) {
                    removedLog.close();
                }
            }
            return logFile;
        }

        void removeFiles(long logNum) throws IOException {
            if (logNum < this.m_lowestInCache) {
                return;
            }
            long m_lowestInCache = Long.MAX_VALUE;
            Iterator iterator = this.m_table.keySet().iterator();
            Long[] logNumArray = new Long[this.m_table.size()];
            int j = 0;
            while (iterator.hasNext()) {
                logNumArray[j++] = (Long)iterator.next();
            }
            for (int i = 0; i < logNumArray.length; ++i) {
                long currentLogNum = logNumArray[i];
                if (currentLogNum <= logNum) {
                    this.m_table.get(logNumArray[i]).close();
                    this.m_table.remove(logNumArray[i]);
                    continue;
                }
                if (currentLogNum >= m_lowestInCache) continue;
                m_lowestInCache = currentLogNum;
            }
        }

        void close() throws IOException {
            this.removeFiles(Long.MAX_VALUE);
            this.m_table = null;
        }
    }
}

