/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication.ftchannel.socket;

import com.sonicsw.mtstorage.replication.ftchannel.ChannelConstants;
import com.sonicsw.mtstorage.replication.ftchannel.IActiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.IChannelListener;
import com.sonicsw.mtstorage.replication.ftchannel.IPassiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.socket.ActiveChannel;
import com.sonicsw.mtstorage.replication.util.Tracer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;

public class PassiveChannel
implements IPassiveChannel,
ChannelConstants {
    private ServerSocket m_serverSocket;
    private boolean m_open = false;
    private boolean m_interruptAccept = false;
    private boolean m_alwaysRetry = false;

    public static void main(String[] args) throws Exception {
        HashMap<String, Integer> config = new HashMap<String, Integer>();
        config.put("PORT", new Integer(args[1]));
        HashMap[] configs = new HashMap[]{config};
        PassiveChannel pch = new PassiveChannel();
        pch.open(configs, null, false, false, true);
        IActiveChannel ach = pch.accept(new TestListener());
        Thread.sleep(1000000000L);
    }

    @Override
    public void doNotReportFailure() {
    }

    @Override
    public synchronized void open(HashMap[] connections, HashMap paramUnused, boolean alwaysRetry, boolean primaryUnused, boolean reportFailureUnused) throws IOException {
        this.m_alwaysRetry = alwaysRetry;
        HashMap connection = connections[0];
        int port = (Integer)connection.get("PORT");
        this.m_serverSocket = new ServerSocket(port);
        this.m_serverSocket.setSoTimeout(1000);
        this.m_open = true;
    }

    @Override
    public void interruptAccept() {
        this.m_interruptAccept = true;
    }

    @Override
    public IActiveChannel accept(IChannelListener listener) throws IOException {
        ActiveChannel channel = new ActiveChannel();
        Socket socket = null;
        while (socket == null && !this.m_interruptAccept) {
            try {
                socket = this.m_serverSocket.accept();
            }
            catch (SocketTimeoutException e) {}
        }
        if (this.m_interruptAccept) {
            if (socket != null) {
                socket.close();
            }
            this.m_interruptAccept = false;
            throw new InterruptedIOException();
        }
        channel.open(socket, null, listener, this.m_alwaysRetry, false);
        return channel;
    }

    @Override
    public void accepted() {
        this.close();
    }

    @Override
    public synchronized void close() {
        if (!this.m_open) {
            return;
        }
        try {
            this.m_serverSocket.close();
        }
        catch (Exception e) {
            Tracer.TRACE(e);
        }
    }

    static class TestListener
    implements IChannelListener {
        TestListener() {
        }

        @Override
        public void connectionDropped(String message) {
            System.out.println("connectionDropped: " + message);
        }

        @Override
        public void reportEvent(String event, boolean warning) {
            System.out.println("reportEvent: " + event);
        }

        @Override
        public void messageReceived(byte[] message) {
            System.out.println("messageReceived: " + message.length + " bytes ");
        }
    }
}

