/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter.classfile;

import com.odi.filter.classfile.AttributeVector;
import com.odi.filter.classfile.ClassField;
import com.odi.filter.classfile.ClassMethod;
import com.odi.filter.classfile.ConstClass;
import com.odi.filter.classfile.ConstantPool;
import com.odi.filter.classfile.FieldArraySorter;
import com.odi.filter.classfile.InterfaceArraySorter;
import com.odi.filter.classfile.MethodArraySorter;
import com.odi.filter.classfile.VMConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;

public final class ClassFile
implements VMConstants,
Serializable {
    public static final int magic = -889275714;
    public static final int jdk11MinorVersion = 3;
    public static final int jdk11MajorVersion = 45;
    public static final int jdk12MinorVersion = 0;
    public static final int jdk12MajorVersion = 46;
    public static final int jdk13MinorVersion = 0;
    public static final int jdk13MajorVersion = 47;
    public static final int jdk14MinorVersion = 0;
    public static final int jdk14MajorVersion = 48;
    private int majorVersion = 45;
    private int minorVersion = 3;
    private ConstantPool constantPool = new ConstantPool();
    private int accessFlags = 0;
    private ConstClass thisClassName;
    private ConstClass superClassName;
    private Vector classInterfaces = new Vector();
    private Vector classFields = new Vector();
    private Vector classMethods = new Vector();
    private AttributeVector classAttributes = new AttributeVector();

    public ConstantPool pool() {
        return this.constantPool;
    }

    public int access() {
        return this.accessFlags;
    }

    public final boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public final boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public final boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public final boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public void setAccessFlags(int flags) {
        this.accessFlags = flags;
    }

    public ConstClass className() {
        return this.thisClassName;
    }

    public ConstClass superName() {
        return this.superClassName;
    }

    public String superNameString() {
        return this.superClassName == null ? null : this.superClassName.asString();
    }

    public void setSuperName(ConstClass superCl) {
        this.superClassName = superCl;
    }

    public Vector interfaces() {
        return this.classInterfaces;
    }

    public void addInterface(ConstClass iface) {
        this.classInterfaces.addElement(iface);
    }

    public Vector fields() {
        return this.classFields;
    }

    public void addField(ClassField field) {
        this.classFields.addElement(field);
    }

    public void addField(ClassField field, int index) {
        this.classFields.insertElementAt(field, index);
    }

    public Vector methods() {
        return this.classMethods;
    }

    public ClassMethod findMethod(String methodName, String methodSig) {
        Enumeration e = this.methods().elements();
        while (e.hasMoreElements()) {
            ClassMethod method = (ClassMethod)e.nextElement();
            if (!method.name().asString().equals(methodName) || !method.signature().asString().equals(methodSig)) continue;
            return method;
        }
        return null;
    }

    public void addMethod(ClassMethod method) {
        this.classMethods.addElement(method);
    }

    public ClassField findField(String fieldName) {
        Enumeration e = this.fields().elements();
        while (e.hasMoreElements()) {
            ClassField field = (ClassField)e.nextElement();
            if (!field.name().asString().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public AttributeVector attributes() {
        return this.classAttributes;
    }

    public long computeSUID() {
        ByteArrayOutputStream dummyOutput = new ByteArrayOutputStream(512);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            DigestOutputStream mos = new DigestOutputStream(dummyOutput, digest);
            DataOutputStream dos = new DataOutputStream(mos);
            dos.writeUTF(this.thisClassName.asString().replace('/', '.'));
            dos.writeInt(this.accessFlags & 0x611);
            ConstClass[] interfaces = this.getSUIDInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                dos.writeUTF(interfaces[i].asString().replace('/', '.'));
            }
            ClassField[] fields = this.getSUIDFields();
            for (int i = 0; i < fields.length; ++i) {
                ClassField field = fields[i];
                int access = field.access();
                if ((access & 2) != 0 && (access & 0x88) != 0) continue;
                dos.writeUTF(field.name().asString());
                dos.writeInt(access);
                dos.writeUTF(field.signature().asString());
            }
            ClassMethod[] methods = this.getSUIDMethods();
            for (int i = 0; i < methods.length; ++i) {
                ClassMethod method = methods[i];
                int access = method.access();
                if ((access & 2) != 0) continue;
                dos.writeUTF(method.name().asString());
                dos.writeInt(access);
                dos.writeUTF(method.signature().asString().replace('/', '.'));
            }
            byte[] hasharray = digest.digest();
            long h = 0L;
            for (int i = 0; i < Math.min(8, hasharray.length); ++i) {
                h += (long)(hasharray[i] & 0xFF) << i * 8;
            }
            return h;
        }
        catch (IOException ignore) {
            return -1L;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SecurityException(nsae.getMessage());
        }
    }

    public ClassFile(DataInputStream data) throws ClassFormatError {
        this(data, true, true);
    }

    public ClassFile(DataInputStream data, boolean allowJDK12ClassFiles) throws ClassFormatError {
        this(data, allowJDK12ClassFiles, true);
    }

    public ClassFile(DataInputStream data, boolean allowJDK12ClassFiles, boolean allowJDK13ClassFiles) throws ClassFormatError {
        try {
            int thisMagic = data.readInt();
            if (thisMagic != -889275714) {
                throw new ClassFormatError("Bad magic value for input");
            }
            int thisMinorVersion = data.readUnsignedShort();
            int thisMajorVersion = data.readUnsignedShort();
            if (!(thisMinorVersion == 3 && thisMajorVersion == 45 || allowJDK12ClassFiles && thisMinorVersion == 0 && thisMajorVersion == 46 || allowJDK13ClassFiles && thisMinorVersion == 0 && thisMajorVersion == 47 || thisMinorVersion == 0 && thisMajorVersion == 48)) {
                throw new UnsupportedClassVersionError("Bad version number: " + thisMajorVersion + "." + thisMinorVersion + " (" + this.getClassFormatVersionString(thisMajorVersion) + " version) ");
            }
            this.minorVersion = thisMinorVersion;
            this.majorVersion = thisMajorVersion;
            this.readConstants(data);
            this.accessFlags = data.readUnsignedShort();
            this.thisClassName = (ConstClass)this.constantPool.constantAt(data.readUnsignedShort());
            this.superClassName = (ConstClass)this.constantPool.constantAt(data.readUnsignedShort());
            this.readInterfaces(data);
            this.readFields(data);
            this.readMethods(data);
            this.classAttributes = AttributeVector.readAttributes(data, this.constantPool);
        }
        catch (IOException e) {
            throw new ClassFormatError("IOException during reading");
        }
    }

    public ClassFile(String cname, String supername) {
        this.thisClassName = this.constantPool.addClass(cname);
        this.superClassName = this.constantPool.addClass(supername);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void write(DataOutputStream buff) throws IOException {
        buff.writeInt(-889275714);
        buff.writeShort(this.minorVersion);
        buff.writeShort(this.majorVersion);
        this.constantPool.write(buff);
        buff.writeShort(this.accessFlags);
        buff.writeShort(this.thisClassName.getIndex());
        buff.writeShort(this.superClassName.getIndex());
        this.writeInterfaces(buff);
        this.writeFields(buff);
        this.writeMethods(buff);
        this.classAttributes.write(buff);
    }

    public byte[] getBytes() throws IOException {
        String writeClassToDirectory = System.getProperty("com.odi.writeClassToDirectory");
        if (writeClassToDirectory != null) {
            String filename = writeClassToDirectory + File.separator + this.thisClassName.asString() + ".class";
            System.err.println("Writing class to file " + filename);
            DataOutputStream stream = new DataOutputStream(new FileOutputStream(filename));
            this.write(stream);
            stream.close();
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        this.write(new DataOutputStream(byteStream));
        return byteStream.toByteArray();
    }

    public void print(PrintStream out) {
        int i;
        this.constantPool.print(out);
        out.println();
        out.println("majorVersion = " + Integer.toString(this.majorVersion));
        out.println("minorVersion = " + Integer.toString(this.minorVersion));
        out.println("accessFlags = " + Integer.toString(this.accessFlags));
        out.println("className = " + this.thisClassName.asString());
        out.println("superClassName = " + this.superClassName.asString());
        out.print("Interfaces =");
        for (i = 0; i < this.classInterfaces.size(); ++i) {
            out.print(" " + ((ConstClass)this.classInterfaces.elementAt(i)).asString());
        }
        out.println();
        out.println("fields =");
        for (i = 0; i < this.classFields.size(); ++i) {
            ((ClassField)this.classFields.elementAt(i)).print(out, 3);
        }
        out.println("methods =");
        for (i = 0; i < this.classMethods.size(); ++i) {
            ((ClassMethod)this.classMethods.elementAt(i)).print(out, 3);
        }
        out.println("attributes =");
        this.classAttributes.print(out, 3);
    }

    public void summarize() {
        PrintStream os = System.out;
        this.constantPool.summarize();
        int codeSize = 0;
        for (int i = 0; i < this.classMethods.size(); ++i) {
            codeSize += ((ClassMethod)this.classMethods.elementAt(i)).codeSize();
        }
        System.out.println(this.classMethods.size() + " methods in " + codeSize + " bytes");
    }

    public void moveEnclosingPointerToFront() {
        int size = this.classFields.size();
        if (size < 2) {
            return;
        }
        ClassField enclosing = (ClassField)this.classFields.lastElement();
        String name = enclosing.name().asString();
        if (name.equals("this$0")) {
            this.classFields.insertElementAt(enclosing, 0);
            this.classFields.removeElementAt(this.classFields.size() - 1);
        }
    }

    private void readConstants(DataInputStream data) throws IOException {
        this.constantPool = new ConstantPool(data);
    }

    private void readInterfaces(DataInputStream data) throws IOException {
        int nInterfaces = data.readUnsignedShort();
        while (nInterfaces-- > 0) {
            int interfaceIndex = data.readUnsignedShort();
            ConstClass ci = null;
            if (interfaceIndex != 0) {
                ci = (ConstClass)this.constantPool.constantAt(interfaceIndex);
            }
            this.classInterfaces.addElement(ci);
        }
    }

    private void writeInterfaces(DataOutputStream data) throws IOException {
        data.writeShort(this.classInterfaces.size());
        for (int i = 0; i < this.classInterfaces.size(); ++i) {
            ConstClass ci = (ConstClass)this.classInterfaces.elementAt(i);
            int interfaceIndex = 0;
            if (ci != null) {
                interfaceIndex = ci.getIndex();
            }
            data.writeShort(interfaceIndex);
        }
    }

    private void readFields(DataInputStream data) throws IOException {
        int nFields = data.readUnsignedShort();
        while (nFields-- > 0) {
            this.classFields.addElement(ClassField.read(data, this.constantPool));
        }
    }

    private void writeFields(DataOutputStream data) throws IOException {
        data.writeShort(this.classFields.size());
        for (int i = 0; i < this.classFields.size(); ++i) {
            ((ClassField)this.classFields.elementAt(i)).write(data);
        }
    }

    private void readMethods(DataInputStream data) throws IOException {
        int nMethods = data.readUnsignedShort();
        while (nMethods-- > 0) {
            this.classMethods.addElement(ClassMethod.read(data, this.constantPool));
        }
    }

    private void writeMethods(DataOutputStream data) throws IOException {
        data.writeShort(this.classMethods.size());
        for (int i = 0; i < this.classMethods.size(); ++i) {
            ((ClassMethod)this.classMethods.elementAt(i)).write(data);
        }
    }

    private ConstClass[] getSUIDInterfaces() {
        ConstClass[] ifaceArray = new ConstClass[this.classInterfaces.size()];
        if (ifaceArray.length > 0) {
            for (int i = 0; i < ifaceArray.length; ++i) {
                ifaceArray[i] = (ConstClass)this.classInterfaces.elementAt(i);
            }
            new InterfaceArraySorter(ifaceArray).sortArray();
        }
        return ifaceArray;
    }

    private ClassField[] getSUIDFields() {
        ClassField[] fieldArray = new ClassField[this.classFields.size()];
        if (fieldArray.length > 0) {
            for (int i = 0; i < fieldArray.length; ++i) {
                fieldArray[i] = (ClassField)this.classFields.elementAt(i);
            }
            new FieldArraySorter(fieldArray).sortArray();
        }
        return fieldArray;
    }

    private ClassMethod[] getSUIDMethods() {
        ClassMethod[] methodArray = new ClassMethod[this.classMethods.size()];
        if (methodArray.length > 0) {
            for (int i = 0; i < methodArray.length; ++i) {
                methodArray[i] = (ClassMethod)this.classMethods.elementAt(i);
            }
            new MethodArraySorter(methodArray).sortArray();
        }
        return methodArray;
    }

    public String getClassFormatVersionString() {
        return this.getClassFormatVersionString(this.majorVersion);
    }

    public String getClassFormatVersionString(int majorVersion) {
        switch (majorVersion) {
            case 45: {
                return "JDK 1.1";
            }
            case 46: {
                return "JDK 1.2";
            }
            case 47: {
                return "JDK 1.3";
            }
            case 48: {
                return "JDK 1.4";
            }
        }
        return "unknown";
    }
}

