/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.FatalInternalException;
import com.odi.Field;
import com.odi.SchemaException;
import com.odi.imp.Reference;
import com.odi.imp.SchemaManager;
import com.odi.imp.Utilities;

public class ArrayField
extends com.odi.imp.Field {
    private byte elementType;
    private String elementClassType;
    private int dimensions;
    private int embeddedElementCount;
    boolean isEmbeddedField = false;

    public ArrayField(String fieldName, byte elementType, String elementClassType, int dimensions) {
        super(fieldName, (byte)17);
        this.elementType = elementType;
        this.elementClassType = elementClassType;
        this.dimensions = dimensions;
    }

    public ArrayField(String fieldName, byte elementType, int dimensions) {
        super(fieldName, (byte)17);
        this.elementType = elementType;
        this.elementClassType = null;
        this.dimensions = dimensions;
    }

    @Override
    void encodeType(StringBuffer buffer, boolean computeEncodingOnly) {
        if (this.isEmbeddedField) {
            buffer.append('E');
            buffer.append("[" + this.embeddedElementCount + "]");
        } else {
            if (ArrayField.isReferenceType(this.elementType)) {
                throw new SchemaException("field \"" + this.name + "\" must be embedded; " + "top level lazy reference arrays are not currently supported.");
            }
            for (int i = 0; i < this.dimensions; ++i) {
                buffer.append("[]");
            }
        }
        if (this.isGTSPrimitiveType(this.elementType)) {
            SchemaManager.encodePrimitiveType(this.elementType, buffer);
        } else if (this.elementType == 15) {
            SchemaManager.encodeClassType(this.elementClassType, buffer, computeEncodingOnly);
        } else if (this.elementType == 16) {
            SchemaManager.encodeInterfaceType(this.elementClassType, buffer);
        } else {
            throw new FatalInternalException("ArrayField.encodeType() unknown type");
        }
    }

    public int getElementType() {
        return this.elementType;
    }

    public String getElementClassType() {
        return this.elementClassType;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int getEmbeddedElementCount() {
        return this.embeddedElementCount;
    }

    @Override
    public String getTypeName() {
        StringBuffer b = new StringBuffer();
        if (this.elementClassType != null) {
            b.append(this.elementClassType);
        } else {
            b.append(this.getBasicTypeName(this.elementType));
        }
        for (int i = 0; i < this.dimensions; ++i) {
            b.append("[]");
        }
        return b.toString();
    }

    boolean verifyEmbeddedArray(Object array) {
        Class<?> elementType = array.getClass().getComponentType();
        if (elementType == null) {
            return false;
        }
        if (this.getEmbeddedElementCount() != Utilities.getArrayElementCount(array)) {
            return false;
        }
        if (elementType.getComponentType() != null) {
            return false;
        }
        if (this.elementClassType == null) {
            return elementType.isPrimitive() || elementType == Reference.class;
        }
        return !elementType.isPrimitive();
    }

    @Override
    public Field makeEmbedded(int embeddedElementCount) {
        if (embeddedElementCount <= 0) {
            throw new IllegalArgumentException("The embedded field \"" + this.name + "\" must have a positive array length, not:" + embeddedElementCount);
        }
        if (this.getDimensions() > 1) {
            throw new IllegalArgumentException(" The embedded field \"" + this.name + "\" must be a single dimensional array.");
        }
        this.isEmbeddedField = true;
        this.embeddedElementCount = embeddedElementCount;
        return this;
    }

    @Override
    public final boolean isEmbedded() {
        return this.isEmbeddedField;
    }
}

