/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.ClassInfo;
import com.odi.FatalInternalException;
import com.odi.NoTransactionInProgressException;
import com.odi.Placement;
import com.odi.imp.Cluster;
import com.odi.imp.GenericObject;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.util.MapKeys;

public class Ref8ByteLocal
extends ReferenceType {
    private static Ref8ByteLocal _instance = null;
    static final long NULL_ENCODING = -1L;
    final Ref8ByteLocalReference NULL_REF = new Ref8ByteLocalReference(-1L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref8ByteLocal(int enumVal) {
        super(enumVal);
        Class<Ref8ByteLocal> clazz = Ref8ByteLocal.class;
        synchronized (Ref8ByteLocal.class) {
            if (_instance != null) {
                throw new FatalInternalException("Can not have more than one instances of a ReferenceType.");
            }
            _instance = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Reference makeReference(byte[] rep, int offset) {
        if (rep.length - offset < 8) {
            throw new FatalInternalException("Can not make reference with size less than 8");
        }
        long val = Ref8ByteLocal.makeLong(rep, offset);
        return new Ref8ByteLocalReference(val);
    }

    public Reference makeReference(long val) {
        return new Ref8ByteLocalReference(val);
    }

    @Override
    public byte[] getBytes(Reference ref) {
        return Ref8ByteLocal.getBytes(((Ref8ByteLocalReference)ref).value);
    }

    static byte[] getBytes(long num) {
        byte[] out = new byte[8];
        long l = num;
        for (int i = 0; i < 8; ++i) {
            l = num >> 8 * i & 0xFFL;
            out[7 - i] = (byte)l;
        }
        return out;
    }

    static String bytesToString(byte[] bytes, int offset, int len) {
        StringBuffer buff = new StringBuffer(len);
        buff.append("(offs=" + Integer.toHexString(offset) + "):");
        for (int i = offset; i < offset + len; ++i) {
            buff.append("" + Integer.toHexString(bytes[i] & 0xFF) + (i < offset + len - 1 ? "," : ""));
        }
        return buff.toString();
    }

    private static long makeLong(byte[] bytes, int offset) {
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            long t = (long)bytes[offset + i] & 0xFFL;
            ret |= t << 8 * (7 - i);
        }
        return ret;
    }

    @Override
    public Reference getFieldValue(GenericObject go, int fieldNum, ClassInfo cinfo) {
        long val = go.getLongField(fieldNum, cinfo);
        if (val == -1L) {
            return this.NULL_REF;
        }
        return new Ref8ByteLocalReference(val);
    }

    @Override
    public void setFieldValue(Reference reference, GenericObject go, int fieldNum, ClassInfo cinfo) {
        go.setLongField(fieldNum, ((Ref8ByteLocalReference)reference).value, cinfo);
    }

    @Override
    public Reference[] getArrayFieldValue(int sz, GenericObject go, int fieldNum, ClassInfo cInfo) {
        long[] rep = (long[])go.getEmbeddedArrayField(fieldNum, cInfo, new long[sz]);
        return this.createRefArray(rep);
    }

    @Override
    public void setArrayFieldValue(Reference[] values, GenericObject go, int fieldNum, ClassInfo cInfo) {
        go.setEmbeddedArrayField(fieldNum, this.createLongArray(values), cInfo);
    }

    private Reference[] createRefArray(long[] rep) {
        Reference[] refs = new Ref8ByteLocalReference[rep.length];
        for (int i = 0; i < refs.length; ++i) {
            refs[i] = rep[i] == -1L ? this.NULL_REF : new Ref8ByteLocalReference(rep[i]);
        }
        return refs;
    }

    private long[] createLongArray(Reference[] rep) {
        long[] values = new long[rep.length];
        for (int i = 0; i < rep.length; ++i) {
            values[i] = ((Ref8ByteLocalReference)rep[i]).value;
        }
        return values;
    }

    @Override
    public Class getReferenceClass() {
        return Ref8ByteLocalReference.class;
    }

    @Override
    public int size() {
        return 8;
    }

    @Override
    public Reference NULL() {
        return this.NULL_REF;
    }

    @Override
    public Reference getReference(Object object) {
        ObjectReference value = ObjectManager.getObjectReference(object);
        return this.getReference(value);
    }

    @Override
    public Reference getReference(ObjectReference value) {
        return new Ref8ByteLocalReference(value.getLocation());
    }

    @Override
    public Object resolve(Reference reference, com.odi.Cluster cluster, int AFTypecode) {
        return this.resolve(reference, cluster);
    }

    @Override
    public Object resolve(Reference reference, com.odi.Cluster cluster) {
        long location = ((Ref8ByteLocalReference)reference).value;
        ObjectManager om = (ObjectManager)cluster.getSession();
        if (!om.inTransaction()) {
            throw new NoTransactionInProgressException();
        }
        return om.resolveLazyReference(reference, cluster);
    }

    @Override
    public void resolveObjectReference(ObjectReference ref, Placement place, Reference reference, int AFTypeCode, int arrayElementCount) {
        MutatingObjRef objRef = (MutatingObjRef)ref;
        objRef.place = place;
        objRef.location = ((Ref8ByteLocalReference)reference).value;
        objRef.AFTypeCode = AFTypeCode;
        objRef.arrayElementCount = arrayElementCount;
    }

    @Override
    public void copy(Reference from, Reference to) {
        if (to == null) {
            throw new IllegalArgumentException("reference \"to\" must not be null");
        }
        ((Ref8ByteLocalReference)from).copyTo((Ref8ByteLocalReference)to);
    }

    @Override
    public boolean areEqualReferences(Reference reference, ObjectReference objRef) {
        return objRef.getLocation() == ((Ref8ByteLocalReference)reference).value;
    }

    @Override
    public ReferenceType childLeafType() {
        return this;
    }

    @Override
    public boolean isNullEncoding(byte[] rep, int offset, ObjectAccess objectAccess) {
        return ObjectAccess.decodeLong(rep, offset) == -1L;
    }

    @Override
    public void encodeNull(byte[] rep, int offset, ObjectAccess objectAccess) {
        ObjectAccess.encodeLong(rep, offset, -1L);
    }

    @Override
    public void encode(byte[] rep, int offset, Reference value, ObjectAccess objectAccess) {
        if (value == this.NULL_REF) {
            this.encodeNull(rep, offset, objectAccess);
        } else {
            ObjectAccess.encodeLong(rep, offset, ((Ref8ByteLocalReference)value).value);
        }
    }

    @Override
    public void encode(byte[] rep, int offset, Reference value) {
        if (value == this.NULL_REF) {
            ObjectAccess.encodeLong(rep, offset, -1L);
        } else {
            ObjectAccess.encodeLong(rep, offset, ((Ref8ByteLocalReference)value).value);
        }
    }

    @Override
    public byte[] encodeToByteArray(Reference ref, byte[] buffer) {
        return MapKeys.longToByteArray(((Ref8ByteLocalReference)ref).value, buffer);
    }

    @Override
    public Reference decode(byte[] rep, int offset, ObjectAccess objectAccess) {
        long value = ObjectAccess.decodeLong(rep, offset);
        return value == -1L ? this.NULL_REF : new Ref8ByteLocalReference(value);
    }

    @Override
    public Reference decode(byte[] rep, int offset) {
        long value = ObjectAccess.decodeLong(rep, offset);
        return value == -1L ? this.NULL_REF : new Ref8ByteLocalReference(value);
    }

    @Override
    public Reference decode(byte[] rep) {
        long value = MapKeys.byteArrayToLong(rep);
        return value == -1L ? this.NULL_REF : new Ref8ByteLocalReference(value);
    }

    @Override
    public ObjectReference createObjectReference(Reference lazyReference, Cluster cluster, int AFTypeCode) {
        return new MutatingObjRef(cluster, ((Ref8ByteLocalReference)lazyReference).value, AFTypeCode);
    }

    final class Ref8ByteLocalReference
    extends Reference {
        long value;

        Ref8ByteLocalReference() {
        }

        Ref8ByteLocalReference(long value) {
            this.value = value;
        }

        @Override
        public ReferenceType REFTYPE() {
            return ReferenceType.REF_8BYTE_LOCAL;
        }

        @Override
        public long getOID() {
            return this.value;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Ref8ByteLocalReference)) {
                return false;
            }
            return this.value == ((Ref8ByteLocalReference)other).value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public void copyTo(Ref8ByteLocalReference to) {
            to.value = this.value;
        }

        public String toString() {
            return "" + this.value;
        }
    }
}

