/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.util.BTreeImpl;
import com.odi.util.Key4Byte;
import com.odi.util.Key8Byte;
import com.odi.util.KeyVariable4ByteRef;
import com.odi.util.KeyVariable8ByteRef;

public abstract class KeyType {
    public static final KeyType KEY_4BYTE = new Key4Byte(1);
    public static final KeyType KEY_8BYTE = new Key8Byte(2);
    public static final KeyType VARKEY_4BYTEREF = new KeyVariable4ByteRef(3);
    public static final KeyType VARKEY_8BYTEREF = new KeyVariable8ByteRef(4);
    private int enumVal;

    protected static KeyType getKeyType(int enumeration) {
        switch (enumeration) {
            case 1: {
                return KEY_4BYTE;
            }
            case 2: {
                return KEY_8BYTE;
            }
            case 3: {
                return VARKEY_4BYTEREF;
            }
            case 4: {
                return VARKEY_8BYTEREF;
            }
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public final String toString() {
        int enumVal = this.getEnumeratedValue();
        switch (enumVal) {
            case 1: {
                return "KEY_4BYTE";
            }
            case 2: {
                return "KEY_8BYTE";
            }
            case 3: {
                return "VARKEY_4BYTEREF";
            }
            case 4: {
                return "VARKEY_8BYTEREF";
            }
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected KeyType(int enumVal) {
        this.enumVal = enumVal;
    }

    public int getEnumeratedValue() {
        return this.enumVal;
    }

    abstract void destroy(byte[] var1, int var2, boolean var3, BTreeImpl var4);

    public abstract int size();

    public abstract int compare(byte[] var1, byte[] var2, int var3, BTreeImpl var4);

    public abstract int compare(byte[] var1, int var2, byte[] var3, int var4, BTreeImpl var5);

    public abstract void setKey(byte[] var1, byte[] var2, int var3, BTreeImpl var4);

    public abstract byte[] getKey(byte[] var1, int var2, byte[] var3, BTreeImpl var4);

    public abstract boolean substringMatch(byte[] var1, int var2, byte[] var3, boolean var4, BTreeImpl var5);

    public abstract ByteIterator getByteIterator(byte[] var1, int var2, BTreeImpl var3);

    public static interface ByteIterator {
        public boolean hasNext();

        public byte next();

        public void reset();
    }
}

