/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.util.OSHashBag;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

class OSHashBagIterator
implements Iterator {
    private OSHashBag theBag;
    private Iterator hashIter;
    private int countRemaining;
    private Object currentObject;
    private boolean removed;
    private int modificationTick;

    OSHashBagIterator(OSHashBag bag) {
        this.theBag = bag;
        this.hashIter = this.theBag.keyIterator();
        this.currentObject = null;
        this.countRemaining = 0;
        this.removed = true;
        this.modificationTick = bag.getTick();
    }

    @Override
    public boolean hasNext() {
        this.checkTick();
        if (this.countRemaining > 0) {
            return true;
        }
        return this.hashIter.hasNext();
    }

    public Object next() {
        this.checkTick();
        if (this.countRemaining > 0) {
            --this.countRemaining;
        } else {
            this.currentObject = this.hashIter.next();
            this.countRemaining = this.theBag.duplicateCount(this.currentObject) - 1;
        }
        this.removed = false;
        return this.currentObject;
    }

    @Override
    public void remove() {
        this.checkTick();
        if (this.removed) {
            throw new IllegalStateException("OSHashBagIterator.remove");
        }
        this.removed = true;
        this.theBag.remove(this.currentObject);
        this.modificationTick = this.theBag.getTick();
    }

    private void checkTick() {
        if (this.modificationTick != this.theBag.getTick()) {
            throw new ConcurrentModificationException("OSHashBag modified while iterating");
        }
    }
}

