/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.imp.ByteIterator;
import com.odi.imp.ObjectAccess;
import com.odi.imp.Ref8ByteLocal;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.imp.mtsonic.Server;
import com.odi.util.BTreeIterator;
import com.odi.util.BitUtil;
import com.odi.util.StorageBTreeImpl;
import com.sonicsw.mtstorage.AbstractBTreeIterator;
import java.util.NoSuchElementException;

public class StorageBTreeIteratorImpl
extends BTreeIterator {
    private static final int STRING_KEY_START = 1;
    private static final int KEY_MAX_LENGTH = 256;
    private static final int KEY_SMALLER = -1;
    private static final int KEY_GREATER = 1;
    private static final int KEY_EQUAL = 0;
    private StorageBTreeImpl m_btree;
    private AbstractBTreeIterator m_storageIterator;
    private Server m_storageServer;
    private byte[] m_currentValue;
    private byte[] m_currentKey;
    private byte[] m_nextValue;
    private byte[] m_nextKey;
    private boolean m_gotNext;
    private boolean m_gotCurrent;
    private char[] m_matchBuffer;
    private String m_pathInfo;

    StorageBTreeIteratorImpl(StorageBTreeImpl btree, boolean inReverse) {
        this.init(btree);
        this.m_storageIterator = AbstractBTreeIterator.createIterator(btree.treeID, inReverse);
    }

    StorageBTreeIteratorImpl(StorageBTreeImpl btree, byte[] firstKey, boolean inReverse) {
        this.init(btree);
        this.m_storageIterator = AbstractBTreeIterator.createIterator(btree.treeID, firstKey, inReverse);
    }

    StorageBTreeIteratorImpl(StorageBTreeImpl btree) {
        this.init(btree);
        this.m_storageIterator = AbstractBTreeIterator.createIterator(btree.treeID);
    }

    void init(StorageBTreeImpl btree) {
        this.m_gotCurrent = false;
        this.m_gotNext = false;
        this.m_btree = btree;
        this.m_btree.fetch();
        this.m_storageServer = (Server)this.m_btree.om.sv;
        this.m_matchBuffer = new char[256];
        this.m_pathInfo = this.m_btree.pathInfo;
    }

    @Override
    public boolean hasNext() {
        if (!this.m_gotNext) {
            if (this.m_storageIterator.getAfterLast()) {
                return false;
            }
            this.m_storageServer.bTreeAdvance(this.m_storageIterator, this.m_pathInfo);
            if (!this.m_storageIterator.getAfterLast()) {
                this.m_nextKey = this.m_storageIterator.getCurrentKey();
                this.m_nextValue = this.m_storageIterator.getCurrentValue();
                this.m_gotNext = true;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Object next() {
        if (this.m_gotNext) {
            this.m_currentValue = this.m_nextValue;
            this.m_currentKey = this.m_nextKey;
            this.m_gotNext = false;
            this.m_gotCurrent = true;
            return this.getValueInternal();
        }
        if (this.hasNext()) {
            return this.next();
        }
        throw new NoSuchElementException();
    }

    private Object getValueInternal() {
        if (this.m_currentValue == null) {
            return null;
        }
        long location = BitUtil.getLong(this.m_currentValue, 0);
        Reference ref = ((Ref8ByteLocal)ReferenceType.REF_8BYTE_LOCAL).makeReference(location);
        return ref.resolve(this.m_btree.cluster, 0);
    }

    @Override
    public byte[] currentKey(byte[] keyBuffer) {
        if (!this.m_gotCurrent) {
            throw new IllegalStateException("The next method hasn't been called, or this element was removed");
        }
        return this.m_currentKey;
    }

    @Override
    public int compareKey(byte[] key) {
        if (!this.m_gotCurrent) {
            throw new IllegalStateException("The next method hasn't been called, or this element was removed");
        }
        if (key == null) {
            if (this.m_currentKey != null) {
                return -1;
            }
            return 0;
        }
        if (this.m_currentKey == null) {
            return 1;
        }
        return StorageBTreeIteratorImpl.compareKeys(key, 0, key.length, this.m_currentKey, 0, this.m_currentKey.length);
    }

    @Override
    public ByteIterator currentKeyByteIterator() {
        return new StorageKeyByteIterator(this.m_currentKey);
    }

    @Override
    public Object currentValue() {
        if (!this.m_gotCurrent) {
            throw new IllegalStateException("The next method hasn't been called, or this element was removed");
        }
        return this.getValueInternal();
    }

    @Override
    public void advance() {
        this.next();
    }

    @Override
    public void remove() {
        if (!this.m_gotCurrent) {
            throw new IllegalStateException("The next method hasn't been called, or this element was removed");
        }
        this.m_storageServer.bTreeRemove(this.m_btree.treeID, this.m_currentKey, this.m_currentValue, this.m_pathInfo);
        this.m_gotCurrent = false;
    }

    @Override
    public boolean advanceToSubstringMatch(String substring0, boolean caseInsensitive) {
        String substring;
        String string = substring = caseInsensitive ? substring0.toUpperCase() : substring0;
        while (this.hasNext()) {
            this.next();
            int maxChars = this.m_currentKey.length - 1;
            String currentKeyString = ObjectAccess.decodeString(this.m_currentKey, 1, maxChars, this.m_matchBuffer);
            if (caseInsensitive) {
                currentKeyString = currentKeyString.toUpperCase();
            }
            if (currentKeyString == null || currentKeyString.indexOf(substring) == -1) continue;
            return true;
        }
        return false;
    }

    private static int compareKeys(byte[] key1, int offset1, int length1, byte[] key2, int offset2, int length2) {
        int max = length1 > length2 ? length1 : length2;
        for (int i = 0; i < max; ++i) {
            byte b2;
            byte b1 = i < length1 ? key1[offset1 + i] : (byte)0;
            byte by = b2 = i < length2 ? key2[offset2 + i] : (byte)0;
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF) < 0 ? -1 : 1;
        }
        return 0;
    }

    public class StorageKeyByteIterator
    extends ByteIterator {
        private final byte[] m_key;
        private int m_pos;

        public StorageKeyByteIterator(byte[] key) {
            this.m_key = key;
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.m_pos < this.m_key.length;
        }

        @Override
        public byte next() {
            if (this.m_pos < this.m_key.length) {
                return this.m_key[this.m_pos++];
            }
            throw new NoSuchElementException();
        }

        public void reset() {
            this.m_pos = 0;
        }
    }
}

