/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.io.multi;

import com.progress.blackbird.evs.EEvsException;
import com.progress.blackbird.evs.EEvsNotOwnerException;
import com.progress.blackbird.evs.EEvsTimeoutException;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.evs.IEvsPortEvent;
import com.progress.blackbird.evs.IEvsPortEventHandler;
import com.progress.blackbird.evs.IEvsTimerPort;
import com.progress.blackbird.evs.nio.EvsDPCPort;
import com.progress.blackbird.evs.nio.EvsDispatcher;
import com.progress.blackbird.evs.nio.EvsTimerPort;
import com.progress.blackbird.io.EIOConnectionFailedException;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInboundStreamClosedException;
import com.progress.blackbird.io.IIOConnection;
import com.progress.blackbird.io.IIOConnectionPacketHandler;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.io.multi.IIOMultiConnectionHandshakeCompletionHandler;
import com.progress.blackbird.io.multi.IIOMultiConnectionHandshakeRequestProcessor;
import com.progress.blackbird.io.multi.IIOMultiConnectionPacketManager;
import com.progress.blackbird.io.multi.IOMultiObject;
import com.progress.blackbird.sys.SysListElement;
import com.progress.blackbird.sys.SysListHead;

public final class IOMultiConnectionHandshaker
extends IOMultiObject {
    private final IIOConnection connection;
    private final IEvsDispatcher dispatcher;
    private final IIOMultiConnectionPacketManager packetManager;
    private final IIOMultiConnectionHandshakeRequestProcessor requestProcessor;
    private final IIOMultiConnectionHandshakeCompletionHandler completionHandler;
    private final IIOConnectionPacketHandler preHandshakePacketHandler;
    private final IEvsTimerPort timer;
    private final int timeout;
    private HandshakeRequestData requestData;
    private int state;
    private static final int EVENT_START = 0;
    private static final int EVENT_PACKET = 1;
    private static final int EVENT_CONN_DOWN = 2;
    private static final int EVENT_TIMEOUT = 3;
    private static final int EVENT_NOTIFY = 4;
    private static final String[] eventStr = new String[]{"START", "PACKET", "CONN_DOWN", "TIMEOUT", "NOTIFY"};
    private static final int STATE_ACCEPTED = 0;
    private static final int STATE_CONNECTED = 1;
    private static final int STATE_WAIT_FOR_REQUEST = 2;
    private static final int STATE_WAIT_FOR_REPLY = 3;
    private static final int STATE_DONE = 4;
    private static final int STATE_NOTIFIED = 5;
    private static final String[] stateStr = new String[]{"ACCEPTED", "CONNECTED", "WAIT_REQUEST", "WAIT_REPLY", "DONE"};

    private IOMultiConnectionHandshaker(IIOConnection iIOConnection, IEvsDispatcher iEvsDispatcher, HandshakeRequestData handshakeRequestData, int n, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionHandshakeRequestProcessor iIOMultiConnectionHandshakeRequestProcessor, IIOMultiConnectionHandshakeCompletionHandler iIOMultiConnectionHandshakeCompletionHandler) throws EIOException {
        this.connection = iIOConnection;
        this.dispatcher = iEvsDispatcher;
        this.packetManager = iIOMultiConnectionPacketManager;
        this.requestProcessor = iIOMultiConnectionHandshakeRequestProcessor;
        this.completionHandler = iIOMultiConnectionHandshakeCompletionHandler;
        this.timer = EvsTimerPort.create(this.threaded);
        this.timeout = n * 1000;
        this.requestData = handshakeRequestData;
        this.state = handshakeRequestData == null ? 0 : 1;
        this.preHandshakePacketHandler = this.connection.setPacketHandler(new PacketHandler());
        EvsDPCPort.create(this.threaded).post(iEvsDispatcher, (byte)31, new StartEventHandler(), null);
    }

    private void sendRequest() throws Exception {
        IIOPacket iIOPacket = this.packetManager.createHandshakeRequest(this.requestData.id);
        try {
            this.connection.write(iIOPacket, null, 5);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processRequest(IIOPacket iIOPacket) throws Exception {
        if (this.packetManager.isHandshakeRequest(iIOPacket)) {
            this.requestData = new HandshakeRequestData(this.packetManager.getHandshakeRequestId(iIOPacket));
            boolean bl = true;
            String string = null;
            if (this.requestProcessor != null) {
                try {
                    string = this.requestProcessor.processRequest(this.connection, iIOPacket);
                }
                catch (Exception exception) {
                    bl = false;
                    string = exception.getMessage();
                }
            }
            IIOPacket iIOPacket2 = this.packetManager.createHandshakeReply(bl, string);
            try {
                this.connection.write(iIOPacket2, null, 5);
            }
            catch (Exception exception) {}
        } else {
            throw new Exception("connect request packet " + iIOPacket + " is invalid");
        }
    }

    private Exception processReply(IIOPacket iIOPacket) throws Exception {
        if (this.packetManager.isHandshakeReply(iIOPacket)) {
            if (!this.packetManager.getHandshakeReplyStatus(iIOPacket)) {
                return new Exception(this.packetManager.getHandshakeReplyDesc(iIOPacket));
            }
            return null;
        }
        throw new Exception("connect reply packet " + iIOPacket + " is invalid");
    }

    private void handshake(int n, Object object) {
        try {
            if (this.trace.debug) {
                this.trace.debugln("Handshake state machine [" + stateStr[this.state] + "," + eventStr[n] + "]");
            }
            block3 : switch (this.state) {
                case 0: {
                    switch (n) {
                        case 0: {
                            this.timer.start(this.dispatcher, (byte)15, this.timeout, new TimeoutEventHandler(), null);
                            this.state = 2;
                            break block3;
                        }
                    }
                    throw new RuntimeException("Invalid event [" + eventStr[n] + "] for state [" + stateStr[this.state] + "]");
                }
                case 1: {
                    switch (n) {
                        case 0: {
                            this.sendRequest();
                            this.timer.start(this.dispatcher, (byte)15, this.timeout, new TimeoutEventHandler(), null);
                            this.state = 3;
                            break block3;
                        }
                    }
                    throw new RuntimeException("Invalid event [" + eventStr[n] + "] for state [" + stateStr[this.state] + "]");
                }
                case 2: {
                    switch (n) {
                        case 1: {
                            this.processRequest((IIOPacket)object);
                            this.state = 4;
                            this.handshake(4, null);
                            break block3;
                        }
                        case 3: {
                            throw new EIOException("Timed out in waiting for handshake request");
                        }
                        case 2: {
                            throw (EIOException)object;
                        }
                    }
                    throw new RuntimeException("Invalid event [" + eventStr[n] + "] for state [" + stateStr[this.state] + "]");
                }
                case 3: {
                    switch (n) {
                        case 1: {
                            Exception exception = this.processReply((IIOPacket)object);
                            this.state = 4;
                            this.handshake(4, exception);
                            break block3;
                        }
                        case 3: {
                            throw new EIOException("Timed out in waiting for handshake reply");
                        }
                        case 2: {
                            throw (EIOException)object;
                        }
                    }
                    throw new RuntimeException("Invalid event [" + eventStr[n] + "] for state [" + stateStr[this.state] + "]");
                }
                case 4: {
                    switch (n) {
                        case 4: {
                            try {
                                this.timer.stop();
                                try {
                                    this.connection.setPacketHandler(this.preHandshakePacketHandler);
                                }
                                catch (EIOConnectionFailedException eIOConnectionFailedException) {
                                    // empty catch block
                                }
                                if (this.completionHandler != null) {
                                    if (object instanceof Exception) {
                                        this.completionHandler.onHandshakeComplete(this.connection, (Exception)object);
                                    } else {
                                        this.completionHandler.onHandshakeComplete(this.connection, null);
                                    }
                                }
                                this.state = 5;
                            }
                            catch (Exception exception) {
                                this.trace.outln("Received exception [" + exception.getMessage() + "] in processing EVENT_NOTIFY during multi-connection handshake", 2);
                            }
                            break block3;
                        }
                    }
                    throw new RuntimeException("Invalid event [" + eventStr[n] + "] for state [" + stateStr[this.state] + "]");
                }
                case 5: {
                    switch (n) {
                        default: 
                    }
                    throw new RuntimeException("Invalid event [" + eventStr[n] + "] for state [" + stateStr[this.state] + "]");
                }
                default: {
                    throw new RuntimeException("Invalid state [" + this.state + "]");
                }
            }
        }
        catch (Exception exception) {
            this.trace.outln("Handshake error [" + this.connection + ", " + exception.getMessage() + "]", 1);
            this.state = 4;
            this.handshake(4, exception);
        }
    }

    public static IOMultiConnectionHandshaker create(IIOConnection iIOConnection, IEvsDispatcher iEvsDispatcher, HandshakeRequestData handshakeRequestData, int n, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionHandshakeRequestProcessor iIOMultiConnectionHandshakeRequestProcessor, IIOMultiConnectionHandshakeCompletionHandler iIOMultiConnectionHandshakeCompletionHandler) throws EIOException {
        return new IOMultiConnectionHandshaker(iIOConnection, iEvsDispatcher, handshakeRequestData, n, iIOMultiConnectionPacketManager, iIOMultiConnectionHandshakeRequestProcessor, iIOMultiConnectionHandshakeCompletionHandler);
    }

    public final HandshakeRequestData getHandshakeRequestData() {
        return this.requestData;
    }

    public static HandshakeCompletionData doSynchronousHandshake(final IIOConnection iIOConnection, final HandshakeRequestData handshakeRequestData, final int n, final IIOMultiConnectionHandshakeRequestProcessor iIOMultiConnectionHandshakeRequestProcessor, final IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager) {
        final class Handshaker
        extends IOMultiObject
        implements IIOMultiConnectionHandshakeCompletionHandler,
        IIOConnectionPacketHandler {
            private boolean done;
            private Exception status;
            private SysListHead packetList = SysListHead.create(null);

            Handshaker() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            HandshakeCompletionData doHandshake() {
                IEvsDispatcher iEvsDispatcher = null;
                IOMultiConnectionHandshaker iOMultiConnectionHandshaker = null;
                try {
                    try {
                        iEvsDispatcher = EvsDispatcher.create(null, false, null);
                    }
                    catch (Exception exception) {
                        throw new EIOException(exception);
                    }
                    iIOConnection.read(iEvsDispatcher, this);
                    iOMultiConnectionHandshaker = IOMultiConnectionHandshaker.create(iIOConnection, iEvsDispatcher, handshakeRequestData, n, iIOMultiConnectionPacketManager, iIOMultiConnectionHandshakeRequestProcessor, this);
                    while (!this.done) {
                        iEvsDispatcher.dispatch(-1);
                    }
                }
                catch (EEvsTimeoutException eEvsTimeoutException) {
                    throw new InternalError("Received timeout exception from dispatcher when inifinite timeout specified!");
                }
                catch (EEvsNotOwnerException eEvsNotOwnerException) {
                    throw new InternalError("Received 'not owner' exception from dispatcher when just created dispatcher!");
                }
                catch (EEvsException eEvsException) {
                    HandshakeCompletionData handshakeCompletionData = new HandshakeCompletionData(new EIOException(eEvsException), iOMultiConnectionHandshaker == null ? null : iOMultiConnectionHandshaker.getHandshakeRequestData(), this.packetList);
                    return handshakeCompletionData;
                }
                catch (EIOException eIOException) {
                    HandshakeCompletionData handshakeCompletionData = new HandshakeCompletionData(eIOException, iOMultiConnectionHandshaker == null ? null : iOMultiConnectionHandshaker.getHandshakeRequestData(), this.packetList);
                    return handshakeCompletionData;
                }
                finally {
                    try {
                        if (iIOConnection.isInboundStreamOpen()) {
                            iIOConnection.read(null, null);
                            while (iIOConnection.isInboundStreamOpen()) {
                                iEvsDispatcher.dispatch(-1);
                            }
                        }
                    }
                    catch (EIOInboundStreamClosedException eIOInboundStreamClosedException) {
                    }
                    catch (Exception exception) {
                        this.trace.outln("Failure in closing connection inbound stream after handshake completion [" + exception.getMessage() + "]. Ignoring.", 2);
                    }
                    try {
                        iEvsDispatcher.close();
                    }
                    catch (Exception exception) {
                        this.trace.outln("Failure in closing dispatcher after handshake completion [" + exception.getMessage() + "]. Ignoring.", 2);
                    }
                }
                return new HandshakeCompletionData(this.status, iOMultiConnectionHandshaker.getHandshakeRequestData(), this.packetList);
            }

            @Override
            public final void onHandshakeComplete(IIOConnection iIOConnection2, Exception exception) {
                this.done = true;
                this.status = exception;
            }

            @Override
            public final void handlePacket(EIOException eIOException, IIOPacket iIOPacket) {
                if (this.trace.debug) {
                    this.trace.debugln("SyncHandshaker: Received packet [status=" + (eIOException != null ? eIOException.getMessage() : "null") + " packet=" + iIOPacket + "]");
                }
                if (eIOException == null) {
                    this.packetList.append((SysListElement)((Object)iIOPacket));
                } else {
                    this.status = eIOException;
                }
            }
        }
        return new Handshaker().doHandshake();
    }

    public static final class HandshakeCompletionData {
        public final Exception status;
        public final HandshakeRequestData requestData;
        public final SysListHead packetList;

        HandshakeCompletionData(Exception exception, HandshakeRequestData handshakeRequestData, SysListHead sysListHead) {
            this.status = exception;
            this.requestData = handshakeRequestData;
            this.packetList = sysListHead;
        }

        public final String toString() {
            return "[" + (this.status == null ? "ok" : this.status.getMessage()) + ", " + this.requestData + ", " + "packetCount=" + this.packetList.getListSize() + "]";
        }
    }

    public static final class HandshakeRequestData {
        public final String id;

        private HandshakeRequestData(String string) {
            this.id = string;
        }

        public static HandshakeRequestData create(String string) {
            return new HandshakeRequestData(string);
        }

        public final String toString() {
            return "<id=" + this.id + ">";
        }
    }

    private final class TimeoutEventHandler
    implements IEvsPortEventHandler {
        private TimeoutEventHandler() {
        }

        @Override
        public final void handleEvent(IEvsPortEvent iEvsPortEvent) {
            IOMultiConnectionHandshaker.this.handshake(3, null);
        }
    }

    private final class PacketHandler
    implements IIOConnectionPacketHandler {
        private PacketHandler() {
        }

        @Override
        public final void handlePacket(EIOException eIOException, IIOPacket iIOPacket) {
            if (eIOException == null) {
                IOMultiConnectionHandshaker.this.handshake(1, iIOPacket);
            } else {
                IOMultiConnectionHandshaker.this.handshake(2, eIOException);
            }
        }
    }

    private final class StartEventHandler
    implements IEvsPortEventHandler {
        private StartEventHandler() {
        }

        @Override
        public final void handleEvent(IEvsPortEvent iEvsPortEvent) {
            IOMultiConnectionHandshaker.this.handshake(0, null);
        }
    }
}

