/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.nwlink;

import com.progress.blackbird.nwlink.ENwLinkException;
import com.progress.blackbird.nwlink.NwLinkObject;
import com.progress.blackbird.sys.ESysIoctlException;
import com.progress.blackbird.sys.ISysIoctl;
import java.util.Properties;

public abstract class NwLink
extends NwLinkObject
implements ISysIoctl {
    private final IntProperty weight = new IntProperty("weight", "0");
    private static final String WEIGHT_PROPNAME = "weight";

    public NwLink() {
        this.setDefaultTracePrefix();
    }

    public final void propertyTableToCommonProps(Properties properties) {
        this.weight.load(properties);
    }

    public final void commonPropsToPropertyTable(Properties properties) {
        this.weight.save(properties);
    }

    @Override
    public Object ioctl(String string, Object object) throws ESysIoctlException, ENwLinkException {
        if (string.compareToIgnoreCase("getprop") == 0) {
            if (object instanceof String) {
                String string2 = (String)object;
                if (string2.compareToIgnoreCase(WEIGHT_PROPNAME) == 0) {
                    return new Integer(this.weight.value);
                }
                throw new ESysIoctlException("invalid property");
            }
            throw new ESysIoctlException("data argument needs to be a String");
        }
        throw new ESysIoctlException("invalid command");
    }

    public class BooleanProperty
    extends Property {
        public boolean value;

        public BooleanProperty(String string, String string2) {
            super(string, string2);
        }

        @Override
        public final void load(Properties properties) {
            String string = (String)properties.get(this.name);
            try {
                this.value = Boolean.valueOf(string == null ? (String)this.defValue : string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public final void save(Properties properties) {
            properties.put(this.name, String.valueOf(this.value));
        }
    }

    public class ShortProperty
    extends Property {
        public short value;

        public ShortProperty(String string, String string2) {
            super(string, string2);
        }

        @Override
        public final void load(Properties properties) {
            String string = (String)properties.get(this.name);
            try {
                this.value = Short.parseShort(string == null ? (String)this.defValue : string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public final void save(Properties properties) {
            properties.put(this.name, String.valueOf(this.value));
        }
    }

    public class IntProperty
    extends Property {
        public int value;

        public IntProperty(String string, String string2) {
            super(string, string2);
        }

        @Override
        public final void load(Properties properties) {
            String string = (String)properties.get(this.name);
            try {
                this.value = Integer.parseInt(string == null ? (String)this.defValue : string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public final void save(Properties properties) {
            properties.put(this.name, String.valueOf(this.value));
        }
    }

    public class StringProperty
    extends Property {
        public String value;

        public StringProperty(String string, String string2) {
            super(string, string2);
        }

        @Override
        public final void load(Properties properties) {
            this.value = (String)properties.get(this.name);
            if (this.value == null) {
                this.value = (String)this.defValue;
            }
        }

        @Override
        public final void save(Properties properties) {
            if (this.value != null) {
                properties.put(this.name, this.value);
            } else {
                properties.remove(this.name);
            }
        }
    }

    public abstract class Property {
        public String name;
        public Object defValue;

        public Property(String string, String string2) {
            this.name = string;
            this.defValue = string2;
        }

        public abstract void load(Properties var1);

        public abstract void save(Properties var1);
    }
}

