/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.nwlink.tcp;

import com.progress.blackbird.nwlink.ENwLinkException;
import com.progress.blackbird.nwlink.ENwLinkIOException;
import com.progress.blackbird.nwlink.INwLink;
import com.progress.blackbird.nwlink.INwLinkStatistics;
import com.progress.blackbird.nwlink.NwLink;
import com.progress.blackbird.nwlink.NwLinkDescriptorParser;
import com.progress.blackbird.nwlink.NwLinkInetAddress;
import com.progress.blackbird.sys.ESysIoctlException;
import com.progress.blackbird.sys.SysConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Properties;

public final class TCPNwLink
extends NwLink
implements INwLink {
    private final NwLink.StringProperty localIfAddr = new NwLink.StringProperty("localifaddr", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.tcp.localifaddr", "0.0.0.0"));
    private final NwLink.IntProperty localPort = new NwLink.IntProperty("localport", "0");
    private final NwLink.StringProperty remoteIfAddr = new NwLink.StringProperty("remoteifaddr", "0.0.0.0");
    private final NwLink.IntProperty remotePort = new NwLink.IntProperty("remoteport", "0");
    private final NwLink.IntProperty backlog = new NwLink.IntProperty("backlog", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.tcp.backlog", "0"));
    private final NwLink.BooleanProperty tcpKeepAlive = new NwLink.BooleanProperty("keepalive", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.tcp.keepalive", "false"));
    private final NwLink.BooleanProperty tcpNoDelay = new NwLink.BooleanProperty("nodelay", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.tcp.nodelay", "true"));
    private final NwLink.IntProperty sendBufferSize = new NwLink.IntProperty("sendbufsize", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.tcp.sendbufsize", "32767"));
    private final NwLink.IntProperty recvBufferSize = new NwLink.IntProperty("recvbufsize", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.tcp.recvbufsize", "32767"));
    private final NwLink.BooleanProperty linger = new NwLink.BooleanProperty("linger", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.tcp.linger", "true"));
    private final NwLink.IntProperty lingerTime = new NwLink.IntProperty("lingertime", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.tcp.lingertime", "10"));
    private final ServerSocketChannel ssc;
    private final SocketChannel sc;
    private final int type;
    private int state;
    private static final int STATE_NOT_CONNECTED = 0;
    private static final int STATE_CONNECTED = 1;
    private static final int STATE_CONNECT_FAILED = 2;
    private static final int STATE_CLOSED = 3;
    private static final String LOCAL_IF_ADDR_PROPNAME = "localifaddr";
    private static final String LOCAL_PORT_PROPNAME = "localport";
    private static final String REMOTE_IF_ADDR_PROPNAME = "remoteifaddr";
    private static final String REMOTE_PORT_PROPNAME = "remoteport";
    private static final String BACKLOG_PROPNAME = "backlog";
    private static final String SEND_BUFFERSIZE_PROPNAME = "sendbufsize";
    private static final String RECV_BUFFERSIZE_PROPNAME = "recvbufsize";
    private static final String KEEPALIVE_PROPNAME = "keepalive";
    private static final String NODELAY_PROPNAME = "nodelay";
    private static final String LINGER_PROPNAME = "linger";
    private static final String LINGERTIME_PROPNAME = "lingertime";

    private TCPNwLink(int n, SelectableChannel selectableChannel, Properties properties) throws ENwLinkException {
        this.type = n;
        this.trace.updateLevelFromProperty(SysConfig.getProperties(), "bb.nwlink.tcp.trace");
        this.propertyTableToProps(properties);
        if (n == 0) {
            if (selectableChannel == null) {
                try {
                    this.ssc = ServerSocketChannel.open();
                }
                catch (IOException iOException) {
                    throw new ENwLinkIOException("server channel create", iOException);
                }
                try {
                    this.trace.outln("Binding passive link to " + this.localIfAddr.value + ":" + this.localPort.value + " with backlog=" + this.backlog.value, 4);
                    this.ssc.socket().bind(new InetSocketAddress(this.localIfAddr.value, this.localPort.value), this.backlog.value);
                }
                catch (IOException iOException) {
                    throw new ENwLinkIOException("server channel bind", iOException);
                }
            }
            this.ssc = (ServerSocketChannel)selectableChannel;
            try {
                this.ssc.configureBlocking(false);
            }
            catch (IOException iOException) {
                throw new ENwLinkIOException("server channel blocking mode change", iOException);
            }
            try {
                this.trace.outln("Configuring passive link (to be inherited by accepted links)...", 4);
                if (this.recvBufferSize.value > 0) {
                    this.trace.outln("....recv buffer size = " + this.recvBufferSize.value, 4);
                    this.ssc.socket().setReceiveBufferSize(this.recvBufferSize.value);
                }
            }
            catch (IOException iOException) {
                throw new ENwLinkIOException("server channel socket properties set", iOException);
            }
            this.sc = null;
        } else if (n == 1) {
            if (selectableChannel == null) {
                try {
                    this.sc = SocketChannel.open();
                }
                catch (IOException iOException) {
                    throw new ENwLinkIOException("channel create", iOException);
                }
                try {
                    this.trace.outln("Binding active link to " + this.localIfAddr.value + ":" + this.localPort.value, 4);
                    this.sc.socket().bind(new InetSocketAddress(this.localIfAddr.value, this.localPort.value));
                }
                catch (IOException iOException) {
                    throw new ENwLinkIOException("channel bind", iOException);
                }
                this.state = 0;
            } else {
                this.sc = (SocketChannel)selectableChannel;
                this.state = 1;
            }
            try {
                this.sc.configureBlocking(false);
            }
            catch (IOException iOException) {
                throw new ENwLinkIOException("channel blocking mode change", iOException);
            }
            this.trace.outln("Configuring active link...", 4);
            try {
                this.sc.socket().setKeepAlive(this.tcpKeepAlive.value);
                this.trace.outln("....keepalive = " + this.tcpKeepAlive.value + " {actual = " + this.sc.socket().getKeepAlive() + "}", 4);
                this.sc.socket().setTcpNoDelay(this.tcpNoDelay.value);
                this.trace.outln("....nodelay = " + this.tcpNoDelay.value + " {actual = " + this.sc.socket().getTcpNoDelay() + "}", 4);
                this.sc.socket().setSoLinger(this.linger.value, this.linger.value ? this.lingerTime.value : 0);
                this.trace.outln("....linger = " + this.linger.value + " (" + (this.linger.value ? this.lingerTime.value : 0) + ")" + " {actual = " + this.sc.socket().getSoLinger() + "}", 4);
                if (this.sendBufferSize.value > 0) {
                    this.sc.socket().setSendBufferSize(this.sendBufferSize.value);
                    this.trace.outln("....send buffer size = " + this.sendBufferSize.value + " {actual = " + this.sc.socket().getSendBufferSize() + "}", 4);
                } else {
                    this.trace.outln("....send buffer size {actual = " + this.sc.socket().getSendBufferSize() + "}", 4);
                }
                if (selectableChannel == null && this.recvBufferSize.value > 0) {
                    this.sc.socket().setReceiveBufferSize(this.recvBufferSize.value);
                    this.trace.outln("....recv buffer size = " + this.recvBufferSize.value + " {actual = " + this.sc.socket().getReceiveBufferSize() + "}", 4);
                } else {
                    this.trace.outln("....recv buffer size = {actual = " + this.sc.socket().getReceiveBufferSize() + "}", 4);
                }
            }
            catch (IOException iOException) {
                throw new ENwLinkIOException("channel socket properties set", iOException);
            }
            this.ssc = null;
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
    }

    private Properties propertyTableToProps(Properties properties) {
        this.propertyTableToCommonProps(properties);
        this.localIfAddr.load(properties);
        this.localPort.load(properties);
        this.remoteIfAddr.load(properties);
        this.remotePort.load(properties);
        this.backlog.load(properties);
        this.tcpKeepAlive.load(properties);
        this.tcpNoDelay.load(properties);
        this.sendBufferSize.load(properties);
        this.recvBufferSize.load(properties);
        this.linger.load(properties);
        this.lingerTime.load(properties);
        return properties;
    }

    private Properties propsToPropertyTable() {
        Properties properties = new Properties();
        this.commonPropsToPropertyTable(properties);
        this.localIfAddr.save(properties);
        this.localPort.save(properties);
        this.remoteIfAddr.save(properties);
        this.remotePort.save(properties);
        this.backlog.save(properties);
        this.tcpKeepAlive.save(properties);
        this.tcpNoDelay.save(properties);
        this.sendBufferSize.save(properties);
        this.recvBufferSize.save(properties);
        this.linger.save(properties);
        this.lingerTime.save(properties);
        return properties;
    }

    private ENwLinkException prepareIllegalStateException() {
        String string = null;
        switch (this.state) {
            case 0: {
                string = "link not connected";
                break;
            }
            case 1: {
                string = "link already connected";
                break;
            }
            case 2: {
                string = "prior connect failed";
                break;
            }
            case 3: {
                string = "link is closed";
            }
        }
        return new ENwLinkException(string);
    }

    public static INwLink create(Integer n, String string) throws ENwLinkException {
        NwLinkDescriptorParser nwLinkDescriptorParser = NwLinkDescriptorParser.create(string);
        Properties properties = nwLinkDescriptorParser.getProperties();
        NwLinkInetAddress nwLinkInetAddress = NwLinkInetAddress.create(nwLinkDescriptorParser.getAddress());
        if (n == 1) {
            properties.put(REMOTE_IF_ADDR_PROPNAME, nwLinkInetAddress.getHost());
            properties.put(REMOTE_PORT_PROPNAME, String.valueOf(nwLinkInetAddress.getPort()));
        } else {
            properties.put(LOCAL_IF_ADDR_PROPNAME, nwLinkInetAddress.getHost());
            properties.put(LOCAL_PORT_PROPNAME, String.valueOf(nwLinkInetAddress.getPort()));
        }
        return new TCPNwLink(n, null, properties);
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public final SelectableChannel getChannel() {
        return this.sc;
    }

    @Override
    public final SelectableChannel getServerChannel() {
        return this.ssc;
    }

    @Override
    public final INwLinkStatistics getStatistics() {
        return null;
    }

    @Override
    public final boolean connect() throws ENwLinkException {
        if (this.state == 0) {
            try {
                boolean bl;
                this.trace.outln("Connecting to " + this.remoteIfAddr.value + ":" + this.remotePort.value + "...", 4);
                boolean bl2 = bl = !this.sc.isConnectionPending() ? this.sc.connect(new InetSocketAddress(this.remoteIfAddr.value, this.remotePort.value)) : this.sc.finishConnect();
                if (bl) {
                    this.state = 1;
                    this.trace.outln("Connect successfully completed.", 4);
                } else {
                    this.trace.outln("Connect pending completion.", 4);
                }
                return bl;
            }
            catch (IOException iOException) {
                this.state = 2;
                this.trace.outln("Connect failed [" + iOException.getMessage() + "]", 4);
                throw new ENwLinkIOException("connect", iOException);
            }
        }
        throw this.prepareIllegalStateException();
    }

    @Override
    public final INwLink accept() throws ENwLinkException {
        TCPNwLink tCPNwLink = null;
        try {
            this.trace.outln("Accepting through " + this.localIfAddr.value + ":" + this.localPort.value + "...", 4);
            SocketChannel socketChannel = this.ssc.accept();
            if (socketChannel != null) {
                this.trace.outln("Accepted successfully completed.", 4);
                tCPNwLink = new TCPNwLink(1, socketChannel, this.propsToPropertyTable());
            } else {
                this.trace.outln("Accept pending completion.", 4);
            }
        }
        catch (IOException iOException) {
            throw new ENwLinkIOException("accept", iOException);
        }
        return tCPNwLink;
    }

    @Override
    public final int read(ByteBuffer byteBuffer) throws ENwLinkException {
        if (this.state == 1) {
            try {
                if (this.trace.debug) {
                    this.trace.debugln("Reading " + byteBuffer.remaining() + " bytes...");
                }
                return this.sc.read(byteBuffer);
            }
            catch (IOException iOException) {
                throw new ENwLinkIOException("read", iOException);
            }
        }
        throw this.prepareIllegalStateException();
    }

    @Override
    public final long write(INwLink.WriteBufferArray writeBufferArray) throws ENwLinkException {
        if (this.state == 1) {
            long l = 0L;
            try {
                while (writeBufferArray.offset < writeBufferArray.array.length) {
                    if (this.trace.debug) {
                        this.trace.debugln("Writing buffer #" + writeBufferArray.offset + "(remaining=" + writeBufferArray.array[writeBufferArray.offset].remaining() + ")");
                    }
                    l += (long)this.sc.write(writeBufferArray.array[writeBufferArray.offset]);
                    if (writeBufferArray.array[writeBufferArray.offset].remaining() <= 0) {
                        ++writeBufferArray.offset;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                throw new ENwLinkIOException("write", iOException);
            }
            return l;
        }
        throw this.prepareIllegalStateException();
    }

    @Override
    public final void close() throws ENwLinkException {
        block19: {
            if (this.state != 3) {
                try {
                    if (this.ssc != null) {
                        this.trace.outln("Closing passive link...", 4);
                        this.ssc.socket().close();
                    }
                    if (this.sc == null) break block19;
                    this.trace.outln("Closing active link...", 4);
                    if (this.sc.socket().isConnected()) {
                        if (!this.sc.socket().isOutputShutdown()) {
                            try {
                                this.sc.socket().shutdownOutput();
                            }
                            catch (Exception exception) {
                                this.trace.outln("Failed to shutdown write half of socket during link close [" + exception.getMessage() + "].", 2);
                            }
                        }
                        if (!this.sc.socket().isInputShutdown()) {
                            try {
                                this.sc.socket().shutdownInput();
                            }
                            catch (Exception exception) {
                                this.trace.outln("Failed to shutdown read half of socket during link close [" + exception.getMessage() + "].", 2);
                            }
                        }
                    }
                    if (!this.sc.socket().isClosed()) {
                        try {
                            this.sc.socket().close();
                        }
                        catch (Exception exception) {
                            this.trace.outln("Failed to close socket during link close [" + exception.getMessage() + "].", 2);
                        }
                    }
                }
                catch (ClosedChannelException closedChannelException) {
                }
                catch (IOException iOException) {
                    throw new ENwLinkIOException("close", iOException);
                }
                finally {
                    this.state = 3;
                }
            }
        }
    }

    @Override
    public final Object ioctl(String string, Object object) throws ESysIoctlException, ENwLinkException {
        if (this.trace.debug) {
            this.trace.debugln("Processing IOCTL command [" + string + "," + object + "]");
        }
        try {
            return super.ioctl(string, object);
        }
        catch (ESysIoctlException eSysIoctlException) {
            if (string.compareToIgnoreCase("getprop") == 0) {
                if (object instanceof String) {
                    String string2 = (String)object;
                    if (string2.compareToIgnoreCase(LOCAL_IF_ADDR_PROPNAME) == 0) {
                        return this.localIfAddr.value;
                    }
                    if (string2.compareToIgnoreCase(LOCAL_PORT_PROPNAME) == 0) {
                        return new Integer(this.localPort.value);
                    }
                    if (string2.compareToIgnoreCase(REMOTE_IF_ADDR_PROPNAME) == 0) {
                        return this.remoteIfAddr.value;
                    }
                    if (string2.compareToIgnoreCase(REMOTE_PORT_PROPNAME) == 0) {
                        return new Integer(this.remotePort.value);
                    }
                    if (string2.compareToIgnoreCase(BACKLOG_PROPNAME) == 0) {
                        return new Integer(this.backlog.value);
                    }
                    if (string2.compareToIgnoreCase(KEEPALIVE_PROPNAME) == 0) {
                        return new Boolean(this.tcpKeepAlive.value);
                    }
                    if (string2.compareToIgnoreCase(NODELAY_PROPNAME) == 0) {
                        return new Boolean(this.tcpNoDelay.value);
                    }
                    if (string2.compareToIgnoreCase(SEND_BUFFERSIZE_PROPNAME) == 0) {
                        return new Integer(this.sendBufferSize.value);
                    }
                    if (string2.compareToIgnoreCase(RECV_BUFFERSIZE_PROPNAME) == 0) {
                        return new Integer(this.recvBufferSize.value);
                    }
                    if (string2.compareToIgnoreCase(LINGER_PROPNAME) == 0) {
                        return new Boolean(this.linger.value);
                    }
                    if (string2.compareToIgnoreCase(LINGERTIME_PROPNAME) == 0) {
                        return new Integer(this.lingerTime.value);
                    }
                    throw new ESysIoctlException("invalid property");
                }
                throw new ESysIoctlException("data argument needs to be a String");
            }
            throw new ESysIoctlException("invalid command");
        }
    }
}

