/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.pdu.EPDUInvalidPacketTypeException;
import com.progress.blackbird.pdu.PDUListElement;
import com.progress.blackbird.pdu.PDUPacketBrokerConnectReply;
import com.progress.blackbird.pdu.PDUPacketBrokerConnectRequest;
import com.progress.blackbird.pdu.PDUPacketClientConnectReply;
import com.progress.blackbird.pdu.PDUPacketClientConnectRequest;
import com.progress.blackbird.pdu.PDUPacketData;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.pdu.PDUPacketJoinReply;
import com.progress.blackbird.pdu.PDUPacketJoinRequest;
import com.progress.blackbird.pdu.PDUPacketLeaveReply;
import com.progress.blackbird.pdu.PDUPacketLeaveRequest;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionAck;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionHandshakeReply;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionHandshakeRequest;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionNack;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionSync;
import com.progress.blackbird.pdu.PDUPacketNetworkConnectionPingReply;
import com.progress.blackbird.pdu.PDUPacketNetworkConnectionPingRequest;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public abstract class PDUPacket
extends PDUListElement
implements Cloneable,
IIOPacket {
    private PDUPacketHeader header;
    private Object object;

    PDUPacket(short s) {
        this.header = PDUPacketHeader.create(s);
    }

    PDUPacket(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        this.header = pDUPacketHeader;
        this.deserializeBody(dataInputStream);
    }

    PDUPacket(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        this.header = pDUPacketHeader;
        this.deserializeBody(printStream, bufferedReader);
    }

    abstract void serializeBody(DataOutputStream var1) throws EIOException;

    abstract void deserializeBody(DataInputStream var1) throws EIOInsufficientDataException, EIOException;

    abstract void deserializeBody(PrintStream var1, BufferedReader var2) throws IOException;

    abstract void cloneBody(PDUPacket var1);

    abstract int getBodyWireSize();

    abstract String bodyToString();

    public static PDUPacket create(short s, PrintStream printStream, BufferedReader bufferedReader) throws EPDUInvalidPacketTypeException, IOException {
        printStream.println(" ******** Header ********");
        PDUPacketHeader pDUPacketHeader = PDUPacketHeader.create(s, printStream, bufferedReader);
        printStream.println(" ********* Body ********");
        switch (pDUPacketHeader.getType()) {
            case 1: {
                return PDUPacketNetworkConnectionPingRequest.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 2: {
                return PDUPacketNetworkConnectionPingReply.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 3: {
                return PDUPacketClientConnectRequest.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 4: {
                return PDUPacketClientConnectReply.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 5: {
                return PDUPacketBrokerConnectRequest.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 6: {
                return PDUPacketBrokerConnectReply.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 7: {
                return PDUPacketJoinRequest.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 8: {
                return PDUPacketJoinReply.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 9: {
                return PDUPacketLeaveRequest.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 10: {
                return PDUPacketLeaveReply.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 11: {
                return PDUPacketMultiConnectionAck.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 12: {
                return PDUPacketMultiConnectionNack.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 13: {
                return PDUPacketMultiConnectionSync.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 14: {
                return PDUPacketMultiConnectionHandshakeRequest.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 15: {
                return PDUPacketMultiConnectionHandshakeReply.create(pDUPacketHeader, printStream, bufferedReader);
            }
            case 255: {
                return PDUPacketData.create(pDUPacketHeader, printStream, bufferedReader);
            }
        }
        throw new EPDUInvalidPacketTypeException(s);
    }

    public static PDUPacket create(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        PDUPacketHeader pDUPacketHeader = PDUPacketHeader.create(dataInputStream);
        switch (pDUPacketHeader.getType()) {
            case 1: {
                return PDUPacketNetworkConnectionPingRequest.create(pDUPacketHeader, dataInputStream);
            }
            case 2: {
                return PDUPacketNetworkConnectionPingReply.create(pDUPacketHeader, dataInputStream);
            }
            case 3: {
                return PDUPacketClientConnectRequest.create(pDUPacketHeader, dataInputStream);
            }
            case 4: {
                return PDUPacketClientConnectReply.create(pDUPacketHeader, dataInputStream);
            }
            case 5: {
                return PDUPacketBrokerConnectRequest.create(pDUPacketHeader, dataInputStream);
            }
            case 6: {
                return PDUPacketBrokerConnectReply.create(pDUPacketHeader, dataInputStream);
            }
            case 7: {
                return PDUPacketJoinRequest.create(pDUPacketHeader, dataInputStream);
            }
            case 8: {
                return PDUPacketJoinReply.create(pDUPacketHeader, dataInputStream);
            }
            case 9: {
                return PDUPacketLeaveRequest.create(pDUPacketHeader, dataInputStream);
            }
            case 10: {
                return PDUPacketLeaveReply.create(pDUPacketHeader, dataInputStream);
            }
            case 11: {
                return PDUPacketMultiConnectionAck.create(pDUPacketHeader, dataInputStream);
            }
            case 12: {
                return PDUPacketMultiConnectionNack.create(pDUPacketHeader, dataInputStream);
            }
            case 13: {
                return PDUPacketMultiConnectionSync.create(pDUPacketHeader, dataInputStream);
            }
            case 14: {
                return PDUPacketMultiConnectionHandshakeRequest.create(pDUPacketHeader, dataInputStream);
            }
            case 15: {
                return PDUPacketMultiConnectionHandshakeReply.create(pDUPacketHeader, dataInputStream);
            }
            case 255: {
                return PDUPacketData.create(pDUPacketHeader, dataInputStream);
            }
        }
        throw new EIOException("Invalid packet type [" + pDUPacketHeader.getType() + "]");
    }

    public final void setHeader(PDUPacketHeader pDUPacketHeader) {
        this.header = pDUPacketHeader;
    }

    public final PDUPacketHeader getHeader() {
        return this.header;
    }

    public final void setObject(Object object) {
        this.object = object;
    }

    public final Object getObject() {
        return this.object;
    }

    public final void serialize(DataOutputStream dataOutputStream) throws EIOException {
        this.header.serialize(dataOutputStream);
        this.serializeBody(dataOutputStream);
    }

    public final String toString() {
        return "packet" + this.hashCode() + "<header=" + this.getHeader() + " body=" + this.bodyToString() + ">";
    }

    @Override
    public final int getWireSize() {
        return this.header.getWireSize() + this.getBodyWireSize();
    }

    @Override
    public final int getQod() {
        int n = 0;
        if (this.header.getZeroLatency()) {
            n |= 1;
        }
        if (this.header.getSynchronous()) {
            n |= 2;
        }
        return n;
    }

    @Override
    public final Object clone() {
        PDUPacket pDUPacket;
        try {
            pDUPacket = (PDUPacket)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Received CloneNotSupportedException even when we implement Cloneable!");
        }
        pDUPacket.setHeader((PDUPacketHeader)this.header.clone());
        this.cloneBody(pDUPacket);
        return pDUPacket;
    }
}

