/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketClientConnectRequest
extends PDUPacket {
    private String connectId;

    private PDUPacketClientConnectRequest(String string) {
        super((short)3);
        this.setConnectId(string);
    }

    private PDUPacketClientConnectRequest(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
        if (this.checked && pDUPacketHeader.getType() != 3) {
            throw new InternalError("CLIENT CONNECT REQUEST packet being constructed from stream but header indicates otherwise");
        }
    }

    private PDUPacketClientConnectRequest(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
        if (this.checked && pDUPacketHeader.getType() != 3) {
            throw new InternalError("CLIENT CONNECT REQUEST packet being constructed interactively but header indicates otherwise");
        }
    }

    @Override
    final void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        try {
            String string = this.connectId == null ? "" : this.connectId;
            dataOutputStream.writeShort(this.getBodyWireSize() - 2);
            dataOutputStream.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() >= 2) {
                short s = dataInputStream.readShort();
                if (dataInputStream.available() < s) {
                    throw new EIOInsufficientDataException(s - dataInputStream.available());
                }
            } else {
                throw new EIOInsufficientDataException();
            }
            this.setConnectId(dataInputStream.readUTF());
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        this.setConnectId(SysInteractive.ask("Connecting client connection id", printStream, bufferedReader, null));
    }

    @Override
    final void cloneBody(PDUPacket pDUPacket) {
    }

    @Override
    final int getBodyWireSize() {
        return 4 + (this.connectId == null ? 0 : this.connectId.length());
    }

    @Override
    final String bodyToString() {
        return "[" + this.getConnectId() + "]";
    }

    public static PDUPacketClientConnectRequest create(String string) {
        return new PDUPacketClientConnectRequest(string);
    }

    static PDUPacketClientConnectRequest create(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        return new PDUPacketClientConnectRequest(pDUPacketHeader, dataInputStream);
    }

    static PDUPacketClientConnectRequest create(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        return new PDUPacketClientConnectRequest(pDUPacketHeader, printStream, bufferedReader);
    }

    public final void setConnectId(String string) {
        this.connectId = string;
    }

    public final String getConnectId() {
        return this.connectId;
    }
}

