/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketData
extends PDUPacket {
    private long ts;
    private byte[] data;
    private int offset;
    private int length;

    private PDUPacketData(byte[] byArray, int n, int n2) {
        super((short)255);
        this.setData(byArray, n, n2);
    }

    private PDUPacketData(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
        if (this.checked && pDUPacketHeader.getType() != 255) {
            throw new InternalError("DATA packet being constructed from stream but header indicates otherwise");
        }
    }

    private PDUPacketData(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
        if (this.checked && pDUPacketHeader.getType() != 255) {
            throw new InternalError("DATA packet being constructed interactively but header indicates otherwise");
        }
    }

    @Override
    final void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        try {
            dataOutputStream.writeInt(this.getBodyWireSize() - 4);
            dataOutputStream.writeLong(this.ts);
            dataOutputStream.writeInt(this.length);
            if (this.length > 0) {
                dataOutputStream.write(this.data, this.offset, this.length);
            }
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    final void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() < 4) throw new EIOInsufficientDataException();
            int n = dataInputStream.readInt();
            if (dataInputStream.available() < n) throw new EIOInsufficientDataException(n - dataInputStream.available());
            this.setTimestamp(dataInputStream.readLong());
            int n2 = dataInputStream.readInt();
            byte[] byArray = new byte[n2];
            if (n2 > 0) {
                dataInputStream.readFully(byArray);
            }
            this.setData(byArray, 0, byArray.length);
            return;
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        int n = Math.max((int)SysInteractive.ask("Data length", printStream, bufferedReader, 0.0), 0);
        this.setData(n > 0 ? new byte[n] : null, 0, n);
        if (SysInteractive.askYesNo("Set timestamp <yes/no>", printStream, bufferedReader, false)) {
            this.setTimestamp(System.currentTimeMillis());
        }
    }

    @Override
    final void cloneBody(PDUPacket pDUPacket) {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        ((PDUPacketData)pDUPacket).setData(byArray, 0, this.length);
    }

    @Override
    final int getBodyWireSize() {
        return 16 + this.length;
    }

    @Override
    final String bodyToString() {
        return "[" + this.getTimestamp() + "," + (this.data != null ? this.getData().length : 0) + "]";
    }

    public static PDUPacketData create(byte[] byArray, int n, int n2) {
        return new PDUPacketData(byArray, n, n2);
    }

    public static PDUPacketData create(byte[] byArray, int n) {
        return PDUPacketData.create(byArray, 0, n);
    }

    public static PDUPacketData create(byte[] byArray) {
        return PDUPacketData.create(byArray, 0, byArray.length);
    }

    static PDUPacketData create(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        return new PDUPacketData(pDUPacketHeader, dataInputStream);
    }

    static PDUPacketData create(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        return new PDUPacketData(pDUPacketHeader, printStream, bufferedReader);
    }

    public final void setTimestamp(long l) {
        this.ts = l;
    }

    public final long getTimestamp() {
        return this.ts;
    }

    public final void setData(byte[] byArray, int n, int n2) {
        if (n < 0 || byArray.length > 0 && n >= byArray.length) {
            throw new IllegalArgumentException("Invalid offset [offset=" + n + " array length=" + byArray.length + "]");
        }
        if (n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Invalid data length [length=" + n2 + " remaining array length=" + (byArray.length - n) + "]");
        }
        this.data = byArray;
        this.offset = n;
        this.length = n2;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final int getDataOffset() {
        return this.offset;
    }

    public final int getDataLength() {
        return this.length;
    }
}

