/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketMultiConnectionHandshakeRequest
extends PDUPacket {
    private String id;

    private PDUPacketMultiConnectionHandshakeRequest(String string) {
        super((short)14);
        this.setId(string);
    }

    private PDUPacketMultiConnectionHandshakeRequest(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
        if (this.checked && pDUPacketHeader.getType() != 14) {
            throw new InternalError("MCONN HANDSHAKE REQUEST packet being constructed from stream but header indicates otherwise");
        }
    }

    private PDUPacketMultiConnectionHandshakeRequest(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
        if (this.checked && pDUPacketHeader.getType() != 14) {
            throw new InternalError("MCONN HANDSHAKE REQUEST packet being constructed interactively but header indicates otherwise");
        }
    }

    @Override
    final void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        try {
            String string = this.id == null ? "" : this.id;
            dataOutputStream.writeShort(this.getBodyWireSize() - 2);
            dataOutputStream.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() >= 2) {
                short s = dataInputStream.readShort();
                if (dataInputStream.available() < s) {
                    throw new EIOInsufficientDataException(s - dataInputStream.available());
                }
            } else {
                throw new EIOInsufficientDataException();
            }
            this.setId(dataInputStream.readUTF());
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        this.setId(SysInteractive.ask("ID", printStream, bufferedReader, ""));
    }

    @Override
    final void cloneBody(PDUPacket pDUPacket) {
    }

    @Override
    final int getBodyWireSize() {
        return 2 + (2 + (this.id == null ? 0 : this.id.length()));
    }

    @Override
    final String bodyToString() {
        return "[" + this.id + "]";
    }

    public static PDUPacketMultiConnectionHandshakeRequest create(String string) {
        return new PDUPacketMultiConnectionHandshakeRequest(string);
    }

    static PDUPacketMultiConnectionHandshakeRequest create(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        return new PDUPacketMultiConnectionHandshakeRequest(pDUPacketHeader, dataInputStream);
    }

    static PDUPacketMultiConnectionHandshakeRequest create(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        return new PDUPacketMultiConnectionHandshakeRequest(pDUPacketHeader, printStream, bufferedReader);
    }

    public final void setId(String string) {
        this.id = string;
    }

    public final String getId() {
        return this.id;
    }
}

