/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.odi.FatalException;
import com.odi.SessionException;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.comm.jms.DurableConnector;
import com.sonicsw.mf.common.IComponent;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IFSElementChange;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.config.impl.ChangeRegistration;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.runtime.ICollectiveOpStatus;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.IFaultTolerantState;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.ISubComponentState;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.CollectiveOpStatus;
import com.sonicsw.mf.common.runtime.impl.ComponentIdentity;
import com.sonicsw.mf.common.runtime.impl.ComponentState;
import com.sonicsw.mf.common.runtime.impl.SubComponentState;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.INotificationHandler;
import com.sonicsw.mf.framework.ITaskScheduler;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.ExceptionMapper;
import com.sonicsw.mf.framework.agent.JMSConnectorServer;
import com.sonicsw.mf.framework.agent.NotificationHandlerDelegate;
import com.sonicsw.mf.framework.directory.DSComponent;
import com.sonicsw.mf.jmx.client.MFNotification;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.naming.Context;

public abstract class AbstractMBean
implements DynamicMBean,
NotificationEmitter {
    private static final boolean DEBUG = false;
    private static final long DEFAULT_NOTIFICATION_HANDLERS_SYNC_TIME_FRAME = 30L;
    private static final String NOTIFICATION_HANDLERS_SYNC_TIME_PROPERTY = "notification.handlers.sync.time";
    private ScheduledThreadPoolExecutor m_notificationsThreadPoolExecutor = new ScheduledThreadPoolExecutor(2);
    private List<Runnable> m_notificationsList = new ArrayList<Runnable>();
    private static Long m_notificationHandlersSyncTime;
    private boolean m_isClosing = false;
    ContainerImpl m_container;
    IComponent m_component;
    private MBeanInfo m_mbeanInfo;
    private String m_releaseVersion;
    private Timer m_commonTimer;
    private Hashtable m_scheduledTasks = new Hashtable();
    private HashMap m_notificationSources = new HashMap();
    private Thread m_notificationSubscriptionRenewalThread;
    private HashMap m_notificationHandlers = new HashMap();
    private HashMap m_lastHandlerRenewals = new HashMap();
    private HashMap m_notificationListeners = new HashMap();
    private long[] m_notificationSequenceNumber;
    private Hashtable m_acceptChangesList = new Hashtable();
    private ChangeRegistration m_changeRegistration = new ChangeRegistration();
    Class m_componentClass;
    ClassLoader m_componentClassLoader;
    boolean m_isDifferentClassLoader;
    CanonicalName m_componentName;
    ObjectName m_objectName;
    private String m_taskThreadName;
    private String m_timerTaskThreadName;
    private String m_configID;
    private IElementIdentity m_elementIdentity;
    private String m_lastErrorDescription;
    private int m_lastErrorLevel;
    IComponentContext m_componentContext;
    private String m_classpath;
    private int m_traceMaskOnCleanup;
    private Long m_notificationSubscriptionTimeout = new Long(DurableConnector.DURABLE_SUBSCRIPTION_TTL);
    private long m_notificationSubscriptionRenewalInterval = 30000L;
    private String m_agentManagerID;
    protected ArrayList m_attributes = new ArrayList();
    protected ArrayList m_operations = new ArrayList();
    protected ArrayList m_notifications = new ArrayList();
    static final ArrayList DEFAULT_ATTRIBUTE_INFOS;
    static final ArrayList DEFAULT_OPERATION_INFOS;
    static final ArrayList DEFAULT_NOTIFICATION_INFOS;
    private static final String[][] EMPTY_STRING_ARRAY_ARRAY;
    private static final Object[] GET_FT_STATE_ATTR_PARAMS;
    private static final String[] HANDLE_NOTIFICATION_SIGNATURE;
    private static final String[] HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE;
    static final String[] SET_ATTRIBUTES_SIGNATURE;
    static final String[] GET_ATTRIBUTE_VALUES_SIGNATURE;
    private static Method RELOAD_METHOD;
    private static Method HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD;
    private static Method SET_ATTRIBUTES_METHOD;
    private static Method GET_ATTRIBUTE_VALUES_METHOD;
    private static Method GET_MBEAN_INFO_METHOD;
    private static final Integer LOGICAL_NOTIFY;
    private static final Integer FILE_NOTIFY;
    public static final String LOGGED_MESSAGE_TO_NOTIFICATION = "LoggedMessage";
    private static final String HANDLE_NOTIFICATION_METHOD_NAME = "handleNotification";
    private static final String HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD_NAME = "handleNotificationSubscription";
    private static final String LOG_MESSAGE_METHOD_NAME = "logMessage";
    private static final String RECORD_AUDIT_EVENT_METHOD_NAME = "recordAuditEvent";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractMBean(ContainerImpl container, IComponent component, String id, String configID) throws Exception {
        int i;
        MBeanOperationInfo[] operationInfos;
        this.m_container = container;
        this.m_component = component;
        this.m_componentContext = this.retrieveContext();
        this.m_componentClass = this.m_component.getClass();
        this.m_componentClassLoader = this.m_componentClass.getClassLoader();
        this.m_isDifferentClassLoader = this.m_componentClassLoader != this.m_container.m_defaultClassLoader;
        IContainerIdentity containerIdentity = this.m_container.getContainerIdentity();
        this.m_objectName = new ObjectName(containerIdentity.getDomainName() + '.' + containerIdentity.getContainerName() + ':' + "ID=" + id);
        this.m_componentName = new CanonicalName(this.m_objectName.getCanonicalName());
        this.m_taskThreadName = this.m_componentName.getComponentName() + " - Task";
        this.m_timerTaskThreadName = this.m_componentName.getComponentName() + " - Timer Task";
        this.m_configID = configID;
        IElement element = this.m_container.getConfiguration(configID);
        this.m_elementIdentity = element.getIdentity();
        this.m_agentManagerID = this.m_componentName.getDomainName() + '.' + "AGENT MANAGER" + ':' + "ID=" + "AGENT MANAGER";
        this.m_lastErrorDescription = "";
        this.m_lastErrorLevel = 0;
        try {
            if (this.m_isDifferentClassLoader) {
                Thread.currentThread().setContextClassLoader(this.m_componentClassLoader);
            }
            this.m_releaseVersion = this.m_componentContext.getConfiguration(false).getIdentity().getReleaseVersion();
            this.m_component.init(this.m_componentContext);
        }
        finally {
            this.checkDifferentClassLoader();
        }
        this.m_attributes.addAll(DEFAULT_ATTRIBUTE_INFOS);
        if (id.equals("AGENT")) {
            operationInfos = DEFAULT_OPERATION_INFOS.toArray(new MBeanOperationInfo[0]);
            for (i = 0; i < operationInfos.length; ++i) {
                if ("start,stop,reload".indexOf(operationInfos[i].getName()) != -1) continue;
                this.m_operations.add(operationInfos[i]);
            }
        } else if (id.equals("DIRECTORY SERVICE")) {
            operationInfos = DEFAULT_OPERATION_INFOS.toArray(new MBeanOperationInfo[0]);
            for (i = 0; i < operationInfos.length; ++i) {
                if ("reload".indexOf(operationInfos[i].getName()) != -1) continue;
                this.m_operations.add(operationInfos[i]);
            }
        } else {
            this.m_operations.addAll(DEFAULT_OPERATION_INFOS);
        }
        if (id.equals("AGENT")) {
            MBeanNotificationInfo[] notificationInfos = DEFAULT_NOTIFICATION_INFOS.toArray(new MBeanNotificationInfo[0]);
            for (i = 0; i < notificationInfos.length; ++i) {
                if (MFNotification.getType((String[])notificationInfos[i].getNotifTypes()).equals(INotification.CATEGORY_TEXT[0] + '.' + INotification.SUBCATEGORY_TEXT[0] + '.' + IComponentState.STATE_TEXT[1])) continue;
                this.m_notifications.add(notificationInfos[i]);
            }
        } else {
            this.m_notifications.addAll(DEFAULT_NOTIFICATION_INFOS);
        }
    }

    private IComponentContext retrieveContext() {
        return this.getContext();
    }

    abstract IComponentContext getContext();

    Context getInitialContext() {
        return this.m_container.getInitialContext();
    }

    String[] getAllAcceptedChanges() {
        if (this.m_componentContext != null) {
            String[] resultList = new String[this.m_acceptChangesList.size()];
            Enumeration allChanges = this.m_acceptChangesList.keys();
            for (int i = 0; i < resultList.length; ++i) {
                resultList[i] = (String)allChanges.nextElement();
            }
            return resultList;
        }
        throw new Error("No Context");
    }

    void handleFileChange(IFSElementChange change) {
        if (change.getChangeType() == 1) {
            this.setDelta((IDeltaElement)change.getElement());
        } else if (change.getChangeType() == 2) {
            this.setDeletedElementName(change.getElement().getIdentity().getName());
        }
        this.m_component.handleFileChange(change);
        this.adjustHandlers();
    }

    void handleElementChange(IElementChange change) {
        if (change.getChangeType() == 1) {
            this.setDelta((IDeltaElement)change.getElement());
        } else if (change.getChangeType() == 2) {
            this.setDeletedElementName(change.getElement().getIdentity().getName());
        }
        this.m_component.handleElementChange(change);
        this.adjustHandlers();
    }

    IComponent getManagedComponent() {
        return this.m_component;
    }

    IComponentState getComponentState() {
        return new ComponentState(this.m_componentName, this.m_elementIdentity, this.m_component.getState().shortValue(), this.m_lastErrorDescription, this.m_lastErrorLevel, this.getSubComponentStates());
    }

    private Map<String, ISubComponentState[]> getSubComponentStates() {
        try {
            Method getSubComponentStatesMethod = this.m_component.getClass().getMethod("getSubComponentStates", new Class[0]);
            Map rawTypes = (Map)getSubComponentStatesMethod.invoke((Object)this.m_component, new Object[0]);
            HashMap<String, ISubComponentState[]> typeStates = new HashMap<String, ISubComponentState[]>();
            for (Map.Entry typeEntry : rawTypes.entrySet()) {
                String type = (String)typeEntry.getKey();
                Set entries = ((Map)typeEntry.getValue()).entrySet();
                ISubComponentState[] subComponentStates = new ISubComponentState[entries.size()];
                int i = 0;
                for (Map.Entry stateEntry : entries) {
                    subComponentStates[i++] = new SubComponentState(this.m_componentName, this.m_elementIdentity, (String)stateEntry.getKey(), type, ((Short)stateEntry.getValue()).shortValue());
                }
                typeStates.put(type, subComponentStates);
            }
            return typeStates;
        }
        catch (Exception e) {
            return null;
        }
    }

    final void preCleanup() {
        this.m_isClosing = true;
    }

    void reload() throws Exception {
        this.preCleanup();
        this.m_container.reloadComponent(this.m_componentName.getComponentName());
    }

    synchronized void clearError() {
        this.m_lastErrorLevel = 0;
        this.m_lastErrorDescription = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNotification(INotification notification) {
        String forwardedBy;
        HashMap attributes;
        CanonicalName notificationSource = new CanonicalName(notification.getSourceIdentity().getCanonicalName());
        String notificationType = notification.getType();
        if (notificationType.startsWith(INotification.CATEGORY_TEXT[0]) && this.m_componentName.getCanonicalName().endsWith("AGENT MANAGER")) {
            ((INotificationHandler)this.m_component).handleNotification(notification);
        }
        if ((attributes = notification.getAttributes()) != null && (forwardedBy = (String)attributes.get("ForwardedBy")) != null) {
            notificationSource = new CanonicalName(forwardedBy);
        }
        HashMap handlers = null;
        HashMap hashMap = this.m_notificationSources;
        synchronized (hashMap) {
            handlers = this.getNotificationSourceHandlers(notificationSource);
        }
        if (handlers == null) {
            return;
        }
        block3: for (Map.Entry entry : handlers.entrySet()) {
            String[] notificationTypes = (String[])entry.getValue();
            for (int i = 0; i < notificationTypes.length; ++i) {
                String notificationTypeSubstring;
                if (notificationTypes[i].equals(notificationType)) {
                    ((INotificationHandler)entry.getKey()).handleNotification(notification);
                    continue block3;
                }
                if (!notificationTypes[i].endsWith("*")) continue;
                int index = notificationTypes[i].indexOf("*");
                String typeSubstring = notificationTypes[i].substring(0, index - 1);
                if (notificationType.length() < index || !typeSubstring.equals(notificationTypeSubstring = notificationType.substring(0, index - 1))) continue;
                ((INotificationHandler)entry.getKey()).handleNotification(notification);
                continue block3;
            }
        }
    }

    private HashMap getNotificationSourceHandlers(CanonicalName notificationSource) {
        String componentName = notificationSource.getComponentName();
        if (componentName.compareTo(notificationSource.getContainerName()) == 0) {
            return (HashMap)this.m_notificationSources.get(notificationSource.getCanonicalName());
        }
        for (Map.Entry entry : this.m_notificationSources.entrySet()) {
            if (!((String)entry.getKey()).endsWith(":ID=" + componentName)) continue;
            return (HashMap)entry.getValue();
        }
        return null;
    }

    void handleFSNamingNotification(INamingNotification notification) {
        this.m_component.handleFSNamingNotification(notification);
    }

    void cleanup() {
        this.stopNotificationRenewal();
        Object[] tasks = this.m_scheduledTasks.keySet().toArray();
        for (int i = 0; i < tasks.length; ++i) {
            this.cancelTask((Runnable)tasks[i]);
        }
        this.m_traceMaskOnCleanup = this.m_component.getTraceMask();
        this.m_component = null;
        this.m_componentContext = null;
        this.m_componentClassLoader = null;
        this.m_elementIdentity = null;
    }

    void loadComponent(String id, String configID, boolean start, int traceMask) throws Exception {
        this.m_container.loadComponent(id, configID, start, traceMask, false);
    }

    void unloadComponent(String id) throws Exception {
        this.m_container.unloadComponent(id);
    }

    String getConfigID() {
        return this.m_configID;
    }

    Boolean acceptChanges(String elementName, String dirName) {
        if (this.m_componentContext != null) {
            return new Boolean(this.acceptChanges(elementName) || this.acceptChanges(dirName));
        }
        throw new Error("No Context");
    }

    boolean isLogicalRequest(String elementName) {
        Object hashEntry = this.m_acceptChangesList.get(elementName);
        return hashEntry != null && (hashEntry.equals(LOGICAL_NOTIFY) || hashEntry.equals(FILE_NOTIFY));
    }

    boolean isFileRequest(String elementName) {
        Object hashEntry = this.m_acceptChangesList.get(elementName);
        return hashEntry != null && hashEntry.equals(FILE_NOTIFY);
    }

    void setRuntimeConfiguration(IDirElement configuration) {
        this.m_container.setRuntimeConfiguration(configuration);
    }

    IElement getConfiguration(String configID, boolean acceptChanges) {
        return this.getConfiguration(configID, acceptChanges, false);
    }

    IElement getConfiguration(String configIDParam, boolean acceptChanges, boolean alwaysFromDS) {
        Object acceptType;
        String configID = configIDParam;
        if (configID == null) {
            configID = this.m_configID;
        }
        if (acceptChanges && this.m_acceptChangesList.get(configID) == null) {
            this.m_acceptChangesList.put(configID, configID);
        }
        if (!acceptChanges && (acceptType = this.m_acceptChangesList.get(configID)) != null && acceptType.equals(configID)) {
            this.m_acceptChangesList.remove(configID);
        }
        return this.m_container.getConfiguration(configID, alwaysFromDS);
    }

    public int checkFSConfiguration(String path) {
        return this.m_container.checkFSConfiguration(path);
    }

    IElement getFSConfiguration(String path, boolean notify) {
        return this.getFSConfiguration(path, notify, false);
    }

    IElement getFSConfiguration(String path, boolean notify, boolean alwaysFromDS) {
        IElement fsElement = this.m_container.getFSConfiguration(path, alwaysFromDS);
        if (fsElement != null && notify) {
            this.m_acceptChangesList.put(fsElement.getIdentity().getName(), LOGICAL_NOTIFY);
        }
        if (!notify && fsElement != null) {
            String storageName = fsElement.getIdentity().getName();
            this.m_acceptChangesList.remove(storageName);
        }
        return fsElement;
    }

    IElement registerFileChangeInterest(String path) {
        IElement fileEnvelope = this.retrieveConfiguration(path);
        if (fileEnvelope != null) {
            this.m_acceptChangesList.put(fileEnvelope.getIdentity().getName(), FILE_NOTIFY);
        }
        return fileEnvelope;
    }

    void unregisterFileChangeInterest(String path) {
        IElement fileEnvelope = this.retrieveConfiguration(path);
        if (fileEnvelope != null) {
            this.m_acceptChangesList.remove(fileEnvelope.getIdentity().getName());
        }
    }

    private IElement retrieveConfiguration(String path) {
        String configName = path;
        String sonicFSPrefix = "sonicfs:///".substring(0, "sonicfs:///".length() - 1);
        if (configName.startsWith(sonicFSPrefix)) {
            configName = configName.substring(sonicFSPrefix.length());
        }
        if (!configName.startsWith(DSComponent.MF_DIR_SEPARATOR_STRING)) {
            String domainName = configName.substring(0, configName.indexOf(DSComponent.MF_DIR_SEPARATOR_STRING));
            if (!domainName.equals(this.m_componentName.getDomainName())) {
                throw new MFRuntimeException("Domain name in register file interest is not known: " + domainName);
            }
            configName = configName.substring(configName.indexOf(DSComponent.MF_DIR_SEPARATOR_STRING));
        }
        IElement fileEnvelope = this.m_container.getFSConfiguration(configName);
        return fileEnvelope;
    }

    File getLocalFile(String path) throws MFException {
        return this.m_container.getLocalFile(path);
    }

    String getPrivateSubDir(String baseDir) {
        return this.m_container.getPrivateSubDir(this.m_configID, baseDir);
    }

    IElement[] getConfigurations(String[] configIDs, boolean[] acceptChanges) {
        if (configIDs == null || acceptChanges == null) {
            throw new IllegalArgumentException("The parameters must not be 'null'.'");
        }
        if (configIDs.length != acceptChanges.length) {
            throw new IllegalArgumentException("'acceptChanges' must have the same number of array elements as 'configIDs'.");
        }
        for (int i = 0; i < configIDs.length; ++i) {
            if (!acceptChanges[i] || this.m_acceptChangesList.get(configIDs[i]) != null) continue;
            this.m_acceptChangesList.put(configIDs[i], configIDs[i]);
        }
        return this.m_container.getConfigurations(configIDs);
    }

    IElement[] getConfigurations(String dirName, boolean acceptChanges) {
        if (acceptChanges) {
            this.m_acceptChangesList.put(dirName, dirName);
        }
        return this.m_container.getConfigurations(dirName, new Boolean(acceptChanges));
    }

    private boolean acceptChanges(String entityName) {
        return this.m_acceptChangesList.containsKey(entityName);
    }

    synchronized boolean registerErrorCondition(String errorMessage, int errorLevel) {
        if (errorLevel < 0 || errorLevel > 2) {
            throw new IllegalArgumentException("Illegal error level: " + errorLevel);
        }
        if (this.m_lastErrorLevel != 0 && errorLevel > this.m_lastErrorLevel) {
            return false;
        }
        this.m_lastErrorLevel = errorLevel;
        this.m_lastErrorDescription = errorMessage == null ? "" : errorMessage;
        return true;
    }

    abstract void addSharedPath(URL var1) throws UnsupportedOperationException;

    abstract void addSharedClassname(String var1) throws UnsupportedOperationException;

    boolean isOperationExported(String operationName, String[] signature) {
        if (this.getOperationInfo(operationName, signature) == null) {
            if (operationName.equals(HANDLE_NOTIFICATION_METHOD_NAME) && signature.length == 1 && signature[0].equals(HANDLE_NOTIFICATION_SIGNATURE[0])) {
                return true;
            }
            if (operationName.equals(LOG_MESSAGE_METHOD_NAME) && this.m_componentName.getComponentName().equals("AGENT MANAGER")) {
                return true;
            }
            if (operationName.equals(RECORD_AUDIT_EVENT_METHOD_NAME) && this.m_componentName.getComponentName().equals("AGENT MANAGER")) {
                return true;
            }
            if (operationName.equals(HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD_NAME) && signature.length == 3 && signature[0].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[0]) && signature[1].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[1]) && signature[2].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[2])) {
                return true;
            }
            if (operationName.equals("setAttributes") && signature.length == 2 && signature[0].equals(SET_ATTRIBUTES_SIGNATURE[0]) && signature[1].equals(SET_ATTRIBUTES_SIGNATURE[1])) {
                return true;
            }
            if (operationName.equals("getAttributeValues") && signature.length == 1 && signature[0].equals(GET_ATTRIBUTE_VALUES_SIGNATURE[0])) {
                return true;
            }
            try {
                Class[] classes = new Class[signature.length];
                for (int i = 0; i < signature.length; ++i) {
                    classes[i] = Class.forName(signature[i]);
                }
                DynamicMBean.class.getDeclaredMethod(operationName, classes);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    ObjectName getObjectName() {
        return this.m_objectName;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MBeanAttributeInfo info = this.retrieveAttributeAndValidate(name);
        if (!info.isReadable()) {
            throw new AttributeNotFoundException(name + " is not a readable attribute.");
        }
        if (name.equals("ConfigID")) {
            return this.m_configID;
        }
        if (name.equals("Classname")) {
            return this.m_componentClass.getName();
        }
        if (name.equals("ReleaseVersion")) {
            return this.m_releaseVersion;
        }
        if (name.equals("LastError")) {
            return this.m_lastErrorDescription;
        }
        if (name.equals("LastErrorLevel")) {
            return new Integer(this.m_lastErrorLevel);
        }
        if (name.equals("LastErrorLevelString")) {
            return Level.LEVEL_TEXT[this.m_lastErrorLevel];
        }
        if (name.equals("Classpath")) {
            return this.m_classpath == null ? this.getClasspath() : this.m_classpath;
        }
        try {
            if (this.m_component instanceof DynamicMBean) {
                return ((DynamicMBean)this.m_component).getAttribute(name);
            }
            Method method = this.m_componentClass.getMethod("get" + name, IEmptyArray.EMPTY_CLASS_ARRAY);
            return method.invoke((Object)this.m_component, IEmptyArray.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            if (e instanceof NoSuchMethodException) {
                throw new ReflectionException(e);
            }
            throw new MBeanException(e);
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < names.length; ++i) {
            try {
                attributeList.add(new Attribute(names[i], this.getAttribute(names[i])));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return attributeList;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            if (this.m_component instanceof DynamicMBean) {
                ((DynamicMBean)this.m_component).setAttribute(attribute);
                return;
            }
            String name = attribute.getName();
            MBeanAttributeInfo info = this.validateAttribute(name);
            Object value = this.getAttributeValue(attribute, info);
            this.setAttribute(name, value);
        }
        catch (Exception e) {
            if (e instanceof NoSuchMethodException) {
                throw new ReflectionException(e);
            }
            throw new MBeanException(e);
        }
    }

    MBeanAttributeInfo validateAttribute(String name) throws AttributeNotFoundException {
        MBeanAttributeInfo info = this.retrieveAttributeAndValidate(name);
        if (!info.isWritable()) {
            throw new AttributeNotFoundException(name + " is not a writeable attribute.");
        }
        return info;
    }

    private MBeanAttributeInfo retrieveAttributeAndValidate(String name) throws AttributeNotFoundException {
        MBeanAttributeInfo info = this.getAttributeInfo(name);
        if (info == null) {
            throw new AttributeNotFoundException(name + " is not a valid attribute.");
        }
        return info;
    }

    Object getAttributeValue(Attribute attribute, MBeanAttributeInfo info) throws InvalidAttributeValueException {
        Object value = attribute.getValue();
        if (value != null && !value.getClass().getName().equals(info.getType())) {
            throw new InvalidAttributeValueException();
        }
        return value;
    }

    public String[] setAttributes(String[] names, Object[] values) {
        if (names.length != values.length) {
            throw new RuntimeException("The number of attribute names does not match the number of values.");
        }
        if (values.length == 0) {
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }
        AttributeList attributes = new AttributeList();
        for (int i = 0; i < names.length; ++i) {
            attributes.add(new Attribute(names[i], values[i]));
        }
        AttributeList updatedAttributes = this.setAttributes(attributes);
        String[] returnValue = new String[updatedAttributes.size()];
        for (int i = 0; i < updatedAttributes.size(); ++i) {
            returnValue[i] = ((Attribute)updatedAttributes.get(i)).getName();
        }
        return returnValue;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList updatedAttributes = new AttributeList();
        int length = attributes.size();
        for (int i = 0; i < length; ++i) {
            Attribute attribute = (Attribute)attributes.get(i);
            try {
                this.setAttribute(attribute);
                updatedAttributes.add(attribute);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return updatedAttributes;
    }

    @Override
    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        MBeanOperationInfo info = this.getOperationInfo(operationName, signature);
        if (info == null) {
            throw new ReflectionException(new NoSuchMethodException(), "Unknown operation: " + operationName);
        }
        try {
            return this.internalInvoke(operationName, params, signature);
        }
        catch (Throwable e) {
            block7: {
                try {
                    ExceptionMapper.throwMappedException(e, false, false);
                }
                catch (MBeanException mBeanException) {
                    throw mBeanException;
                }
                catch (ReflectionException reflectionException) {
                    throw reflectionException;
                }
                catch (Exception exception) {
                    if (!(exception instanceof RuntimeException)) break block7;
                    throw (RuntimeException)exception;
                }
            }
            this.logMessage("Please report to Sonic the following trace...", e, 2);
            throw new RuntimeErrorException(new Error("Runtime error: check agent for details"));
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.m_mbeanInfo == null) {
            MBeanOperationInfo[] operations;
            MBeanAttributeInfo[] attributes;
            if (this.m_component instanceof DynamicMBean) {
                this.m_mbeanInfo = ((DynamicMBean)this.m_component).getMBeanInfo();
                attributes = this.m_mbeanInfo.getAttributes();
                this.cloneAttributes(attributes);
                operations = this.m_mbeanInfo.getOperations();
                this.cloneOperations(operations);
                MBeanNotificationInfo[] notifications = this.m_mbeanInfo.getNotifications();
                this.cloneNotifications(notifications);
            } else {
                attributes = this.m_component.getAttributeInfos();
                this.cloneAttributes(attributes);
                operations = this.m_component.getOperationInfos();
                this.cloneOperations(operations);
                MBeanNotificationInfo[] notifications = this.m_component.getNotificationInfos();
                this.cloneNotifications(notifications);
            }
            Class<?> mBeanClass = this.getClass();
            MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{new MBeanConstructorInfo("Framework constructor", mBeanClass.getConstructors()[0])};
            this.m_mbeanInfo = new MBeanInfo(mBeanClass.getName(), "Sonic MBean", this.m_attributes.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY), constructors, this.m_operations.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY), this.m_notifications.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY));
        }
        return this.m_mbeanInfo;
    }

    private void cloneNotifications(MBeanNotificationInfo[] notifications) {
        if (notifications != null) {
            for (int i = 0; i < notifications.length; ++i) {
                this.m_notifications.add(notifications[i]);
            }
        }
    }

    private void cloneOperations(MBeanOperationInfo[] operations) {
        if (operations != null) {
            for (int i = 0; i < operations.length; ++i) {
                this.m_operations.add(operations[i]);
            }
        }
    }

    private void cloneAttributes(MBeanAttributeInfo[] attributes) {
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                this.m_attributes.add(attributes[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        HashMap hashMap = this.m_notificationListeners;
        synchronized (hashMap) {
            ArrayList<NotificationFilter> filters;
            HashMap handbacks = (HashMap)this.m_notificationListeners.get(listener);
            if (handbacks == null) {
                handbacks = new HashMap();
                this.m_notificationListeners.put(listener, handbacks);
            }
            if ((filters = (ArrayList<NotificationFilter>)handbacks.get(handback)) == null) {
                filters = new ArrayList<NotificationFilter>();
                handbacks.put(handback, filters);
            }
            if (!filters.contains(filter)) {
                filters.add(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        AbstractMBean.logRemoveNotificationListener();
        HashMap hashMap = this.m_notificationListeners;
        synchronized (hashMap) {
            HashMap handbacks = (HashMap)this.m_notificationListeners.get(listener);
            if (handbacks == null) {
                throw new ListenerNotFoundException("Unknown listener");
            }
            ArrayList filters = (ArrayList)handbacks.get(handback);
            if (filters == null) {
                throw new ListenerNotFoundException("Unknown handback");
            }
            if (!filters.remove(filter)) {
                throw new ListenerNotFoundException("Unknown filter");
            }
            if (filters.isEmpty()) {
                handbacks.remove(handback);
                if (handbacks.isEmpty()) {
                    this.m_notificationListeners.remove(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        AbstractMBean.logRemoveNotificationListener();
        HashMap hashMap = this.m_notificationListeners;
        synchronized (hashMap) {
            if (this.m_notificationListeners.remove(listener) == null) {
                throw new ListenerNotFoundException("Unknown listener");
            }
        }
    }

    private static void logRemoveNotificationListener() {
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.m_mbeanInfo.getNotifications();
    }

    private String getClasspath() {
        StringBuffer sb = new StringBuffer();
        URL[] urls = ((URLClassLoader)this.m_componentClassLoader).getURLs();
        for (int i = 0; i < urls.length; ++i) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(urls[i].toExternalForm());
        }
        return sb.toString();
    }

    MBeanAttributeInfo getAttributeInfo(String name) {
        MBeanAttributeInfo[] attributes = this.m_mbeanInfo.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(name)) continue;
            return attributes[i];
        }
        return null;
    }

    private MBeanOperationInfo getOperationInfo(String operationName, String[] signature) {
        MBeanOperationInfo[] operations = this.m_mbeanInfo.getOperations();
        for (int i = 0; i < operations.length; ++i) {
            MBeanParameterInfo[] params;
            if (!operations[i].getName().equals(operationName) || (params = operations[i].getSignature()).length != signature.length) continue;
            for (int j = 0; j < params.length; ++j) {
                if (params[j].getType().equals(signature[j])) continue;
            }
            return operations[i];
        }
        return null;
    }

    public Object[] getAttributeValues(String[] names) {
        Object[] values = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            try {
                values[i] = this.getAttribute(names[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttribute(String name, Object valueParam) throws Exception {
        Object value = valueParam;
        int traceMask = this.m_component.getTraceMask();
        Object originalValue = null;
        if ((traceMask & 3) > 0) {
            originalValue = this.getAttribute(name);
        }
        Method method = this.m_componentClass.getMethod("set" + name, value.getClass());
        try {
            if (this.m_isDifferentClassLoader) {
                Thread.currentThread().setContextClassLoader(this.m_componentClassLoader);
                value = ContainerUtil.transferObject(value, this.m_componentClassLoader);
            }
            method.invoke((Object)this.m_component, value);
        }
        finally {
            this.checkDifferentClassLoader();
        }
        if ((traceMask & 2) > 0) {
            StringBuffer msg = new StringBuffer("Set attribute [" + name + "]");
            if ((traceMask & 1) > 0) {
                msg.append(", values...");
                msg.append(IContainer.NEWLINE).append("\tOriginal value = ").append(originalValue);
                msg.append(IContainer.NEWLINE).append("\tNew value      = ").append(value);
            }
            this.logMessage(msg.toString(), 7);
        }
    }

    private void checkDifferentClassLoader() {
        if (this.m_isDifferentClassLoader) {
            Thread.currentThread().setContextClassLoader(this.m_container.m_defaultClassLoader);
        }
    }

    Object internalInvoke(String operationName, Object[] params, String[] signature) throws Exception {
        Object returnValue = null;
        try {
            Method method = null;
            AbstractMBean target = null;
            if (operationName.equals("reload") && signature.length == 0) {
                target = this;
                method = RELOAD_METHOD;
            } else if (operationName.equals(HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD_NAME) && signature.length == 3 && signature[0].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[0]) && signature[1].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[1]) && signature[2].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[2])) {
                target = this;
                method = HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD;
            } else if (operationName.equals("setAttributes") && signature.length == 2 && signature[0].equals(SET_ATTRIBUTES_SIGNATURE[0]) && signature[1].equals(SET_ATTRIBUTES_SIGNATURE[1])) {
                target = this;
                method = SET_ATTRIBUTES_METHOD;
            } else if (operationName.equals("getAttributeValues") && signature.length == 1 && signature[0].equals(GET_ATTRIBUTE_VALUES_SIGNATURE[0])) {
                target = this;
                method = GET_ATTRIBUTE_VALUES_METHOD;
            } else if (operationName.equals("getMBeanInfo") && signature.length == 0) {
                target = this;
                method = GET_MBEAN_INFO_METHOD;
            } else if (operationName.equals("start") && this.m_container.isFTContainer() && !this.m_container.isFailingOver() && !this.m_container.getContainerFT().isActive()) {
                throw new IllegalStateException("Cannot start component when the container is " + IFaultTolerantState.STATE_TEXT[this.m_container.getContainerFT().getState()]);
            }
            if (target == null && !((target = this.m_component) instanceof DynamicMBean)) {
                Class[] parameterTypes = new Class[signature.length];
                for (int i = 0; i < signature.length; ++i) {
                    parameterTypes[i] = this.m_componentClassLoader.loadClass(signature[i]);
                }
                method = this.m_componentClass.getMethod(operationName, parameterTypes);
            }
            returnValue = method == null ? this.internalInvoke(target, operationName, signature, params) : this.internalInvoke(target, operationName, method, params);
        }
        catch (FatalException e) {
            this.logMessage("Failed operation [" + operationName + "], trace follows...", e, 1);
            this.m_container.m_agent.shutdown(4);
            throw e;
        }
        catch (SessionException e) {
            this.logMessage("Failed operation [" + operationName + "], trace follows...", e, 1);
            this.m_container.m_agent.shutdown(4);
            throw e;
        }
        catch (MFException e) {
            this.throwWrappedExceptionOnUnload((Exception)((Object)e));
        }
        catch (MFRuntimeException e) {
            this.throwWrappedExceptionOnUnload((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            if (e.getClass().getName().startsWith("java.")) {
                this.throwWrappedExceptionOnUnload(e);
            }
            MFRuntimeException mfe = new MFRuntimeException();
            mfe.setLinkedException((Exception)e);
            this.throwWrappedExceptionOnUnload((Exception)((Object)mfe));
        }
        catch (Exception e) {
            if (e.getClass().getName().startsWith("java.")) {
                this.throwWrappedExceptionOnUnload(e);
            }
            MFException mfe = new MFException();
            mfe.setLinkedException(e);
            this.throwWrappedExceptionOnUnload((Exception)((Object)mfe));
        }
        catch (OutOfMemoryError e) {
            this.logMessage("Failed operation [" + operationName + "] due to insufficient memory...", e, 1);
            throw e;
        }
        catch (Error e) {
            this.logMessage("Failed operation [" + operationName + "], trace follows...", e, 1);
            throw e;
        }
        return returnValue;
    }

    void throwWrappedExceptionOnUnload(Exception e) throws Exception {
        if (this.m_isClosing) {
            MFRuntimeException mfe = new MFRuntimeException("Request failure occured while unloading/reloading");
            mfe.setLinkedException(e);
            throw mfe;
        }
        throw e;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object internalInvoke(Object target, String operationName, Object object, Object[] paramsParam) throws Exception {
        Object returnValue;
        int traceMask;
        Object[] params;
        block14: {
            params = paramsParam;
            traceMask = this.m_component.getTraceMask();
            returnValue = null;
            ClassLoader contextClassLoader = null;
            try {
                if (this.m_isDifferentClassLoader) {
                    contextClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.m_componentClassLoader);
                    params = (Object[])ContainerUtil.transferObject(params, this.m_componentClassLoader);
                }
                returnValue = target instanceof DynamicMBean && object instanceof String[] ? ((DynamicMBean)target).invoke(operationName, params, (String[])object) : ((Method)object).invoke(target, params);
                if (this.m_isDifferentClassLoader) {
                    returnValue = ContainerUtil.transferObject(returnValue, this.m_container.m_defaultClassLoader);
                }
                if (!this.m_isDifferentClassLoader) break block14;
            }
            catch (InvocationTargetException e) {
                try {
                    Throwable throwable = e.getTargetException();
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    String msg = "Operation [" + operationName + "] failure on: " + this.m_componentName.getCanonicalName();
                    this.logMessage(msg + ",trace follows...", throwable, 2);
                    throw new MFRuntimeException(msg);
                }
                catch (Throwable throwable) {
                    if (this.m_isDifferentClassLoader) {
                        Thread.currentThread().setContextClassLoader(contextClassLoader == null ? this.m_container.m_defaultClassLoader : contextClassLoader);
                    }
                    throw throwable;
                }
            }
            Thread.currentThread().setContextClassLoader(contextClassLoader == null ? this.m_container.m_defaultClassLoader : contextClassLoader);
        }
        if ((traceMask & 4) > 0) {
            StringBuffer msg = new StringBuffer("Operation invoked [" + operationName + "]");
            if ((traceMask & 1) > 0 && (params.length > 0 || returnValue != null || object instanceof Method && !((Method)object).getReturnType().equals(Void.TYPE))) {
                msg.append(", details...");
                if (params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        msg.append(IContainer.NEWLINE).append("\tparams[").append(i).append("] = ").append(this.toString(params[i]));
                    }
                }
                if (returnValue != null || object instanceof Method && !((Method)object).getReturnType().equals(Void.TYPE)) {
                    msg.append(IContainer.NEWLINE).append("\treturn = ").append(this.toString(returnValue));
                }
            }
            this.logMessage(msg.toString(), 7);
        }
        return returnValue;
    }

    private String toString(Object objectParam) {
        Object[] object = objectParam;
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            object = ((List)object).toArray();
        }
        if (object instanceof Set) {
            object = ((Set)object).toArray();
        }
        if (!object.getClass().isArray()) {
            return object.toString();
        }
        try {
            int origLength = Array.getLength(object);
            StringBuffer sb = new StringBuffer();
            sb.append("Array of " + origLength + " items");
            int useLength = 10;
            if (origLength < 10) {
                useLength = origLength;
            }
            if (origLength > 10) {
                sb.append("; first 10 items: ");
            } else {
                sb.append(": ");
            }
            sb.append('{');
            for (int i = 0; i < useLength; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.toString(Array.get(object, i)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception illegal) {
            return " Parsing array we got " + illegal.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INotification createNotification(short category, String subCategory, String eventName, int severityLevel) {
        MFNotification notification = new MFNotification(this.m_objectName, category, subCategory, eventName, severityLevel);
        if (this.m_notificationSequenceNumber == null) {
            this.m_notificationSequenceNumber = new long[]{0L};
        }
        long[] lArray = this.m_notificationSequenceNumber;
        synchronized (this.m_notificationSequenceNumber) {
            long l = this.m_notificationSequenceNumber[0];
            this.m_notificationSequenceNumber[0] = l + 1L;
            notification.setSequenceNumber(l);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            notification.setSourceIdentity((IComponentIdentity)new ComponentIdentity(this.m_componentName, this.m_elementIdentity));
            return notification;
        }
    }

    void sendNotification(final INotification notification) {
        HashMap attributes = notification.getAttributes();
        boolean isForwardedNotification = attributes != null && attributes.containsKey("ForwardedBy");
        int traceMask = this.m_traceMaskOnCleanup;
        traceMask = this.retrieveTraceMask(traceMask);
        if (notification.getCategory() == 0 && notification.getSubCategory().equals(INotification.SUBCATEGORY_TEXT[0]) && !isForwardedNotification) {
            notification.setAttribute("LastError", (Object)this.m_lastErrorDescription);
            notification.setAttribute("LastErrorLevel", (Object)("" + this.m_lastErrorLevel));
            attributes = notification.getAttributes();
        }
        if ((traceMask & 8) > 0 && !notification.getEventName().equals(LOGGED_MESSAGE_TO_NOTIFICATION)) {
            StringBuffer msg = new StringBuffer("Notification generated [" + notification.getType() + "]");
            if ((traceMask & 1) > 0) {
                if (attributes == null) {
                    msg.append(", containing 0 attributes");
                } else if (!attributes.isEmpty()) {
                    msg.append(", containing attributes...");
                    Object[] entries = attributes.entrySet().toArray();
                    for (int i = 0; i < entries.length; ++i) {
                        msg.append(IContainer.NEWLINE).append('\t').append(((Map.Entry)entries[i]).getKey()).append('=').append(((Map.Entry)entries[i]).getValue());
                    }
                }
            }
            this.logMessage(msg.toString(), 7);
        }
        this.sendInternalNotification(notification);
        if (notification.getType().equals("system.state.Startup") && this.m_componentName.getComponentName().equals("AGENT")) {
            return;
        }
        Runnable notificationSender = new Runnable(){

            @Override
            public void run() {
                AbstractMBean.this.sendExternalNotification(notification);
            }
        };
        if (this.m_container.isClosing()) {
            new Thread(notificationSender).start();
        } else {
            this.m_container.getNotificationPublisher().enqueueNotificationTask(notificationSender, System.currentTimeMillis() + JMSConnectorServer.NOTIFICATION_TTL);
        }
    }

    void logMessage(String message, int severityLevel) {
        this.m_container.logMessage(this.m_componentName.getComponentName(), message, severityLevel);
    }

    void logMessage(String message, Throwable exception, int severityLevel) {
        this.m_container.logMessage(this.m_componentName.getComponentName(), message, exception, severityLevel);
    }

    void logMessage(Throwable exception, int severityLevel) {
        this.logMessage("Trace follows...", exception, severityLevel);
    }

    private void setDelta(IDeltaElement delta) {
        this.m_changeRegistration.setDelta(delta);
    }

    private void setDeletedElementName(String deletedElementName) {
        this.m_changeRegistration.setDeletedElementName(deletedElementName);
    }

    private void adjustHandlers() {
        this.m_changeRegistration.adjustHandlers();
    }

    void fireAttributeChangeHandlers() {
        this.m_changeRegistration.fireAttributeChangeHandlers(true);
    }

    void registerAttributeChangeHandler(AttributeName name, IAttributeChangeHandler handler) {
        this.m_changeRegistration.registerAttributeChangeHandler(name, handler);
    }

    void unregisterAttributeChangeHandler(AttributeName name) {
        this.m_changeRegistration.unregisterAttributeChangeHandler(name);
    }

    IElement getContainerConfiguration(boolean acceptsChanges) {
        return this.getConfiguration(this.m_container.getContainerIdentity().getConfigIdentity().getName(), acceptsChanges);
    }

    IAttributeSet getDeploymentParameters() {
        String compID;
        IElementIdentity containerIdentity = this.m_container.getContainerIdentity().getConfigIdentity();
        IElement containerCE = this.m_componentContext.getConfiguration(containerIdentity.getName(), true);
        IAttributeSet containerAS = containerCE.getAttributes();
        IAttributeSet componentAS = (IAttributeSet)containerAS.getAttribute("COMPONENTS");
        HashMap map = componentAS.getAttributes();
        IAttributeSet spas = (IAttributeSet)map.get(compID = this.m_componentName.getComponentName());
        if (spas == null) {
            return null;
        }
        IAttributeSet dpas = (IAttributeSet)spas.getAttribute("DEPLOYMENT_PARAMETERS");
        return dpas;
    }

    public void handleNotificationSubscription(String handlerID, String[] notificationTypes) {
        this.handleNotificationSubscription(handlerID, notificationTypes, this.m_notificationSubscriptionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotificationSubscription(String destination, String[] notificationTypes, Long notificationSubscriptionTimeout) {
        NotificationHandlerDelegate localHandler = null;
        HashMap hashMap = this.m_notificationHandlers;
        synchronized (hashMap) {
            while (this.m_container.isCacheReadOnly()) {
                try {
                    this.m_notificationHandlers.wait(1000L);
                }
                catch (InterruptedException e) {
                    this.logMessage("handleNotificationSubscriptions Could not wait", e, 2);
                }
            }
            if (notificationTypes.length == 0) {
                localHandler = (NotificationHandlerDelegate)this.m_notificationHandlers.remove(destination);
                this.m_container.deleteNotificationHandlerSubscriptionsFromCache(this.m_objectName, localHandler);
            } else {
                localHandler = (NotificationHandlerDelegate)this.m_notificationHandlers.get(destination);
                if (localHandler == null) {
                    localHandler = new NotificationHandlerDelegate(destination);
                    this.m_notificationHandlers.put(destination, localHandler);
                }
                localHandler.setHandledNotificationTypes(notificationTypes);
                localHandler.setNotificationSubscriptionTimeout(notificationSubscriptionTimeout);
                this.m_container.storeNotificationHandlerSubscriptionsInCache(this.m_objectName, localHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreNotificationHandler(NotificationHandlerDelegate localHandler) {
        HashMap hashMap = this.m_notificationHandlers;
        synchronized (hashMap) {
            this.m_notificationHandlers.put(localHandler.getDestination(), localHandler);
        }
    }

    private void sendInternalNotification(final INotification notification) {
        boolean isSystemStateNotification = false;
        if (notification.getCategory() == 0 && notification.getSubCategory().equals(INotification.SUBCATEGORY_TEXT[0]) && !this.m_componentName.getComponentName().equals("AGENT MANAGER")) {
            isSystemStateNotification = true;
            final long amNotificationsTTL = this.m_container.m_agent.getNotificationInterval();
            if (this.m_container.isBooted()) {
                this.invokeHandleNotification(this.m_agentManagerID, notification, amNotificationsTTL);
            } else {
                Thread invoker = new Thread(this.m_componentName.getComponentName() + " - Delayed Notification Notifier"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        IContainer container;
                        IContainer iContainer = container = ContainerImpl.getContainer();
                        synchronized (iContainer) {
                            while (!container.isBooted()) {
                                if (container.isClosing()) {
                                    return;
                                }
                                try {
                                    container.wait(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        AbstractMBean.this.invokeHandleNotification(AbstractMBean.this.m_agentManagerID, notification, amNotificationsTTL);
                    }
                };
                invoker.setDaemon(true);
                invoker.start();
            }
        }
        if (this.m_notificationHandlers.isEmpty()) {
            return;
        }
        String notificationType = notification.getType();
        long syncTime = this.getNotificationHandlersSyncTimeFrame();
        if (syncTime != 0L && isSystemStateNotification && notificationType.contains("Online")) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    AbstractMBean.this.fireNotificationHandlers(notification);
                }
            };
            this.m_notificationsThreadPoolExecutor.schedule(task, syncTime, TimeUnit.SECONDS);
            this.m_notificationsList.add(task);
        } else if (syncTime != 0L && isSystemStateNotification && notificationType.contains("Offline")) {
            Iterator<Runnable> taskIterator = this.m_notificationsList.iterator();
            while (taskIterator.hasNext()) {
                Runnable task = taskIterator.next();
                this.m_notificationsThreadPoolExecutor.remove(task);
                taskIterator.remove();
            }
            this.m_notificationsThreadPoolExecutor.purge();
        }
        this.fireNotificationHandlers(notification);
    }

    private long getNotificationHandlersSyncTimeFrame() {
        if (m_notificationHandlersSyncTime != null) {
            return m_notificationHandlersSyncTime;
        }
        m_notificationHandlersSyncTime = 30L;
        String value = System.getProperty(NOTIFICATION_HANDLERS_SYNC_TIME_PROPERTY);
        if (value != null) {
            try {
                m_notificationHandlersSyncTime = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return m_notificationHandlersSyncTime;
    }

    private void fireNotificationHandlers(INotification notification) {
        String notificationType = notification.getType();
        Iterator localHandlers = this.getMatchingNotificationHandlers(notificationType);
        while (localHandlers.hasNext()) {
            NotificationHandlerDelegate localHandler = (NotificationHandlerDelegate)localHandlers.next();
            this.invokeHandleNotification(localHandler.getDestination(), notification, localHandler.getNotificationSubscriptionTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getMatchingNotificationHandlers(String notificationType) {
        ArrayList<NotificationHandlerDelegate> handlerList = new ArrayList<NotificationHandlerDelegate>();
        HashMap hashMap = this.m_notificationHandlers;
        synchronized (hashMap) {
            Iterator localHandlers = this.m_notificationHandlers.values().iterator();
            while (localHandlers.hasNext()) {
                NotificationHandlerDelegate localHandler = (NotificationHandlerDelegate)localHandlers.next();
                if (localHandler.hasExpired()) {
                    localHandlers.remove();
                    this.m_container.deleteNotificationHandlerSubscriptionsFromCache(this.m_objectName, localHandler);
                    if ((this.m_container.m_agent.m_traceMask & 0x100) <= 0) continue;
                    this.m_container.logMessage("AGENT", "Expired management notification subcription(s) from \"" + localHandler.getDestination() + "\" to \"" + this.getContext().getComponentName().getComponentName() + "\"", 7);
                    continue;
                }
                if (!localHandler.handlesNotificationType(notificationType)) continue;
                handlerList.add(localHandler);
            }
            this.m_notificationHandlers.notifyAll();
        }
        return handlerList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendExternalNotification(INotification notification) {
        Notification jmxNotification = (Notification)notification;
        ArrayList<NotificationListener> matchingListeners = new ArrayList<NotificationListener>();
        ArrayList matchingHandbacks = new ArrayList();
        HashMap hashMap = this.m_notificationListeners;
        synchronized (hashMap) {
            if (this.m_notificationListeners.isEmpty()) {
                return;
            }
            Iterator listeners = this.m_notificationListeners.entrySet().iterator();
            while (listeners.hasNext()) {
                ArrayList notifiedHandbacks = new ArrayList();
                Map.Entry listenerEntry = listeners.next();
                NotificationListener listener = (NotificationListener)listenerEntry.getKey();
                for (Map.Entry handbackEntry : ((HashMap)listenerEntry.getValue()).entrySet()) {
                    Object handback = handbackEntry.getKey();
                    if (notifiedHandbacks.contains(handback)) continue;
                    for (NotificationFilter filter : (ArrayList)handbackEntry.getValue()) {
                        if (filter != null && !filter.isNotificationEnabled(jmxNotification)) continue;
                        notifiedHandbacks.add(handback);
                        matchingListeners.add(listener);
                        matchingHandbacks.add(handback);
                    }
                }
            }
        }
        for (int i = matchingListeners.size() - 1; i >= 0; --i) {
            ((NotificationListener)matchingListeners.get(i)).handleNotification(jmxNotification, matchingHandbacks.get(i));
        }
    }

    private void invokeHandleNotification(String destination, INotification notification, long ttl) {
        block5: {
            boolean isTraceable = !notification.getEventName().equals("LogMessage");
            int traceMask = this.m_traceMaskOnCleanup;
            if (isTraceable) {
                traceMask = this.retrieveTraceMask(traceMask);
            }
            boolean synchronous = false;
            if (this.isSameContainer(destination) && this.m_container.isClosing()) {
                synchronous = true;
            }
            try {
                if (isTraceable && (traceMask & 8) > 0 && (traceMask & 1) > 0) {
                    StringBuffer msg = new StringBuffer("Sending notification [" + notification.getType() + "] to " + destination);
                    this.logMessage(msg.toString(), 7);
                }
                this.invoke(destination, HANDLE_NOTIFICATION_METHOD_NAME, new Object[]{notification}, HANDLE_NOTIFICATION_SIGNATURE, synchronous, ttl);
            }
            catch (Exception e) {
                if (!isTraceable || (traceMask & 8) <= 0 || (traceMask & 1) <= 0) break block5;
                StringBuffer msg = new StringBuffer("Failed to send notification [" + notification.getType() + "] to " + destination + ", trace follows...");
                this.logMessage(msg.toString(), e, 7);
            }
        }
    }

    void setNotificationSubscriptionRenewalInterval(Long notificationSubscriptionRenewalInterval) {
        this.m_notificationSubscriptionRenewalInterval = notificationSubscriptionRenewalInterval != null ? notificationSubscriptionRenewalInterval : 30000L;
    }

    Long getNotificationSubscriptionRenewalInterval() {
        return new Long(this.m_notificationSubscriptionRenewalInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNotificationHandler(String notificationSource, INotificationHandler handler, String[] notificationTypes) {
        if (notificationTypes.length == 0) {
            throw new IllegalArgumentException();
        }
        String[] alreadySubscribedNotifications = null;
        HashMap hashMap = this.m_notificationSources;
        synchronized (hashMap) {
            HashMap<INotificationHandler, String[]> handlers = (HashMap<INotificationHandler, String[]>)this.m_notificationSources.get(notificationSource);
            if (handlers == null) {
                handlers = new HashMap<INotificationHandler, String[]>();
                this.m_notificationSources.put(notificationSource, handlers);
            } else {
                alreadySubscribedNotifications = this.getSubscriptionNotifications(notificationSource);
            }
            handlers.put(handler, notificationTypes);
            if (alreadySubscribedNotifications != null && notificationTypes != null && alreadySubscribedNotifications.length == notificationTypes.length) {
                boolean isMatch = false;
                for (int i = 0; i < notificationTypes.length && (isMatch = this.isNotificationFound(alreadySubscribedNotifications, notificationTypes, i)); ++i) {
                }
                if (isMatch) {
                    return;
                }
            }
        }
        this.renewNotificationSubscriptions(notificationSource);
        if (this.m_notificationSubscriptionRenewalThread == null) {
            this.m_notificationSubscriptionRenewalThread = new Thread(this.m_componentName.getComponentName() + " - Notification Subsciption Renewer"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (!this.isInterrupted() && !AbstractMBean.this.m_isClosing) {
                            Thread.sleep(AbstractMBean.this.m_notificationSubscriptionRenewalInterval);
                            String[] sources = null;
                            HashMap hashMap = AbstractMBean.this.m_notificationSources;
                            synchronized (hashMap) {
                                sources = AbstractMBean.this.m_notificationSources.keySet().toArray(IEmptyArray.EMPTY_STRING_ARRAY);
                            }
                            for (int i = 0; i < sources.length && !this.isInterrupted() && !AbstractMBean.this.m_isClosing; ++i) {
                                AbstractMBean.this.renewNotificationSubscriptions(sources[i]);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        AbstractMBean.this.m_notificationSubscriptionRenewalThread = null;
                    }
                }
            };
            this.m_notificationSubscriptionRenewalThread.setDaemon(true);
            this.m_notificationSubscriptionRenewalThread.start();
        }
    }

    private void renewNotificationSubscriptions(String notificationSource) {
        block9: {
            if (this.m_isClosing) {
                return;
            }
            String[] notificationTypes = this.getSubscriptionNotifications(notificationSource);
            try {
                if (this.m_isClosing) {
                    return;
                }
                CanonicalName canonicalName = new CanonicalName(notificationSource);
                if (this.isSameContainer(notificationSource) && !this.m_container.isHostingComponent(canonicalName.getComponentName())) {
                    return;
                }
                if (this.m_isClosing) {
                    return;
                }
                Long lastRenewal = (Long)this.m_lastHandlerRenewals.get(notificationSource);
                if (lastRenewal != null && lastRenewal > System.currentTimeMillis() - 1000L) {
                    Thread.sleep(1000L);
                }
                this.m_lastHandlerRenewals.put(notificationSource, new Long(System.currentTimeMillis()));
                Object[] params = new Object[]{this.m_componentName.getCanonicalName(), notificationTypes, this.m_notificationSubscriptionTimeout};
                this.invoke(notificationSource, HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD_NAME, params, HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE, false, 0L);
            }
            catch (Exception e) {
                int traceMask = this.m_traceMaskOnCleanup;
                traceMask = this.retrieveTraceMask(traceMask);
                if ((traceMask & 8) <= 0) break block9;
                StringBuffer msg = new StringBuffer("Exception thrown while renewing subscription by " + this.m_componentName.getCanonicalName() + " to notification source = " + notificationSource);
                if ((traceMask & 1) > 0) {
                    msg.append(", for notificationTypes: ");
                    for (int i = 0; i < notificationTypes.length; ++i) {
                        msg.append(notificationTypes[i] + ", ");
                    }
                }
                this.logMessage(msg.toString(), e, 7);
            }
        }
    }

    private int retrieveTraceMask(int traceMaskParam) {
        int traceMask = traceMaskParam;
        try {
            traceMask = this.m_component.getTraceMask();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return traceMask;
    }

    private String[] getSubscriptionNotifications(String notificationSource) {
        HashSet<String> subscriptionNotifications = new HashSet<String>();
        HashMap handlers = (HashMap)this.m_notificationSources.get(notificationSource);
        if (handlers != null) {
            String[][] notificationTypes = (String[][])handlers.values().toArray((T[])EMPTY_STRING_ARRAY_ARRAY);
            for (int i = 0; i < notificationTypes.length; ++i) {
                for (int j = 0; j < notificationTypes[i].length; ++j) {
                    subscriptionNotifications.add(notificationTypes[i][j]);
                }
            }
        }
        return subscriptionNotifications.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNotificationHandler(String notificationSource, INotificationHandler handler) {
        HashMap hashMap = this.m_notificationSources;
        synchronized (hashMap) {
            HashMap handlers = (HashMap)this.m_notificationSources.get(notificationSource);
            if (handlers != null) {
                String[] preNotificationTypes = this.getSubscriptionNotifications(notificationSource);
                handlers.remove(handler);
                String[] postNotificationTypes = this.getSubscriptionNotifications(notificationSource);
                boolean found = false;
                for (int i = 0; i < preNotificationTypes.length; ++i) {
                    found = this.isNotificationFound(postNotificationTypes, preNotificationTypes, i);
                    if (found) continue;
                    this.renewNotificationSubscriptions(notificationSource);
                    break;
                }
                if (handlers.isEmpty()) {
                    this.m_notificationSources.remove(notificationSource);
                    this.m_lastHandlerRenewals.remove(notificationSource);
                }
            }
            if (this.m_notificationSources.isEmpty()) {
                this.stopNotificationRenewal();
            }
        }
    }

    private boolean isNotificationFound(String[] postNotificationTypes, String[] preNotificationTypes, int i) {
        boolean found = false;
        for (int j = 0; j < postNotificationTypes.length; ++j) {
            if (!preNotificationTypes[i].equals(postNotificationTypes[j])) continue;
            found = true;
            break;
        }
        return found;
    }

    private void stopNotificationRenewal() {
        if (this.m_notificationSubscriptionRenewalThread != null) {
            this.m_notificationSubscriptionRenewalThread.interrupt();
        }
    }

    private long adjustExpirationTime(String operationName, long expirationTime) {
        long adjustedExpirationTime = expirationTime;
        if (operationName.equalsIgnoreCase("getAttribute") || operationName.equalsIgnoreCase("getAttributes") || operationName.equalsIgnoreCase("setAttribute") || operationName.equalsIgnoreCase("setAttributes")) {
            adjustedExpirationTime = System.currentTimeMillis() + JMSConnectorServer.NOTIFICATION_TTL;
        }
        return adjustedExpirationTime;
    }

    Object invoke(String target, String operationName, Object[] params, String[] signature, boolean synchronous, long timeout) throws Exception {
        Invoker invoker = null;
        long expirationTime = 0L;
        expirationTime = this.adjustExpirationTime(operationName, expirationTime);
        invoker = this.isSameContainer(target) ? new LocalInvoker(target, operationName, params, signature, synchronous) : new RemoteInvoker(target, operationName, params, signature, synchronous, timeout);
        if (synchronous) {
            invoker.run();
            if (invoker.exception != null) {
                throw invoker.exception;
            }
            return invoker.returnValue;
        }
        this.scheduleTask(invoker, null, true, expirationTime);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ICollectiveOpStatus invoke(final String[] targets, final String operationName, final Object[] params, final String[] signature, final boolean synchronous, final long timeout) throws Exception {
        long startTime = System.currentTimeMillis();
        final Hashtable<String, Object[]> results = synchronous ? new Hashtable<String, Object[]>(targets.length) : null;
        for (int i = 0; i < targets.length; ++i) {
            final String target = targets[i];
            if (synchronous) {
                Runnable invoker = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object rtnValue = null;
                        Exception e = null;
                        try {
                            rtnValue = AbstractMBean.this.invoke(target, operationName, params, signature, synchronous, timeout);
                        }
                        catch (Exception ex) {
                            rtnValue = null;
                            e = ex;
                        }
                        Hashtable hashtable = results;
                        synchronized (hashtable) {
                            results.put(target, new Object[]{rtnValue, e});
                            if (results.size() == targets.length) {
                                results.notifyAll();
                            }
                        }
                    }
                };
                this.m_container.getTaskScheduler().scheduleTask(invoker, false);
                continue;
            }
            this.invoke(target, operationName, params, signature, synchronous, timeout);
        }
        if (!synchronous) {
            return null;
        }
        Hashtable<String, Object[]> i = results;
        synchronized (i) {
            try {
                if (timeout <= 0L) {
                    while (results.size() < targets.length) {
                        results.wait();
                    }
                } else {
                    long waitTime = timeout - (System.currentTimeMillis() - startTime);
                    while (waitTime > 0L && results.size() < targets.length) {
                        results.wait(waitTime);
                        waitTime = timeout - (System.currentTimeMillis() - startTime);
                    }
                }
            }
            catch (InterruptedException waitTime) {
                // empty catch block
            }
            for (int i2 = 0; i2 < targets.length; ++i2) {
                Object result = results.get(targets[i2]);
                if (result != null) continue;
                results.put(targets[i2], new Object[]{null, new InvokeTimeoutException("Request timeout.")});
            }
        }
        Object[] entries = results.entrySet().toArray();
        CollectiveOpStatus collectiveOpStatus = new CollectiveOpStatus(entries.length);
        for (int i3 = 0; i3 < entries.length; ++i3) {
            Map.Entry entry = (Map.Entry)entries[i3];
            Object[] result = (Object[])entry.getValue();
            collectiveOpStatus.addResult((String)entry.getKey(), result[0], (Throwable)result[1]);
        }
        return collectiveOpStatus;
    }

    void scheduleTask(Runnable task, Date startTime, boolean usePooledThread) {
        this.scheduleTask(task, startTime, usePooledThread, 0L);
    }

    void scheduleTask(Runnable task, Date startTime, boolean usePooledThread, long expirationTime) {
        if (startTime == null || startTime.getTime() <= System.currentTimeMillis()) {
            if (usePooledThread) {
                ITaskScheduler taskScheduler = this.m_container.getTaskScheduler();
                taskScheduler.scheduleTask(task, false, expirationTime);
            } else {
                new Thread(task, this.m_taskThreadName).start();
            }
        } else {
            if (this.m_commonTimer == null) {
                this.m_commonTimer = this.m_container.getTimer();
            }
            TimerTaskDelegate timerTask = new TimerTaskDelegate(task, usePooledThread);
            this.m_scheduledTasks.put(task, timerTask);
            this.m_commonTimer.schedule((TimerTask)timerTask, startTime);
        }
    }

    void cancelTask(Runnable task) {
        if (this.m_commonTimer == null || task == null) {
            return;
        }
        TimerTaskDelegate timerTask = (TimerTaskDelegate)this.m_scheduledTasks.remove(task);
        if (timerTask == null) {
            return;
        }
        timerTask.clearTask();
    }

    private boolean isSameContainer(String target) {
        CanonicalName canonicalName = new CanonicalName(target);
        if (!canonicalName.getDomainName().equals(this.m_componentName.getDomainName())) {
            return false;
        }
        if (canonicalName.getContainerName().equals(this.m_componentName.getContainerName())) {
            return true;
        }
        if (canonicalName.getContainerName().equals(canonicalName.getComponentName()) && this.m_container.isHostingComponent(canonicalName.getComponentName())) {
            try {
                CanonicalName localName = new CanonicalName(this.m_componentName.getDomainName(), this.m_componentName.getContainerName(), canonicalName.getComponentName());
                Object[] values = (Object[])this.invoke(localName.getCanonicalName(), "getAttributeValues", GET_FT_STATE_ATTR_PARAMS, GET_ATTRIBUTE_VALUES_SIGNATURE, true, 0L);
                Short status = (Short)values[0];
                if (status == null) {
                    return true;
                }
                if (status == 0 || status == 2) {
                    return true;
                }
            }
            catch (Exception e) {
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        DEFAULT_ATTRIBUTE_INFOS = new ArrayList(15);
        DEFAULT_OPERATION_INFOS = new ArrayList(3);
        DEFAULT_NOTIFICATION_INFOS = new ArrayList(2);
        EMPTY_STRING_ARRAY_ARRAY = new String[0][];
        GET_FT_STATE_ATTR_PARAMS = new Object[]{new String[]{"FaultTolerantState"}};
        HANDLE_NOTIFICATION_SIGNATURE = new String[]{INotification.class.getName()};
        HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE = new String[]{String.class.getName(), String[].class.getName(), Long.class.getName()};
        SET_ATTRIBUTES_SIGNATURE = new String[]{String[].class.getName(), Object[].class.getName()};
        GET_ATTRIBUTE_VALUES_SIGNATURE = new String[]{String[].class.getName()};
        LOGICAL_NOTIFY = new Integer(0);
        FILE_NOTIFY = new Integer(1);
        try {
            RELOAD_METHOD = AbstractMBean.class.getDeclaredMethod("reload", IEmptyArray.EMPTY_CLASS_ARRAY);
            HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD = AbstractMBean.class.getDeclaredMethod(HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD_NAME, String.class, String[].class, Long.class);
            SET_ATTRIBUTES_METHOD = AbstractMBean.class.getDeclaredMethod("setAttributes", String[].class, Object[].class);
            GET_ATTRIBUTE_VALUES_METHOD = AbstractMBean.class.getDeclaredMethod("getAttributeValues", String[].class);
            GET_MBEAN_INFO_METHOD = AbstractMBean.class.getDeclaredMethod("getMBeanInfo", IEmptyArray.EMPTY_CLASS_ARRAY);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        MBeanFeatureInfo mbInfo = null;
        mbInfo = new MBeanAttributeInfo("ConfigID", String.class.getName(), "Configuration identity.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("Classname", String.class.getName(), "Component classname.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("ReleaseVersion", String.class.getName(), "Component release version.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("State", Short.class.getName(), "Execution state of the component.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("StateString", String.class.getName(), "Description of the execution state of the component.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("LastError", String.class.getName(), "Last (uncleared) error condition.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("LastErrorLevel", Integer.class.getName(), "Last (uncleared) error severity.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("LastErrorLevelString", String.class.getName(), "Last (uncleared) error severity description.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("Uptime", Long.class.getName(), "Execution time (milliseconds).", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("Classpath", String.class.getName(), "Component classpath.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("TraceMask", Integer.class.getName(), "Debug bit mask.", true, true, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("TraceMaskValues", String.class.getName(), "Possible TraceMask values.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);
        mbInfo = new MBeanOperationInfo("reload", "Asynchronously reload the component and restart the component if it was previously online.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1);
        DEFAULT_OPERATION_INFOS.add(mbInfo);
    }

    private class TimerTaskDelegate
    extends TimerTask {
        Runnable task;
        private boolean usePooledThread;

        private TimerTaskDelegate(Runnable task, boolean usePooledThread) {
            this.task = task;
            this.usePooledThread = usePooledThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable task = null;
            TimerTaskDelegate timerTaskDelegate = this;
            synchronized (timerTaskDelegate) {
                if (this.task == null) {
                    return;
                }
                task = this.task;
            }
            if (AbstractMBean.this.m_isClosing) {
                return;
            }
            if (this.usePooledThread) {
                AbstractMBean.this.m_container.getTaskScheduler().scheduleTask(task, false);
            } else {
                new Thread(task, AbstractMBean.this.m_timerTaskThreadName).start();
            }
            AbstractMBean.this.m_scheduledTasks.remove(task);
            this.clearTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearTask() {
            TimerTaskDelegate timerTaskDelegate = this;
            synchronized (timerTaskDelegate) {
                this.task = null;
            }
        }
    }

    private class RemoteInvoker
    extends Invoker {
        long timeout;

        private RemoteInvoker(String target, String operationName, Object[] params, String[] signature, boolean synchronous, long timeout) {
            super(target, operationName, params, signature, synchronous);
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                if (AbstractMBean.this.m_isClosing && !this.operationName.equals(AbstractMBean.HANDLE_NOTIFICATION_METHOD_NAME)) {
                    return;
                }
                this.returnValue = AbstractMBean.this.m_container.invokeRemote(this.target, this.operationName, this.params, this.signature, this.timeout, this.synchronous);
            }
            catch (Exception e) {
                if (AbstractMBean.this.m_isClosing || AbstractMBean.this.m_container.isClosing()) {
                    return;
                }
                if (this.synchronous) {
                    this.exception = e;
                }
                if (e.getClass().getName().equals(InvokeTimeoutException.class.getName()) || e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException().getClass().getName().equals(InvokeTimeoutException.class.getName())) {
                    AbstractMBean.this.logMessage("Timeout while invoking [" + this.operationName + "] on " + this.target, 2);
                }
                if (e.getClass().getName().equals(InvokeTimeoutCommsException.class.getName()) || e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException().getClass().getName().equals(InvokeTimeoutCommsException.class.getName())) {
                    if ((AbstractMBean.this.m_container.m_agent.getTraceMask() & 0x20) > 0) {
                        AbstractMBean.this.logMessage("Existing connection failure caused: timeout while invoking [" + this.operationName + "] on " + this.target, 7);
                    }
                }
                if ((AbstractMBean.this.m_container.m_agent.getTraceMask() & 0x20) > 0) {
                    AbstractMBean.this.logMessage("Failed to invoke [" + this.operationName + "] on " + this.target + ", trace follows...", e, 7);
                }
                AbstractMBean.this.logMessage("Failed to invoke [" + this.operationName + "] on " + this.target, 2);
            }
        }
    }

    private class LocalInvoker
    extends Invoker {
        private LocalInvoker(String target, String operationName, Object[] params, String[] signature, boolean synchronous) {
            super(target, operationName, params, signature, synchronous);
        }

        @Override
        public void run() {
            try {
                if (AbstractMBean.this.m_isClosing && !this.operationName.equals(AbstractMBean.HANDLE_NOTIFICATION_METHOD_NAME)) {
                    return;
                }
                if (AbstractMBean.this.m_isDifferentClassLoader) {
                    this.params = (Object[])ContainerUtil.transferObject(this.params, AbstractMBean.this.m_container.m_defaultClassLoader);
                }
                if (AbstractMBean.this.m_isClosing && !this.operationName.equals(AbstractMBean.HANDLE_NOTIFICATION_METHOD_NAME)) {
                    return;
                }
                this.returnValue = AbstractMBean.this.m_container.invokeLocal(this.target, this.operationName, this.params, this.signature);
                if (AbstractMBean.this.m_isClosing) {
                    return;
                }
                if (AbstractMBean.this.m_isDifferentClassLoader) {
                    this.returnValue = ContainerUtil.transferObject(this.returnValue, AbstractMBean.this.m_componentClassLoader);
                }
            }
            catch (Exception e) {
                if (AbstractMBean.this.m_isClosing || AbstractMBean.this.m_container.isClosing()) {
                    return;
                }
                if (this.synchronous) {
                    this.exception = e;
                }
                if ((AbstractMBean.this.m_container.m_agent.getTraceMask() & 0x20) > 0) {
                    AbstractMBean.this.logMessage("Failed to invoke [" + this.operationName + "] on " + this.target + ", trace follows...", e, 7);
                }
                AbstractMBean.this.logMessage("Failed to invoke [" + this.operationName + "] on " + this.target, 2);
            }
        }
    }

    private abstract class Invoker
    implements Runnable {
        String target;
        String operationName;
        Object[] params;
        String[] signature;
        boolean synchronous;
        Object returnValue;
        Exception exception;

        Invoker(String target, String operationName, Object[] params, String[] signature, boolean synchronous) {
            this.target = target;
            this.operationName = operationName;
            this.params = params;
            this.signature = signature;
            this.synchronous = synchronous;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(super.toString());
            sb.append(" (operation: ").append(this.operationName);
            sb.append(", target: ").append(this.target).append(')');
            return sb.toString();
        }
    }
}

