/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory;

import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.directory.DirectoryServiceFactory;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Hashtable;

public final class DirectorySeeder {
    private IDirectoryService m_ds;
    private static final String FILES_DUMP_SUFFIX = "_files";

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args[0].equals("?")) {
            DirectorySeeder.printUsage();
        }
        try {
            new DirectorySeeder(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectorySeeder(String[] args) throws Exception {
        try {
            this.m_ds = this.createDSInstance(args[0]);
            ArrayList<String> xmlFiles = new ArrayList<String>();
            System.out.println("Seeding directory store:");
            boolean parseBlobArg = false;
            String blobDirectory = null;
            File blobsSubDir = null;
            for (int i = 1; i < args.length; ++i) {
                if (parseBlobArg) {
                    blobDirectory = args[i];
                    parseBlobArg = false;
                    continue;
                }
                if (args[i].equals("-files")) {
                    parseBlobArg = true;
                    continue;
                }
                xmlFiles.add(args[i]);
            }
            if (blobDirectory != null && !(blobsSubDir = new File(blobDirectory, this.m_ds.getDomain() + FILES_DUMP_SUFFIX)).exists()) {
                throw new DirectoryServiceException("Files directory " + blobsSubDir.getAbsolutePath() + " does not exist.");
            }
            String[] xmlFilesArray = new String[xmlFiles.size()];
            xmlFiles.toArray(xmlFilesArray);
            for (int i = 0; i < xmlFilesArray.length; ++i) {
                String file = xmlFilesArray[i];
                System.out.print("- " + file + " .");
                String seedXML = this.getXMLStringFromFile(file);
                System.out.print('.');
                this.m_ds.importFromXML(seedXML);
                System.out.println('.');
            }
            if (System.getProperty("verbose", "false").equals("true")) {
                String contents = this.m_ds.exportDirectoryToXML("/");
                System.out.println("Reporting contents:");
                System.out.println();
                System.out.println(contents);
                System.out.println();
            }
            if (blobsSubDir != null) {
                System.out.println("Loading files...");
                this.loadBlobs(blobsSubDir, "");
                System.out.println("...done");
            }
        }
        finally {
            if (this.m_ds != null) {
                this.m_ds.close();
            }
        }
        System.out.println("Done.");
        System.exit(0);
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Usage: -Dverbose={[false]|true} com.sonicsw.mf.framework.directory.storage.DirectorySeeder <ds.xml> <seed.xml> -files <files_directory>");
        System.out.println();
        System.out.println("Where: <ds.xml>            Directory Service configuration.");
        System.out.println("       <seeddata.xml>      The configuration information to be used to seed the");
        System.out.println("                           Directory Service storage. Multiple seed files may");
        System.out.println("                           be specified as additional arguments.");
        System.out.println("       <files_directory>   The directory to read files from in order to import them into");
        System.out.println("                           This utility loads the files from the <domain_name>_files subdirectory. ");
        System.out.println("                           the Directory Service. Files are exported using the -files");
        System.out.println("                           option with the DirectoryDump command");
        System.exit(1);
    }

    private String getXMLStringFromFile(String xmlFilename) throws Exception {
        FileInputStream fis = new FileInputStream(xmlFilename);
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);
        return new String(bytes);
    }

    private void loadBlobs(File blobRootDirectory, String subDir) throws Exception {
        File blobDirFile = new File(blobRootDirectory, subDir);
        String blobRootDirectoryString = blobRootDirectory.getCanonicalPath();
        File[] children = blobDirFile.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            String childCanPath = child.getCanonicalPath();
            String childDsName = childCanPath.substring(blobRootDirectoryString.length());
            childDsName = childDsName.replace(File.separatorChar, '/');
            if (child.isDirectory()) {
                this.loadBlobs(blobRootDirectory, childDsName);
                continue;
            }
            IDirElement blobEl = this.m_ds.getElement(childDsName, true);
            if (blobEl == null) continue;
            FileInputStream blobStream = new FileInputStream(child);
            this.m_ds.attachBlob(blobEl.doneUpdate(), blobStream, null);
        }
    }

    private IDirectoryService createDSInstance(String dsXMLFile) throws Exception {
        IDirElement[] dsConfigs = ContainerUtil.importConfigurations(new File(dsXMLFile), IContainer.PASSWORD);
        IDirElement dsConfig = null;
        for (int i = 0; i < dsConfigs.length; ++i) {
            String elType = dsConfigs[i].getIdentity().getType();
            if (!elType.equals("MF_DIRECTORY_SERVICE") && !elType.equals("MF_BACKUP_DIRECTORY_SERVICE")) continue;
            dsConfig = dsConfigs[i];
        }
        if (dsConfig == null) {
            throw new Exception("File " + dsXMLFile + " does not contain valid Directory Service boot information");
        }
        IAttributeSet dsAttributes = dsConfig.getAttributes();
        String hostDir = (String)dsAttributes.getAttribute("HOST_DIRECTORY");
        String domainName = (String)dsAttributes.getAttribute("DOMAIN_NAME");
        if (domainName == null) {
            domainName = "Domain1";
        }
        Object tmp = dsAttributes.getAttribute("FILE_SYSTEM_STORAGE");
        if (domainName == null || tmp == null) {
            throw new MFRuntimeException("Bad Directory Service Configuration - must contain DOMAIN_NAME and FILE_SYSTEM_STORAGE.");
        }
        if (!(tmp instanceof IAttributeSet)) {
            throw new MFRuntimeException("Bad Directory Service Configuration - FILE_SYSTEM_STORAGE must be an attribute set.");
        }
        IAttributeSet fsStorage = (IAttributeSet)tmp;
        String hostDirDepricated = (String)fsStorage.getAttribute("HOST_DIRECTORY");
        String password = (String)fsStorage.getAttribute("PASSWORD");
        Hashtable<String, String> directoryEnv = new Hashtable<String, String>();
        directoryEnv.put("STORAGE_TYPE_ATTRIBUTE", "PSE_STORAGE");
        if (hostDirDepricated != null) {
            directoryEnv.put("FS_HOST_DIRECTORY_ATTRIBUTE", hostDirDepricated);
        }
        if (hostDir != null) {
            directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", hostDir);
        }
        if (password != null && password.length() != 0) {
            directoryEnv.put("PASSWORD", password);
        }
        DirectoryServiceFactory factory = new DirectoryServiceFactory(directoryEnv);
        return factory.createDirectoryService(domainName);
    }
}

