/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class BTreeEmptyNodeNote
extends AbstractNote
implements BTreeNoteInterface,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 15;
    byte[] m_scratchBuffer = new byte[8];
    long m_pageNum;
    byte[] m_oldBuffer;
    int m_oldStart;
    int m_oldLength;
    int m_oldValueOffset;

    BTreeEmptyNodeNote() {
    }

    public String toString() {
        return this.getClass().getName() + " page " + this.m_pageNum;
    }

    @Override
    public long getPageNum() {
        return this.m_pageNum;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)15);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_pageNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        int currentLength = 9;
        BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_oldLength);
        writer.write(this.m_scratchBuffer, 0, 2);
        currentLength += 2;
        writer.write(this.m_oldBuffer, this.m_oldStart, this.m_oldLength);
        return currentLength += this.m_oldLength;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        this.m_oldBuffer = buffer;
        int currentOffset = offset;
        this.m_pageNum = BitUtil.getLong(buffer, currentOffset);
        this.m_oldLength = BitUtil.getShort(buffer, currentOffset += 8);
        this.m_oldValueOffset = currentOffset += 2;
        currentOffset += this.m_oldLength;
    }

    void initNote(long pageNum, byte[] oldData, int oldDataStart, int oldDataLength) {
        this.m_pageNum = pageNum;
        this.m_oldBuffer = oldData;
        this.m_oldStart = oldDataStart;
        this.m_oldLength = oldDataLength;
    }
}

