/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class BTreeSecondaryCreateNote
extends AbstractNote
implements BTreeNoteInterface,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 24;
    byte[] m_scratchBuffer = new byte[8];
    long m_pageNum;
    byte[] m_oldEntry;
    int m_oldLength;
    byte[] m_newEntry;
    int m_newLength;
    int m_oldEntryOffset;
    int m_newEntryOffset;

    BTreeSecondaryCreateNote() {
    }

    public String toString() {
        return this.getClass().getName() + " page " + this.m_pageNum;
    }

    @Override
    public long getPageNum() {
        return this.m_pageNum;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)24);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_pageNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        int currentLength = 9;
        BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_oldLength);
        writer.write(this.m_scratchBuffer, 0, 2);
        currentLength += 2;
        writer.write(this.m_oldEntry, 0, this.m_oldLength);
        currentLength += this.m_oldLength;
        BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_newLength);
        writer.write(this.m_scratchBuffer, 0, 2);
        currentLength += 2;
        writer.write(this.m_newEntry, 0, this.m_newLength);
        return currentLength += this.m_newLength;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        this.m_oldEntry = buffer;
        this.m_newEntry = buffer;
        int currentOffset = offset;
        this.m_pageNum = BitUtil.getLong(buffer, currentOffset);
        this.m_oldLength = BitUtil.getShort(buffer, currentOffset += 8);
        this.m_oldEntryOffset = currentOffset += 2;
        this.m_newLength = BitUtil.getShort(buffer, currentOffset += this.m_oldLength);
        this.m_newEntryOffset = currentOffset += 2;
        currentOffset += this.m_newLength;
    }

    void initNote(long pageNum, byte[] oldEntry, int entryOffset, int entryLength) {
        this.m_pageNum = pageNum;
        byte[] buffer = new byte[entryLength];
        this.m_oldEntry = buffer;
        System.arraycopy(oldEntry, entryOffset, this.m_oldEntry, 0, entryLength);
        this.m_oldLength = entryLength;
    }

    void setNewEntry(byte[] newEntry, int entryOffset, int entryLength) {
        byte[] buffer = new byte[entryLength];
        this.m_newEntry = buffer;
        System.arraycopy(newEntry, entryOffset, this.m_newEntry, 0, entryLength);
        this.m_newLength = entryLength;
    }
}

