/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.BTreeKeyNotFoundException;
import com.sonicsw.mtstorage.impl.BTree;
import com.sonicsw.mtstorage.impl.BTreeIteratorState;
import com.sonicsw.mtstorage.impl.BTreeKeyBuffer;
import com.sonicsw.mtstorage.impl.BTreeManager;
import com.sonicsw.mtstorage.impl.BTreeSnapshot;
import com.sonicsw.mtstorage.impl.SnapshotStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

final class BTreeSnapshotManager {
    private BTreeSnapshot m_currentSnapshot;
    private HashMap m_entriesByTransaction;
    private HashMap m_inMemoryByTransaction;
    private boolean m_holdInMemory;
    private ArrayList m_snapshots;
    private HashMap m_snapshotIndex;
    Long m_snapshotTransID;
    BTreeManager m_sShotBtreeManager;

    BTreeSnapshotManager(SnapshotStorage snapshotStorage, boolean holdDeletedInMemory) throws IOException {
        this.m_sShotBtreeManager = snapshotStorage.getBTreeManager();
        this.m_snapshotTransID = snapshotStorage.getTransaction();
        this.m_currentSnapshot = new BTreeSnapshot(this.m_sShotBtreeManager, this.m_snapshotTransID);
        this.m_snapshots = new ArrayList();
        this.m_snapshotIndex = new HashMap();
        this.m_entriesByTransaction = new HashMap();
        this.m_holdInMemory = holdDeletedInMemory;
        if (this.m_holdInMemory) {
            this.m_inMemoryByTransaction = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSnapshot(Long snapshotID) throws IOException {
        BTreeSnapshotManager bTreeSnapshotManager = this;
        synchronized (bTreeSnapshotManager) {
            if (this.m_holdInMemory) {
                this.fromMemoryToSnapshot();
            }
        }
        BTreeSnapshot newSnapshot = new BTreeSnapshot(this.m_sShotBtreeManager, this.m_snapshotTransID);
        this.m_snapshots.add(newSnapshot);
        this.m_snapshotIndex.put(snapshotID, newSnapshot);
        newSnapshot.copyFrom(this.m_currentSnapshot);
    }

    void deleteSnapshot(Long snapshotID) throws IOException {
        BTreeSnapshot snapshot = (BTreeSnapshot)this.m_snapshotIndex.remove(snapshotID);
        int snapshotIndex = this.m_snapshots.indexOf(snapshot);
        this.m_snapshots.remove(snapshotIndex);
        snapshot.delete();
    }

    boolean treeWasDeleted(Long snapshotID, Long treeDBK) {
        BTreeSnapshot snapshot = (BTreeSnapshot)this.m_snapshotIndex.get(snapshotID);
        return snapshot.treeLifeCycleEvent(treeDBK);
    }

    boolean contains(BTree mainTree, Long snapshotID, Long treeDBK, byte[] key, byte[] value) throws IOException {
        BTreeSnapshot snapshot = (BTreeSnapshot)this.m_snapshotIndex.get(snapshotID);
        Boolean found = snapshot.contains(treeDBK, key, value);
        if (found != null) {
            return found;
        }
        if (snapshot.treeLifeCycleEvent(treeDBK)) {
            return false;
        }
        return mainTree.contains(key, value);
    }

    byte[] getFirstKey(BTree mainTree, Long snapshotID, Long treeDBK) throws IOException {
        return this.getFirstKeyInternal(mainTree, snapshotID, treeDBK, false);
    }

    byte[] getLastKey(BTree mainTree, Long snapshotID, Long treeDBK) throws IOException {
        return this.getFirstKeyInternal(mainTree, snapshotID, treeDBK, true);
    }

    private byte[] getFirstKeyInternal(BTree mainTree, Long snapshotID, Long treeDBK, boolean reverse) throws IOException {
        BTreeIteratorState.KeyValuePair smallestEntry;
        BTreeIteratorState.KeyValuePair firstInMain;
        BTreeIteratorState.KeyValuePair firstInSnapshot;
        block3: {
            BTreeSnapshot snapshot = (BTreeSnapshot)this.m_snapshotIndex.get(snapshotID);
            BTreeIteratorState snIterator = new BTreeIteratorState(treeDBK, reverse);
            firstInSnapshot = snapshot.advanceInDeleted(snIterator);
            firstInMain = null;
            if (!snapshot.treeLifeCycleEvent(treeDBK)) {
                BTreeIteratorState iterator = new BTreeIteratorState(treeDBK, reverse);
                do {
                    mainTree.advance(iterator);
                    if (iterator.getAfterLast() || BTreeIteratorState.selectEntries(firstInSnapshot, iterator.getPosition(), reverse) == firstInSnapshot) break block3;
                } while (snapshot.createdLater(treeDBK, iterator.getCurrentKey(), iterator.getCurrentValue()));
                firstInMain = iterator.getPosition();
            }
        }
        if ((smallestEntry = BTreeIteratorState.selectEntries(firstInSnapshot, firstInMain, reverse)) == null) {
            throw new BTreeKeyNotFoundException();
        }
        return smallestEntry.m_key;
    }

    boolean containsKey(BTree mainTree, Long snapshotID, Long treeDBK, byte[] key) throws IOException {
        BTreeSnapshot snapshot = (BTreeSnapshot)this.m_snapshotIndex.get(snapshotID);
        int mainCount = 0;
        if (!snapshot.treeLifeCycleEvent(treeDBK)) {
            BTreeIteratorState iterator = new BTreeIteratorState(treeDBK, key, false);
            while (true) {
                mainTree.advance(iterator);
                if (iterator.getAfterLast() || !BTreeKeyBuffer.keysEqual(key, iterator.getCurrentKey())) break;
                if (snapshot.createdLater(treeDBK, iterator.getCurrentKey(), iterator.getCurrentValue())) continue;
                ++mainCount;
            }
        }
        return snapshot.countDeletedKeyEntries(treeDBK, key) + mainCount > 0;
    }

    byte[] get(BTree mainTree, Long snapshotID, Long treeDBK, byte[] key) throws IOException {
        BTreeIteratorState.KeyValuePair firstInSnapshot;
        BTreeIteratorState.KeyValuePair smallestEntry;
        BTreeIteratorState iterator;
        BTreeIteratorState.KeyValuePair firstInMain;
        BTreeSnapshot snapshot;
        block3: {
            snapshot = (BTreeSnapshot)this.m_snapshotIndex.get(snapshotID);
            firstInMain = null;
            if (!snapshot.treeLifeCycleEvent(treeDBK)) {
                iterator = new BTreeIteratorState(treeDBK, key, false);
                do {
                    mainTree.advance(iterator);
                    if (iterator.getAfterLast()) break block3;
                } while (snapshot.createdLater(treeDBK, iterator.getCurrentKey(), iterator.getCurrentValue()));
                firstInMain = iterator.getPosition();
            }
        }
        if ((smallestEntry = BTreeIteratorState.selectEntries(firstInSnapshot = snapshot.advanceInDeleted(iterator = new BTreeIteratorState(treeDBK, key, false)), firstInMain, false)) == null || !BTreeKeyBuffer.keysEqual(key, smallestEntry.m_key)) {
            throw new BTreeKeyNotFoundException();
        }
        return smallestEntry.m_value;
    }

    void advance(BTree mainTree, Long snapshotID, BTreeIteratorState iterator) throws IOException {
        BTreeIteratorState.KeyValuePair bestEntry;
        BTreeIteratorState.KeyValuePair nextInMain;
        BTreeIteratorState.KeyValuePair nextInSnapshot;
        block4: {
            BTreeSnapshot snapshot = (BTreeSnapshot)this.m_snapshotIndex.get(snapshotID);
            nextInSnapshot = snapshot.adjacentInDeleted(iterator, iterator.isReverse());
            nextInMain = null;
            if (!snapshot.treeLifeCycleEvent(new Long(iterator.getTreeDbk()))) {
                BTreeIteratorState iteratorCopy = iterator.replicate();
                do {
                    mainTree.advance(iteratorCopy);
                    if (iteratorCopy.getAfterLast() || BTreeIteratorState.selectEntries(nextInSnapshot, iteratorCopy.getPosition(), iterator.isReverse()) == nextInSnapshot) break block4;
                } while (snapshot.createdLater(new Long(iteratorCopy.getTreeDbk()), iteratorCopy.getCurrentKey(), iteratorCopy.getCurrentValue()));
                nextInMain = iteratorCopy.getPosition();
            }
        }
        if ((bestEntry = BTreeIteratorState.selectEntries(nextInSnapshot, nextInMain, iterator.isReverse())) == null) {
            iterator.setAfterLast();
        } else {
            iterator.setCurrentKey(bestEntry.m_key);
            iterator.setCurrentValue(bestEntry.m_value);
        }
    }

    void transactionRolledback(Long transactionID) throws IOException {
        if (this.m_inMemoryByTransaction != null) {
            this.m_inMemoryByTransaction.remove(transactionID);
        }
        this.removeTransactionEntries(transactionID, false);
    }

    void transactionCommitted(Long transactionID) throws IOException {
        if (this.m_inMemoryByTransaction != null) {
            this.m_inMemoryByTransaction.remove(transactionID);
        }
        this.removeTransactionEntries(transactionID, true);
    }

    void btreeEntryInserted(Long transactionID, Long treeDBK, byte[] key, byte[] value) throws IOException {
        if (this.m_holdInMemory) {
            this.addEntryForTransaction(this.m_inMemoryByTransaction, transactionID, new BTreeEntry(treeDBK, false, key, value));
            return;
        }
        if (this.btreeEntryInserted(this.m_currentSnapshot, transactionID, treeDBK, key, value)) {
            this.addEntryForTransaction(this.m_entriesByTransaction, transactionID, new BTreeEntry(treeDBK, false, key, value));
        }
        int sz = this.m_snapshots.size();
        for (int j = 0; j < sz; ++j) {
            this.btreeEntryInserted((BTreeSnapshot)this.m_snapshots.get(j), transactionID, treeDBK, key, value);
        }
    }

    void treeCreatedOrDeleted(Long transactionID, long dbk, boolean rollingBack) {
        Long treeDBK = new Long(dbk);
        this.m_currentSnapshot.treeCreatedOrDeleted(treeDBK, rollingBack);
        if (!rollingBack) {
            this.addEntryForTransaction(this.m_entriesByTransaction, transactionID, new BTreeCreateDeleteEntry(treeDBK));
        }
        int sz = this.m_snapshots.size();
        for (int j = 0; j < sz; ++j) {
            ((BTreeSnapshot)this.m_snapshots.get(j)).treeCreatedOrDeleted(treeDBK, rollingBack);
        }
    }

    private boolean btreeEntryInserted(BTreeSnapshot snapshot, Long transactionID, Long treeDBK, byte[] key, byte[] value) throws IOException {
        if (snapshot.containsEntry(treeDBK, true, key, value)) {
            snapshot.removeEntry(treeDBK, true, key, value);
            return false;
        }
        return snapshot.addEntry(treeDBK, false, key, value);
    }

    void btreeEntryDeleted(Long transactionID, Long treeDBK, byte[] key, byte[] value) throws IOException {
        if (this.m_holdInMemory) {
            this.addEntryForTransaction(this.m_inMemoryByTransaction, transactionID, new BTreeEntry(treeDBK, true, key, value));
            return;
        }
        if (this.btreeEntryDeleted(this.m_currentSnapshot, transactionID, treeDBK, key, value)) {
            this.addEntryForTransaction(this.m_entriesByTransaction, transactionID, new BTreeEntry(treeDBK, true, key, value));
        }
        int sz = this.m_snapshots.size();
        for (int j = 0; j < sz; ++j) {
            this.btreeEntryDeleted((BTreeSnapshot)this.m_snapshots.get(j), transactionID, treeDBK, key, value);
        }
    }

    private boolean btreeEntryDeleted(BTreeSnapshot snapshot, Long transactionID, Long treeDBK, byte[] key, byte[] value) throws IOException {
        if (snapshot.containsEntry(treeDBK, false, key, value)) {
            snapshot.removeEntry(treeDBK, false, key, value);
            return false;
        }
        return snapshot.addEntry(treeDBK, true, key, value);
    }

    BTreeIteratorState.KeyValuePair adjacentInDeleted(BTreeIteratorState iterator, boolean reverse) throws IOException {
        return this.m_currentSnapshot.adjacentInDeleted(iterator, reverse);
    }

    BTreeIteratorState.KeyValuePair advanceInDeleted(BTreeIteratorState iterator) throws IOException {
        return this.m_currentSnapshot.advanceInDeleted(iterator);
    }

    private void removeTransactionEntries(Long transactionID, boolean commit) throws IOException {
        ArrayList transactionEntries = (ArrayList)this.m_entriesByTransaction.remove(transactionID);
        if (transactionEntries == null || !commit) {
            return;
        }
        for (int i = 0; i < transactionEntries.size(); ++i) {
            Object tmp = transactionEntries.get(i);
            if (tmp instanceof BTreeEntry) {
                BTreeEntry entry = (BTreeEntry)tmp;
                this.m_currentSnapshot.removeEntry(entry.m_treeDBK, entry.m_inDeletionTree, entry.m_key, entry.m_value);
                continue;
            }
            this.m_currentSnapshot.treeCreatedOrDeleted(((BTreeCreateDeleteEntry)tmp).m_treeDBK, true);
        }
    }

    private void addEntryForTransaction(HashMap transactionTable, Long transactionID, Object entry) {
        ArrayList<Object> transactionEntries = (ArrayList<Object>)transactionTable.get(transactionID);
        if (transactionEntries == null) {
            transactionEntries = new ArrayList<Object>();
            transactionTable.put(transactionID, transactionEntries);
        }
        transactionEntries.add(entry);
    }

    private void fromMemoryToSnapshot() throws IOException {
        this.m_holdInMemory = false;
        for (Long transactionID : this.m_inMemoryByTransaction.keySet()) {
            ArrayList transactionEntries = (ArrayList)this.m_inMemoryByTransaction.get(transactionID);
            int sz = transactionEntries.size();
            for (int i = 0; i < sz; ++i) {
                BTreeEntry entry = (BTreeEntry)transactionEntries.get(i);
                if (entry.m_inDeletionTree) {
                    this.btreeEntryDeleted(transactionID, entry.m_treeDBK, entry.m_key, entry.m_value);
                    continue;
                }
                this.btreeEntryInserted(transactionID, entry.m_treeDBK, entry.m_key, entry.m_value);
            }
        }
        this.m_inMemoryByTransaction = null;
    }

    private class BTreeCreateDeleteEntry {
        Long m_treeDBK;

        BTreeCreateDeleteEntry(Long treeDBK) {
            this.m_treeDBK = treeDBK;
        }
    }

    private class BTreeEntry {
        Long m_treeDBK;
        boolean m_inDeletionTree;
        byte[] m_key;
        byte[] m_value;

        BTreeEntry(Long treeDBK, boolean inDeletionTree, byte[] key, byte[] value) {
            this.m_treeDBK = treeDBK;
            this.m_inDeletionTree = inDeletionTree;
            this.m_key = key;
            this.m_value = value;
        }
    }
}

