/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AsyncDeleteManager;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.CheckpointNote;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.TransactionManager;
import java.io.IOException;

final class CheckpointV2Note
extends CheckpointNote {
    protected static byte NOTE_TYPE = (byte)44;
    byte[] m_scratchBuffer = new byte[4];
    TransactionManager m_transactionManager;
    AsyncDeleteManager m_deleteManager;

    CheckpointV2Note() {
    }

    @Override
    TransactionManager getTransactionManager() {
        return this.m_transactionManager;
    }

    AsyncDeleteManager getDeleteManager() {
        return this.m_deleteManager;
    }

    @Override
    public long getTransactionNum() {
        return 0L;
    }

    @Override
    public long getPageNum() {
        return 0L;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write(NOTE_TYPE);
        byte[] serializedTrManager = this.m_transactionManager.serialize();
        BitUtil.putInt(this.m_scratchBuffer, 0, serializedTrManager.length);
        writer.write(this.m_scratchBuffer, 0, 4);
        writer.write(serializedTrManager, 0, serializedTrManager.length);
        byte[] serializedDelManager = this.m_deleteManager.serialize();
        writer.write(serializedDelManager, 0, serializedDelManager.length);
        return 5 + serializedTrManager.length + serializedDelManager.length;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        int transManagerLength = BitUtil.getInt(buffer, currentOffset);
        this.m_transactionManager = TransactionManager.deSerialize(buffer, currentOffset += 4);
        this.m_deleteManager = AsyncDeleteManager.deSerialize(buffer, currentOffset += transManagerLength);
    }

    void initNote(TransactionManager transactionManager, AsyncDeleteManager deleteManager) {
        this.m_transactionManager = transactionManager;
        this.m_deleteManager = deleteManager == null ? new AsyncDeleteManager() : deleteManager;
    }
}

