/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

final class LogTest {
    private static long LOG_FILE_SIZE = 4096000L;
    private File m_dbDir;
    boolean m_preAllocate;
    private int m_numFiles;
    private int m_pageSize;
    private String m_openMode;
    private int m_numWriteBeforeSync;

    public static void usage() {
        System.out.println("Usage: Must pass 6 args: preallocate(true/false) dirName num-log-files page-size openMode num-writes-before-sync");
    }

    public static void main(String[] args) throws IOException {
        LogTest logTest = new LogTest(args);
        if (args[0].equalsIgnoreCase("true")) {
            logTest.cleanup();
            logTest.createLogs();
        } else {
            logTest.cleanup();
        }
        logTest.writeLogs();
    }

    LogTest(String[] args) {
        try {
            this.m_preAllocate = args[0].equalsIgnoreCase("true");
            this.m_dbDir = new File(args[1]);
            this.m_numFiles = new Integer(args[2]);
            this.m_pageSize = new Integer(args[3]);
            this.m_openMode = args[4];
            this.m_numWriteBeforeSync = new Integer(args[5]);
        }
        catch (Exception e) {
            LogTest.usage();
            System.exit(1);
        }
    }

    public void cleanup() {
        File[] files = this.m_dbDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
    }

    private void writeLogs() throws IOException {
        byte[] buffer = new byte[this.m_pageSize];
        int pagesPerLog = (int)(LOG_FILE_SIZE / (long)this.m_pageSize);
        long startT = System.currentTimeMillis();
        for (int i = 0; i < this.m_numFiles; ++i) {
            File file = new File(this.m_dbDir, "log" + i);
            RandomAccessFile randomFile = new RandomAccessFile(file, this.m_openMode);
            int syncCounter = 0;
            for (int j = 0; j < pagesPerLog; ++j) {
                randomFile.write(buffer);
                if (++syncCounter != this.m_numWriteBeforeSync) continue;
                randomFile.getFD().sync();
                syncCounter = 0;
            }
            randomFile.close();
        }
        long totalTime = System.currentTimeMillis() - startT;
        long totalBits = LOG_FILE_SIZE * (long)this.m_numFiles * 8L;
        System.out.println("\n\nPreallocate " + this.m_preAllocate);
        System.out.println("Directory " + this.m_dbDir.getCanonicalPath());
        System.out.println(this.m_numFiles + " files");
        System.out.println("open mode " + this.m_openMode);
        System.out.println("Sync every " + this.m_numWriteBeforeSync);
        System.out.println("Page size " + this.m_pageSize);
        System.out.println("Test total time, " + totalTime + " millis ");
        System.out.println("Mbits/second  " + totalBits / (totalTime * 1000L));
    }

    private void createLogs() throws IOException {
        for (int i = 0; i < this.m_numFiles; ++i) {
            File file = new File(this.m_dbDir, "log" + i);
            RandomAccessFile randomFile = new RandomAccessFile(file, "rw");
            randomFile.seek(LOG_FILE_SIZE);
            randomFile.close();
        }
    }
}

