/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.CheckpointNote;
import com.sonicsw.mtstorage.impl.Constants;
import com.sonicsw.mtstorage.impl.INote;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.LogEndIndicator;
import com.sonicsw.mtstorage.impl.LogPage;
import com.sonicsw.mtstorage.impl.LogPageHeader;
import com.sonicsw.mtstorage.impl.NoteFactory;
import com.sonicsw.mtstorage.impl.TransactionEndNote;
import com.sonicsw.mtstorage.impl.VirtualLogFile;
import com.sonicsw.mtstorage.replication.ReplicationManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

final class NoteWriter
implements INoteWriter {
    static final short HEADER_LENGTH = 4;
    static final short TRAILER_LENGTH = 4;
    static final short HEADER_PLUS_TRAILER_LENGTH = 8;
    private File m_dbDir;
    private VirtualLogFile m_virtualLog;
    private byte[] m_scratchBuffer;
    private LogEndIndicator m_logEndInidicator;
    private long m_nextNoteID;
    private long m_IDAfterLargestTransEnd;
    private int m_currentPageOffset;
    private ActivePages m_activePages;
    private boolean m_stopWaitingForReplicationData;

    NoteWriter(File dbDir) {
        this.m_dbDir = dbDir;
        this.m_scratchBuffer = new byte[4];
        this.m_stopWaitingForReplicationData = false;
    }

    VirtualLogFile getVirtualLog() {
        return this.m_virtualLog;
    }

    void releaseLog(long noteID) throws IOException {
        this.m_virtualLog.releasePages(VirtualLogFile.noteIDPageNum(noteID));
    }

    void releaseLog() throws IOException {
        this.m_virtualLog.releasePages();
    }

    void open(HashMap parameters) throws IOException {
        this.m_virtualLog = new VirtualLogFile(this.m_dbDir, parameters);
        this.m_logEndInidicator = this.m_virtualLog.getIndicator();
        this.m_IDAfterLargestTransEnd = this.m_nextNoteID = this.m_logEndInidicator.getNextNoteID();
        this.m_currentPageOffset = VirtualLogFile.noteIDOffestInPage(this.m_nextNoteID);
        this.m_activePages = new ActivePages();
    }

    void close() throws IOException {
        this.m_virtualLog.close();
    }

    void getMetrics(Properties props, String dbName) {
        if (this.m_virtualLog != null) {
            this.m_virtualLog.getMetrics(props, dbName);
        }
    }

    synchronized long getNextNoteID() {
        return this.m_nextNoteID;
    }

    synchronized long getIDAfterLastTransEnd() {
        return this.m_IDAfterLargestTransEnd;
    }

    synchronized void stopWaitingForData() {
        this.m_stopWaitingForReplicationData = true;
        this.notifyAll();
    }

    synchronized ReplicationManager.ReplicationDataIndicator getReplicationData(long startingID, boolean firstLogRequest) throws InterruptedException, IOException {
        this.m_stopWaitingForReplicationData = false;
        while (true) {
            if (this.m_stopWaitingForReplicationData) {
                this.m_stopWaitingForReplicationData = false;
                return null;
            }
            ReplicationManager.ReplicationDataIndicator indicator = this.m_virtualLog.getReplicationData(startingID, firstLogRequest);
            if (indicator != null) {
                return indicator;
            }
            this.wait();
        }
    }

    synchronized int replicateNotes(byte[] buffer, long startingID, int dataOffset, int totaldataLength, int firstNoteOffset, long[] lastNoteID, CheckpointNote[] checkpointNote) throws IOException {
        lastNoteID[0] = -1L;
        boolean firstCall = firstNoteOffset == -1;
        int currentNotePointer = firstCall ? dataOffset : firstNoteOffset;
        boolean firstNote = true;
        while (currentNotePointer - dataOffset < totaldataLength) {
            if ((!firstNote || firstCall) && NoteFactory.isCheckpointNote(buffer[currentNotePointer + 4])) {
                checkpointNote[0] = (CheckpointNote)NoteFactory.createNote(buffer[currentNotePointer + 4], buffer, currentNotePointer + 4 + 1);
                return currentNotePointer;
            }
            firstNote = false;
            int fullNoteLength = BitUtil.getInt(buffer, currentNotePointer);
            if (fullNoteLength <= 0) {
                throw new IOException("noteLength " + fullNoteLength + " total data length " + totaldataLength + " first note offset " + firstNoteOffset + " start ID " + startingID + " offset in page " + VirtualLogFile.noteIDOffestInPage(startingID));
            }
            lastNoteID[0] = this.writeNote(buffer, currentNotePointer, fullNoteLength);
            currentNotePointer += fullNoteLength;
        }
        return -1;
    }

    static int removePageHeaders(byte[] buffer, int dataOffset, long startID, int dataLength) {
        int offsetInPage = VirtualLogFile.noteIDOffestInPage(startID);
        int crntHeader = offsetInPage == 0 ? 0 : LogPage.PAGE_LENGTH - offsetInPage;
        int headerNum = 1;
        while (crntHeader + 8 <= dataLength) {
            int segmentOffset = dataOffset + crntHeader + 8;
            int amountToCopy = Constants.MIN(LogPageHeader.PAYLOAD_BYTES_IN_PAGE, dataLength - (crntHeader + 8));
            if (amountToCopy > 0) {
                System.arraycopy(buffer, segmentOffset, buffer, segmentOffset - 8 * headerNum, amountToCopy);
            }
            ++headerNum;
            crntHeader += LogPage.PAGE_LENGTH;
        }
        return dataLength - (headerNum - 1) * 8;
    }

    private long writeNote(byte[] buffer, int srcNoteOffset, int fullNoteLength) throws IOException {
        int noteLength = fullNoteLength - 8;
        this.m_activePages.doneWithBuffers();
        long noteID = this.m_nextNoteID;
        this.write(buffer, srcNoteOffset, fullNoteLength, true);
        this.m_nextNoteID = VirtualLogFile.calcNoteIDOffset(this.m_nextNoteID, fullNoteLength);
        if (NoteFactory.isTransactionEndNote(buffer[srcNoteOffset + 4])) {
            this.m_IDAfterLargestTransEnd = this.m_nextNoteID;
        }
        this.m_logEndInidicator.setNoteIDInfo(noteID, this.m_nextNoteID);
        this.m_activePages.doneWithBuffers();
        return noteID;
    }

    synchronized long writeNote(INote note) throws IOException {
        this.m_activePages.doneWithBuffers();
        long noteID = this.m_nextNoteID;
        int offsetInPageOfThisNote = this.m_currentPageOffset;
        BitUtil.putInt(this.m_scratchBuffer, 0, 0);
        this.write(this.m_scratchBuffer, 0, 4, false);
        int noteLength = note.writeNote(this) + 8;
        BitUtil.putInt(this.m_scratchBuffer, 0, noteLength);
        this.write(this.m_scratchBuffer, 0, 4, true);
        this.m_activePages.writePrefixLength(this.m_scratchBuffer, offsetInPageOfThisNote);
        this.m_nextNoteID = VirtualLogFile.calcNoteIDOffset(this.m_nextNoteID, noteLength);
        if (note instanceof TransactionEndNote) {
            this.m_IDAfterLargestTransEnd = this.m_nextNoteID;
        }
        this.m_logEndInidicator.setNoteIDInfo(noteID, this.m_nextNoteID);
        this.m_activePages.doneWithBuffers();
        if (this.m_virtualLog.muchLogToReplicate()) {
            this.forceTailToDisk();
        }
        return noteID;
    }

    synchronized long forceTailToDisk() throws IOException {
        boolean mustWriteCurrentPage = this.m_currentPageOffset != 0;
        this.m_virtualLog.forceToDisk(mustWriteCurrentPage ? this.m_activePages.getCurrentPage() : null);
        this.notifyAll();
        return this.m_logEndInidicator.getLastWrittenNoteID();
    }

    private void write(byte[] buffer, int offset, int length, boolean markLogHeader) throws IOException {
        int spaceNeeded = length;
        int srcOffset = offset;
        byte[] currentBuffer = this.m_activePages.getCurrentPage().getBuffer();
        while (spaceNeeded > 0) {
            if (this.m_currentPageOffset == LogPage.PAGE_LENGTH) {
                this.m_activePages.getNextPage();
                currentBuffer = this.m_activePages.getCurrentPage().getBuffer();
            }
            int availableBufferSpace = LogPage.PAGE_LENGTH - this.m_currentPageOffset;
            int byteCount = Constants.MIN(availableBufferSpace, spaceNeeded);
            System.arraycopy(buffer, srcOffset, currentBuffer, this.m_currentPageOffset, byteCount);
            this.m_currentPageOffset += byteCount;
            spaceNeeded -= byteCount;
            srcOffset += byteCount;
        }
        if (markLogHeader) {
            this.m_activePages.getCurrentPage().storeNoteEndPointer(this.m_currentPageOffset - 1);
        }
        if (this.m_currentPageOffset == LogPage.PAGE_LENGTH) {
            this.m_activePages.getNextPage();
        }
    }

    @Override
    public void write(byte value) throws IOException {
        this.m_scratchBuffer[0] = value;
        this.write(this.m_scratchBuffer, 0, 1, false);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.write(buffer, offset, length, false);
    }

    private class ActivePages {
        private ArrayList m_activeList;

        ActivePages() throws IOException {
            boolean needDataOfFirstPage = VirtualLogFile.noteIDOffestInPage(NoteWriter.this.m_nextNoteID) != 0;
            this.m_activeList = new ArrayList();
            this.m_activeList.add(NoteWriter.this.m_virtualLog.getNextPageForWrite(needDataOfFirstPage));
        }

        void getNextPage() throws IOException {
            this.m_activeList.add(NoteWriter.this.m_virtualLog.getNextPageForWrite(false));
            NoteWriter.this.m_currentPageOffset = 8;
        }

        LogPage getCurrentPage() {
            return (LogPage)this.m_activeList.get(this.m_activeList.size() - 1);
        }

        void writePrefixLength(byte[] src, int prefixInFirstPage) {
            int availableInFirstPage = LogPage.PAGE_LENGTH - prefixInFirstPage;
            LogPage page = (LogPage)this.m_activeList.get(0);
            byte[] buffer = page.getBuffer();
            int howManyToCopy = Constants.MIN(4, availableInFirstPage);
            for (int i = 0; i < howManyToCopy; ++i) {
                buffer[prefixInFirstPage + i] = src[i];
            }
            if (availableInFirstPage < 4) {
                buffer = ((LogPage)this.m_activeList.get(1)).getBuffer();
                int j = 8;
                int i = howManyToCopy;
                while (i < 4) {
                    buffer[j] = src[i];
                    ++i;
                    ++j;
                }
            }
        }

        void doneWithBuffers() throws IOException {
            if (this.m_activeList.size() > 1) {
                LogPage oneBeforeLast = (LogPage)this.m_activeList.get(this.m_activeList.size() - 2);
                NoteWriter.this.m_virtualLog.writeTail(oneBeforeLast.getPageNum());
                LogPage lastPage = (LogPage)this.m_activeList.get(this.m_activeList.size() - 1);
                this.m_activeList = new ArrayList();
                this.m_activeList.add(lastPage);
            }
        }
    }
}

