/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IPageNote;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class PageTypeNote
extends AbstractNote
implements IPageNote,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 8;
    byte[] m_scratchBuffer = new byte[8];
    long m_pageNum;
    byte m_oldPageType;
    byte m_newPageType;

    PageTypeNote() {
    }

    public String toString() {
        return this.getClass().getName() + " page " + this.m_pageNum + " old type " + this.m_oldPageType + " newPageType " + this.m_newPageType;
    }

    @Override
    public long getPageNum() {
        return this.m_pageNum;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_pageNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        writer.write(this.m_oldPageType);
        writer.write(this.m_newPageType);
        return 11;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_pageNum = BitUtil.getLong(buffer, currentOffset);
        currentOffset += 8;
        this.m_oldPageType = buffer[currentOffset++];
        this.m_newPageType = buffer[currentOffset];
    }

    void initNote(long pageNum, byte oldPageType, byte newPageType) {
        this.m_pageNum = pageNum;
        this.m_oldPageType = oldPageType;
        this.m_newPageType = newPageType;
    }
}

